/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantAllowedLevelService;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.AIAssistantKillSwitch;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.grazie.auth.GrazieAuthFacade;
import com.intellij.ml.llm.grazie.auth.GrazieAuthState;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManagerSettings;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreSettingsManager;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreSettingsState;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreUxHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMProjectConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nLLMProjectConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMProjectConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMProjectConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,123:1\n30#2,2:124\n*S KotlinDebug\n*F\n+ 1 LLMProjectConfigurable.kt\ncom/intellij/ml/llm/core/settings/LLMProjectConfigurable\n*L\n35#1:124,2\n*E\n"})
public final class LLMProjectConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;

    public LLMProjectConfigurable(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(LLMBundle.message("settings.configurable.project.settings.display.name", new Object[0]), "ai.assistant.reference.settings.project.settings", null, 4, null);
        this.project = project;
        this.scope = scope;
    }

    @NotNull
    public DialogPanel createPanel() {
        LLMProjectSettingsManager settings = LLMProjectSettingsManager.Companion.getInstance(this.project);
        AiIgnoreSettingsManager aiIgnoreSettings = AiIgnoreSettingsManager.Companion.getInstance(this.project);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<AIAssistantAllowedLevelService> serviceClass$iv = AIAssistantAllowedLevelService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ComponentPredicate projectFilePredicate = ComponentPredicateKt.predicate(((AIAssistantAllowedLevelService)object).getLevel(), (CoroutineScope)this.scope, LLMProjectConfigurable::createPanel$lambda$0);
        ComponentPredicate authedPredicate = ComponentPredicateKt.predicate(GrazieAuthFacade.Companion.getInstance().getAuthState(), (CoroutineScope)this.scope, LLMProjectConfigurable::createPanel$lambda$1);
        return BuilderKt.panel(arg_0 -> LLMProjectConfigurable.createPanel$lambda$14(projectFilePredicate, this, settings, authedPredicate, aiIgnoreSettings, arg_0));
    }

    public void apply() {
        boolean modified = this.isModified();
        super.apply();
        if (modified) {
            LLMProjectSettingsManager.Companion.fireSettingsChanged(this.project);
        }
    }

    private static final boolean createPanel$lambda$0(AIAssistantKillSwitch.Level it) {
        return it == AIAssistantKillSwitch.Level.ProjectFile;
    }

    private static final boolean createPanel$lambda$1(GrazieAuthState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GrazieAuthState.Authenticated;
    }

    private static final Unit createPanel$lambda$14$lambda$2(LLMProjectSettingsManager $settings, ComponentPredicate $authedPredicate, ComponentPredicate $projectFilePredicate, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        ButtonKt.bindSelected((Cell)$this$row.checkBox(LLMBundle.message("project.settings.turnedOn", objectArray)), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((LLMProjectSettingsManager)this.receiver).isTurnedOn();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((LLMProjectSettingsManager)this.receiver).setTurnedOn(p0);
            }
        })).enabledIf(ComponentPredicateKt.and((ComponentPredicate)$authedPredicate, (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AIAssistantUIUtilKt.howCompletelyDisableLink($this$row);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        Row.text$default((Row)$this$row, (String)LLMBundle.message("project.settings.disabled.ny.noai.file", objectArray), (int)Integer.MAX_VALUE, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$14$lambda$6$lambda$5(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return string;
    }

    private static final Unit createPanel$lambda$14$lambda$6(AiIgnoreSettingsManager $aiIgnoreSettings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFileDescriptor(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Cell.label$default((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, null, LLMProjectConfigurable::createPanel$lambda$14$lambda$6$lambda$5, (int)2, null), (String)LLMBundle.message("project.settings.path.to.aiignore", new Object[0]), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE), (Function0)((Function0)new Function0<String>((Object)$aiIgnoreSettings){

            public final String invoke() {
                return ((AiIgnoreSettingsManager)this.receiver).getPresentableAIIgnoreURL();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)$aiIgnoreSettings){

            public final void invoke(String p0) {
                ((AiIgnoreSettingsManager)this.receiver).setAIIgnoreURL(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$7(AiIgnoreSettingsManager $aiIgnoreSettings, ComponentPredicate $authedPredicate, ComponentPredicate $projectFilePredicate, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(LLMBundle.message("project.settings.aiignore.turnedOn", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($aiIgnoreSettings.getState()){

            public Object get() {
                return ((AiIgnoreSettingsState)this.receiver).getEnabled();
            }

            public void set(Object value) {
                ((AiIgnoreSettingsState)this.receiver).setEnabled(((Boolean)value).booleanValue());
            }
        })).enabledIf(ComponentPredicateKt.and((ComponentPredicate)$authedPredicate, (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$9$lambda$8(AiIgnoreUxHelper $uxHelper, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $uxHelper.createNewFile();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$9(AiIgnoreUxHelper $uxHelper, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("project.settings.aiignore.create", new Object[0]), arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$9$lambda$8($uxHelper, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11$lambda$10(AiIgnoreUxHelper $uxHelper, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $uxHelper.openExistingFile();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14$lambda$11(AiIgnoreUxHelper $uxHelper, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button(LLMBundle.message("project.settings.aiignore.open", new Object[0]), arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$11$lambda$10($uxHelper, arg_0));
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$14$lambda$13$lambda$12(LLMProjectConfigurable this$0, VirtualFile it) {
        Object object;
        Path projectRootPath;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path selectedPath = NioPathUtil.toNioPathOrNull((String)string);
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this$0.project);
        Path path = projectRootPath = virtualFile != null ? virtualFile.toNioPath() : null;
        if (projectRootPath != null && selectedPath != null) {
            Path path2 = projectRootPath.relativize(selectedPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
            object = ((Object)path2).toString();
        } else {
            object = VirtualFileUtil.toNioPathOrNull((VirtualFile)it);
            if (object == null || (object = object.toString()) == null) {
                String string2 = it.getPresentableUrl();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableUrl(...)");
            }
        }
        return object;
    }

    private static final Unit createPanel$lambda$14$lambda$13(LLMProjectConfigurable this$0, LLMProjectSettingsManager $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFile().withTitle(LLMBundle.message("project.settings.project.review.rules.path.dialog.title", new Object[0])).withDescription(LLMBundle.message("project.settings.project.review.rules.path.dialog.description", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withDescription(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)Cell.label$default((Cell)$this$row.textFieldWithBrowseButton(fileChooserDescriptor, this$0.project, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$13$lambda$12(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE), (String)LLMBundle.message("project.settings.project.review.rules.path.field", new Object[0]), null, (int)2, null), (Function0)((Function0)new Function0<String>((Object)$settings){

            public final String invoke() {
                return ((LLMProjectSettingsManager)this.receiver).getProjectReviewRulesFilePath();
            }
        }), (Function1)((Function1)new Function1<String, Unit>((Object)$settings){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LLMProjectSettingsManager)this.receiver).setProjectReviewRulesFilePath(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$14(ComponentPredicate $projectFilePredicate, LLMProjectConfigurable this$0, LLMProjectSettingsManager $settings, ComponentPredicate $authedPredicate, AiIgnoreSettingsManager $aiIgnoreSettings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$2($settings, $authedPredicate, $projectFilePredicate, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, LLMProjectConfigurable::createPanel$lambda$14$lambda$3, (int)1, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)$projectFilePredicate));
        Panel.row$default((Panel)$this$panel, null, LLMProjectConfigurable::createPanel$lambda$14$lambda$4, (int)1, null).visibleIf($projectFilePredicate);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$6($aiIgnoreSettings, arg_0), (int)1, null).visible(AiIgnoreManagerSettings.Companion.getInstance(this$0.project).isPathConfigurable());
        boolean isAiIgnoreEnabledInRegistry = AiIgnoreManagerSettings.Companion.getInstance(this$0.project).isEnabledInRegistry();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$7($aiIgnoreSettings, $authedPredicate, $projectFilePredicate, arg_0), (int)1, null).visible(isAiIgnoreEnabledInRegistry);
        if (isAiIgnoreEnabledInRegistry && !this$0.project.isDefault()) {
            AiIgnoreUxHelper uxHelper = AiIgnoreUxHelper.Companion.getInstance(this$0.project);
            boolean canCreateNewFile = uxHelper.canCreateNewFile();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$9(uxHelper, arg_0), (int)1, null).visible(canCreateNewFile);
            boolean canOpenExistingFile = uxHelper.canOpenExistingFile();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$11(uxHelper, arg_0), (int)1, null).visible(canOpenExistingFile);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> LLMProjectConfigurable.createPanel$lambda$14$lambda$13(this$0, $settings, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }
}

