/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.Color16;
import com.intellij.ui.JBColor;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J'\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017J<\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010 \u001a\u00020\u00072\b\b\u0002\u0010!\u001a\u00020\u0007H\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/core/ui/XNextGradientPainterService;", "", "<init>", "()V", "gradientCache", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "", "Ljava/awt/TexturePaint;", "startColor", "Lcom/intellij/ui/JBColor;", "endColor", "get", "g2d", "Ljava/awt/Graphics2D;", "height", "createPainter", "Lcom/intellij/openapi/ui/Painter;", "project", "Lcom/intellij/openapi/project/Project;", "extraLayers", "", "Ljavax/swing/Icon;", "(Lcom/intellij/openapi/project/Project;[Ljavax/swing/Icon;)Lcom/intellij/openapi/ui/Painter;", "coefficients", "", "createVerticalGradientTexture", "graphics", "Ljava/awt/Graphics;", "colorStart", "Ljava/awt/Color;", "colorEnd", "xStart", "yStart", "Companion", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nXNextGradientPainterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XNextGradientPainterService.kt\ncom/intellij/ml/llm/core/ui/XNextGradientPainterService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,152:1\n382#2,7:153\n*S KotlinDebug\n*F\n+ 1 XNextGradientPainterService.kt\ncom/intellij/ml/llm/core/ui/XNextGradientPainterService\n*L\n61#1:153,7\n*E\n"})
public final class XNextGradientPainterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SynchronizedClearableLazy<Map<Integer, TexturePaint>> gradientCache = new SynchronizedClearableLazy(XNextGradientPainterService::gradientCache$lambda$0);
    @NotNull
    private final JBColor startColor = new JBColor("MainWindow.background.topColor", (Color)new JBColor(15595775, 2107192));
    @NotNull
    private final JBColor endColor = new JBColor("MainWindow.background.bottomColor", (Color)new JBColor(0xF2F3FF, 1908773));
    @NotNull
    private final double[] coefficients;

    public XNextGradientPainterService() {
        SimpleMessageBusConnection busConnection = ApplicationKt.getApplication().getMessageBus().simpleConnect();
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, arg_0 -> XNextGradientPainterService._init_$lambda$1(this, arg_0));
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        busConnection.subscribe(topic2, arg_0 -> XNextGradientPainterService._init_$lambda$2(this, arg_0));
        double[] dArray = new double[]{0.4375, 0.1875, 0.3125, 0.0625};
        this.coefficients = dArray;
    }

    /*
     * WARNING - void declaration
     */
    private final TexturePaint get(Graphics2D g2d, int height) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = (Map)this.gradientCache.get();
        Integer key$iv = height;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TexturePaint answer$iv = this.createVerticalGradientTexture(g2d, (Color)this.startColor, (Color)this.endColor, height, 0, 0);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TexturePaint)object;
    }

    @NotNull
    public final Painter createPainter(@Nullable Project project, @NotNull Icon[] extraLayers) {
        Intrinsics.checkNotNullParameter((Object)extraLayers, (String)"extraLayers");
        return (Painter)new AbstractPainter(project, this, extraLayers){
            private boolean needRepaint;
            final /* synthetic */ Project $project;
            final /* synthetic */ XNextGradientPainterService this$0;
            final /* synthetic */ Icon[] $extraLayers;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$extraLayers = $extraLayers;
                this.needRepaint = true;
            }

            public boolean needsRepaint() {
                return this.needRepaint && !IdeBackgroundUtil.isEditorBackgroundImageSet((Project)this.$project);
            }

            public void executePaint(Component component, Graphics2D g2d) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
                if (!this.needsRepaint()) {
                    return;
                }
                this.needRepaint = false;
                float adjustedAlpha = Intrinsics.areEqual((Object)true, (Object)g2d.getRenderingHint(IdeBackgroundUtil.ADJUST_ALPHA)) ? 0.65f : 1.0f;
                Object hintedAdjustedAlphaObject = g2d.getRenderingHint(JBSwingUtilities.ADJUSTED_BACKGROUND_ALPHA);
                if (hintedAdjustedAlphaObject instanceof Float) {
                    adjustedAlpha = ((Number)hintedAdjustedAlphaObject).floatValue();
                }
                GraphicsConfig gc = new GraphicsConfig((Graphics)g2d).setAlpha(adjustedAlpha);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setPaint(XNextGradientPainterService.access$get(this.this$0, g2d, component.getHeight()));
                g2d.fillRect(0, 0, component.getWidth(), component.getHeight());
                gc.restore();
                for (Icon icon : this.$extraLayers) {
                    icon.paintIcon(component, g2d, 0, 0);
                }
                this.needRepaint = true;
            }
        };
    }

    public static /* synthetic */ Painter createPainter$default(XNextGradientPainterService xNextGradientPainterService, Project project, Icon[] iconArray, int n, Object object) {
        if ((n & 2) != 0) {
            iconArray = new Icon[]{};
        }
        return xNextGradientPainterService.createPainter(project, iconArray);
    }

    private final TexturePaint createVerticalGradientTexture(Graphics graphics, Color colorStart, Color colorEnd, int height, int xStart, int yStart) {
        int y;
        int n;
        int imgWidth = 2;
        BufferedImage bufferedImage = ImageUtil.createImage((Graphics)graphics, (int)imgWidth, (int)height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        int n2 = image.getHeight();
        Color16[][] color16ArrayArray = new Color16[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            n = 0;
            int n4 = image.getWidth();
            Color16[] color16Array = new Color16[n4];
            int n5 = n3;
            Color16[][] color16ArrayArray2 = color16ArrayArray;
            while (n < n4) {
                int n6 = n++;
                color16Array[n6] = Color16.Companion.getTRANSPARENT();
            }
            color16ArrayArray2[n5] = color16Array;
        }
        Color16[][] pixels = color16ArrayArray;
        Color16 colorStart16 = Color16.Companion.toColor16(colorStart);
        Color16 colorEnd16 = Color16.Companion.toColor16(colorEnd);
        Color16 delta16 = colorEnd16.minus(colorStart16);
        n = image.getHeight();
        for (y = 0; y < n; ++y) {
            double rel = (double)y * 1.0 / (double)(image.getHeight() - 1);
            Color16 curColor = colorStart16.plus(delta16.times(rel));
            int n7 = image.getWidth();
            for (int x = 0; x < n7; ++x) {
                pixels[y][x] = curColor;
            }
        }
        n = image.getHeight();
        for (y = 0; y < n; ++y) {
            int n8 = image.getWidth();
            for (int x = 0; x < n8; ++x) {
                Color16 oldColor = pixels[y][x];
                Color newColor = oldColor.toColor8();
                image.setRGB(x, y, newColor.getRGB());
                Color16 error = oldColor.minus(Color16.Companion.toColor16(newColor));
                if (x + 1 < image.getWidth()) {
                    pixels[y][x + 1] = pixels[y][x + 1].plus(error.times(this.coefficients[0]));
                }
                if (x - 1 >= 0 && y + 1 < image.getHeight()) {
                    pixels[y + 1][x - 1] = pixels[y + 1][x - 1].plus(error.times(this.coefficients[1]));
                }
                if (y + 1 < image.getHeight()) {
                    pixels[y + 1][x] = pixels[y + 1][x].plus(error.times(this.coefficients[2]));
                }
                if (x + 1 >= image.getWidth() || y + 1 >= image.getHeight()) continue;
                pixels[y + 1][x + 1] = pixels[y + 1][x + 1].plus(error.times(this.coefficients[3]));
            }
        }
        return new TexturePaint(image, new Rectangle(xStart, yStart, imgWidth, height));
    }

    static /* synthetic */ TexturePaint createVerticalGradientTexture$default(XNextGradientPainterService xNextGradientPainterService, Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 0;
        }
        return xNextGradientPainterService.createVerticalGradientTexture(graphics, color, color2, n, n2, n3);
    }

    private static final Map gradientCache$lambda$0() {
        return new LinkedHashMap();
    }

    private static final void _init_$lambda$1(XNextGradientPainterService this$0, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.gradientCache.drop();
    }

    private static final void _init_$lambda$2(XNextGradientPainterService this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.gradientCache.drop();
    }

    public static final /* synthetic */ TexturePaint access$get(XNextGradientPainterService $this, Graphics2D g2d, int height) {
        return $this.get(g2d, height);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/core/ui/XNextGradientPainterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/ui/XNextGradientPainterService;", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nXNextGradientPainterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XNextGradientPainterService.kt\ncom/intellij/ml/llm/core/ui/XNextGradientPainterService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,152:1\n40#2,3:153\n*S KotlinDebug\n*F\n+ 1 XNextGradientPainterService.kt\ncom/intellij/ml/llm/core/ui/XNextGradientPainterService$Companion\n*L\n34#1:153,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XNextGradientPainterService getInstance() {
            boolean $i$f$service = false;
            Class<XNextGradientPainterService> serviceClass$iv = XNextGradientPainterService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (XNextGradientPainterService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

