/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ide.HelpTooltip;
import com.intellij.llmInstaller.ui.hub.states.AIHubUIKt;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.QuotaTimeData;
import com.intellij.ml.llm.core.chat.ui.RemainedQuotasInfo;
import com.intellij.ml.llm.core.quota.QuotaInfo;
import com.intellij.ml.llm.core.quota.QuotaManager2;
import com.intellij.ml.llm.hub.AIHubInstalled;
import com.intellij.ml.llm.hub.AIHubInstalledKt;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import com.intellij.ml.llm.hub.AIHubNotificationManagerKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.ui.UiScopeKt;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/hub/AIHubQuotes;", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "<init>", "(Lcom/intellij/ui/dsl/builder/Panel;Lcom/intellij/ui/popup/WizardPopup;)V", "quotesPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "creditsLabel", "Ljavax/swing/JLabel;", "remainedLabel", "progressBar", "Ljavax/swing/JProgressBar;", "updateQuotes", "", "getRemainedCredits", "", "Lorg/jetbrains/annotations/Nls;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nAIHubQuotes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIHubQuotes.kt\ncom/intellij/ml/llm/hub/AIHubQuotes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1761#2,3:131\n*S KotlinDebug\n*F\n+ 1 AIHubQuotes.kt\ncom/intellij/ml/llm/hub/AIHubQuotes\n*L\n75#1:131,3\n*E\n"})
public final class AIHubQuotes {
    @NotNull
    private final DialogPanel quotesPanel;
    private JLabel creditsLabel;
    private JLabel remainedLabel;
    private JProgressBar progressBar;

    public AIHubQuotes(@NotNull Panel panel, @NotNull WizardPopup popup) {
        JProgressBar jProgressBar;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        this.quotesPanel = BuilderKt.panel(arg_0 -> AIHubQuotes._init_$lambda$3(this, arg_0));
        Panel $this$_init__u24lambda_u245 = panel;
        boolean bl = false;
        Panel.row$default((Panel)$this$_init__u24lambda_u245, null, arg_0 -> AIHubQuotes.lambda$5$lambda$4(this, arg_0), (int)1, null);
        JLabel jLabel2 = this.creditsLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"creditsLabel");
            jLabel2 = null;
        }
        if ((jLabel = this.remainedLabel) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remainedLabel");
            jLabel = null;
        }
        if ((jProgressBar = this.progressBar) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            jProgressBar = null;
        }
        this.updateQuotes(this.quotesPanel, jLabel2, jLabel, jProgressBar);
        JProgressBar jProgressBar2 = this.progressBar;
        if (jProgressBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
            jProgressBar2 = null;
        }
        UiScopeKt.launchOnShow$default((Component)jProgressBar2, (String)"HUB quotes", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, popup, null){
            int label;
            final /* synthetic */ AIHubQuotes this$0;
            final /* synthetic */ WizardPopup $popup;
            {
                this.this$0 = $receiver;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow[] flowArray = new Flow[]{QuotaManager2.Companion.getInstance().getQuotaInfo(), QuotaManager2.Companion.getInstance().getNextRefill()};
                        this.label = 1;
                        Object object2 = FlowKt.merge((Flow[])flowArray).collect(new FlowCollector(){

                            public final Object emit(Object it, Continuation<? super Unit> $completion) {
                                JProgressBar jProgressBar;
                                JLabel jLabel;
                                DialogPanel dialogPanel = this$0.quotesPanel;
                                JLabel jLabel2 = this$0.creditsLabel;
                                if (jLabel2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"creditsLabel");
                                    jLabel2 = null;
                                }
                                if ((jLabel = this$0.remainedLabel) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"remainedLabel");
                                    jLabel = null;
                                }
                                if ((jProgressBar = this$0.progressBar) == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
                                    jProgressBar = null;
                                }
                                this$0.updateQuotes(dialogPanel, jLabel2, jLabel, jProgressBar);
                                AIAssistantUIUtilKt.repack((AbstractPopup)$popup);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void updateQuotes(DialogPanel quotesPanel, JLabel creditsLabel, JLabel remainedLabel, JProgressBar progressBar) {
        boolean bl;
        block10: {
            Iterable $this$any$iv = (Iterable)AIHubNotificationManager.Companion.getInstance().getNotifications().getValue();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AIHubNotificationManager.NotificationState it = (AIHubNotificationManager.NotificationState)element$iv;
                    boolean bl2 = false;
                    if (!AIHubNotificationManagerKt.isExpired(it.getNotification())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean anyExpiredNotification = bl;
        boolean isUnimplementedQuota = Intrinsics.areEqual((Object)QuotaManager2.Companion.getInstance().getQuotaInfo().getValue(), (Object)QuotaInfo.Companion.getEMPTY_AVAILABLE());
        if (anyExpiredNotification || isUnimplementedQuota) {
            quotesPanel.setVisible(false);
            return;
        }
        quotesPanel.setVisible(true);
        RemainedQuotasInfo quotasInfo = AIAssistantUIUtil.INSTANCE.getRemainedTariffQuotasPercent();
        QuotaTimeData quotaData = AIAssistantUIUtil.INSTANCE.getQuotaTimeData();
        creditsLabel.setText(this.getRemainedCredits());
        remainedLabel.setText(AIAssistantUIUtil.INSTANCE.formatQuotaInfoLabel(quotaData));
        progressBar.setValue(quotasInfo.getRemainedPercents());
        QuotaInfo.SuccessfulQuotaInfo quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        long usedCredits = 0L;
        long totalCredits = 0L;
        if (quota == null) {
            AIHubInstalled.Companion.getLog$intellij_ml_llm_core().debug("updateQuotes: lastSuccessfulQuota is null");
            usedCredits = 0L;
            totalCredits = 0L;
        } else {
            long l;
            QuotaInfo.SuccessfulQuotaInfo successfulQuotaInfo = quota;
            if (successfulQuotaInfo instanceof QuotaInfo.Available) {
                l = MathKt.roundToLong((double)((QuotaInfo.Available)quota).getCurrent().doubleValue());
            } else if (successfulQuotaInfo instanceof QuotaInfo.Reached) {
                l = MathKt.roundToLong((double)((QuotaInfo.Reached)quota).getMaximum().doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            usedCredits = l;
            totalCredits = MathKt.roundToLong((double)quota.getMaximum().doubleValue());
        }
        new HelpTooltip().setTitle(LLMBundle.message("ai.hub.quota.tooltip.title", new Object[0])).setDescription(AIHubInstalled.Companion.getQuotaTooltipMessage(usedCredits, totalCredits, quotasInfo.getEndsInDays(), quotasInfo.getEndsInHours())).installOn((JComponent)quotesPanel);
    }

    private final String getRemainedCredits() {
        long l;
        QuotaInfo.SuccessfulQuotaInfo quota = (QuotaInfo.SuccessfulQuotaInfo)QuotaManager2.Companion.getInstance().getLastSuccessfulQuota().getValue();
        if (quota instanceof QuotaInfo.Reached) {
            l = 0L;
        } else if (quota instanceof QuotaInfo.Available) {
            Comparable comparable = BigDecimal.ZERO;
            BigDecimal bigDecimal = ((QuotaInfo.Available)quota).getMaximum().subtract(((QuotaInfo.Available)quota).getCurrent());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(...)");
            Comparable comparable2 = ComparatorUtil.max((Comparable)comparable, (Comparable)bigDecimal);
            Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"max(...)");
            BigDecimal left = (BigDecimal)comparable2;
            l = MathKt.roundToLong((double)left.doubleValue());
        } else if (quota == null) {
            l = 0L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        long remainedCredits = l;
        Object[] objectArray = new Object[]{remainedCredits};
        return LLMBundle.message("ai.hub.quota.credit", objectArray);
    }

    private static final Unit lambda$3$lambda$0(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.creditsLabel = (JLabel)$this$row.label("").visible(AIHubInstalledKt.getIS_SHOW_QUOTAS_INFO()).getComponent();
        $this$row.label(LLMBundle.message("ai.hub.label.quota", new Object[0])).visible(!AIHubInstalledKt.getIS_SHOW_QUOTAS_INFO());
        this$0.remainedLabel = (JLabel)AIAssistantUIUtilKt.greyForeground($this$row.label("")).align((Align)AlignX.RIGHT.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2$lambda$1(JProgressBar $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setValue(0);
        $this$applyToComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, new VerticalComponentGap(Boolean.valueOf(false), null, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$3$lambda$2(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.progressBar = (JProgressBar)AIHubUIKt.hubProgressBar((Row)$this$row, (int)0, (int)100).align((Align)AlignX.FILL.INSTANCE).applyToComponent(AIHubQuotes::lambda$3$lambda$2$lambda$1).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(AIHubQuotes this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIHubQuotes.lambda$3$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AIHubQuotes.lambda$3$lambda$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$5$lambda$4(AIHubQuotes this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.quotesPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }
}

