/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtilKt;
import com.intellij.ml.llm.core.chat.ui.LicenseType;
import com.intellij.ml.llm.hub.AIHubNotificationManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/hub/AutoHideNotification;", "", "<init>", "()V", "statefulHideRules", "", "Lcom/intellij/ml/llm/hub/AIHubNotificationManager$Notification;", "getStatefulHideRules", "()Ljava/util/Set;", "licenseDependentHideRules", "", "Lcom/intellij/ml/llm/core/chat/ui/LicenseType;", "getLicenseDependentHideRules", "()Ljava/util/Map;", "paidLicensesHideRules", "getPaidLicensesHideRules", "contradictNotificationsHideRules", "", "getContradictNotificationsHideRules", "()Ljava/util/List;", "quotaExceededNotifications", "getQuotaExceededNotifications", "getHideReason", "", "notification", "allNotifications", "licenseType", "hasEnoughQuota", "", "intellij.ml.llm.core"})
@ApiStatus.Internal
public final class AutoHideNotification {
    @NotNull
    public static final AutoHideNotification INSTANCE = new AutoHideNotification();
    @NotNull
    private static final Set<AIHubNotificationManager.Notification> statefulHideRules;
    @NotNull
    private static final Map<LicenseType, Set<AIHubNotificationManager.Notification>> licenseDependentHideRules;
    @NotNull
    private static final Set<AIHubNotificationManager.Notification> paidLicensesHideRules;
    @NotNull
    private static final List<Set<AIHubNotificationManager.Notification>> contradictNotificationsHideRules;
    @NotNull
    private static final Set<AIHubNotificationManager.Notification> quotaExceededNotifications;

    private AutoHideNotification() {
    }

    @NotNull
    public final Set<AIHubNotificationManager.Notification> getStatefulHideRules() {
        return statefulHideRules;
    }

    @NotNull
    public final Map<LicenseType, Set<AIHubNotificationManager.Notification>> getLicenseDependentHideRules() {
        return licenseDependentHideRules;
    }

    @NotNull
    public final Set<AIHubNotificationManager.Notification> getPaidLicensesHideRules() {
        return paidLicensesHideRules;
    }

    @NotNull
    public final List<Set<AIHubNotificationManager.Notification>> getContradictNotificationsHideRules() {
        return contradictNotificationsHideRules;
    }

    @NotNull
    public final Set<AIHubNotificationManager.Notification> getQuotaExceededNotifications() {
        return quotaExceededNotifications;
    }

    @Nullable
    public final String getHideReason(@NotNull AIHubNotificationManager.Notification notification, @NotNull Set<? extends AIHubNotificationManager.Notification> allNotifications, @Nullable LicenseType licenseType, boolean hasEnoughQuota) {
        Intrinsics.checkNotNullParameter((Object)((Object)notification), (String)"notification");
        Intrinsics.checkNotNullParameter(allNotifications, (String)"allNotifications");
        if (statefulHideRules.contains((Object)notification) && !allNotifications.contains((Object)notification)) {
            return "statefulHideRules";
        }
        if (CollectionsKt.contains((Iterable)licenseDependentHideRules.keySet(), (Object)((Object)licenseType))) {
            for (Map.Entry entry : licenseDependentHideRules.entrySet()) {
                LicenseType lt = (LicenseType)((Object)entry.getKey());
                Set allowedNotifications = (Set)entry.getValue();
                if (lt == licenseType || !allowedNotifications.contains((Object)notification)) continue;
                return "licenseDependentHideRules";
            }
        }
        for (Set set : contradictNotificationsHideRules) {
            int intersectionCount = CollectionsKt.intersect((Iterable)set, (Iterable)allNotifications).size();
            if (intersectionCount > 1) {
                AIHubNotificationManager.Companion.getLog$intellij_ml_llm_core().info("Notifications break contradictNotificationsHideRules: " + allNotifications);
                break;
            }
            if (intersectionCount != 1 || !set.contains((Object)notification) || allNotifications.contains((Object)notification)) continue;
            return "contradictNotificationsHideRules";
        }
        LicenseType licenseType2 = licenseType;
        if ((licenseType2 != null ? Intrinsics.areEqual((Object)AIAssistantUIUtilKt.isPaid(licenseType2), (Object)true) : false) && paidLicensesHideRules.contains((Object)notification)) {
            return "paidLicensesHideRules";
        }
        if (quotaExceededNotifications.contains((Object)notification) && !allNotifications.contains((Object)notification) && hasEnoughQuota) {
            return "quotaExceededNotifications";
        }
        return null;
    }

    static {
        AIHubNotificationManager.Notification[] notificationArray = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.THIRD_PARTY_PROVIDERS_BLOCKED, AIHubNotificationManager.Notification.QUOTA_ALMOST_REACHED, AIHubNotificationManager.Notification.NO_LOCAL_MODELS};
        statefulHideRules = SetsKt.setOf((Object[])notificationArray);
        notificationArray = new Pair[7];
        notificationArray[0] = TuplesKt.to((Object)((Object)LicenseType.ULTIMATE), (Object)SetsKt.setOf((Object)((Object)AIHubNotificationManager.Notification.ULTIMATE_QUOTA_EXCEEDED)));
        notificationArray[1] = TuplesKt.to((Object)((Object)LicenseType.ENTERPRISE), (Object)SetsKt.setOf((Object)((Object)AIHubNotificationManager.Notification.ENTERPRISE_QUOTA_EXCEEDED)));
        AIHubNotificationManager.Notification[] notificationArray2 = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRING, AIHubNotificationManager.Notification.PRO_TRIAL_QUOTA_EXCEEDED};
        notificationArray[2] = TuplesKt.to((Object)((Object)LicenseType.PRO_TRIAL), (Object)SetsKt.setOf((Object[])notificationArray2));
        notificationArray2 = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.PRO_EXPIRING, AIHubNotificationManager.Notification.PRO_QUOTA_EXCEEDED};
        notificationArray[3] = TuplesKt.to((Object)((Object)LicenseType.PRO), (Object)SetsKt.setOf((Object[])notificationArray2));
        notificationArray2 = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRING, AIHubNotificationManager.Notification.BUSINESS_TRIAL_QUOTA_EXCEEDED};
        notificationArray[4] = TuplesKt.to((Object)((Object)LicenseType.BUSINESS_TRIAL), (Object)SetsKt.setOf((Object[])notificationArray2));
        notificationArray2 = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.BUSINESS_EXPIRING, AIHubNotificationManager.Notification.BUSINESS_QUOTA_EXCEEDED};
        notificationArray[5] = TuplesKt.to((Object)((Object)LicenseType.BUSINESS), (Object)SetsKt.setOf((Object[])notificationArray2));
        notificationArray2 = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.FREE_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.FREE_ENABLED, AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_FREE_ENABLED};
        notificationArray[6] = TuplesKt.to((Object)((Object)LicenseType.FREE), (Object)SetsKt.setOf((Object[])notificationArray2));
        licenseDependentHideRules = MapsKt.mapOf((Pair[])notificationArray);
        notificationArray = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.FREE_ENABLED, AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_FREE_ENABLED, AIHubNotificationManager.Notification.PRO_TRIAL_EXPIRED, AIHubNotificationManager.Notification.PRO_EXPIRED, AIHubNotificationManager.Notification.BUSINESS_TRIAL_EXPIRED, AIHubNotificationManager.Notification.BUSINESS_EXPIRED};
        paidLicensesHideRules = SetsKt.setOf((Object[])notificationArray);
        notificationArray = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.FREE_ENABLED, AIHubNotificationManager.Notification.LICENSE_EXPIRED_AND_FREE_ENABLED};
        contradictNotificationsHideRules = CollectionsKt.listOf((Object)SetsKt.setOf((Object[])notificationArray));
        notificationArray = new AIHubNotificationManager.Notification[]{AIHubNotificationManager.Notification.FREE_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.BUSINESS_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.BUSINESS_TRIAL_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.PRO_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.PRO_TRIAL_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.ULTIMATE_QUOTA_EXCEEDED, AIHubNotificationManager.Notification.ENTERPRISE_QUOTA_EXCEEDED};
        quotaExceededNotifications = SetsKt.setOf((Object[])notificationArray);
    }
}

