/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.hub.actions;

import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsManager;
import com.intellij.ml.llm.hub.statistics.AIHubLogger;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/hub/actions/EnableSwitcherForThisProjectAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "enableAction", "", "<init>", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSettings", "Lcom/intellij/ml/llm/core/settings/LLMProjectSettingsManager;", "Lcom/intellij/ml/llm/hub/actions/DisableForThisProjectAction;", "Lcom/intellij/ml/llm/hub/actions/EnableForThisProjectAction;", "intellij.ml.llm.core"})
@ApiStatus.Internal
public abstract class EnableSwitcherForThisProjectAction
extends DumbAwareAction {
    private final boolean enableAction;

    private EnableSwitcherForThisProjectAction(boolean enableAction) {
        this.enableAction = enableAction;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AIHubLogger.Action logAction = this.enableAction ? AIHubLogger.Action.ENABLE_FOR_PROJECT : AIHubLogger.Action.DISABLE_FOR_PROJECT;
        AIHubLogger.INSTANCE.logHubActionsClicked(e.getProject(), logAction);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        AIAssistantUIUtil.INSTANCE.setAIEnabled(project, this.enableAction);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LLMProjectSettingsManager lLMProjectSettingsManager = this.getSettings(e);
        e.getPresentation().setVisible(lLMProjectSettingsManager != null ? lLMProjectSettingsManager.isTurnedOn() == !this.enableAction : false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final LLMProjectSettingsManager getSettings(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return LLMProjectSettingsManager.Companion.getInstance(project2);
    }

    public /* synthetic */ EnableSwitcherForThisProjectAction(boolean enableAction, DefaultConstructorMarker $constructor_marker) {
        this(enableAction);
    }
}

