/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.caching;

import ai.grazie.model.llm.chat.caching.LLMCachePoint;
import ai.grazie.model.llm.chat.caching.LLMCachePoints;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool;
import ai.grazie.model.llm.chat.v5.LLMChatMediaMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.chat.v5.LLMChatSystemMessage;
import ai.grazie.model.llm.chat.v5.LLMChatToolMessage;
import ai.grazie.model.llm.chat.v5.LLMChatUserMessage;
import ai.grazie.model.llm.parameters.LLMParameters;
import ai.grazie.model.llm.profile.AnthropicProfileIDs;
import ai.grazie.model.llm.profile.LLMProfileID;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import ai.grazie.utils.json.JSON;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\n\u0010\u0012\u001a\u00020\u0010*\u00020\u0005R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/util/caching/PromptCachingUtil;", "", "<init>", "()V", "buildCachePoints", "Lai/grazie/model/llm/chat/caching/LLMCachePoints;", "profile", "Lai/grazie/model/llm/profile/LLMProfileID;", "messages", "", "Lai/grazie/model/llm/chat/v5/LLMChatMessage;", "functionDeclarations", "", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "(Lai/grazie/model/llm/profile/LLMProfileID;[Lai/grazie/model/llm/chat/v5/LLMChatMessage;Ljava/util/List;)Lai/grazie/model/llm/chat/caching/LLMCachePoints;", "append", "Lai/grazie/utils/attributes/Attributes;", "cachePoints", "toAttributes", "MAX_CACHE_POINTS", "", "SUPPORTED_MODELS", "getSUPPORTED_MODELS", "()Ljava/util/List;", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nPromptCachingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromptCachingUtil.kt\ncom/intellij/ml/llm/util/caching/PromptCachingUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 JSON.kt\nai/grazie/utils/json/JSON\n*L\n1#1,78:1\n1740#2,3:79\n774#2:95\n865#2,2:96\n1563#2:98\n1634#2,3:99\n1056#2:102\n1#3:82\n1790#4,6:83\n1790#4,6:89\n28#5:103\n28#5:104\n*S KotlinDebug\n*F\n+ 1 PromptCachingUtil.kt\ncom/intellij/ml/llm/util/caching/PromptCachingUtil\n*L\n23#1:79,3\n42#1:95\n42#1:96,2\n43#1:98\n43#1:99,3\n47#1:102\n32#1:83,6\n37#1:89,6\n58#1:103\n66#1:104\n*E\n"})
public final class PromptCachingUtil {
    @NotNull
    public static final PromptCachingUtil INSTANCE = new PromptCachingUtil();
    public static final int MAX_CACHE_POINTS = 4;
    @NotNull
    private static final List<LLMProfileID> SUPPORTED_MODELS;

    private PromptCachingUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LLMCachePoints buildCachePoints(@NotNull LLMProfileID profile, @NotNull LLMChatMessage[] messages, @NotNull List<LlmFunctionDescriptor> functionDeclarations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int index;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        LLMCachePoint lLMCachePoint;
        int n;
        Object $this$indexOfLast$iv;
        LLMCachePoint systemMessageCachePoint;
        Integer $this$indexOfLast$iv2;
        LLMCachePoint toolDeclarationCachePoint;
        block21: {
            LLMCachePoint lLMCachePoint2;
            int n2;
            int index$iv;
            Object object;
            block20: {
                LLMCachePoint lLMCachePoint3;
                LLMChatMessage[] $i$f$all2;
                int n3;
                block23: {
                    block22: {
                        boolean bl;
                        block19: {
                            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                            Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
                            Intrinsics.checkNotNullParameter(functionDeclarations, (String)"functionDeclarations");
                            boolean enablePromptCaching = Registry.Companion.get("llm.ai.prompt.caching.enabled").asBoolean();
                            if (!enablePromptCaching) break block22;
                            Iterable $this$all$iv = SUPPORTED_MODELS;
                            boolean $i$f$all2 = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                object = $this$all$iv.iterator();
                                while (object.hasNext()) {
                                    Object element$iv = object.next();
                                    LLMProfileID it = (LLMProfileID)element$iv;
                                    n3 = 0;
                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)profile.getId())) continue;
                                    bl = false;
                                    break block19;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block23;
                    }
                    return null;
                }
                LLMChatMessage[] it = object = functionDeclarations;
                boolean bl = false;
                Object object2 = $i$f$all2 = !((Collection)it).isEmpty() ? object : null;
                if ($i$f$all2 != null) {
                    it = $i$f$all2;
                    boolean bl2 = false;
                    lLMCachePoint3 = new LLMCachePoint(it.size());
                } else {
                    lLMCachePoint3 = null;
                }
                toolDeclarationCachePoint = lLMCachePoint3;
                it = messages;
                boolean $i$f$indexOfLast = false;
                n3 = ((void)$this$indexOfLast$iv2).length + -1;
                if (0 <= n3) {
                    do {
                        index$iv = n3--;
                        Integer it2 = $this$indexOfLast$iv2[index$iv];
                        boolean bl3 = false;
                        if (!(it2 instanceof LLMChatSystemMessage)) continue;
                        n2 = index$iv;
                        break block20;
                    } while (0 <= n3);
                }
                n2 = -1;
            }
            $this$indexOfLast$iv2 = n2;
            int it = ((Number)$this$indexOfLast$iv2).intValue();
            boolean bl = false;
            Object object3 = object = it != -1 ? $this$indexOfLast$iv2 : null;
            if (object != null) {
                it = ((Number)object).intValue();
                boolean bl4 = false;
                lLMCachePoint2 = new LLMCachePoint(it + 1);
            } else {
                lLMCachePoint2 = null;
            }
            systemMessageCachePoint = lLMCachePoint2;
            LLMChatMessage[] it2 = messages;
            boolean $i$f$indexOfLast = false;
            index$iv = ((void)$this$indexOfLast$iv).length + -1;
            if (0 <= index$iv) {
                do {
                    int index$iv2 = index$iv--;
                    Integer it3 = $this$indexOfLast$iv[index$iv2];
                    boolean bl5 = false;
                    if (!(it3 instanceof LLMChatToolMessage || it3 instanceof LLMChatAssistantMessageTool)) continue;
                    n = index$iv2;
                    break block21;
                } while (0 <= index$iv);
            }
            n = -1;
        }
        $this$indexOfLast$iv = n;
        int it = ((Number)$this$indexOfLast$iv).intValue();
        boolean bl = false;
        Integer n4 = $this$indexOfLast$iv2 = it != -1 ? $this$indexOfLast$iv : null;
        if ($this$indexOfLast$iv2 != null) {
            it = ((Number)$this$indexOfLast$iv2).intValue();
            boolean bl6 = false;
            lLMCachePoint = new LLMCachePoint(it + 1);
        } else {
            lLMCachePoint = null;
        }
        LLMCachePoint toolCachePoint = lLMCachePoint;
        $this$indexOfLast$iv = (Iterable)ArraysKt.getIndices((Object[])messages);
        boolean $i$f$filter = false;
        void bl6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            index = ((Number)element$iv$iv).intValue();
            boolean bl7 = false;
            if (!(messages[index] instanceof LLMChatMediaMessage || messages[index] instanceof LLMChatUserMessage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void element;
            index = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(new LLMCachePoint((int)(element + true)));
        }
        Object object = new LLMCachePoint[]{toolDeclarationCachePoint, systemMessageCachePoint, toolCachePoint};
        List messageCachePoints = CollectionsKt.takeLast((List)((List)destination$iv$iv), (int)(4 - CollectionsKt.listOfNotNull((Object[])object).size()));
        Object[] $i$f$map22 = new LLMCachePoint[]{systemMessageCachePoint, toolCachePoint};
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])$i$f$map22), (Iterable)messageCachePoints);
        boolean $i$f$sortedBy = false;
        object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LLMCachePoint it = (LLMCachePoint)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (LLMCachePoint)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
        List list = CollectionsKt.listOfNotNull((Object)toolDeclarationCachePoint);
        List list2 = CollectionsKt.emptyList();
        return new LLMCachePoints(list2, (List)object, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Attributes append(@NotNull Attributes $this$append, @Nullable LLMCachePoints cachePoints) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        if (AttributesExtensionKt.getCachePoints((Attributes)$this$append) != null || cachePoints == null) {
            return $this$append;
        }
        JSON jSON = (JSON)JSON.Default.INSTANCE;
        LLMCachePoints value$iv = cachePoints;
        boolean $i$f$string = false;
        Attributes.Value.Json encoded = new Attributes.Value.Json(this_$iv.string((SerializationStrategy)LLMCachePoints.Companion.serializer(), (Object)value$iv), null, 2, null);
        return $this$append.plus(Attributes.Companion.invoke(MapsKt.mapOf((Pair)TuplesKt.to((Object)LLMParameters.INSTANCE.getCachePoints(), (Object)encoded))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Attributes toAttributes(@NotNull LLMCachePoints $this$toAttributes) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toAttributes, (String)"<this>");
        if ($this$toAttributes.getMessages().isEmpty() && $this$toAttributes.getTools().isEmpty() && $this$toAttributes.getFunctions().isEmpty()) {
            return Attributes.Companion.invoke(MapsKt.emptyMap());
        }
        JSON jSON = (JSON)JSON.Default.INSTANCE;
        LLMCachePoints value$iv = $this$toAttributes;
        boolean $i$f$string = false;
        Attributes.Value.Json encoded = new Attributes.Value.Json(this_$iv.string((SerializationStrategy)LLMCachePoints.Companion.serializer(), (Object)value$iv), null, 2, null);
        return Attributes.Companion.invoke(MapsKt.mapOf((Pair)TuplesKt.to((Object)LLMParameters.INSTANCE.getCachePoints(), (Object)encoded)));
    }

    @NotNull
    public final List<LLMProfileID> getSUPPORTED_MODELS() {
        return SUPPORTED_MODELS;
    }

    static {
        Object[] objectArray = new LLMProfileID[]{AnthropicProfileIDs.INSTANCE.getClaude_4_Opus(), AnthropicProfileIDs.INSTANCE.getClaude_4_Sonnet(), AnthropicProfileIDs.INSTANCE.getClaude_3_7_Sonnet(), AnthropicProfileIDs.INSTANCE.getClaude_3_5_Haiku()};
        SUPPORTED_MODELS = CollectionsKt.listOf((Object[])objectArray);
    }
}

