/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.util.file;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/util/file/FileManagerUtils;", "", "<init>", "()V", "getOpenedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getRecentFiles", "", "notAllowedFileTypes", "", "isSupported", "", "file", "Lcom/intellij/psi/PsiFile;", "isSupported$intellij_ml_llm_core", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nFileManagerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManagerUtils.kt\ncom/intellij/ml/llm/util/file/FileManagerUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n3829#2:61\n4344#2,2:62\n*S KotlinDebug\n*F\n+ 1 FileManagerUtils.kt\ncom/intellij/ml/llm/util/file/FileManagerUtils\n*L\n33#1:61\n33#1:62,2\n*E\n"})
public final class FileManagerUtils {
    @NotNull
    public static final FileManagerUtils INSTANCE = new FileManagerUtils();
    @NotNull
    private static final List<String> notAllowedFileTypes = CollectionsKt.listOf((Object)"svg");

    private FileManagerUtils() {
    }

    @ApiStatus.Internal
    @Nullable
    public final VirtualFile getOpenedFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        VirtualFile[] virtualFileArray = fileEditorManager.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
        return (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<VirtualFile> getRecentFiles(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List recentFiles = EditorHistoryManager.Companion.getInstance(project).getFileList();
        Object[] objectArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
        Object[] openFiles = objectArray;
        HashSet recentFilesSet = new HashSet(recentFiles);
        HashSet openFilesSet = ArraysKt.toHashSet((Object[])openFiles);
        int index = 0;
        int n = ((Collection)recentFiles).size();
        for (int i = 0; i < n; ++i) {
            if (!openFilesSet.contains(recentFiles.get(i))) continue;
            index = i;
            break;
        }
        ArrayList result2 = new ArrayList(recentFiles);
        Object[] objectArray2 = openFiles;
        int n2 = index;
        ArrayList arrayList = result2;
        boolean $i$f$filter = false;
        void var10_14 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!recentFilesSet.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList.addAll(n2, list);
        return result2;
    }

    public final boolean isSupported$intellij_ml_llm_core(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getVirtualFile() instanceof LightVirtualFile) {
            return false;
        }
        if (file.getFileType().isBinary()) {
            return false;
        }
        String string = file.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return !notAllowedFileTypes.contains(string2);
    }

    public final boolean isSupported(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof LightVirtualFile) {
            return false;
        }
        if (file.getFileType().isBinary()) {
            return false;
        }
        String string = file.getFileType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return !notAllowedFileTypes.contains(string2);
    }
}

