/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.inlinePromptDetector.GenerateCodeIntentionKt;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptBundle;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptGenerateCodeAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\r\u0010\u0011\u001a\u00070\n\u00a2\u0006\u0002\b\u0012H\u0016J\r\u0010\u0013\u001a\u00070\n\u00a2\u0006\u0002\b\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J!\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/GenerateCodeIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "Lcom/intellij/openapi/util/Iconable;", "promptRange", "Lcom/intellij/psi/SmartPsiFileRange;", "<init>", "(Lcom/intellij/psi/SmartPsiFileRange;)V", "promptElaborations", "", "", "smartPromptRange", "addPromptElaboration", "", "elaboration", "getPromptRange", "Lcom/intellij/openapi/util/TextRange;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "startInWriteAction", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "Companion", "intellij.ml.llm.inlinePromptDetector"})
public final class GenerateCodeIntention
implements IntentionAction,
PriorityAction,
Iconable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> promptElaborations;
    @Nullable
    private volatile SmartPsiFileRange smartPromptRange;

    public GenerateCodeIntention(@NotNull SmartPsiFileRange promptRange) {
        Intrinsics.checkNotNullParameter((Object)promptRange, (String)"promptRange");
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.promptElaborations = list;
        this.smartPromptRange = promptRange;
    }

    public final void addPromptElaboration(@NotNull String elaboration) {
        Intrinsics.checkNotNullParameter((Object)elaboration, (String)"elaboration");
        this.promptElaborations.add(elaboration);
    }

    @Nullable
    public final TextRange getPromptRange() {
        SmartPsiFileRange smartPsiFileRange = this.smartPromptRange;
        return smartPsiFileRange != null && (smartPsiFileRange = smartPsiFileRange.getRange()) != null ? GenerateCodeIntentionKt.access$asTextRange((Segment)smartPsiFileRange) : null;
    }

    @NotNull
    public String getFamilyName() {
        return LLMBundle.message((String)"intention.category.small.on.file", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{AIAssistantBranding.INSTANCE.getName()};
        return InlinePromptBundle.message("generate.code.with.ai.assistant.intention.name", objectArray);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return editor.getUserData(GenerateCodeIntentionKt.getINLINE_PROMPT_CODE_GENERATION_CANCELLATION_KEY()) == null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!this.isAvailable(project, editor, psiFile)) {
            return;
        }
        InlinePromptGenerateCodeAction.Companion.generateFromDetectedPrompt(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public Icon getIcon(int flags) {
        return AIAssistantBranding.Logo16Colored;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/GenerateCodeIntention$Companion;", "", "<init>", "()V", "isGenerationInProgress", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.inlinePromptDetector"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isGenerationInProgress(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return editor.getUserData(GenerateCodeIntentionKt.getINLINE_PROMPT_CODE_GENERATION_CANCELLATION_KEY()) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

