/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.ml.llm.editor.AICaretAttributeKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorHighlightingPredicate;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u000e\u0012\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\u000e\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptEditorFilter;", "Lcom/intellij/openapi/editor/impl/EditorHighlightingPredicate;", "Lcom/intellij/openapi/Disposable$Default;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "promptHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "ignoredErrors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "shouldRender", "element", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "afterAdded", "", "highlighter", "attributesChanged", "renderersChanged", "fontStyleChanged", "foregroundColorChanged", "addToIgnoredIfErrorOrWarning", "intellij.ml.llm.inlinePromptDetector"})
final class InlinePromptEditorFilter
implements EditorHighlightingPredicate,
Disposable.Default,
MarkupModelListener {
    @NotNull
    private final RangeHighlighterEx promptHighlighter;
    @NotNull
    private final EditorColorsScheme colorScheme;
    @NotNull
    private final ConcurrentMap<RangeHighlighterEx, Boolean> ignoredErrors;

    public InlinePromptEditorFilter(@NotNull RangeHighlighterEx promptHighlighter, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)promptHighlighter, (String)"promptHighlighter");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        this.promptHighlighter = promptHighlighter;
        this.colorScheme = colorScheme;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.ignoredErrors = concurrentMap;
    }

    public boolean shouldRender(@NotNull RangeHighlighter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTextAttributesKey(), (Object)AICaretAttributeKeys.INLINE_PROMPT_ATTRS)) {
            return true;
        }
        if (((Map)this.ignoredErrors).containsKey(element)) {
            return false;
        }
        if (!element.getTextRange().intersects((Segment)this.promptHighlighter)) {
            return true;
        }
        TextAttributes textAttributes = element.getTextAttributes(this.colorScheme);
        return !(textAttributes != null ? textAttributes.hasEffects() : false);
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.addToIgnoredIfErrorOrWarning(highlighter);
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.addToIgnoredIfErrorOrWarning(highlighter);
    }

    private final void addToIgnoredIfErrorOrWarning(RangeHighlighterEx highlighter) {
        TextAttributesKey textAttributesKey = highlighter.getTextAttributesKey();
        if (textAttributesKey == null) {
            return;
        }
        TextAttributesKey attributesKey = textAttributesKey;
        if (Intrinsics.areEqual((Object)attributesKey, (Object)CodeInsightColors.ERRORS_ATTRIBUTES) || Intrinsics.areEqual((Object)attributesKey, (Object)CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES) || Intrinsics.areEqual((Object)attributesKey, (Object)CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING) || Intrinsics.areEqual((Object)attributesKey, (Object)CodeInsightColors.WARNINGS_ATTRIBUTES) || Intrinsics.areEqual((Object)attributesKey, (Object)CodeInsightColors.RUNTIME_ERROR)) {
            this.ignoredErrors.put(highlighter, true);
        }
    }
}

