/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.inlinePrompt.InlinePromptExtension;
import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.inlinePromptDetector.ui.InlinePromptHintsManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ'\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptExtensionsImpl;", "Lcom/intellij/inlinePrompt/InlinePromptExtension;", "<init>", "()V", "isInlinePromptShown", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Z", "isInlinePromptCodeGenerating", "getBulbIcon", "Ljavax/swing/Icon;", "intellij.ml.llm.inlinePromptDetector"})
final class InlinePromptExtensionsImpl
implements InlinePromptExtension {
    public boolean isInlinePromptShown(@NotNull Project project, @NotNull Editor editor, @Nullable Integer line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return InlinePromptHintsManager.INSTANCE.isGenerateHintShown(editor, line);
    }

    public boolean isInlinePromptCodeGenerating(@NotNull Project project, @NotNull Editor editor, @Nullable Integer line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return InlinePromptHintsManager.INSTANCE.isGenerationInProgressHintShown(editor, line);
    }

    @NotNull
    public Icon getBulbIcon(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Icon icon = MLLlmIcons.IntentionBulbInlinePrompt;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IntentionBulbInlinePrompt");
        return icon;
    }
}

