/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.inlinePromptDetector;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.DisabledInlinePrompts;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptAdvancedSettingListener;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptCustomDetector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptDetectorUtil;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptExtensionPoints;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingPassFactory;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingPassFactoryKt;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptHighlightingUtil;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptMarkupModelListenerKt;
import com.intellij.ml.llm.inlinePromptDetector.PromptInfo;
import com.intellij.ml.llm.inlinePromptDetector.ui.InlinePromptHintsManager;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHint;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.inlinePromptDetector"})
public final class InlinePromptHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Language language = psiFile.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        InlinePromptCustomDetector inlinePromptCustomDetector = InlinePromptExtensionPoints.INSTANCE.findDetectorByLanguage(language);
        if (inlinePromptCustomDetector == null) {
            return null;
        }
        InlinePromptCustomDetector detector = inlinePromptCustomDetector;
        if (!InlinePromptDetectorUtil.INSTANCE.isAvailable(psiFile, editor, detector)) {
            return null;
        }
        Project project = psiFile.getProject();
        Document document = editor.getDocument();
        return (TextEditorHighlightingPass)new DumbAware(psiFile, editor, detector, project, document){
            private final int creationStamp;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ InlinePromptCustomDetector $detector;
            {
                this.$psiFile = $psiFile;
                this.$editor = $editor;
                this.$detector = $detector;
                super($super_call_param$1, $super_call_param$2);
                this.creationStamp = InlinePromptAdvancedSettingListener.Companion.getSettingModificationStamp().get();
            }

            /*
             * WARNING - void declaration
             */
            public void doCollectInformation(ProgressIndicator progress) {
                void $this$debug_u24default$iv;
                Collection collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int it;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                if (!AdvancedSettings.Companion.getBoolean("ai.assistant.inline.prompt.detector") || PrivacyPathCheckerKt.isAiIgnoreBlocked((PsiElement)((PsiElement)this.$psiFile))) {
                    void $this$debug_u24default$iv2;
                    Logger logger = InlinePromptHighlightingPassFactoryKt.getInlinePromptLog();
                    Editor editor = this.$editor;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        void var19_10 = $this$debug_u24default$iv2;
                        boolean bl = false;
                        var19_10.debug("Highlighting pass for " + editor + ": inline prompt detector is disabled", e$iv);
                    }
                    this.addHighlightInfos(CollectionsKt.emptyList());
                    return;
                }
                progress.checkCanceled();
                Project project = this.$psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                Set<Integer> lineNumbers = this.getCaretLineNumbers(document2);
                DisabledInlinePrompts.Companion.possiblyEnableAllLines(this.$editor);
                Iterable $this$filter$iv = lineNumbers;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(it < document2.getLineCount())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    int start = document2.getLineStartOffset(it);
                    int end = document2.getLineEndOffset(it);
                    int lineSep = document2.getLineSeparatorLength(it);
                    int newlineOffset = RangesKt.coerceAtLeast((int)StringsKt.indexOf$default((CharSequence)document2.getText().subSequence(end, end + lineSep), (char)'\n', (int)0, (boolean)false, (int)6, null), (int)0);
                    collection.add(new TextRange(start, end + newlineOffset));
                }
                List interestingRanges = (List)destination$iv$iv;
                List promptInfos = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable(this.$detector.findInlinePrompts(this.$psiFile, (Sequence<? extends TextRange>)CollectionsKt.asSequence((Iterable)interestingRanges))), arg_0 -> createHighlightingPass.1.doCollectInformation$lambda$3(document2, arg_0)), (int)1));
                if (this.$editor instanceof EditorImpl) {
                    InlinePromptMarkupModelListenerKt.installInlinePromptListenerTo((EditorImpl)this.$editor, document2, project2);
                }
                if (promptInfos.isEmpty()) {
                    if (this.$detector.isApplicable(this.$psiFile)) {
                        this.addHighlightInfos(CollectionsKt.emptyList());
                        ApplicationKt.getApplication().invokeLater(() -> createHighlightingPass.1.doCollectInformation$lambda$4(this.$editor));
                    }
                } else {
                    PromptInfo promptInfo = (PromptInfo)CollectionsKt.first((List)promptInfos);
                    HighlightInfo highlightInfo = InlinePromptHighlightingUtil.INSTANCE.processInlinePromptHighlighting(project2, this.$psiFile, this.$editor, document2, promptInfo.getPromptRange());
                    this.addHighlightInfos(CollectionsKt.listOf((Object)highlightInfo));
                    highlightInfo.getHighlighter().setEditorFilter(arg_0 -> createHighlightingPass.1.doCollectInformation$lambda$5(this.$editor, arg_0));
                }
                Logger promptInfo = InlinePromptHighlightingPassFactoryKt.getInlinePromptLog();
                Editor editor = this.$editor;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    collection = $this$debug_u24default$iv;
                    boolean bl = false;
                    collection.debug("inline prompt pass is finished for " + editor + " with promptInfos = " + promptInfos, e$iv);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final Set<Integer> getCaretLineNumbers(Document document) {
                Set set;
                void $this$mapTo$iv$iv;
                CaretModel caretModel = this.$editor.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                CaretModel caretModel2 = caretModel;
                List list = caretModel2.getAllCarets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void caret;
                    Caret caret2 = (Caret)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(document.getLineNumber(caret.getOffset()));
                }
                Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Editor editor = this.$editor;
                Set lineNumbers = set2;
                boolean bl = false;
                int disabledLine = DisabledInlinePrompts.Companion.disabledLine(editor);
                if (lineNumbers.contains(disabledLine)) {
                    Logger $this$debug_u24default$iv = InlinePromptHighlightingPassFactoryKt.getInlinePromptLog();
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl2 = false;
                        logger.debug("inline prompt detector is disabled for " + editor + " on line " + disabledLine, e$iv);
                    }
                    set = SetsKt.minus((Set)lineNumbers, (Object)disabledLine);
                } else {
                    set = lineNumbers;
                }
                Set lineNumbers2 = set;
                return lineNumbers2;
            }

            private final void addHighlightInfos(List<? extends HighlightInfo> highlightInfos) {
                BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.$psiFile.getProject(), (PsiFile)this.$psiFile, (Document)this.getDocument(), (int)0, (int)this.$psiFile.getTextLength(), (Collection)highlightInfos, (int)this.getId());
                Iterable $this$forEach$iv = highlightInfos;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HighlightInfo highlighter = (HighlightInfo)element$iv;
                    boolean bl = false;
                    RangeHighlighterEx rangeHighlighterEx = highlighter.getHighlighter();
                    if (rangeHighlighterEx != null) {
                        rangeHighlighterEx.setGreedyToRight(true);
                    }
                    RangeHighlighterEx rangeHighlighterEx2 = highlighter.getHighlighter();
                    if (rangeHighlighterEx2 == null) continue;
                    EditorActionAvailabilityHint[] editorActionAvailabilityHintArray = new EditorActionAvailabilityHint[]{new EditorActionAvailabilityHint("InlinePromptGenerateCodeAction", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null)};
                    EditorActionAvailabilityHintKt.addActionAvailabilityHint((RangeHighlighter)((RangeHighlighter)rangeHighlighterEx2), (EditorActionAvailabilityHint[])editorActionAvailabilityHintArray);
                }
            }

            public void doApplyInformationToEditor() {
            }

            protected boolean isValid() {
                return super.isValid() && this.creationStamp == InlinePromptAdvancedSettingListener.Companion.getSettingModificationStamp().get();
            }

            private static final PromptInfo doCollectInformation$lambda$3(Document $document, TextRange range) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return new PromptInfo(range, $document.getLineNumber(range.getStartOffset()));
            }

            private static final void doCollectInformation$lambda$4(Editor $editor) {
                InlinePromptHintsManager.INSTANCE.onInlinePromptNotFound$intellij_ml_llm_inlinePromptDetector($editor);
            }

            private static final boolean doCollectInformation$lambda$5(Editor $editor, Editor e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return $editor == e;
            }
        };
    }
}

