/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal;

import ai.grazie.code.exec.model.DeviceMetadataProvider;
import ai.grazie.code.exec.model.TerminalHistoryProvider;
import ai.grazie.code.exec.model.TerminalMetadataProvider;
import ai.grazie.code.features.terminal.TerminalTextToCommandFeature;
import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import ai.grazie.model.task.SuspendableTasksService;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.LLMTextPresentation;
import com.intellij.ml.llm.LLMTextWithIconPresentation;
import com.intellij.ml.llm.core.clients.AiaLlmProviderClient;
import com.intellij.ml.llm.grazie.ErrorStateAction;
import com.intellij.ml.llm.grazie.ErrorStateDescriptor;
import com.intellij.ml.llm.grazie.GrazieErrorUtilKt;
import com.intellij.ml.llm.terminal.IJDeviceMetadataProvider;
import com.intellij.ml.llm.terminal.IJTerminalHistoryProvider;
import com.intellij.ml.llm.terminal.IJTerminalMetadataProvider;
import com.intellij.ml.llm.terminal.TerminalAskingAiPlaceholderManager;
import com.intellij.ml.llm.terminal.TerminalLLMScopeProvider;
import com.intellij.ml.llm.terminal.TerminalOldAiPlaceholderManager;
import com.intellij.ml.llm.terminal.TerminalTextToCommandAction;
import com.intellij.ml.llm.terminal.TerminalTextToCommandChrF;
import com.intellij.ml.llm.terminal.TerminalTextToCommandEditDistance;
import com.intellij.ml.llm.terminal.TerminalTextToCommandLengthDiff;
import com.intellij.ml.llm.terminal.TerminalTextToCommandModeActivator;
import com.intellij.ml.llm.terminal.TerminalTextToCommandPromptsHistory;
import com.intellij.ml.llm.terminal.TerminalTextToCommandSession;
import com.intellij.ml.llm.terminal.TerminalTextToCommandSessionListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.http.HttpConnectTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.EventListener;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.action.TerminalCommandCompletionAction;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;
import org.jetbrains.plugins.terminal.fus.TerminalCommandGenerationEvent;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 O2\u00020\u0001:\u0004LMNOB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u001a\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00142\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0019J\u0016\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u0010.J$\u0010/\u001a\b\u0012\u0004\u0012\u00020+002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0082@\u00a2\u0006\u0002\u0010.J\u001c\u00101\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00020+00H\u0082@\u00a2\u0006\u0002\u00103J \u00104\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\b\u00105\u001a\u0004\u0018\u000106H\u0082@\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u00020!H\u0082@\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020!H\u0003J\b\u0010;\u001a\u00020!H\u0003J\b\u0010<\u001a\u00020!H\u0003J\u0010\u0010=\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0003J\b\u0010>\u001a\u00020!H\u0002J\b\u0010?\u001a\u00020!H\u0002J\u0019\u0010@\u001a\u00020!2\u000e\b\u0004\u0010A\u001a\b\u0012\u0004\u0012\u00020!0BH\u0082\bJ\u001d\u0010C\u001a\u00020!2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020!0DH\u0082\bJ\u0018\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020G2\u0006\u0010%\u001a\u00020\u0019H\u0003J\b\u0010H\u001a\u00020!H\u0003J\b\u0010I\u001a\u00020!H\u0003J\u0010\u0010J\u001a\u00020!2\u0006\u0010K\u001a\u00020+H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001f\u00a8\u0006P"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSessionListener;", "decorationState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "sessionDisposable", "Lcom/intellij/openapi/Disposable;", "decorationsDisposable", "commandGenerationJob", "Lkotlinx/coroutines/Job;", "isCommandGenerationInProgress", "", "()Z", "startCommandGeneration", "", "interruptCommandGeneration", "addListener", "listener", "parentDisposable", "doStartCommandGeneration", "scope", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateCommandFromText", "commandDescription", "", "tasksService", "Lai/grazie/model/task/SuspendableTasksService;", "(Ljava/lang/String;Lai/grazie/model/task/SuspendableTasksService;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createGeneratedCommandFlow", "Lkotlinx/coroutines/flow/Flow;", "writeGeneratedCommandToPrompt", "resultTextFlow", "(Lkotlinx/coroutines/flow/Flow;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleGenerationFinish", "exception", "", "(Ljava/lang/String;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updatePromptDecorationOnStateChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installAiInputPromptDecorations", "installAiPlaceholder", "installProcessingInlay", "showErrorDescription", "closeErrorOnTyping", "interruptCommandGenerationOnTyping", "doOnDocumentChange", "block", "Lkotlin/Function0;", "withPromptDecorationsDisposable", "Lkotlin/Function1;", "setPromptTextAttributes", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "deinstall", "deinstallPromptDecorations", "installReportMetricsHook", "generatedCommand", "GeneratedCommandMetricsReporter", "PromptDecorationState", "TerminalAiErrorDescription", "Companion", "intellij.ml.llm.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalTextToCommandSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTextToCommandSession.kt\ncom/intellij/ml/llm/terminal/TerminalTextToCommandSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,500:1\n357#1,4:510\n357#1,4:514\n357#1,4:518\n357#1,4:522\n346#1:526\n357#1,2:527\n347#1,14:529\n346#1:543\n357#1,2:544\n347#1,14:546\n357#1,4:560\n1#2:501\n70#3,6:502\n24#4:508\n24#4:509\n*S KotlinDebug\n*F\n+ 1 TerminalTextToCommandSession.kt\ncom/intellij/ml/llm/terminal/TerminalTextToCommandSession\n*L\n273#1:510,4\n290#1:514,4\n302#1:518,4\n314#1:522,4\n328#1:526\n328#1:527,2\n328#1:529,14\n335#1:543\n335#1:544,2\n335#1:546,14\n346#1:560,4\n130#1:502,6\n167#1:508\n170#1:509\n*E\n"})
public final class TerminalTextToCommandSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalPromptModel promptModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final EventDispatcher<TerminalTextToCommandSessionListener> dispatcher;
    @NotNull
    private final MutableStateFlow<PromptDecorationState> decorationState;
    @NotNull
    private final Disposable sessionDisposable;
    @Nullable
    private Disposable decorationsDisposable;
    @Nullable
    private Job commandGenerationJob;
    @NotNull
    private static final Key<TerminalTextToCommandSession> KEY;
    @NotNull
    private static final Key<GeneratedCommandMetricsReporter> METRICS_REPORTER_KEY;

    private TerminalTextToCommandSession(Project project, TerminalPromptModel promptModel, TerminalOutputModel outputModel) {
        this.project = project;
        this.promptModel = promptModel;
        this.outputModel = outputModel;
        CoroutineScope coroutineScope = TerminalLLMScopeProvider.Companion.getInstance(this.project).getScope();
        String string = TerminalTextToCommandSession.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
        EventDispatcher eventDispatcher = EventDispatcher.create(TerminalTextToCommandSessionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        this.decorationState = StateFlowKt.MutableStateFlow((Object)PromptDecorationState.TypingCommand.INSTANCE);
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)this.promptModel));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.sessionDisposable = disposable;
        this.getEditor().getCaretModel().moveToOffset(this.getEditor().getDocument().getTextLength());
        TerminalTextToCommandAction escapeAction = new TerminalTextToCommandAction();
        Integer[] integerArray = new Integer[]{27};
        escapeAction.setShortcutSet((ShortcutSet)new CustomShortcutSet(integerArray));
        escapeAction.registerCustomShortcutSet(this.getEditor().getContentComponent(), this.sessionDisposable);
        Disposer.register((Disposable)this.sessionDisposable, () -> TerminalTextToCommandSession._init_$lambda$1(this));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)new CoroutineName("prompt decoration state update")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.updatePromptDecorationOnStateChange((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        TerminalTextToCommandSession.Companion.setTerminalTextToCommandSession((Editor)this.getEditor(), this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final EditorEx getEditor() {
        return this.promptModel.getEditor();
    }

    @RequiresEdt
    public final boolean isCommandGenerationInProgress() {
        Job it = this.commandGenerationJob;
        boolean bl = false;
        return it != null && it.isActive();
    }

    public final void startCommandGeneration() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 1;
                        Object object2 = TerminalTextToCommandSession.access$doStartCommandGeneration(this.this$0, (CoroutineScope)$this$launch, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void interruptCommandGeneration() {
        block0: {
            Job job2 = this.commandGenerationJob;
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
    }

    public final void addListener(@NotNull TerminalTextToCommandSessionListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (parentDisposable != null) {
            this.dispatcher.addListener((EventListener)listener, parentDisposable);
        } else {
            this.dispatcher.addListener((EventListener)listener);
        }
    }

    public static /* synthetic */ void addListener$default(TerminalTextToCommandSession terminalTextToCommandSession, TerminalTextToCommandSessionListener terminalTextToCommandSessionListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalTextToCommandSession.addListener(terminalTextToCommandSessionListener, disposable);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doStartCommandGeneration(CoroutineScope scope, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doStartCommandGeneration.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTextToCommandSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalTextToCommandSession.access$doStartCommandGeneration(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.commandGenerationJob;
                v1 = v0 != null ? v0.isActive() : false;
                if (v1) {
                    return Unit.INSTANCE;
                }
                it = var5_6 = this.promptModel.getCommandText();
                $i$a$-takeIf-TerminalTextToCommandSession$doStartCommandGeneration$commandDescription$1 = false;
                v2 = !StringsKt.isBlank((CharSequence)it) != false ? var5_6 : null;
                if (v2 == null) {
                    return Unit.INSTANCE;
                }
                commandDescription = v2;
                $i$f$serviceAsync = 0;
                v3 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v3;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = scope;
                $continuation.L$1 = commandDescription;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v4 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(TerminalTextToCommandPromptsHistory.class, (Continuation)$continuation);
                if (v4 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl47
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$2;
                commandDescription = (String)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl47:
                // 2 sources

                ((TerminalTextToCommandPromptsHistory)v4).addHistoryEntry(commandDescription);
                $continuation.L$0 = scope;
                $continuation.L$1 = commandDescription;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v5 = AiaLlmProviderClient.Companion.getClient().getSuspendableTasksService(this.project, (Continuation)$continuation);
                if (v5 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl61
            }
            case 2: {
                commandDescription = (String)$continuation.L$1;
                scope = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl61:
                // 2 sources

                v6 = (SuspendableTasksService)v5;
                if (v6 == null) {
                    return Unit.INSTANCE;
                }
                tasksService = v6;
                this.commandGenerationJob = job = BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)new CoroutineName("command generation")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, commandDescription, tasksService, null){
                    int label;
                    final /* synthetic */ TerminalTextToCommandSession this$0;
                    final /* synthetic */ String $commandDescription;
                    final /* synthetic */ SuspendableTasksService $tasksService;
                    {
                        this.this$0 = $receiver;
                        this.$commandDescription = $commandDescription;
                        this.$tasksService = $tasksService;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = TerminalTextToCommandSession.access$generateCommandFromText(this.this$0, this.$commandDescription, this.$tasksService, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                job.invokeOnCompletion((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, doStartCommandGeneration$lambda$3(com.intellij.ml.llm.terminal.TerminalTextToCommandSession java.lang.Throwable ), (Ljava/lang/Throwable;)Lkotlin/Unit;)((TerminalTextToCommandSession)this));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object generateCommandFromText(String commandDescription, SuspendableTasksService tasksService, Continuation<? super Unit> $completion) {
        if (!($completion instanceof generateCommandFromText.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTextToCommandSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalTextToCommandSession.access$generateCommandFromText(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.decorationState.setValue((Object)PromptDecorationState.ProcessingRequest.INSTANCE);
                ((TerminalTextToCommandSessionListener)this.dispatcher.getMulticaster()).generationStarted();
                var5_7 = this;
                $this$generateCommandFromText_u24lambda_u244 = var5_7;
                $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1 = 0;
                $continuation.L$0 = commandDescription;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)tasksService);
                $continuation.L$2 = $this$generateCommandFromText_u24lambda_u244;
                $continuation.I$0 = $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1;
                $continuation.label = 1;
                v0 = $this$generateCommandFromText_u24lambda_u244.createGeneratedCommandFlow(commandDescription, tasksService, (Continuation<? super Flow<String>>)$continuation);
                ** if (v0 != var11_6) goto lbl28
lbl27:
                // 1 sources

                return var11_6;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1 = $continuation.I$0;
                $this$generateCommandFromText_u24lambda_u244 = (TerminalTextToCommandSession)$continuation.L$2;
                tasksService = (SuspendableTasksService)$continuation.L$1;
                commandDescription = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                resultFlow = (Flow)v0;
                $continuation.L$0 = commandDescription;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)tasksService);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$generateCommandFromText_u24lambda_u244);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)resultFlow);
                $continuation.I$0 = $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1;
                $continuation.label = 2;
                v1 = $this$generateCommandFromText_u24lambda_u244.writeGeneratedCommandToPrompt((Flow<String>)resultFlow, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var11_6) goto lbl48
lbl47:
                // 1 sources

                return var11_6;
lbl48:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1 = $continuation.I$0;
                resultFlow = (Flow)$continuation.L$3;
                $this$generateCommandFromText_u24lambda_u244 = (TerminalTextToCommandSession)$continuation.L$2;
                tasksService = (SuspendableTasksService)$continuation.L$1;
                commandDescription = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl59:
                    // 2 sources

                    var6_8 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable $i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1) {
                    var6_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-TerminalTextToCommandSession$generateCommandFromText$result$1));
                }
                result = var6_8;
                exception = Result.exceptionOrNull-impl((Object)result);
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)new CoroutineName("finish command generation")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, commandDescription, exception, null){
                    int label;
                    final /* synthetic */ TerminalTextToCommandSession this$0;
                    final /* synthetic */ String $commandDescription;
                    final /* synthetic */ Throwable $exception;
                    {
                        this.this$0 = $receiver;
                        this.$commandDescription = $commandDescription;
                        this.$exception = $exception;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = TerminalTextToCommandSession.access$handleGenerationFinish(this.this$0, this.$commandDescription, this.$exception, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                var6_8 = exception;
                if (var6_8 != null) {
                    if (var6_8 instanceof CancellationException) {
                        throw exception;
                    }
                    if (var6_8 instanceof HTTPStatusException || var6_8 instanceof UnresolvedAddressException || var6_8 instanceof HttpConnectTimeoutException || var6_8 instanceof ConnectException) {
                        $this$thisLogger$iv = this;
                        $i$f$thisLogger = false;
                        v2 = Logger.getInstance(TerminalTextToCommandSession.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.warn(exception);
                    } else {
                        $this$thisLogger$iv = this;
                        $i$f$thisLogger = false;
                        v3 = Logger.getInstance(TerminalTextToCommandSession.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                        v3.error(exception);
                    }
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object createGeneratedCommandFlow(String commandDescription, SuspendableTasksService tasksService, Continuation<? super Flow<String>> $completion) {
        TerminalTextToCommandFeature textToCommandFeature = new TerminalTextToCommandFeature((DeviceMetadataProvider)new IJDeviceMetadataProvider(), (TerminalHistoryProvider)new IJTerminalHistoryProvider(this.outputModel), (TerminalMetadataProvider)new IJTerminalMetadataProvider(this.promptModel), tasksService, null, 16, null);
        return textToCommandFeature.convert(commandDescription, $completion);
    }

    private final Object writeGeneratedCommandToPrompt(Flow<String> resultTextFlow, Continuation<? super Unit> $completion) {
        Object object = FlowKt.withIndex((Flow)FlowKt.flowOn(resultTextFlow, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()))).collect(new FlowCollector(this){
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * Unable to fully structure code
             */
            public final Object emit(IndexedValue<String> var1_1, Continuation<? super Unit> $completion) {
                if (!($completion instanceof writeGeneratedCommandToPrompt.emit.1)) ** GOTO lbl-1000
                var10_3 = $completion;
                if ((var10_3.label & -2147483648) != 0) {
                    var10_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        int I$0;
                        int I$1;
                        int I$2;
                        Object L$0;
                        Object L$1;
                        char C$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ writeGeneratedCommandToPrompt.2<T> this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        index = var1_1.component1();
                        textPart = (String)var1_1.component2();
                        if (index == 0) {
                            TerminalTextToCommandSession.access$getDecorationState$p(this.this$0).setValue((Object)PromptDecorationState.WritingGeneratedCommand.INSTANCE);
                            $continuation.L$0 = textPart;
                            $continuation.I$0 = index;
                            $continuation.label = 1;
                            v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, emit$lambda$1(com.intellij.ml.llm.terminal.TerminalTextToCommandSession ), ()Lkotlin/Unit;)((TerminalTextToCommandSession)this.this$0), (Continuation)$continuation);
                            if (v0 == var11_5) {
                                return var11_5;
                            }
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        index = $continuation.I$0;
                        textPart = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 2 sources

                        v1 = TerminalTextToCommandSession.access$getEditor(this.this$0).getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDocument(...)");
                        document = v1;
                        var6_9 = 0;
                        var7_10 = textPart.length();
lbl33:
                        // 2 sources

                        while (var6_9 < var7_10) {
                            char = textPart.charAt(var6_9);
                            $continuation.L$0 = textPart;
                            $continuation.L$1 = document;
                            $continuation.I$0 = index;
                            $continuation.I$1 = var6_9;
                            $continuation.I$2 = var7_10;
                            $continuation.C$0 = char;
                            $continuation.label = 2;
                            v2 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, emit$lambda$3(com.intellij.openapi.editor.ex.DocumentEx char com.intellij.ml.llm.terminal.TerminalTextToCommandSession ), ()Lkotlin/Unit;)((DocumentEx)document, (char)char, (TerminalTextToCommandSession)this.this$0), (Continuation)$continuation);
                            if (v2 == var11_5) {
                                return var11_5;
                            }
                            ** GOTO lbl56
                        }
                        break;
                    }
                    case 2: {
                        char = $continuation.C$0;
                        var7_10 = $continuation.I$2;
                        var6_9 = $continuation.I$1;
                        index = $continuation.I$0;
                        document = (DocumentEx)$continuation.L$1;
                        textPart = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl56:
                        // 2 sources

                        $continuation.L$0 = textPart;
                        $continuation.L$1 = document;
                        $continuation.I$0 = index;
                        $continuation.I$1 = var6_9;
                        $continuation.I$2 = var7_10;
                        $continuation.C$0 = char;
                        $continuation.label = 3;
                        v3 = DelayKt.delay((long)20L, (Continuation)$continuation);
                        if (v3 == var11_5) {
                            return var11_5;
                        }
                        ** GOTO lbl76
                    }
                    case 3: {
                        char = $continuation.C$0;
                        var7_10 = $continuation.I$2;
                        var6_9 = $continuation.I$1;
                        index = $continuation.I$0;
                        document = (DocumentEx)$continuation.L$1;
                        textPart = (String)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl76:
                        // 2 sources

                        ++var6_9;
                        ** GOTO lbl33
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            private static final Unit emit$lambda$1$lambda$0(TerminalTextToCommandSession this$0) {
                TerminalTextToCommandSession.access$getPromptModel$p(this$0).setCommandText("");
                return Unit.INSTANCE;
            }

            private static final Unit emit$lambda$1(TerminalTextToCommandSession this$0) {
                ActionsKt.runUndoTransparentWriteAction(() -> writeGeneratedCommandToPrompt.2.emit$lambda$1$lambda$0(this$0));
                return Unit.INSTANCE;
            }

            private static final Unit emit$lambda$3$lambda$2(DocumentEx $document, char $char, TerminalTextToCommandSession this$0) {
                $document.insertString($document.getTextLength(), (CharSequence)String.valueOf($char));
                TerminalTextToCommandSession.access$getEditor(this$0).getCaretModel().moveToOffset($document.getTextLength());
                return Unit.INSTANCE;
            }

            private static final Unit emit$lambda$3(DocumentEx $document, char $char, TerminalTextToCommandSession this$0) {
                ActionsKt.runUndoTransparentWriteAction(() -> writeGeneratedCommandToPrompt.2.emit$lambda$3$lambda$2($document, $char, this$0));
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleGenerationFinish(String commandDescription, Throwable exception, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleGenerationFinish.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTextToCommandSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalTextToCommandSession.access$handleGenerationFinish(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = exception;
                if (var4_7 != null) ** GOTO lbl20
                this.decorationState.setValue((Object)PromptDecorationState.CommandGenerated.INSTANCE);
                ((TerminalTextToCommandSessionListener)this.dispatcher.getMulticaster()).generationFinished();
                this.deinstall();
                this.installReportMetricsHook(this.promptModel.getCommandText());
                TerminalUsageTriggerCollector.INSTANCE.triggerCommandGenerationEvent(this.project, TerminalCommandGenerationEvent.GENERATION_FINISHED);
                ** GOTO lbl51
lbl20:
                // 1 sources

                if (!(var4_7 instanceof CancellationException)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandDescription);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)exception);
                $continuation.label = 1;
                v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleGenerationFinish$lambda$5(com.intellij.ml.llm.terminal.TerminalTextToCommandSession java.lang.String ), ()Lkotlin/Unit;)((TerminalTextToCommandSession)this, (String)commandDescription), (Continuation)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                exception = (Throwable)$continuation.L$1;
                commandDescription = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                this.decorationState.setValue((Object)PromptDecorationState.TypingCommand.INSTANCE);
                ((TerminalTextToCommandSessionListener)this.dispatcher.getMulticaster()).generationInterrupted();
                TerminalUsageTriggerCollector.INSTANCE.triggerCommandGenerationEvent(this.project, TerminalCommandGenerationEvent.GENERATION_INTERRUPTED);
                ** GOTO lbl51
            }
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)commandDescription);
        $continuation.L$1 = exception;
        $continuation.label = 2;
        v1 = DelayKt.delay((long)300L, (Continuation)$continuation);
        if (v1 == var7_6) {
            return var7_6;
        }
        ** GOTO lbl49
        {
            case 2: {
                exception = (Throwable)$continuation.L$1;
                commandDescription = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                this.decorationState.setValue((Object)new PromptDecorationState.GenerationError(exception));
                TerminalUsageTriggerCollector.INSTANCE.triggerCommandGenerationEvent(this.project, TerminalCommandGenerationEvent.GENERATION_FAILED);
lbl51:
                // 3 sources

                this.promptModel.resetChangesHistory();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updatePromptDecorationOnStateChange(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updatePromptDecorationOnStateChange.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ TerminalTextToCommandSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalTextToCommandSession.access$updatePromptDecorationOnStateChange(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.decorationState.collect(new FlowCollector(this){
                    final /* synthetic */ TerminalTextToCommandSession this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final Object emit(PromptDecorationState state, Continuation<? super Unit> $completion) {
                        TerminalTextToCommandSession.access$deinstallPromptDecorations(this.this$0);
                        PromptDecorationState promptDecorationState = state;
                        if (Intrinsics.areEqual((Object)promptDecorationState, (Object)PromptDecorationState.TypingCommand.INSTANCE)) {
                            TerminalTextToCommandSession.access$installAiInputPromptDecorations(this.this$0);
                            TerminalTextToCommandSession.access$installAiPlaceholder(this.this$0);
                        } else if (Intrinsics.areEqual((Object)promptDecorationState, (Object)PromptDecorationState.ProcessingRequest.INSTANCE)) {
                            TerminalTextToCommandSession.access$installAiInputPromptDecorations(this.this$0);
                            TerminalTextToCommandSession.access$installProcessingInlay(this.this$0);
                            TerminalTextToCommandSession.access$interruptCommandGenerationOnTyping(this.this$0);
                        } else if (Intrinsics.areEqual((Object)promptDecorationState, (Object)PromptDecorationState.WritingGeneratedCommand.INSTANCE)) {
                            TerminalTextToCommandSession.access$interruptCommandGenerationOnTyping(this.this$0);
                        } else if (promptDecorationState instanceof PromptDecorationState.GenerationError) {
                            TerminalTextToCommandSession.access$installAiInputPromptDecorations(this.this$0);
                            TerminalTextToCommandSession.access$installAiPlaceholder(this.this$0);
                            TerminalTextToCommandSession.access$showErrorDescription(this.this$0, ((PromptDecorationState.GenerationError)state).getException());
                            TerminalTextToCommandSession.access$closeErrorOnTyping(this.this$0);
                        } else if (!Intrinsics.areEqual((Object)promptDecorationState, (Object)PromptDecorationState.CommandGenerated.INSTANCE)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresEdt
    private final void installAiInputPromptDecorations() {
        Disposable disposable$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable$iv = disposable;
        boolean bl = false;
        Color caretColor = this.getEditor().getColorsScheme().getColor(BlockTerminalColors.GENERATE_COMMAND_CARET_COLOR);
        this.getEditor().getColorsScheme().setColor(EditorColors.CARET_COLOR, caretColor);
        Disposer.register((Disposable)disposable3, () -> TerminalTextToCommandSession.installAiInputPromptDecorations$lambda$8$lambda$6(this));
        TextAttributes promptAttributes = this.getEditor().getColorsScheme().getAttributes(BlockTerminalColors.GENERATE_COMMAND_PROMPT_TEXT);
        Intrinsics.checkNotNull((Object)promptAttributes);
        this.setPromptTextAttributes(promptAttributes, disposable3);
        this.getEditor().putUserData(TerminalCommandCompletionAction.Companion.getSUPPRESS_COMPLETION(), (Object)true);
        Disposer.register((Disposable)disposable3, () -> TerminalTextToCommandSession.installAiInputPromptDecorations$lambda$8$lambda$7(this));
        this_$iv.decorationsDisposable = disposable$iv;
    }

    @RequiresEdt
    private final void installAiPlaceholder() {
        Disposable disposable$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable$iv = disposable;
        boolean bl = false;
        if (TerminalTextToCommandModeActivator.Companion.isNaturalLanguageDetectionEnabled()) {
            TerminalAskingAiPlaceholderManager.Companion.install(this.promptModel, disposable3);
        } else {
            TerminalOldAiPlaceholderManager.Companion.install(this.promptModel, disposable3);
        }
        this_$iv.decorationsDisposable = disposable$iv;
    }

    @RequiresEdt
    private final void installProcessingInlay() {
        Disposable disposable$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable$iv = disposable;
        boolean bl = false;
        String processingText = LLMBundle.message((String)"inlay.generation.processing", (Object[])new Object[0]);
        AnimatedIcon.Default processingIcon = new AnimatedIcon.Default();
        LLMTextWithIconPresentation presentation = new LLMTextWithIconPresentation((Editor)this.getEditor(), (InlayPresentation)new LLMTextPresentation((Editor)this.getEditor(), processingText, false, null, false, 24, null), (Icon)processingIcon);
        PresentationRenderer renderer = new PresentationRenderer((InlayPresentation)presentation);
        Inlay inlay = this.getEditor().getInlayModel().addAfterLineEndElement(this.getEditor().getDocument().getTextLength(), true, (EditorCustomElementRenderer)renderer);
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        Disposer.register((Disposable)disposable3, (Disposable)((Disposable)inlay2));
        this_$iv.decorationsDisposable = disposable$iv;
    }

    @RequiresEdt
    private final void showErrorDescription(Throwable exception) {
        Disposable disposable$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable$iv = disposable;
        boolean bl = false;
        ErrorStateDescriptor errorStateDescriptor = GrazieErrorUtilKt.getErrorDescriptor((Throwable)exception);
        if (errorStateDescriptor == null) {
            errorStateDescriptor = (ErrorStateDescriptor)ErrorStateDescriptor.Companion.getDefault();
        }
        ErrorStateDescriptor descriptor = errorStateDescriptor;
        TerminalAiErrorDescription errorDescription = new TerminalAiErrorDescription(this.project, descriptor, (Function0<Unit>)((Function0)() -> TerminalTextToCommandSession.showErrorDescription$lambda$13$lambda$11(this)));
        this.promptModel.setErrorDescription((TerminalPromptErrorDescription)errorDescription);
        Disposer.register((Disposable)disposable3, () -> TerminalTextToCommandSession.showErrorDescription$lambda$13$lambda$12(this));
        this_$iv.decorationsDisposable = disposable$iv;
    }

    private final void closeErrorOnTyping() {
        Disposable disposable$iv$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$doOnDocumentChange = false;
        TerminalTextToCommandSession this_$iv$iv = this_$iv;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable$iv = disposable$iv$iv = disposable;
        boolean bl = false;
        this_$iv.getEditor().getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = terminalTextToCommandSession;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                boolean bl = false;
                TerminalTextToCommandSession.access$getDecorationState$p(this.this$0).setValue((Object)PromptDecorationState.TypingCommand.INSTANCE);
            }
        }, disposable$iv);
        this_$iv$iv.decorationsDisposable = disposable$iv$iv;
    }

    private final void interruptCommandGenerationOnTyping() {
        Disposable disposable$iv$iv;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$doOnDocumentChange = false;
        TerminalTextToCommandSession this_$iv$iv = this_$iv;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable$iv = disposable$iv$iv = disposable;
        boolean bl = false;
        this_$iv.getEditor().getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = terminalTextToCommandSession;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                boolean bl = false;
                String curCommandName = CommandProcessor.getInstance().getCurrentCommandName();
                if (curCommandName != null) {
                    this.this$0.interruptCommandGeneration();
                }
            }
        }, disposable$iv);
        this_$iv$iv.decorationsDisposable = disposable$iv$iv;
    }

    private final void doOnDocumentChange(Function0<Unit> block) {
        Disposable disposable$iv;
        boolean $i$f$doOnDocumentChange = false;
        TerminalTextToCommandSession this_$iv = this;
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this_$iv.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this_$iv.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable$iv = disposable;
        boolean bl = false;
        this.getEditor().getDocument().addDocumentListener(new DocumentListener(block){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$block.invoke();
            }
        }, disposable3);
        this_$iv.decorationsDisposable = disposable$iv;
    }

    private final void withPromptDecorationsDisposable(Function1<? super Disposable, Unit> block) {
        boolean $i$f$withPromptDecorationsDisposable = false;
        Disposable disposable = this.decorationsDisposable;
        if (disposable == null) {
            Disposable disposable2 = Disposer.newDisposable((Disposable)this.sessionDisposable);
            disposable = disposable2;
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        }
        Disposable disposable3 = disposable;
        block.invoke((Object)disposable3);
        this.decorationsDisposable = disposable3;
    }

    @RequiresEdt
    private final void setPromptTextAttributes(TextAttributes attributes, Disposable parentDisposable) {
        RangeHighlighter rangeHighlighter = this.getEditor().getMarkupModel().addRangeHighlighter(this.promptModel.getCommandStartOffset(), this.getEditor().getDocument().getTextLength(), 5500, attributes, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        Disposer.register((Disposable)parentDisposable, () -> TerminalTextToCommandSession.setPromptTextAttributes$lambda$17(this, highlighter));
    }

    @RequiresEdt
    private final void deinstall() {
        Disposer.dispose((Disposable)this.sessionDisposable);
        TerminalTextToCommandSession.Companion.setTerminalTextToCommandSession((Editor)this.getEditor(), null);
    }

    @RequiresEdt
    private final void deinstallPromptDecorations() {
        Disposable disposable = this.decorationsDisposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        this.decorationsDisposable = null;
    }

    private final void installReportMetricsHook(String generatedCommand) {
        GeneratedCommandMetricsReporter newReporter = new GeneratedCommandMetricsReporter(generatedCommand);
        Disposer.register((Disposable)((Disposable)this.promptModel), (Disposable)newReporter);
        GeneratedCommandMetricsReporter generatedCommandMetricsReporter = TerminalTextToCommandSession.Companion.getGeneratedCommandMetricsReporter((Editor)this.outputModel.getEditor());
        if (generatedCommandMetricsReporter != null) {
            GeneratedCommandMetricsReporter it = generatedCommandMetricsReporter;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        TerminalTextToCommandSession.Companion.setGeneratedCommandMetricsReporter((Editor)this.outputModel.getEditor(), newReporter);
        this.outputModel.addListener(new TerminalOutputModelListener(this){
            final /* synthetic */ TerminalTextToCommandSession this$0;
            {
                this.this$0 = $receiver;
            }

            public void blockCreated(CommandBlock block) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                GeneratedCommandMetricsReporter generatedCommandMetricsReporter = com.intellij.ml.llm.terminal.TerminalTextToCommandSession$Companion.access$getGeneratedCommandMetricsReporter(TerminalTextToCommandSession.Companion, (Editor)TerminalTextToCommandSession.access$getOutputModel$p(this.this$0).getEditor());
                if (generatedCommandMetricsReporter == null) {
                    return;
                }
                GeneratedCommandMetricsReporter reporter = generatedCommandMetricsReporter;
                String string = block.getCommand();
                if (string == null) {
                    return;
                }
                String submittedCommand = string;
                reporter.report(submittedCommand);
                Disposer.dispose((Disposable)reporter);
            }
        }, (Disposable)newReporter);
    }

    private static final void _init_$lambda$1(TerminalTextToCommandSession this$0) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.coroutineScope, null, (int)1, null);
    }

    private static final Unit doStartCommandGeneration$lambda$3(TerminalTextToCommandSession this$0, Throwable it) {
        this$0.commandGenerationJob = null;
        return Unit.INSTANCE;
    }

    private static final Unit handleGenerationFinish$lambda$5(TerminalTextToCommandSession this$0, String $commandDescription) {
        this$0.promptModel.setCommandText($commandDescription);
        this$0.getEditor().getCaretModel().moveToOffset(this$0.getEditor().getDocument().getTextLength());
        return Unit.INSTANCE;
    }

    private static final void installAiInputPromptDecorations$lambda$8$lambda$6(TerminalTextToCommandSession this$0) {
        this$0.getEditor().getColorsScheme().setColor(EditorColors.CARET_COLOR, null);
    }

    private static final void installAiInputPromptDecorations$lambda$8$lambda$7(TerminalTextToCommandSession this$0) {
        this$0.getEditor().putUserData(TerminalCommandCompletionAction.Companion.getSUPPRESS_COMPLETION(), null);
    }

    private static final Unit showErrorDescription$lambda$13$lambda$11(TerminalTextToCommandSession this$0) {
        this$0.startCommandGeneration();
        return Unit.INSTANCE;
    }

    private static final void showErrorDescription$lambda$13$lambda$12(TerminalTextToCommandSession this$0) {
        this$0.promptModel.setErrorDescription(null);
    }

    private static final void setPromptTextAttributes$lambda$17(TerminalTextToCommandSession this$0, RangeHighlighter $highlighter) {
        this$0.getEditor().getMarkupModel().removeHighlighter($highlighter);
    }

    public static final /* synthetic */ Object access$doStartCommandGeneration(TerminalTextToCommandSession $this, CoroutineScope scope, Continuation $completion) {
        return $this.doStartCommandGeneration(scope, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$generateCommandFromText(TerminalTextToCommandSession $this, String commandDescription, SuspendableTasksService tasksService, Continuation $completion) {
        return $this.generateCommandFromText(commandDescription, tasksService, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleGenerationFinish(TerminalTextToCommandSession $this, String commandDescription, Throwable exception, Continuation $completion) {
        return $this.handleGenerationFinish(commandDescription, exception, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$createGeneratedCommandFlow(TerminalTextToCommandSession $this, String commandDescription, SuspendableTasksService tasksService, Continuation $completion) {
        return $this.createGeneratedCommandFlow(commandDescription, tasksService, (Continuation<? super Flow<String>>)$completion);
    }

    public static final /* synthetic */ Object access$writeGeneratedCommandToPrompt(TerminalTextToCommandSession $this, Flow resultTextFlow, Continuation $completion) {
        return $this.writeGeneratedCommandToPrompt((Flow<String>)resultTextFlow, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$getDecorationState$p(TerminalTextToCommandSession $this) {
        return $this.decorationState;
    }

    public static final /* synthetic */ EditorEx access$getEditor(TerminalTextToCommandSession $this) {
        return $this.getEditor();
    }

    public static final /* synthetic */ TerminalPromptModel access$getPromptModel$p(TerminalTextToCommandSession $this) {
        return $this.promptModel;
    }

    public static final /* synthetic */ void access$deinstallPromptDecorations(TerminalTextToCommandSession $this) {
        $this.deinstallPromptDecorations();
    }

    public static final /* synthetic */ void access$installAiInputPromptDecorations(TerminalTextToCommandSession $this) {
        $this.installAiInputPromptDecorations();
    }

    public static final /* synthetic */ void access$installAiPlaceholder(TerminalTextToCommandSession $this) {
        $this.installAiPlaceholder();
    }

    public static final /* synthetic */ void access$installProcessingInlay(TerminalTextToCommandSession $this) {
        $this.installProcessingInlay();
    }

    public static final /* synthetic */ void access$interruptCommandGenerationOnTyping(TerminalTextToCommandSession $this) {
        $this.interruptCommandGenerationOnTyping();
    }

    public static final /* synthetic */ void access$showErrorDescription(TerminalTextToCommandSession $this, Throwable exception) {
        $this.showErrorDescription(exception);
    }

    public static final /* synthetic */ void access$closeErrorOnTyping(TerminalTextToCommandSession $this) {
        $this.closeErrorOnTyping();
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalTextToCommandSession $this) {
        return $this.outputModel;
    }

    public /* synthetic */ TerminalTextToCommandSession(Project project, TerminalPromptModel promptModel, TerminalOutputModel outputModel, DefaultConstructorMarker $constructor_marker) {
        this(project, promptModel, outputModel);
    }

    static {
        Key key = Key.create((String)"TerminalTextToCommandSession");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        Key key2 = Key.create((String)"GeneratedCommandMetricsReporter");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        METRICS_REPORTER_KEY = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0004\u0018\u00010\u0006*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00068B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession;", "value", "terminalTextToCommandSession", "Lcom/intellij/openapi/editor/Editor;", "getTerminalTextToCommandSession", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession;", "setTerminalTextToCommandSession", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession;)V", "METRICS_REPORTER_KEY", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$GeneratedCommandMetricsReporter;", "generatedCommandMetricsReporter", "getGeneratedCommandMetricsReporter", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$GeneratedCommandMetricsReporter;", "setGeneratedCommandMetricsReporter", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$GeneratedCommandMetricsReporter;)V", "install", "project", "Lcom/intellij/openapi/project/Project;", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "deinstallAndResetToInitialState", "", "get", "intellij.ml.llm.terminal"})
    public static final class Companion {
        private Companion() {
        }

        private final TerminalTextToCommandSession getTerminalTextToCommandSession(Editor $this$terminalTextToCommandSession) {
            return (TerminalTextToCommandSession)$this$terminalTextToCommandSession.getUserData(KEY);
        }

        private final void setTerminalTextToCommandSession(Editor $this$terminalTextToCommandSession, TerminalTextToCommandSession value) {
            $this$terminalTextToCommandSession.putUserData(KEY, (Object)value);
        }

        private final GeneratedCommandMetricsReporter getGeneratedCommandMetricsReporter(Editor $this$generatedCommandMetricsReporter) {
            return (GeneratedCommandMetricsReporter)$this$generatedCommandMetricsReporter.getUserData(METRICS_REPORTER_KEY);
        }

        private final void setGeneratedCommandMetricsReporter(Editor $this$generatedCommandMetricsReporter, GeneratedCommandMetricsReporter value) {
            $this$generatedCommandMetricsReporter.putUserData(METRICS_REPORTER_KEY, (Object)value);
        }

        @RequiresEdt
        @NotNull
        public final TerminalTextToCommandSession install(@NotNull Project project, @NotNull TerminalPromptModel promptModel, @NotNull TerminalOutputModel outputModel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
            Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
            TerminalTextToCommandSession session = new TerminalTextToCommandSession(project, promptModel, outputModel, null);
            TerminalUsageTriggerCollector.INSTANCE.triggerCommandGenerationEvent(project, TerminalCommandGenerationEvent.MODE_ENABLED);
            return session;
        }

        @RequiresEdt
        public final void deinstallAndResetToInitialState(@NotNull TerminalPromptModel promptModel) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
                TerminalTextToCommandSession terminalTextToCommandSession = this.get(promptModel);
                if (terminalTextToCommandSession == null) break block0;
                TerminalTextToCommandSession it = terminalTextToCommandSession;
                boolean bl = false;
                it.deinstall();
                TerminalUsageTriggerCollector.INSTANCE.triggerCommandGenerationEvent(it.getProject(), TerminalCommandGenerationEvent.MODE_DISABLED);
            }
        }

        @Nullable
        public final TerminalTextToCommandSession get(@NotNull TerminalPromptModel promptModel) {
            Intrinsics.checkNotNullParameter((Object)promptModel, (String)"promptModel");
            return this.getTerminalTextToCommandSession((Editor)promptModel.getEditor());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$GeneratedCommandMetricsReporter;", "Lcom/intellij/openapi/Disposable;", "generatedCommand", "", "<init>", "(Ljava/lang/String;)V", "initTime", "", "report", "", "submittedCommand", "isExpired", "", "dispose", "intellij.ml.llm.terminal"})
    private static final class GeneratedCommandMetricsReporter
    implements Disposable {
        @NotNull
        private final String generatedCommand;
        private final long initTime;

        public GeneratedCommandMetricsReporter(@NotNull String generatedCommand) {
            Intrinsics.checkNotNullParameter((Object)generatedCommand, (String)"generatedCommand");
            this.generatedCommand = generatedCommand;
            this.initTime = System.currentTimeMillis();
        }

        public final void report(@NotNull String submittedCommand) {
            Intrinsics.checkNotNullParameter((Object)submittedCommand, (String)"submittedCommand");
            if (!this.isExpired()) {
                new TerminalTextToCommandEditDistance(this.generatedCommand, submittedCommand, 0, 0, 12, null).calculateAndLog();
                new TerminalTextToCommandChrF(this.generatedCommand, submittedCommand, 0, 0, 12, null).calculateAndLog();
                new TerminalTextToCommandLengthDiff(this.generatedCommand, submittedCommand, 0, 0, 12, null).calculateAndLog();
            }
        }

        private final boolean isExpired() {
            return System.currentTimeMillis() - this.initTime > 60000L;
        }

        public void dispose() {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0005\u0007\b\t\n\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "", "TypingCommand", "ProcessingRequest", "WritingGeneratedCommand", "GenerationError", "CommandGenerated", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$CommandGenerated;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$GenerationError;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$ProcessingRequest;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$TypingCommand;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$WritingGeneratedCommand;", "intellij.ml.llm.terminal"})
    private static interface PromptDecorationState {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$CommandGenerated;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.terminal"})
        public static final class CommandGenerated
        implements PromptDecorationState {
            @NotNull
            public static final CommandGenerated INSTANCE = new CommandGenerated();

            private CommandGenerated() {
            }

            @NotNull
            public String toString() {
                return "CommandGenerated";
            }

            public int hashCode() {
                return 1974134184;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CommandGenerated)) {
                    return false;
                }
                CommandGenerated cfr_ignored_0 = (CommandGenerated)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$GenerationError;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "exception", "", "<init>", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "intellij.ml.llm.terminal"})
        public static final class GenerationError
        implements PromptDecorationState {
            @NotNull
            private final Throwable exception;

            public GenerationError(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$ProcessingRequest;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.terminal"})
        public static final class ProcessingRequest
        implements PromptDecorationState {
            @NotNull
            public static final ProcessingRequest INSTANCE = new ProcessingRequest();

            private ProcessingRequest() {
            }

            @NotNull
            public String toString() {
                return "ProcessingRequest";
            }

            public int hashCode() {
                return 1184673112;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProcessingRequest)) {
                    return false;
                }
                ProcessingRequest cfr_ignored_0 = (ProcessingRequest)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$TypingCommand;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.terminal"})
        public static final class TypingCommand
        implements PromptDecorationState {
            @NotNull
            public static final TypingCommand INSTANCE = new TypingCommand();

            private TypingCommand() {
            }

            @NotNull
            public String toString() {
                return "TypingCommand";
            }

            public int hashCode() {
                return 1514920240;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TypingCommand)) {
                    return false;
                }
                TypingCommand cfr_ignored_0 = (TypingCommand)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState$WritingGeneratedCommand;", "Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$PromptDecorationState;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.terminal"})
        public static final class WritingGeneratedCommand
        implements PromptDecorationState {
            @NotNull
            public static final WritingGeneratedCommand INSTANCE = new WritingGeneratedCommand();

            private WritingGeneratedCommand() {
            }

            @NotNull
            public String toString() {
                return "WritingGeneratedCommand";
            }

            public int hashCode() {
                return -844612588;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WritingGeneratedCommand)) {
                    return false;
                }
                WritingGeneratedCommand cfr_ignored_0 = (WritingGeneratedCommand)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/terminal/TerminalTextToCommandSession$TerminalAiErrorDescription;", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorDescription;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/ml/llm/grazie/ErrorStateDescriptor;", "onRetry", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/grazie/ErrorStateDescriptor;Lkotlin/jvm/functions/Function0;)V", "errorText", "", "getErrorText", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "linkText", "getLinkText", "onLinkClick", "intellij.ml.llm.terminal"})
    private static final class TerminalAiErrorDescription
    implements TerminalPromptErrorDescription {
        @NotNull
        private final Project project;
        @NotNull
        private final ErrorStateDescriptor descriptor;
        @NotNull
        private final Function0<Unit> onRetry;
        @NotNull
        private final Icon icon;

        public TerminalAiErrorDescription(@NotNull Project project, @NotNull ErrorStateDescriptor descriptor, @NotNull Function0<Unit> onRetry) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter(onRetry, (String)"onRetry");
            this.project = project;
            this.descriptor = descriptor;
            this.onRetry = onRetry;
            Icon icon = AllIcons.General.BalloonError;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonError");
            this.icon = icon;
        }

        @NotNull
        public String getErrorText() {
            return this.descriptor.getText();
        }

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public String getLinkText() {
            return this.descriptor instanceof ErrorStateDescriptor.Actionable ? ((ErrorStateDescriptor.Actionable)this.descriptor).getLinkText() : null;
        }

        public void onLinkClick() {
            if (!(this.descriptor instanceof ErrorStateDescriptor.Actionable)) {
                return;
            }
            ErrorStateAction action = ((ErrorStateDescriptor.Actionable)this.descriptor).getAction();
            if (action instanceof ErrorStateAction.DefaultRetry) {
                this.onRetry.invoke();
            } else {
                BuildersKt.launch$default((CoroutineScope)TerminalLLMScopeProvider.Companion.getInstance(this.project).getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(action, this, null){
                    int label;
                    final /* synthetic */ ErrorStateAction $action;
                    final /* synthetic */ TerminalAiErrorDescription this$0;
                    {
                        this.$action = $action;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$action.doAction(TerminalAiErrorDescription.access$getProject$p(this.this$0), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }

        public static final /* synthetic */ Project access$getProject$p(TerminalAiErrorDescription $this) {
            return $this.project;
        }
    }
}

