# Package Information

This package provides a stable API for the LLM plugin to interact with components of DataSpell that lack a stable API.  
This is necessary because the release cycle of the LLM plugin differs from that of IntelliJ IDEA or DataSpell. The LLM plugin is released
every two weeks from the master branch.  
As a result, if the API used by the LLM plugin changes in the master branch, and the LLM plugin is installed on a stable version
of DataSpell, the LLM plugin may break.
This package must consist of interfaces with a stable API that can be used by the LLM plugin.

The general rules are:

- Use `serviceOrNull` to obtain a service in the LLM plugin.
- If any interface in this package changes, introduce a new interface instead of modifying the existing one.
  - Note: Modifying an existing interface with an implementation located in the IDE module (e.g., in the DataSpell module) could result in
    incompatibilities. For instance, a new version of the LLM plugin might be installed on an older version of the IDE that still implements
    the old version of the interface. By introducing a new interface, the `serviceOrNull` call will return `null`, preserving compatibility.