/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessorKt;
import com.intellij.openapi.vcs.changes.ChangesViewUserObjectTag;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDiffPreviewHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ChangesViewDiffPreviewHandler;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDiffPreviewHandler;", "<init>", "()V", "isShowAllChangesForEmptySelection", "", "()Z", "iterateSelectedChanges", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "iterateAllChanges", "selectChange", "", "change", "intellij.platform.vcs.impl"})
public final class ChangesViewDiffPreviewHandler
extends ChangesTreeDiffPreviewHandler {
    @NotNull
    public static final ChangesViewDiffPreviewHandler INSTANCE = new ChangesViewDiffPreviewHandler();

    private ChangesViewDiffPreviewHandler() {
    }

    @Override
    public boolean isShowAllChangesForEmptySelection() {
        return false;
    }

    @NotNull
    public JBIterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        ChangesListView changesView = changesListView;
        Project project = ((ChangesListView)tree).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JBIterable jBIterable = changesView.getSelectedChangesNodes();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getSelectedChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable jBIterable2 = changesView.getSelectedUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getSelectedUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, iterable, (Iterable)jBIterable2);
    }

    @NotNull
    public JBIterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges(@NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        ChangesListView changesView = changesListView;
        Project project = ((ChangesListView)tree).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JBIterable jBIterable = changesView.getChangesNodes();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getChangesNodes(...)");
        Iterable iterable = (Iterable)jBIterable;
        JBIterable jBIterable2 = changesView.getUnversionedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getUnversionedFiles(...)");
        return ChangesViewDiffPreviewProcessorKt.access$wrap(project, iterable, (Iterable)jBIterable2);
    }

    @Override
    public void selectChange(@NotNull ChangesTree tree, @NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ChangesBrowserNode.Tag tag = change.getTag();
        ChangesViewUserObjectTag changesViewUserObjectTag = tag instanceof ChangesViewUserObjectTag ? (ChangesViewUserObjectTag)tag : null;
        Object tag2 = changesViewUserObjectTag != null ? changesViewUserObjectTag.getUserObject() : null;
        ChangesListView changesListView = tree instanceof ChangesListView ? (ChangesListView)tree : null;
        if (changesListView == null) {
            return;
        }
        ChangesListView changesView = changesListView;
        TreePath treePath = changesView.findNodePathInTree(change.getUserObject(), tag2);
        if (treePath == null) {
            return;
        }
        TreePath treePath2 = treePath;
        TreeUtil.selectPath((JTree)((JTree)changesView), (TreePath)treePath2, (boolean)false);
    }
}

