/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.WindowsPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.function.Consumer;
import org.cef.misc.Utils;

public class WindowsPipeSocket
extends Socket {
    private static final int TRANSPORT_OPEN_COOLDOWN_MS = Utils.getInteger("JCEF_TRANSPORT_OPEN_COOLDOWN_MS", 3);
    private final long myHandle;
    private final Consumer<Long> myCloseCallback;
    private final InputStream myIn;
    private final OutputStream myOut;
    private final long myReaderWait;
    private final long myWriterWait;

    public WindowsPipeSocket(long handle, Consumer<Long> closeCallback) throws IOException {
        this.myHandle = handle;
        this.myCloseCallback = closeCallback;
        this.myReaderWait = WindowsPipe.CreateEvent(true, false, null);
        this.myWriterWait = WindowsPipe.CreateEvent(true, false, null);
        this.myIn = new PipeInputStream(handle);
        this.myOut = new PipeOutputStream(handle);
    }

    public WindowsPipeSocket(String pipeName) throws IOException {
        this(WindowsPipe.OpenFile(WindowsPipe.normalizePipePath(pipeName)), null);
        if (TRANSPORT_OPEN_COOLDOWN_MS > 0) {
            try {
                Thread.sleep(TRANSPORT_OPEN_COOLDOWN_MS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.myIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOut;
    }

    @Override
    public void close() throws IOException {
        if (this.myCloseCallback != null) {
            this.myCloseCallback.accept(this.myHandle);
        }
        WindowsPipe.CloseHandle(this.myHandle);
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    private class PipeInputStream
    extends InputStream {
        private final long handle;

        PipeInputStream(long handle) {
            this.handle = handle;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int result = this.read(b) == 0 ? -1 : 0xFF & b[0];
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return WindowsPipe.read(WindowsPipeSocket.this.myReaderWait, this.handle, b, off, len);
        }
    }

    private class PipeOutputStream
    extends OutputStream {
        private final long handle;

        PipeOutputStream(long handle) {
            this.handle = handle;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(0xFF & b)});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            WindowsPipe.write(WindowsPipeSocket.this.myWriterWait, this.handle, b, off, len);
        }
    }
}

