/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.git;

import git4idea.GitLocalBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.git.Commit;
import uk.co.ben_gibson.url.Host;
import uk.co.ben_gibson.url.URL;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"domain", "Luk/co/ben_gibson/url/Host;", "Lgit4idea/repo/GitRemote;", "getDomain", "(Lgit4idea/repo/GitRemote;)Luk/co/ben_gibson/url/Host;", "httpUrl", "Luk/co/ben_gibson/url/URL;", "getHttpUrl", "(Lgit4idea/repo/GitRemote;)Luk/co/ben_gibson/url/URL;", "contains", "", "repository", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitLocalBranch;", "commit", "Luk/co/ben_gibson/git/link/git/Commit;", "GitLink"})
@SourceDebugExtension(value={"SMAP\nRemoteExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteExtensions.kt\nuk/co/ben_gibson/git/link/git/RemoteExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class RemoteExtensionsKt {
    @Nullable
    public static final Host getDomain(@NotNull GitRemote $this$domain) {
        Intrinsics.checkNotNullParameter((Object)$this$domain, (String)"<this>");
        URL uRL = RemoteExtensionsKt.getHttpUrl($this$domain);
        return uRL != null ? uRL.getHost() : null;
    }

    @Nullable
    public static final URL getHttpUrl(@NotNull GitRemote $this$httpUrl) {
        String string;
        Regex regex;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$httpUrl, (String)"<this>");
        String string2 = $this$httpUrl.getFirstUrl();
        if (string2 == null) {
            return null;
        }
        Object url = string2;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)(url = ((Object)StringsKt.trim((CharSequence)((CharSequence)url))).toString())), (CharSequence)"dev.azure", (boolean)false, (int)2, null)) {
            url = StringsKt.removeSuffix((String)url, (CharSequence)".git");
        }
        if (!StringsKt.startsWith$default((String)url, (String)"git@", (boolean)false, (int)2, null)) {
            charSequence = (CharSequence)url;
            regex = new Regex(":\\d{1,5}");
            string = "";
            url = regex.replace(charSequence, string);
        }
        if (!StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            charSequence = StringsKt.replace$default((String)url, (String)"git@", (String)"", (boolean)false, (int)4, null);
            regex = new Regex("^[^:]+://");
            string = "";
            url = StringsKt.replace$default((String)regex.replace(charSequence, string), (String)":", (String)"/", (boolean)false, (int)4, null);
            url = "http://" + (String)url;
        }
        return URL.Companion.fromString((String)url);
    }

    public static final boolean contains(@NotNull GitRemote $this$contains, @NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        String[] stringArray = new String[]{$this$contains.getFirstUrl(), branch.getFullName(), "--heads"};
        GitCommandResult gitCommandResult = Git.getInstance().lsRemote(repository.getProject(), repository.getRoot(), $this$contains, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"lsRemote(...)");
        GitCommandResult result = gitCommandResult;
        if (result.success()) {
            return result.getOutput().size() == 1;
        }
        return branch.findTrackedBranch(repository) != null;
    }

    public static final boolean contains(@NotNull GitRemote $this$contains, @NotNull GitRepository repository, @NotNull Commit commit) {
        Object v4;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            GitLineHandler command = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
            String[] stringArray = new String[]{"-r", "--contains", commit.toString()};
            command.addParameters(stringArray);
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(command);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
            GitCommandResult result = gitCommandResult;
            if (!result.success()) {
                return false;
            }
            List list = result.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutput(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String string = ((Object)StringsKt.trim((CharSequence)it)).toString();
                String string2 = $this$contains.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                v4 = t;
                break block2;
            }
            v4 = null;
        }
        return v4 != null;
    }
}

