/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.pipeline.middleware;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.git.RepositoryExtensionsKt;
import uk.co.ben_gibson.git.link.pipeline.Pass;
import uk.co.ben_gibson.git.link.pipeline.middleware.Middleware;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.platform.PlatformLocator;
import uk.co.ben_gibson.git.link.settings.ProjectSettings;
import uk.co.ben_gibson.git.link.ui.notification.Notification;
import uk.co.ben_gibson.git.link.ui.notification.NotifierKt;
import uk.co.ben_gibson.url.URL;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\fH\u0096\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Luk/co/ben_gibson/git/link/pipeline/middleware/ResolveContext;", "Luk/co/ben_gibson/git/link/pipeline/middleware/Middleware;", "()V", "priority", "", "getPriority", "()I", "invoke", "Luk/co/ben_gibson/url/URL;", "pass", "Luk/co/ben_gibson/git/link/pipeline/Pass;", "next", "Lkotlin/Function0;", "localePlatform", "Luk/co/ben_gibson/git/link/platform/Platform;", "locateRemote", "Lgit4idea/repo/GitRemote;", "repository", "Lgit4idea/repo/GitRepository;", "locateRepository", "GitLink"})
@SourceDebugExtension(value={"SMAP\nResolveContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolveContext.kt\nuk/co/ben_gibson/git/link/pipeline/middleware/ResolveContext\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n30#2,3:59\n30#2,3:62\n*S KotlinDebug\n*F\n+ 1 ResolveContext.kt\nuk/co/ben_gibson/git/link/pipeline/middleware/ResolveContext\n*L\n34#1:59,3\n52#1:62,3\n*E\n"})
public final class ResolveContext
implements Middleware {
    private final int priority;

    public ResolveContext() {
        this.priority = 5;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    @Nullable
    public URL invoke(@NotNull Pass pass, @NotNull Function0<URL> next2) {
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter(next2, (String)"next");
        GitRepository gitRepository = this.locateRepository(pass);
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository = gitRepository;
        GitRemote gitRemote = this.locateRemote(pass, repository);
        if (gitRemote == null) {
            return null;
        }
        GitRemote remote = gitRemote;
        Platform platform = this.localePlatform(pass);
        if (platform == null) {
            return null;
        }
        Platform platform2 = platform;
        pass.setPlatform(platform2);
        pass.setRepository(repository);
        pass.setRemote(remote);
        return (URL)next2.invoke();
    }

    private final Platform localePlatform(Pass pass) {
        ComponentManager $this$service$iv = (ComponentManager)pass.getProject();
        boolean $i$f$service = false;
        Class<PlatformLocator> serviceClass$iv = PlatformLocator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        Platform platform = ((PlatformLocator)object).locate();
        if (platform == null) {
            NotifierKt.sendNotification(Notification.Companion.hostNotSet(pass.getProject()), pass.getProject());
        }
        return platform;
    }

    private final GitRepository locateRepository(Pass pass) {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance((Project)pass.getProject()).getRepositoryForFile(pass.getContext().getFile());
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            NotifierKt.sendNotification(Notification.Companion.repositoryNotFound(), pass.getProject());
            gitRepository = Unit.INSTANCE;
        }
        return repository;
    }

    private final GitRemote locateRemote(Pass pass, GitRepository repository) {
        ComponentManager $this$service$iv = (ComponentManager)pass.getProject();
        boolean $i$f$service = false;
        Class<ProjectSettings> serviceClass$iv = ProjectSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        GitRemote remote = RepositoryExtensionsKt.locateRemote(repository, ((ProjectSettings)object).getRemote());
        GitRemote gitRemote = remote;
        if (gitRemote == null) {
            NotifierKt.sendNotification(Notification.Companion.remoteNotFound(), pass.getProject());
            gitRemote = Unit.INSTANCE;
        }
        return remote;
    }

    @Override
    public int compareTo(@NotNull Middleware other) {
        return Middleware.DefaultImpls.compareTo(this, other);
    }
}

