/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.ui.validation;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.GitLinkBundle;
import uk.co.ben_gibson.git.link.git.Commit;
import uk.co.ben_gibson.git.link.git.File;
import uk.co.ben_gibson.git.link.ui.LineSelection;
import uk.co.ben_gibson.git.link.url.UrlOptions;
import uk.co.ben_gibson.git.link.url.factory.TemplatedUrlFactory;
import uk.co.ben_gibson.git.link.url.template.UrlTemplates;
import uk.co.ben_gibson.url.Host;
import uk.co.ben_gibson.url.URL;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a4\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"alphaNumeric", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "value", "", "commitTemplate", "domain", "exists", "existing", "", "fileAtBranchTemplate", "fileAtCommitTemplate", "length", "min", "", "max", "notBlank", "urlTemplate", "options", "Luk/co/ben_gibson/git/link/url/UrlOptions;", "fileAtBranch", "fileAtCommit", "commit", "GitLink"})
public final class ValidationExtensionsKt {
    @Nullable
    public static final ValidationInfo notBlank(@NotNull ValidationInfoBuilder $this$notBlank, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$notBlank, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((CharSequence)value).length() == 0 ? $this$notBlank.error(GitLinkBundle.message("validation.required", new Object[0])) : null;
    }

    @Nullable
    public static final ValidationInfo domain(@NotNull ValidationInfoBuilder $this$domain, @NotNull String value) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$domain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        try {
            Host.Companion.invoke(value);
            validationInfo = null;
        }
        catch (IllegalArgumentException e) {
            validationInfo = $this$domain.error(GitLinkBundle.message("validation.invalid-domain", new Object[0]));
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo alphaNumeric(@NotNull ValidationInfoBuilder $this$alphaNumeric, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$alphaNumeric, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        CharSequence charSequence = value;
        return !new Regex("[\\w\\s]+").matches(charSequence) ? $this$alphaNumeric.error(GitLinkBundle.message("validation.alpha-numeric", new Object[0])) : null;
    }

    @Nullable
    public static final ValidationInfo exists(@NotNull ValidationInfoBuilder $this$exists, @NotNull String value, @NotNull Collection<String> existing) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(existing, (String)"existing");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        if (existing.contains(value)) {
            return $this$exists.error(GitLinkBundle.message("validation.exists", new Object[0]));
        }
        return null;
    }

    @Nullable
    public static final ValidationInfo length(@NotNull ValidationInfoBuilder $this$length, @NotNull String value, int min, int max) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        if (value.length() < min) {
            Object[] objectArray = new Object[]{min};
            validationInfo = $this$length.error(GitLinkBundle.message("validation.min-length", objectArray));
        } else if (value.length() > max) {
            Object[] objectArray = new Object[]{max};
            validationInfo = $this$length.error(GitLinkBundle.message("validation.max-length", objectArray));
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo fileAtCommitTemplate(@NotNull ValidationInfoBuilder $this$fileAtCommitTemplate, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$fileAtCommitTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        UrlOptions.UrlOptionsFileAtCommit options = new UrlOptions.UrlOptionsFileAtCommit(new File("foo.kt", false, "src/main", false), "main", new Commit("734232a3c18f0625843bd161c3f5da272b9d53c1"), new LineSelection(10, 20));
        return ValidationExtensionsKt.urlTemplate$default($this$fileAtCommitTemplate, options, null, value, null, 10, null);
    }

    @Nullable
    public static final ValidationInfo fileAtBranchTemplate(@NotNull ValidationInfoBuilder $this$fileAtBranchTemplate, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$fileAtBranchTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        UrlOptions.UrlOptionsFileAtBranch options = new UrlOptions.UrlOptionsFileAtBranch(new File("foo.kt", false, "src/main", false), "master", new LineSelection(10, 20));
        return ValidationExtensionsKt.urlTemplate$default($this$fileAtBranchTemplate, options, value, null, null, 12, null);
    }

    @Nullable
    public static final ValidationInfo commitTemplate(@NotNull ValidationInfoBuilder $this$commitTemplate, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$commitTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        UrlOptions.UrlOptionsCommit options = new UrlOptions.UrlOptionsCommit(new Commit("734232a3c18f0625843bd161c3f5da272b9d53c1"), "main");
        return ValidationExtensionsKt.urlTemplate$default($this$commitTemplate, options, null, null, value, 6, null);
    }

    private static final ValidationInfo urlTemplate(ValidationInfoBuilder $this$urlTemplate, UrlOptions options, String fileAtBranch, String fileAtCommit, String commit) {
        ValidationInfo validationInfo;
        TemplatedUrlFactory factory = new TemplatedUrlFactory(new UrlTemplates(fileAtBranch, fileAtCommit, commit));
        try {
            factory.createUrl(URL.Companion.fromString("https://example.com"), options);
            validationInfo = null;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                throw e;
            }
            validationInfo = $this$urlTemplate.error(GitLinkBundle.message("validation.invalid-url-template", new Object[0]));
        }
        return validationInfo;
    }

    static /* synthetic */ ValidationInfo urlTemplate$default(ValidationInfoBuilder validationInfoBuilder, UrlOptions urlOptions, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        return ValidationExtensionsKt.urlTemplate(validationInfoBuilder, urlOptions, string, string2, string3);
    }
}

