/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change.change;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.DuplicableOperatorAction;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.handler.ChangeEditorActionHandler;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/action/change/change/ChangeRot13MotionAction;", "Lcom/maddyhome/idea/vim/handler/ChangeEditorActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/command/DuplicableOperatorAction;", "<init>", "()V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "argumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "getArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "duplicateWith", "", "getDuplicateWith", "()C", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "Companion", "vim-engine"})
public final class ChangeRot13MotionAction
extends ChangeEditorActionHandler.ForEachCaret
implements DuplicableOperatorAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Command.Type type = Command.Type.CHANGE;
    @NotNull
    private final Argument.Type argumentType = Argument.Type.MOTION;
    private final char duplicateWith = (char)63;

    @Override
    @NotNull
    public Command.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Argument.Type getArgumentType() {
        return this.argumentType;
    }

    @Override
    public char getDuplicateWith() {
        return this.duplicateWith;
    }

    @Override
    public boolean execute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @Nullable Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (argument == null) {
            return false;
        }
        TextRange textRange = VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        return Companion.applyRot13(editor, caret, range);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/action/change/change/ChangeRot13MotionAction$Companion;", "", "<init>", "()V", "applyRot13", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "applyRot13ToRange", "", "start", "", "end", "rot13", "", "ch", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean applyRot13(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            int[] starts = range.getStartOffsets();
            int[] ends = range.getEndOffsets();
            int n = ends.length + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    this.applyRot13ToRange(editor, caret, starts[i], ends[i]);
                } while (0 <= n);
            }
            caret.moveToOffset(range.getStartOffset());
            return true;
        }

        private final void applyRot13ToRange(VimEditor editor, VimCaret caret, int start, int end) {
            StringBuilder stringBuilder;
            Pair pair = start > end ? TuplesKt.to((Object)end, (Object)start) : TuplesKt.to((Object)start, (Object)end);
            int newStart = ((Number)pair.component1()).intValue();
            int newEnd = ((Number)pair.component2()).intValue();
            StringBuilder $this$applyRot13ToRange_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = newStart; i < newEnd; ++i) {
                $this$applyRot13ToRange_u24lambda_u240.append(Companion.rot13(editor.text().charAt(i)));
            }
            String changedText = stringBuilder.toString();
            VimInjectorKt.getInjector().getChangeGroup().replaceText(editor, caret, newStart, newEnd, changedText);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final char rot13(char ch) {
            char c;
            if (ch < '\u0080') {
                boolean bl = 'a' <= ch ? ch < '{' : false;
                if (bl) {
                    c = (char)(97 + (ch - 97 + 13) % 26);
                    return c;
                }
            }
            if (ch < '\u0080') {
                boolean bl = 'A' <= ch ? ch < '[' : false;
                if (bl) {
                    c = (char)(65 + (ch - 65 + 13) % 26);
                    return c;
                }
            }
            c = ch;
            return c;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

