/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimscriptFunctionService;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.vimscript.model.CommandLineVimLContext;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.LazyVimscriptFunction;
import com.maddyhome.idea.vim.vimscript.model.functions.VimscriptFunctionProvider;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0016J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0010H\u0016J\b\u0010#\u001a\u00020\u0010H\u0016R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase;", "Lcom/maddyhome/idea/vim/api/VimscriptFunctionService;", "<init>", "()V", "functionProviders", "", "Lcom/maddyhome/idea/vim/vimscript/model/functions/VimscriptFunctionProvider;", "getFunctionProviders", "()Ljava/util/List;", "globalFunctions", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "builtInFunctions", "Lcom/maddyhome/idea/vim/vimscript/model/functions/LazyVimscriptFunction;", "deleteFunction", "", "name", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "storeFunction", "declaration", "getFunctionHandler", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "getFunctionHandlerOrNull", "getUserDefinedFunction", "getBuiltInFunction", "storeScriptFunction", "functionDeclaration", "getScriptFunction", "deleteScriptFunction", "getDefaultFunctionScope", "registerHandlers", "resetUserDefinedFunctions", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimScriptFunctionServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimScriptFunctionServiceBase.kt\ncom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1869#2:187\n1869#2,2:188\n1870#2:190\n*S KotlinDebug\n*F\n+ 1 VimScriptFunctionServiceBase.kt\ncom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase\n*L\n167#1:187\n168#1:188,2\n167#1:190\n*E\n"})
public abstract class VimScriptFunctionServiceBase
implements VimscriptFunctionService {
    @NotNull
    private final Map<String, FunctionDeclaration> globalFunctions = new LinkedHashMap();
    @NotNull
    private final Map<String, LazyVimscriptFunction> builtInFunctions = new LinkedHashMap();

    @NotNull
    protected abstract List<VimscriptFunctionProvider> getFunctionProviders();

    @Override
    public void deleteFunction(@NotNull String name, @Nullable Scope scope, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        if (Character.isLowerCase(name.charAt(0)) && scope != Scope.SCRIPT_VARIABLE) {
            Object[] objectArray = new Object[]{name};
            throw ExExceptionsKt.exExceptionMessage("E128", objectArray);
        }
        if (scope != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
                case 1: {
                    if (this.globalFunctions.containsKey(name)) {
                        FunctionDeclaration functionDeclaration = this.globalFunctions.get(name);
                        Intrinsics.checkNotNull((Object)functionDeclaration);
                        functionDeclaration.setDeleted(true);
                        this.globalFunctions.remove(name);
                        return;
                    }
                    Object[] objectArray = new Object[]{scope + name};
                    throw ExExceptionsKt.exExceptionMessage("E130", objectArray);
                }
                case 2: {
                    if (!(vimContext.getFirstParentContext() instanceof Script)) {
                        throw ExExceptionsKt.exExceptionMessage("E81", new Object[0]);
                    }
                    if (this.getScriptFunction(name, vimContext) != null) {
                        this.deleteScriptFunction(name, vimContext);
                        return;
                    }
                    Object[] objectArray = new Object[]{scope + name};
                    throw ExExceptionsKt.exExceptionMessage("E130", objectArray);
                }
            }
            Object[] objectArray = new Object[]{scope + name};
            throw ExExceptionsKt.exExceptionMessage("E130", objectArray);
        }
        if (this.globalFunctions.containsKey(name)) {
            FunctionDeclaration functionDeclaration = this.globalFunctions.get(name);
            Intrinsics.checkNotNull((Object)functionDeclaration);
            functionDeclaration.setDeleted(true);
            this.globalFunctions.remove(name);
            return;
        }
        VimLContext firstParentContext = vimContext.getFirstParentContext();
        if (firstParentContext instanceof Script && this.getScriptFunction(name, vimContext) != null) {
            this.deleteScriptFunction(name, vimContext);
            return;
        }
        Object[] objectArray = new Object[]{name};
        throw ExExceptionsKt.exExceptionMessage("E130", objectArray);
    }

    @Override
    public void storeFunction(@NotNull FunctionDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Scope scope = declaration.getScope();
        if (scope == null) {
            scope = this.getDefaultFunctionScope();
        }
        Scope scope2 = scope;
        switch (WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
            case 1: {
                if (this.globalFunctions.containsKey(declaration.getName()) && !declaration.getReplaceExisting()) {
                    Object[] objectArray = new Object[]{declaration.getName()};
                    throw ExExceptionsKt.exExceptionMessage("E122", objectArray);
                }
                this.globalFunctions.put(declaration.getName(), declaration);
                break;
            }
            case 2: {
                if (!(declaration.getFirstParentContext() instanceof Script)) {
                    throw ExExceptionsKt.exExceptionMessage("E81", new Object[0]);
                }
                if (this.getScriptFunction(declaration.getName(), declaration) != null && !declaration.getReplaceExisting()) {
                    Object[] objectArray = new Object[]{declaration.getName()};
                    throw ExExceptionsKt.exExceptionMessage("E122", objectArray);
                }
                this.storeScriptFunction(declaration);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{scope2 + declaration.getName()};
                throw ExExceptionsKt.exExceptionMessage("E884", objectArray);
            }
        }
    }

    @Override
    @NotNull
    public FunctionHandler getFunctionHandler(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        FunctionHandler functionHandler = this.getFunctionHandlerOrNull(scope, name, vimContext);
        if (functionHandler == null) {
            Object[] objectArray = new Object[1];
            Object object = scope;
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            objectArray[0] = (String)object + name;
            throw ExExceptionsKt.exExceptionMessage("E117", objectArray);
        }
        return functionHandler;
    }

    @Override
    @Nullable
    public FunctionHandler getFunctionHandlerOrNull(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        FunctionHandler builtInFunction;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        if (scope == null && (builtInFunction = this.getBuiltInFunction(name)) != null) {
            return builtInFunction;
        }
        FunctionDeclaration definedFunction = this.getUserDefinedFunction(scope, name, vimContext);
        if (definedFunction != null) {
            return new DefinedFunctionHandler(definedFunction);
        }
        return null;
    }

    @Override
    @Nullable
    public FunctionDeclaration getUserDefinedFunction(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        FunctionDeclaration functionDeclaration;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope2 = scope;
        switch (scope2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
            case 1: {
                functionDeclaration = this.globalFunctions.get(name);
                break;
            }
            case 2: {
                functionDeclaration = this.getScriptFunction(name, vimContext);
                break;
            }
            case -1: {
                VimLContext firstParentContext;
                VimLContext vimLContext = firstParentContext = vimContext.getFirstParentContext();
                if (vimLContext instanceof CommandLineVimLContext) {
                    functionDeclaration = this.globalFunctions.get(name);
                    break;
                }
                if (vimLContext instanceof Script) {
                    functionDeclaration = this.globalFunctions.get(name);
                    if (functionDeclaration != null) break;
                    functionDeclaration = this.getScriptFunction(name, vimContext);
                    break;
                }
                throw new RuntimeException("Unknown parent context");
            }
            default: {
                functionDeclaration = null;
            }
        }
        return functionDeclaration;
    }

    @Override
    @Nullable
    public FunctionHandler getBuiltInFunction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LazyVimscriptFunction lazyVimscriptFunction = this.builtInFunctions.get(name);
        return lazyVimscriptFunction != null ? lazyVimscriptFunction.getInstance() : null;
    }

    private final void storeScriptFunction(FunctionDeclaration functionDeclaration) {
        Script script = functionDeclaration.getScript();
        if (script == null) {
            throw ExExceptionsKt.exExceptionMessage("E81", new Object[0]);
        }
        Script script2 = script;
        script2.getScriptFunctions().put(functionDeclaration.getName(), functionDeclaration);
    }

    private final FunctionDeclaration getScriptFunction(String name, VimLContext vimContext) {
        Script script = vimContext.getScript();
        if (script == null) {
            Object[] objectArray = new Object[]{name};
            throw ExExceptionsKt.exExceptionMessage("E120", objectArray);
        }
        Script script2 = script;
        return script2.getScriptFunctions().get(name);
    }

    private final void deleteScriptFunction(String name, VimLContext vimContext) {
        Script script = vimContext.getScript();
        if (script == null) {
            throw ExExceptionsKt.exExceptionMessage("E81", new Object[0]);
        }
        Script script2 = script;
        if (script2.getScriptFunctions().get(name) != null) {
            FunctionDeclaration functionDeclaration = script2.getScriptFunctions().get(name);
            Intrinsics.checkNotNull((Object)functionDeclaration);
            functionDeclaration.setDeleted(true);
        }
        script2.getScriptFunctions().remove(name);
    }

    private final Scope getDefaultFunctionScope() {
        return Scope.GLOBAL_VARIABLE;
    }

    @Override
    public void registerHandlers() {
        Iterable $this$forEach$iv = this.getFunctionProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimscriptFunctionProvider provider = (VimscriptFunctionProvider)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = provider.getFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LazyVimscriptFunction it = (LazyVimscriptFunction)element$iv2;
                boolean bl2 = false;
                this.builtInFunctions.put(it.getName(), it);
            }
        }
    }

    @Override
    public void resetUserDefinedFunctions() {
        Iterator<Map.Entry<String, FunctionDeclaration>> iterator = this.globalFunctions.entrySet().iterator();
        while (iterator.hasNext()) {
            FunctionDeclaration function = iterator.next().getValue();
            function.setDeleted(true);
            iterator.remove();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.SCRIPT_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

