/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.DigraphResult;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import java.util.Arrays;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/maddyhome/idea/vim/common/DigraphSequence;", "", "<init>", "()V", "digraphState", "Lcom/maddyhome/idea/vim/common/DigraphSequence$DigraphState;", "digraphChar", "", "codeChars", "", "codeCnt", "", "codeType", "codeMax", "isDigraphStart", "", "key", "Ljavax/swing/KeyStroke;", "isLiteralStart", "startDigraphSequence", "Lcom/maddyhome/idea/vim/common/DigraphResult;", "startLiteralSequence", "processKey", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "specialKeyToCodepoint", "(Ljavax/swing/KeyStroke;)Ljava/lang/Integer;", "reset", "", "equals", "other", "", "hashCode", "clone", "toString", "", "Companion", "DigraphState", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDigraphSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigraphSequence.kt\ncom/maddyhome/idea/vim/common/DigraphSequence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,292:1\n1#2:293\n39#3:294\n*S KotlinDebug\n*F\n+ 1 DigraphSequence.kt\ncom/maddyhome/idea/vim/common/DigraphSequence\n*L\n280#1:294\n*E\n"})
public final class DigraphSequence
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DigraphState digraphState = DigraphState.DIG_STATE_PENDING;
    private char digraphChar;
    private char[] codeChars;
    private int codeCnt;
    private int codeType;
    private int codeMax;
    @NotNull
    private static final VimLogger logger;

    public final boolean isDigraphStart(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.digraphState == DigraphState.DIG_STATE_PENDING && key.getKeyCode() == 75 && (key.getModifiers() & 0x80) != 0;
    }

    public final boolean isLiteralStart(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.digraphState == DigraphState.DIG_STATE_PENDING && (key.getKeyCode() == 86 || key.getKeyCode() == 81) && (key.getModifiers() & 0x80) != 0;
    }

    @NotNull
    public final DigraphResult startDigraphSequence() {
        logger.debug("startDigraphSequence");
        this.digraphState = DigraphState.DIG_STATE_DIG_ONE;
        return DigraphResult.HandledDigraph.INSTANCE;
    }

    @NotNull
    public final DigraphResult startLiteralSequence() {
        logger.debug("startLiteralSequence");
        this.digraphState = DigraphState.DIG_STATE_CODE_START;
        this.codeChars = new char[8];
        this.codeCnt = 0;
        return DigraphResult.HandledLiteral.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final DigraphResult processKey(@NotNull KeyStroke key, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.digraphState.ordinal()]) {
            case 1: {
                logger.debug("DIG_STATE_PENDING");
                if (key.getKeyCode() == 8 && VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getDigraph()) {
                    this.digraphState = DigraphState.DIG_STATE_BACK_SPACE;
                } else if (key.getKeyChar() != '\uffff') {
                    this.digraphChar = key.getKeyChar();
                }
                DigraphResult digraphResult = DigraphResult.Unhandled.INSTANCE;
                return digraphResult;
            }
            case 2: {
                logger.debug("DIG_STATE_BACK_SPACE");
                this.digraphState = DigraphState.DIG_STATE_PENDING;
                if (key.getKeyChar() != '\uffff') {
                    int codepoint = VimInjectorKt.getInjector().getDigraphGroup().getCharacterForDigraph(this.digraphChar, key.getKeyChar());
                    this.digraphChar = '\u0000';
                    return DigraphResult.Companion.done(codepoint);
                }
                DigraphResult digraphResult = DigraphResult.Unhandled.INSTANCE;
                return digraphResult;
            }
            case 3: {
                logger.debug("DIG_STATE_DIG_ONE");
                if (key.getKeyChar() != '\uffff') {
                    this.digraphChar = key.getKeyChar();
                    this.digraphState = DigraphState.DIG_STATE_DIG_TWO;
                    return DigraphResult.Companion.handled(this.digraphChar);
                }
                this.digraphState = DigraphState.DIG_STATE_PENDING;
                DigraphResult digraphResult = DigraphResult.Bad.INSTANCE;
                return digraphResult;
            }
            case 4: {
                logger.debug("DIG_STATE_DIG_TWO");
                this.digraphState = DigraphState.DIG_STATE_PENDING;
                if (key.getKeyChar() != '\uffff') {
                    int codepoint = VimInjectorKt.getInjector().getDigraphGroup().getCharacterForDigraph(this.digraphChar, key.getKeyChar());
                    return DigraphResult.Companion.done(codepoint);
                }
                DigraphResult digraphResult = DigraphResult.Bad.INSTANCE;
                return digraphResult;
            }
            case 5: {
                DigraphResult digraphResult;
                logger.debug("DIG_STATE_CODE_START");
                switch (key.getKeyChar()) {
                    case 'O': 
                    case 'o': {
                        this.codeMax = 3;
                        this.digraphState = DigraphState.DIG_STATE_CODE_CHAR;
                        this.codeType = 8;
                        logger.debug("Octal");
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                        return digraphResult;
                    }
                    case 'X': 
                    case 'x': {
                        this.codeMax = 2;
                        this.digraphState = DigraphState.DIG_STATE_CODE_CHAR;
                        this.codeType = 16;
                        logger.debug("hex2");
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                        return digraphResult;
                    }
                    case 'u': {
                        this.codeMax = 4;
                        this.digraphState = DigraphState.DIG_STATE_CODE_CHAR;
                        this.codeType = 16;
                        logger.debug("hex4");
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                        return digraphResult;
                    }
                    case 'U': {
                        this.codeMax = 8;
                        this.digraphState = DigraphState.DIG_STATE_CODE_CHAR;
                        this.codeType = 16;
                        logger.debug("hex8");
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                        return digraphResult;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.codeMax = 3;
                        this.digraphState = DigraphState.DIG_STATE_CODE_CHAR;
                        this.codeType = 10;
                        char[] cArray = this.codeChars;
                        if (this.codeChars == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                            cArray = null;
                        }
                        int n = this.codeCnt;
                        this.codeCnt = n + 1;
                        cArray[n] = key.getKeyChar();
                        logger.debug("decimal");
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                        return digraphResult;
                    }
                }
                this.digraphState = DigraphState.DIG_STATE_PENDING;
                if (key.getKeyCode() == 9) {
                    return DigraphResult.Companion.done(9);
                }
                Integer codepoint = this.specialKeyToCodepoint(key);
                if (codepoint != null) {
                    return DigraphResult.Companion.done(codepoint);
                }
                logger.debug("unknown");
                digraphResult = DigraphResult.Companion.done(Integer.valueOf(key.getKeyChar()));
                return digraphResult;
            }
            case 6: {
                logger.debug("DIG_STATE_CODE_CHAR");
                boolean valid = false;
                switch (this.codeType) {
                    case 10: {
                        char c = key.getKeyChar();
                        boolean bl = '0' <= c ? c < ':' : false;
                        if (!bl) break;
                        valid = true;
                        break;
                    }
                    case 8: {
                        char c = key.getKeyChar();
                        boolean bl = '0' <= c ? c < '8' : false;
                        if (!bl) break;
                        valid = true;
                        break;
                    }
                    case 16: {
                        char c = key.getKeyChar();
                        if (!('0' <= c ? c < ':' : false)) {
                            c = key.getKeyChar();
                            if (!('a' <= c ? c < 'g' : false)) {
                                c = key.getKeyChar();
                                boolean bl = 'A' <= c ? c < 'G' : false;
                                if (!bl) break;
                            }
                        }
                        valid = true;
                    }
                }
                if (valid) {
                    DigraphResult digraphResult;
                    logger.debug("valid");
                    char[] cArray = this.codeChars;
                    if (this.codeChars == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                        cArray = null;
                    }
                    int codepoint = this.codeCnt;
                    this.codeCnt = codepoint + 1;
                    cArray[codepoint] = key.getKeyChar();
                    if (this.codeCnt == this.codeMax) {
                        this.digraphState = DigraphState.DIG_STATE_PENDING;
                        char[] cArray2 = this.codeChars;
                        if (this.codeChars == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                            cArray2 = null;
                        }
                        char[] cArray3 = cArray2;
                        int n = 0;
                        int n2 = this.codeCnt;
                        String digits = new String(cArray3, n, n2);
                        int codepoint2 = Integer.parseInt(digits, CharsKt.checkRadix((int)this.codeType));
                        digraphResult = DigraphResult.Companion.done(codepoint2);
                        return digraphResult;
                    } else {
                        digraphResult = DigraphResult.HandledLiteral.INSTANCE;
                    }
                    return digraphResult;
                }
                if (this.codeCnt > 0) {
                    logger.debug("invalid");
                    this.digraphState = DigraphState.DIG_STATE_PENDING;
                    char[] cArray = this.codeChars;
                    if (this.codeChars == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                        cArray = null;
                    }
                    char[] codepoint2 = cArray;
                    int n = 0;
                    int n3 = this.codeCnt;
                    String digits = new String(codepoint2, n, n3);
                    int codepoint22 = Integer.parseInt(digits, CharsKt.checkRadix((int)this.codeType));
                    if (VimInjectorKt.getInjector().getApplication().isUnitTest()) return DigraphResult.Companion.done(codepoint22);
                    VimInjectorKt.getInjector().getApplication().postKey(key, editor);
                    return DigraphResult.Companion.done(codepoint22);
                }
                if (this.codeCnt == 0) {
                    this.digraphState = DigraphState.DIG_STATE_PENDING;
                    Object object = this.specialKeyToCodepoint(key);
                    if (object != null) {
                        int it = ((Number)object).intValue();
                        boolean bl = false;
                        DigraphResult digraphResult = DigraphResult.Companion.done(it);
                        object = digraphResult;
                        if (digraphResult != null) return object;
                    }
                    object = DigraphResult.Companion.done(Integer.valueOf(key.getKeyChar()));
                    return object;
                }
                DigraphResult digraphResult = DigraphResult.Bad.INSTANCE;
                return digraphResult;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final Integer specialKeyToCodepoint(KeyStroke key) {
        String string;
        if ((key.getModifiers() & 0x80) != 0) {
            string = VimInjectorKt.getInjector().getParser().parseVimScriptString("\\" + VimInjectorKt.getInjector().getParser().toKeyNotation(key));
            if (string.length() == 1) {
                return string.charAt(0) == '\n' ? Integer.valueOf(0) : Integer.valueOf(string.charAt(0));
            }
        } else {
            return switch (key.getKeyCode()) {
                case 10 -> 13;
                case 27 -> 27;
                default -> null;
            };
        }
        logger.error("Digraph char was recognized as multiple chars: " + string + " (" + key + ")");
        return null;
    }

    public final void reset() {
        this.digraphState = DigraphState.DIG_STATE_PENDING;
        this.codeChars = new char[8];
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.common.DigraphSequence");
        DigraphSequence cfr_ignored_0 = (DigraphSequence)object2;
        if (this.digraphState != ((DigraphSequence)other).digraphState) {
            return false;
        }
        if (this.digraphChar != ((DigraphSequence)other).digraphChar) {
            return false;
        }
        if (this.codeCnt != ((DigraphSequence)other).codeCnt) {
            return false;
        }
        if (this.codeType != ((DigraphSequence)other).codeType) {
            return false;
        }
        if (this.codeMax != ((DigraphSequence)other).codeMax) {
            return false;
        }
        if (this.codeChars != null && ((DigraphSequence)other).codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            char[] cArray2 = cArray;
            char[] cArray3 = ((DigraphSequence)other).codeChars;
            if (((DigraphSequence)other).codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray3 = null;
            }
            if (!Arrays.equals(cArray2, cArray3)) {
                return false;
            }
        } else if (this.codeChars != null != (((DigraphSequence)other).codeChars != null)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int result = this.digraphState.getValue();
        result = 31 * result + Character.hashCode(this.digraphChar);
        if (this.codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            n = Arrays.hashCode(cArray);
        } else {
            n = 0;
        }
        result = 31 * result + n;
        result = 31 * result + this.codeCnt;
        result = 31 * result + this.codeType;
        result = 31 * result + this.codeMax;
        return result;
    }

    @NotNull
    public DigraphSequence clone() {
        DigraphSequence result = new DigraphSequence();
        result.digraphState = this.digraphState;
        result.digraphChar = this.digraphChar;
        if (this.codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            char[] cArray2 = cArray;
            char[] cArray3 = Arrays.copyOf(cArray2, cArray2.length);
            Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"copyOf(...)");
            result.codeChars = cArray3;
        }
        result.codeCnt = this.codeCnt;
        result.codeType = this.codeType;
        result.codeMax = this.codeMax;
        return result;
    }

    @NotNull
    public String toString() {
        return "State = " + this.digraphState + ", char = " + this.digraphChar;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(DigraphSequence.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/common/DigraphSequence$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/common/DigraphSequence$DigraphState;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "getValue", "()I", "DIG_STATE_PENDING", "DIG_STATE_DIG_ONE", "DIG_STATE_DIG_TWO", "DIG_STATE_CODE_START", "DIG_STATE_CODE_CHAR", "DIG_STATE_BACK_SPACE", "vim-engine"})
    private static final class DigraphState
    extends Enum<DigraphState> {
        private final int value;
        public static final /* enum */ DigraphState DIG_STATE_PENDING = new DigraphState(1);
        public static final /* enum */ DigraphState DIG_STATE_DIG_ONE = new DigraphState(2);
        public static final /* enum */ DigraphState DIG_STATE_DIG_TWO = new DigraphState(3);
        public static final /* enum */ DigraphState DIG_STATE_CODE_START = new DigraphState(10);
        public static final /* enum */ DigraphState DIG_STATE_CODE_CHAR = new DigraphState(11);
        public static final /* enum */ DigraphState DIG_STATE_BACK_SPACE = new DigraphState(20);
        private static final /* synthetic */ DigraphState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DigraphState(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static DigraphState[] values() {
            return (DigraphState[])$VALUES.clone();
        }

        public static DigraphState valueOf(String value) {
            return Enum.valueOf(DigraphState.class, value);
        }

        @NotNull
        public static EnumEntries<DigraphState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = digraphStateArray = new DigraphState[]{DigraphState.DIG_STATE_PENDING, DigraphState.DIG_STATE_DIG_ONE, DigraphState.DIG_STATE_DIG_TWO, DigraphState.DIG_STATE_CODE_START, DigraphState.DIG_STATE_CODE_CHAR, DigraphState.DIG_STATE_BACK_SPACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DigraphState.values().length];
            try {
                nArray[DigraphState.DIG_STATE_PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DigraphState.DIG_STATE_BACK_SPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DigraphState.DIG_STATE_DIG_ONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DigraphState.DIG_STATE_DIG_TWO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DigraphState.DIG_STATE_CODE_START.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DigraphState.DIG_STATE_CODE_CHAR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

