/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.ranges;

import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ranges.CurrentLineAddress;
import com.maddyhome.idea.vim.ex.ranges.LastLineAddress;
import com.maddyhome.idea.vim.ex.ranges.LineAddress;
import com.maddyhome.idea.vim.ex.ranges.MarkAddress;
import com.maddyhome.idea.vim.ex.ranges.SearchAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u0082\u0001\u0005\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Address;", "", "offset", "", "isMove", "", "<init>", "(IZ)V", "getOffset", "()I", "()Z", "getLine1", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "applyOffset", "line", "calculateLine1", "toString", "", "equals", "other", "hashCode", "Companion", "Lcom/maddyhome/idea/vim/ex/ranges/CurrentLineAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/LastLineAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/LineAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/MarkAddress;", "Lcom/maddyhome/idea/vim/ex/ranges/SearchAddress;", "vim-engine"})
public abstract sealed class Address
permits CurrentLineAddress, LastLineAddress, LineAddress, MarkAddress, SearchAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    private final boolean isMove;

    private Address(int offset, boolean isMove) {
        this.offset = offset;
        this.isMove = isMove;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean isMove() {
        return this.isMove;
    }

    public final int getLine1(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = this.calculateLine1(editor, caret);
        return this.applyOffset(line);
    }

    protected int applyOffset(int line) {
        return line != -1 ? line + this.offset : line;
    }

    protected abstract int calculateLine1(@NotNull VimEditor var1, @NotNull ImmutableVimCaret var2);

    @NotNull
    public String toString() {
        return "Range{offset=" + this.offset + ", move=" + this.isMove + "}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Address)) {
            return false;
        }
        if (this.offset != ((Address)other).offset) {
            return false;
        }
        return this.isMove == ((Address)other).isMove;
    }

    public int hashCode() {
        int result = this.offset;
        result = 31 * result + Boolean.hashCode(this.isMove);
        return result;
    }

    public /* synthetic */ Address(int offset, boolean isMove, DefaultConstructorMarker $constructor_marker) {
        this(offset, isMove);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/ex/ranges/Address$Companion;", "", "<init>", "()V", "createRangeAddresses", "", "Lcom/maddyhome/idea/vim/ex/ranges/Address;", "str", "", "offset", "", "move", "", "(Ljava/lang/String;IZ)[Lcom/maddyhome/idea/vim/ex/ranges/Address;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Address[] createRangeAddresses(@NotNull String str, int offset, boolean move) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (((CharSequence)str).length() == 0 || Intrinsics.areEqual((Object)str, (Object)".")) {
                Address[] addressArray = new Address[]{new CurrentLineAddress(offset, move)};
                return addressArray;
            }
            if (Intrinsics.areEqual((Object)str, (Object)"%")) {
                Address[] addressArray = new Address[]{new LineAddress(1, 0, move), new LastLineAddress(offset, move)};
                return addressArray;
            }
            if (Intrinsics.areEqual((Object)str, (Object)"$")) {
                Address[] addressArray = new Address[]{new LastLineAddress(offset, move)};
                return addressArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"'", (boolean)false, (int)2, null) && str.length() == 2) {
                Address[] addressArray = new Address[]{new MarkAddress(str.charAt(1), offset, move)};
                return addressArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\&", (boolean)false, (int)2, null)) {
                Address[] addressArray = new Address[]{new SearchAddress(str, offset, move)};
                return addressArray;
            }
            if (StringsKt.startsWith$default((String)str, (String)"?", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"\\?", (boolean)false, (int)2, null)) {
                Address[] addressArray = new Address[]{new SearchAddress(str, offset, move)};
                return addressArray;
            }
            try {
                int line1 = Integer.parseInt(str);
                Address[] addressArray = new Address[]{new LineAddress(line1, offset, move)};
                return addressArray;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

