/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimSimpleSelection;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/maddyhome/idea/vim/group/visual/VimCharacterSelection;", "Lcom/maddyhome/idea/vim/group/visual/VimSimpleSelection;", "vimStart", "", "vimEnd", "nativeStart", "nativeEnd", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "<init>", "(IIIILcom/maddyhome/idea/vim/api/VimEditor;)V", "getVimStart", "()I", "getVimEnd", "getNativeStart", "getNativeEnd", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "normNativeStart", "getNormNativeStart", "normNativeEnd", "getNormNativeEnd", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "toVimTextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "skipNewLineForLineMode", "", "vim-engine"})
public final class VimCharacterSelection
extends VimSimpleSelection {
    private final int vimStart;
    private final int vimEnd;
    private final int nativeStart;
    private final int nativeEnd;
    @NotNull
    private final VimEditor editor;
    private final int normNativeStart;
    private final int normNativeEnd;
    @NotNull
    private final SelectionType type;

    public VimCharacterSelection(int vimStart, int vimEnd, int nativeStart, int nativeEnd, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(null);
        this.vimStart = vimStart;
        this.vimEnd = vimEnd;
        this.nativeStart = nativeStart;
        this.nativeEnd = nativeEnd;
        this.editor = editor;
        this.normNativeStart = Math.min(this.getNativeStart(), this.getNativeEnd());
        this.normNativeEnd = Math.max(this.getNativeStart(), this.getNativeEnd());
        this.type = SelectionType.CHARACTER_WISE;
    }

    @Override
    public int getVimStart() {
        return this.vimStart;
    }

    @Override
    public int getVimEnd() {
        return this.vimEnd;
    }

    @Override
    public int getNativeStart() {
        return this.nativeStart;
    }

    @Override
    public int getNativeEnd() {
        return this.nativeEnd;
    }

    @Override
    @NotNull
    protected VimEditor getEditor() {
        return this.editor;
    }

    @Override
    public int getNormNativeStart() {
        return this.normNativeStart;
    }

    @Override
    public int getNormNativeEnd() {
        return this.normNativeEnd;
    }

    @Override
    @NotNull
    public SelectionType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public TextRange toVimTextRange(boolean skipNewLineForLineMode) {
        return new TextRange(this.getNormNativeStart(), this.getNormNativeEnd());
    }
}

