/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/handler/ExternalActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "ranges", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "<init>", "(Ljava/util/Map;)V", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "isLinewiseMotion", "", "()Z", "baseExecute", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "getRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "vim-engine"})
public final class ExternalActionHandler
extends EditorActionHandlerBase {
    @NotNull
    private final Map<ImmutableVimCaret, VimSelection> ranges;
    @NotNull
    private final Command.Type type;
    private final boolean isLinewiseMotion;

    public ExternalActionHandler(@NotNull Map<ImmutableVimCaret, ? extends VimSelection> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        super(true);
        this.ranges = ranges;
        this.type = Command.Type.MOTION;
    }

    @Override
    @NotNull
    public Command.Type getType() {
        return this.type;
    }

    public final boolean isLinewiseMotion() {
        return this.isLinewiseMotion;
    }

    @Override
    protected boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return true;
    }

    @Nullable
    public final TextRange getRange(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        VimSelection vimSelection = this.ranges.get(caret);
        return vimSelection != null ? VimSelection.toVimTextRange$default(vimSelection, false, 1, null) : null;
    }
}

