/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretListener;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimFoldRegion;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.undo.VimKeyBasedUndoService;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 /2\u00020\u0001:\u0005+,-./B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J4\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010#\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010&\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020'H\u0002J \u0010(\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020'H\u0002J(\u0010*\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u00030\"1\u00a8\u00062"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "<init>", "()V", "keepFold", "", "getKeepFold", "()Z", "motionType", "Lcom/maddyhome/idea/vim/command/MotionType;", "getMotionType", "()Lcom/maddyhome/idea/vim/command/MotionType;", "type", "Lcom/maddyhome/idea/vim/command/Command$Type;", "getType", "()Lcom/maddyhome/idea/vim/command/Command$Type;", "getHandlerOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "baseExecute", "Lcom/maddyhome/idea/vim/api/VimCaret;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "doExecuteForEach", "", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$ForEachCaret;", "moveToAdjustedOffset", "offset", "Lcom/maddyhome/idea/vim/handler/Motion$AdjustedOffset;", "moveToAbsoluteOffset", "Lcom/maddyhome/idea/vim/handler/Motion$AbsoluteOffset;", "prepareMoveToAbsoluteOffset", "", "postExecute", "ForEachCaret", "SingleExecution", "AmbiguousExecution", "CaretMergingWatcher", "Companion", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$AmbiguousExecution;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMotionActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotionActionHandler.kt\ncom/maddyhome/idea/vim/handler/MotionActionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,318:1\n39#2:319\n*S KotlinDebug\n*F\n+ 1 MotionActionHandler.kt\ncom/maddyhome/idea/vim/handler/MotionActionHandler\n*L\n315#1:319\n*E\n"})
public abstract sealed class MotionActionHandler
extends EditorActionHandlerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean keepFold;
    @NotNull
    private final Command.Type type = Command.Type.MOTION;
    @NotNull
    private static final VimLogger logger;

    private MotionActionHandler() {
        super(false);
    }

    public boolean getKeepFold() {
        return this.keepFold;
    }

    @NotNull
    public abstract MotionType getMotionType();

    @Override
    @NotNull
    public final Command.Type getType() {
        return this.type;
    }

    @NotNull
    public final Motion getHandlerOffset(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, @Nullable Argument argument, @NotNull OperatorArguments operatorArguments) {
        Motion motion;
        MotionActionHandler handler;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        MotionActionHandler motionActionHandler = handler = this instanceof AmbiguousExecution ? ((AmbiguousExecution)this).getMotionActionHandler(argument) : this;
        if (motionActionHandler instanceof SingleExecution) {
            motion = ((SingleExecution)handler).getOffset(editor, context, argument, operatorArguments);
        } else if (motionActionHandler instanceof ForEachCaret) {
            motion = ((ForEachCaret)handler).getOffset(editor, caret, context, argument, operatorArguments);
        } else {
            if (motionActionHandler instanceof AmbiguousExecution) {
                throw new RuntimeException("Ambiguous handler cannot hold another ambiguous handler");
            }
            throw new NoWhenBranchMatchedException();
        }
        return motion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        MotionActionHandler handler;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean blockSelectionActive = EditorExtensionsKt.getInBlockSelection(editor);
        MotionActionHandler motionActionHandler = handler = this instanceof AmbiguousExecution ? ((AmbiguousExecution)this).getMotionActionHandler(cmd.getArgument()) : this;
        if (motionActionHandler instanceof SingleExecution) {
            Motion offset;
            Object object;
            MotionActionHandler $this$baseExecute_u24lambda_u240 = this;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.INSERT.INSTANCE)) {
                VimUndoRedo undo = VimInjectorKt.getInjector().getUndo();
                object = undo;
                if (object instanceof VimKeyBasedUndoService) {
                    ((VimKeyBasedUndoService)undo).setMergeUndoKey();
                } else if (object instanceof VimTimestampBasedUndoService) {
                    long nanoTime = System.nanoTime();
                    editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> MotionActionHandler.baseExecute$lambda$0$0(undo, nanoTime, arg_0)));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((object = (offset = ((SingleExecution)handler).getOffset(editor, context, cmd.getArgument(), operatorArguments))) instanceof Motion.AdjustedOffset) {
                $this$baseExecute_u24lambda_u240.moveToAdjustedOffset(editor, caret, cmd, (Motion.AdjustedOffset)offset);
            } else if (object instanceof Motion.AbsoluteOffset) {
                $this$baseExecute_u24lambda_u240.moveToAbsoluteOffset(editor, caret, cmd, (Motion.AbsoluteOffset)offset);
            } else if (object instanceof Motion.Error) {
                VimInjectorKt.getInjector().getMessages().indicateError();
            } else if (!(object instanceof Motion.NoMotion)) {
                throw new NoWhenBranchMatchedException();
            }
        } else if (motionActionHandler instanceof ForEachCaret) {
            MotionActionHandler $this$baseExecute_u24lambda_u241 = this;
            boolean bl = false;
            if (blockSelectionActive || editor.carets().size() == 1) {
                VimCaret primaryCaret = editor.primaryCaret();
                $this$baseExecute_u24lambda_u241.doExecuteForEach((ForEachCaret)handler, editor, primaryCaret, context, cmd, operatorArguments);
            } else {
                try {
                    editor.addCaretListener(CaretMergingWatcher.INSTANCE);
                    editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> MotionActionHandler.baseExecute$lambda$1$0($this$baseExecute_u24lambda_u241, handler, editor, context, cmd, operatorArguments, arg_0)));
                }
                finally {
                    editor.removeCaretListener(CaretMergingWatcher.INSTANCE);
                }
            }
        } else {
            if (motionActionHandler instanceof AmbiguousExecution) {
                throw new RuntimeException("Ambiguous handler cannot hold another ambiguous handler");
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private final void doExecuteForEach(ForEachCaret $this$doExecuteForEach, VimEditor editor, VimCaret caret, ExecutionContext context, Command cmd, OperatorArguments operatorArguments) {
        Motion offset;
        Object object;
        if (Intrinsics.areEqual((Object)editor.getMode(), (Object)Mode.INSERT.INSTANCE)) {
            VimUndoRedo undo = VimInjectorKt.getInjector().getUndo();
            object = undo;
            if (object instanceof VimKeyBasedUndoService) {
                ((VimKeyBasedUndoService)undo).setMergeUndoKey();
            } else if (object instanceof VimTimestampBasedUndoService) {
                ((VimTimestampBasedUndoService)undo).endInsertSequence(caret, caret.getOffset(), System.nanoTime());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ((object = (offset = $this$doExecuteForEach.getOffset(editor, caret, context, cmd.getArgument(), operatorArguments))) instanceof Motion.AdjustedOffset) {
            this.moveToAdjustedOffset(editor, caret, cmd, (Motion.AdjustedOffset)offset);
        } else if (object instanceof Motion.AbsoluteOffset) {
            this.moveToAbsoluteOffset(editor, caret, cmd, (Motion.AbsoluteOffset)offset);
        } else if (object instanceof Motion.Error) {
            VimInjectorKt.getInjector().getMessages().indicateError();
        } else if (!(object instanceof Motion.NoMotion)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void moveToAdjustedOffset(VimEditor editor, VimCaret caret, Command cmd, Motion.AdjustedOffset offset) {
        int normalisedOffset;
        if (EditorExtensionsKt.getInBlockSelection(editor)) {
            StrictMode.INSTANCE.assertTrue(caret.isPrimary(), "Block selection mode must only operate on primary caret");
        }
        StrictMode.INSTANCE.assertTrue((normalisedOffset = this.prepareMoveToAbsoluteOffset(editor, cmd, offset)) == offset.getOffset(), "Adjusted offset should be normalised by action");
        caret.setVimLastColumn(offset.getIntendedColumn());
        VimCaret caretAfterMove = caret.moveToOffset(normalisedOffset);
        VimCaret validCaret = EditorExtensionsKt.getInBlockSelection(editor) ? editor.primaryCaret() : caretAfterMove;
        validCaret.setVimLastColumn(offset.getIntendedColumn());
    }

    private final void moveToAbsoluteOffset(VimEditor editor, VimCaret caret, Command cmd, Motion.AbsoluteOffset offset) {
        int normalisedOffset = this.prepareMoveToAbsoluteOffset(editor, cmd, offset);
        caret.moveToOffset(normalisedOffset);
    }

    private final int prepareMoveToAbsoluteOffset(VimEditor editor, Command cmd, Motion.AbsoluteOffset offset) {
        VimFoldRegion foldRegion;
        int resultOffset = offset.getOffset();
        if (resultOffset < 0) {
            logger.error("Offset is less than 0. " + resultOffset + ". " + this.getClass().getName());
        }
        if (cmd.getFlags().contains((Object)CommandFlags.FLAG_SAVE_JUMP)) {
            VimInjectorKt.getInjector().getJumpService().saveJumpLocation(editor);
        }
        if (!EngineHelperKt.isEndAllowed(editor)) {
            resultOffset = EngineEditorHelperKt.normalizeOffset(editor, resultOffset, false);
        }
        if ((foldRegion = editor.getCollapsedFoldRegionAtOffset(resultOffset)) != null && !foldRegion.isExpanded()) {
            if (this.getKeepFold()) {
                resultOffset = foldRegion.getStartOffset();
            } else {
                foldRegion.setExpanded(true);
            }
        }
        return resultOffset;
    }

    @Override
    protected void postExecute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Mode mode = editor.getMode();
        Mode.VISUAL vISUAL = mode instanceof Mode.VISUAL ? (Mode.VISUAL)mode : null;
        boolean bl = vISUAL != null ? vISUAL.isSelectPending() : false;
        if (bl) {
            VimInjectorKt.getInjector().getVisualMotionGroup().processSingleVisualCommand(editor);
        }
    }

    private static final Unit baseExecute$lambda$0$0(VimUndoRedo $undo, long $nanoTime, VimCaret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((VimTimestampBasedUndoService)$undo).endInsertSequence(it, it.getOffset(), $nanoTime);
        return Unit.INSTANCE;
    }

    private static final Unit baseExecute$lambda$1$0(MotionActionHandler $this_run, MotionActionHandler $handler, VimEditor $editor, ExecutionContext $context, Command $cmd, OperatorArguments $operatorArguments, VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        $this_run.doExecuteForEach((ForEachCaret)$handler, $editor, caret, $context, $cmd, $operatorArguments);
        return Unit.INSTANCE;
    }

    public /* synthetic */ MotionActionHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(MotionActionHandler.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$AmbiguousExecution;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "<init>", "()V", "getMotionActionHandler", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "process", "", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "postExecute", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract non-sealed class AmbiguousExecution
    extends MotionActionHandler {
        public AmbiguousExecution() {
            super(null);
        }

        @NotNull
        public abstract MotionActionHandler getMotionActionHandler(@Nullable Argument var1);

        @Override
        public final void process(@NotNull Command cmd) {
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            super.process(cmd);
        }

        @Override
        protected final void postExecute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            super.postExecute(editor, context, cmd, operatorArguments);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$CaretMergingWatcher;", "Lcom/maddyhome/idea/vim/api/VimCaretListener;", "<init>", "()V", "caretRemoved", "", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "vim-engine"})
    private static final class CaretMergingWatcher
    implements VimCaretListener {
        @NotNull
        public static final CaretMergingWatcher INSTANCE = new CaretMergingWatcher();

        private CaretMergingWatcher() {
        }

        @Override
        public void caretRemoved(@Nullable ImmutableVimCaret caret) {
            if (caret == null) {
                return;
            }
            VimEditor editor = caret.getEditor();
            ImmutableVimCaret caretToDelete = caret;
            if (EditorExtensionsKt.getInVisualMode(editor)) {
                for (VimCaret vimCaret : editor.carets()) {
                    boolean caretEndBetweenCur;
                    int curCaretStart = vimCaret.getSelectionStart();
                    int curCaretEnd = vimCaret.getSelectionEnd();
                    int n = caretToDelete.getSelectionStart();
                    boolean caretStartBetweenCur = curCaretStart <= n ? n < curCaretEnd : false;
                    int n2 = curCaretStart + 1;
                    int n3 = caretToDelete.getSelectionEnd();
                    boolean bl = n2 <= n3 ? n3 <= curCaretEnd : (caretEndBetweenCur = false);
                    if (!caretStartBetweenCur && !caretEndBetweenCur) continue;
                    int vimSelectionStart = caretToDelete.getVimSelectionStart();
                    vimCaret.setVimSelectionStart(vimSelectionStart);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "<init>", "()V", "getOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract non-sealed class ForEachCaret
    extends MotionActionHandler {
        public ForEachCaret() {
            super(null);
        }

        @NotNull
        public abstract Motion getOffset(@NotNull VimEditor var1, @NotNull ImmutableVimCaret var2, @NotNull ExecutionContext var3, @Nullable Argument var4, @NotNull OperatorArguments var5);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/handler/MotionActionHandler$SingleExecution;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler;", "<init>", "()V", "getOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract non-sealed class SingleExecution
    extends MotionActionHandler {
        public SingleExecution() {
            super(null);
        }

        @NotNull
        public abstract Motion getOffset(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @Nullable Argument var3, @NotNull OperatorArguments var4);
    }
}

