/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.options.helpers.KeywordOptionHelper;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/helper/CharacterHelper;", "", "<init>", "()V", "charType", "Lcom/maddyhome/idea/vim/helper/CharacterHelper$CharacterType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "ch", "", "punctuationAsLetters", "", "isWhitespace", "isBig", "isInvisibleControlCharacter", "codepoint", "", "isZeroWidthCharacter", "isHalfWidthKatakanaLetter", "CharacterType", "vim-engine"})
public final class CharacterHelper {
    @NotNull
    public static final CharacterHelper INSTANCE = new CharacterHelper();

    private CharacterHelper() {
    }

    @JvmStatic
    @NotNull
    public static final CharacterType charType(@NotNull VimEditor editor, char ch, boolean punctuationAsLetters) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Character.UnicodeBlock block = Character.UnicodeBlock.of(ch);
        return Character.isWhitespace(ch) ? CharacterType.WHITESPACE : (block == Character.UnicodeBlock.HIRAGANA ? CharacterType.HIRAGANA : (block == Character.UnicodeBlock.KATAKANA ? CharacterType.KATAKANA : (INSTANCE.isHalfWidthKatakanaLetter(ch) ? CharacterType.HALF_WIDTH_KATAKANA : (Intrinsics.areEqual((Object)block, (Object)Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) ? CharacterType.CJK_UNIFIED_IDEOGRAPHS : (punctuationAsLetters || KeywordOptionHelper.INSTANCE.isKeyword(editor, ch) ? CharacterType.KEYWORD : CharacterType.PUNCTUATION)))));
    }

    public final boolean isWhitespace(@NotNull VimEditor editor, char ch, boolean isBig) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return CharacterHelper.charType(editor, ch, isBig) == CharacterType.WHITESPACE;
    }

    public final boolean isInvisibleControlCharacter(int codepoint) {
        byte type = (byte)Character.getType(codepoint);
        return type == 15 || type == 16 || type == 18 || type == 19 || type == 0;
    }

    public final boolean isZeroWidthCharacter(int codepoint) {
        return codepoint == 65279 || codepoint == 8203 || codepoint == 8204 || codepoint == 8205;
    }

    private final boolean isHalfWidthKatakanaLetter(char ch) {
        return '\uff66' <= ch ? ch < '\uffa0' : false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/helper/CharacterHelper$CharacterType;", "", "<init>", "(Ljava/lang/String;I)V", "KEYWORD", "HIRAGANA", "KATAKANA", "HALF_WIDTH_KATAKANA", "CJK_UNIFIED_IDEOGRAPHS", "PUNCTUATION", "WHITESPACE", "vim-engine"})
    public static final class CharacterType
    extends Enum<CharacterType> {
        public static final /* enum */ CharacterType KEYWORD = new CharacterType();
        public static final /* enum */ CharacterType HIRAGANA = new CharacterType();
        public static final /* enum */ CharacterType KATAKANA = new CharacterType();
        public static final /* enum */ CharacterType HALF_WIDTH_KATAKANA = new CharacterType();
        public static final /* enum */ CharacterType CJK_UNIFIED_IDEOGRAPHS = new CharacterType();
        public static final /* enum */ CharacterType PUNCTUATION = new CharacterType();
        public static final /* enum */ CharacterType WHITESPACE = new CharacterType();
        private static final /* synthetic */ CharacterType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CharacterType[] values() {
            return (CharacterType[])$VALUES.clone();
        }

        public static CharacterType valueOf(String value) {
            return Enum.valueOf(CharacterType.class, value);
        }

        @NotNull
        public static EnumEntries<CharacterType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = characterTypeArray = new CharacterType[]{CharacterType.KEYWORD, CharacterType.HIRAGANA, CharacterType.KATAKANA, CharacterType.HALF_WIDTH_KATAKANA, CharacterType.CJK_UNIFIED_IDEOGRAPHS, CharacterType.PUNCTUATION, CharacterType.WHITESPACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

