/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.action.change.Extension;
import com.maddyhome.idea.vim.action.change.VimRepeater;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.handler.ExternalActionHandler;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/maddyhome/idea/vim/key/ToHandlerMappingInfo;", "Lcom/maddyhome/idea/vim/key/MappingInfo;", "extensionHandler", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "fromKeys", "", "Ljavax/swing/KeyStroke;", "isRecursive", "", "owner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "originalModes", "", "Lcom/maddyhome/idea/vim/command/MappingMode;", "<init>", "(Lcom/maddyhome/idea/vim/extension/ExtensionHandler;Ljava/util/List;ZLcom/maddyhome/idea/vim/key/MappingOwner;Ljava/util/Set;)V", "getPresentableString", "", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMappingInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToHandlerMappingInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,281:1\n1285#2,2:282\n1299#2,4:284\n39#3:288\n*S KotlinDebug\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToHandlerMappingInfo\n*L\n172#1:282,2\n172#1:284,4\n222#1:288\n*E\n"})
public final class ToHandlerMappingInfo
extends MappingInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionHandler extensionHandler;
    @NotNull
    private static final VimLogger LOG;

    public ToHandlerMappingInfo(@NotNull ExtensionHandler extensionHandler2, @NotNull List<? extends KeyStroke> fromKeys, boolean isRecursive, @NotNull MappingOwner owner, @NotNull Set<? extends MappingMode> originalModes) {
        Intrinsics.checkNotNullParameter((Object)extensionHandler2, (String)"extensionHandler");
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(originalModes, (String)"originalModes");
        super(fromKeys, isRecursive, owner, originalModes, null);
        this.extensionHandler = extensionHandler2;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return "call " + this.extensionHandler.getClass().getCanonicalName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull KeyHandlerState keyState) {
        ExtensionHandler handler;
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        LOG.debug("Executing 'ToHandler' mapping info...");
        boolean shouldCalculateOffsets = editor.getMode() instanceof Mode.OP_PENDING;
        Iterable $this$associateWith$iv = editor.carets();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ImmutableVimCaret immutableVimCaret = (ImmutableVimCaret)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getOffset();
            map.put(t, n);
        }
        Map startOffsets = destination$iv$iv;
        if (this.extensionHandler.isRepeatable()) {
            Extension.INSTANCE.clean();
        }
        if ((handler = this.extensionHandler) instanceof ExtensionHandler.WithCallback) {
            ((ExtensionHandler.WithCallback)handler).set_backingFunction(() -> ToHandlerMappingInfo.execute$lambda$1(shouldCalculateOffsets, editor, startOffsets, keyState, context));
        }
        OperatorArguments operatorArguments = new OperatorArguments(keyState.getCommandBuilder().calculateCount0Snapshot(), editor.getMode());
        Character register = keyState.getCommandBuilder().getRegisterSnapshot();
        if (register != null) {
            VimInjectorKt.getInjector().getRegisterGroup().selectRegister(register.charValue());
        }
        VimInjectorKt.getInjector().getActionExecutor().executeCommand(editor, () -> ToHandlerMappingInfo.execute$lambda$2(this, editor, context, operatorArguments), "Vim " + this.extensionHandler.getClass().getSimpleName(), null);
        if (this.extensionHandler.isRepeatable()) {
            Extension.INSTANCE.setLastExtensionHandler(this.extensionHandler);
            ArgumentCapturerKt.setArgumentCaptured(null);
            VimRepeater.INSTANCE.setRepeatHandler(true);
        }
        if (!(handler instanceof ExtensionHandler.WithCallback)) {
            ToHandlerMappingInfo.Companion.myFun(shouldCalculateOffsets, editor, startOffsets, keyState);
        }
    }

    private static final void execute$lambda$1(boolean $shouldCalculateOffsets, VimEditor $editor, Map $startOffsets, KeyHandlerState $keyState, ExecutionContext $context) {
        ToHandlerMappingInfo.Companion.myFun($shouldCalculateOffsets, $editor, $startOffsets, $keyState);
        if ($shouldCalculateOffsets) {
            VimInjectorKt.getInjector().getApplication().invokeLater((Function0<Unit>)((Function0)() -> ToHandlerMappingInfo.execute$lambda$1$0($editor, $context, $keyState)));
        }
    }

    private static final Unit execute$lambda$1$0(VimEditor $editor, ExecutionContext $context, KeyHandlerState $keyState) {
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        keyHandler.finishedCommandPreparation$vim_engine($editor, $context, null, false, $keyState);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$2(ToHandlerMappingInfo this$0, VimEditor $editor, ExecutionContext $context, OperatorArguments $operatorArguments) {
        this$0.extensionHandler.execute($editor, $context, $operatorArguments);
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(ToHandlerMappingInfo.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/key/ToHandlerMappingInfo$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "myFun", "", "shouldCalculateOffsets", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startOffsets", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        private final void myFun(boolean shouldCalculateOffsets, VimEditor editor, Map<ImmutableVimCaret, Integer> startOffsets, KeyHandlerState keyState) {
            if (shouldCalculateOffsets && !keyState.getCommandBuilder().hasCurrentCommandPartArgument()) {
                Map offsets = new HashMap();
                for (VimCaret caret : editor.carets()) {
                    Integer startOffset = startOffsets.get(caret);
                    if (caret.hasSelection()) {
                        int n = caret.getVimSelectionStart();
                        int n2 = caret.getOffset();
                        SelectionType selectionType = ModeExtensionsKt.getSelectionType(editor.getMode());
                        if (selectionType == null) {
                            selectionType = SelectionType.CHARACTER_WISE;
                        }
                        VimSelection vimSelection = VimSelection.Companion.create(n, n2, selectionType, editor);
                        offsets.put(caret, vimSelection);
                        editor.setMode(new Mode.NORMAL(null, 1, null));
                        continue;
                    }
                    if (startOffset == null) continue;
                    int vimSelection = caret.getOffset();
                    if (startOffset == vimSelection) continue;
                    int endOffset = caret.getOffset();
                    if (startOffset < endOffset) {
                        --endOffset;
                    } else {
                        startOffset = startOffset - 1;
                    }
                    VimSelection vimSelection2 = VimSelection.Companion.create(startOffset, endOffset, SelectionType.CHARACTER_WISE, editor);
                    offsets.put(caret, vimSelection2);
                    editor.currentCaret().moveToOffset(startOffset);
                }
                if (!offsets.isEmpty()) {
                    keyState.getCommandBuilder().addAction(new ExternalActionHandler(offsets));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

