/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.thinapi;

import com.intellij.vim.api.scopes.OptionScope;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOptionGroup;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/thinapi/OptionScopeImpl;", "Lcom/intellij/vim/api/scopes/OptionScope;", "<init>", "()V", "vimEditor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getVimEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "optionGroup", "Lcom/maddyhome/idea/vim/api/VimOptionGroup;", "getOptionGroup", "()Lcom/maddyhome/idea/vim/api/VimOptionGroup;", "getOptionValue", "T", "name", "", "type", "Lkotlin/reflect/KType;", "(Ljava/lang/String;Lkotlin/reflect/KType;)Ljava/lang/Object;", "setOption", "", "value", "scope", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/reflect/KType;Ljava/lang/String;)V", "reset", "vim-engine"})
public final class OptionScopeImpl
implements OptionScope {
    @NotNull
    public static final OptionScopeImpl INSTANCE = new OptionScopeImpl();

    private OptionScopeImpl() {
    }

    private final VimEditor getVimEditor() {
        VimEditor vimEditor = VimInjectorKt.getInjector().getEditorGroup().getFocusedEditor();
        Intrinsics.checkNotNull((Object)vimEditor);
        return vimEditor;
    }

    private final VimOptionGroup getOptionGroup() {
        return VimInjectorKt.getInjector().getOptionGroup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getOptionValue(@NotNull String name, @NotNull KType type) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Option<VimDataType> option = this.getOptionGroup().getOption(name);
        if (option == null) {
            throw new IllegalArgumentException("Option " + name + " not found");
        }
        Option<VimDataType> option2 = option;
        VimDataType optionValue = this.getOptionGroup().getOptionValue(option2, new OptionAccessScope.EFFECTIVE(this.getVimEditor()));
        KClassifier kClassifier = type.getClassifier();
        if (kClassifier == null) {
            throw new IllegalArgumentException("Option type is undefined");
        }
        KClassifier kotlinType = kClassifier;
        VimDataType vimDataType = optionValue;
        if (vimDataType instanceof VimInt) {
            int intValue = ((VimInt)optionValue).getValue();
            KClassifier kClassifier2 = kotlinType;
            if (Intrinsics.areEqual((Object)kClassifier2, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                object = intValue;
            } else {
                if (!Intrinsics.areEqual((Object)kClassifier2, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) throw new IllegalArgumentException("Wrong option type. Expected boolean or integer, got " + kotlinType + ". Option name: " + name + ", value: " + intValue + ".");
                object = intValue == VimInt.Companion.getONE().getValue();
            }
        } else {
            if (!(vimDataType instanceof VimString)) throw new IllegalArgumentException("Options can only be of types string, integer and boolean.");
            String stringValue = ((VimString)optionValue).getValue();
            if (!Intrinsics.areEqual((Object)kotlinType, (Object)Reflection.getOrCreateKotlinClass(String.class))) throw new IllegalArgumentException("Wrong option type. Expected string, got " + kotlinType + ". Option name: " + name + ", value: " + stringValue);
            object = ((VimString)optionValue).getValue();
        }
        Integer kotlinValue = object;
        return (T)kotlinValue;
    }

    public <T> void setOption(@NotNull String name, T value, @NotNull KType type, @NotNull String scope) {
        VimDataType vimDataType;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Option<VimDataType> option = this.getOptionGroup().getOption(name);
        if (option == null) {
            throw new IllegalArgumentException("Option " + name + " not found");
        }
        Option<VimDataType> option2 = option;
        KClassifier kClassifier = type.getClassifier();
        if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Int");
            vimDataType = new VimInt((Integer)value);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
            vimDataType = new VimString((String)value);
        } else if (Intrinsics.areEqual((Object)kClassifier, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            vimDataType = (Boolean)value != false ? VimInt.Companion.getONE() : VimInt.Companion.getZERO();
        } else {
            throw new IllegalArgumentException("Options can only be of types string, integer and boolean");
        }
        VimDataType optionValue = vimDataType;
        OptionAccessScope optionAccessScope = switch (scope) {
            case "global" -> new OptionAccessScope.GLOBAL(this.getVimEditor());
            case "local" -> new OptionAccessScope.LOCAL(this.getVimEditor());
            case "effective" -> new OptionAccessScope.EFFECTIVE(this.getVimEditor());
            default -> new OptionAccessScope.EFFECTIVE(this.getVimEditor());
        };
        try {
            this.getOptionGroup().setOptionValue(option2, optionAccessScope, optionValue);
        }
        catch (ExException e) {
            throw new IllegalArgumentException("Failed to set option " + name + " to " + value + ". " + e.getMessage());
        }
    }

    public void reset(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Option<VimDataType> option = this.getOptionGroup().getOption(name);
        if (option == null) {
            throw new IllegalArgumentException("Option " + name + " not found");
        }
        Option<VimDataType> option2 = option;
        this.getOptionGroup().resetToDefaultValue(option2, new OptionAccessScope.EFFECTIVE(this.getVimEditor()));
    }
}

