/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.thinapi;

import com.intellij.vim.api.VimApi;
import com.intellij.vim.api.scopes.TextObjectRange;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ListenerOwner;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.thinapi.ApiTextObjectActionHandler;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012.\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\t\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/thinapi/TextObjectExtensionHandler;", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "listenerOwner", "Lcom/maddyhome/idea/vim/common/ListenerOwner;", "mappingOwner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "preserveSelectionAnchor", "", "rangeProvider", "Lkotlin/Function2;", "Lcom/intellij/vim/api/VimApi;", "", "Lkotlin/ParameterName;", "name", "count", "Lcom/intellij/vim/api/scopes/TextObjectRange;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lcom/maddyhome/idea/vim/common/ListenerOwner;Lcom/maddyhome/idea/vim/key/MappingOwner;ZLkotlin/jvm/functions/Function2;)V", "isRepeatable", "()Z", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
final class TextObjectExtensionHandler
implements ExtensionHandler {
    @NotNull
    private final ListenerOwner listenerOwner;
    @NotNull
    private final MappingOwner mappingOwner;
    private final boolean preserveSelectionAnchor;
    @NotNull
    private final Function2<VimApi, Integer, TextObjectRange> rangeProvider;
    private final boolean isRepeatable;

    public TextObjectExtensionHandler(@NotNull ListenerOwner listenerOwner, @NotNull MappingOwner mappingOwner, boolean preserveSelectionAnchor, @NotNull Function2<? super VimApi, ? super Integer, ? extends TextObjectRange> rangeProvider) {
        Intrinsics.checkNotNullParameter((Object)listenerOwner, (String)"listenerOwner");
        Intrinsics.checkNotNullParameter((Object)mappingOwner, (String)"mappingOwner");
        Intrinsics.checkNotNullParameter(rangeProvider, (String)"rangeProvider");
        this.listenerOwner = listenerOwner;
        this.mappingOwner = mappingOwner;
        this.preserveSelectionAnchor = preserveSelectionAnchor;
        this.rangeProvider = rangeProvider;
    }

    @Override
    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    @Override
    public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        KeyHandlerState keyHandlerState = KeyHandler.Companion.getInstance().getKeyHandlerState();
        int count = operatorArguments.getCount1();
        ApiTextObjectActionHandler textObjectHandler = new ApiTextObjectActionHandler(this.listenerOwner, this.mappingOwner, this.preserveSelectionAnchor, this.rangeProvider);
        if (!(editor.getMode() instanceof Mode.OP_PENDING)) {
            for (VimCaret caret : editor.carets()) {
                TextRange range = textObjectHandler.getRange(editor, caret, context, count, operatorArguments.getCount0());
                if (range == null) continue;
                if (editor.getMode() instanceof Mode.VISUAL) {
                    EngineVisualGroupKt.vimSetSelection(caret, range.getStartOffset(), range.getEndOffset() - 1, true);
                    continue;
                }
                caret.moveToOffset(range.getStartOffset());
            }
        } else {
            keyHandlerState.getCommandBuilder().addAction(textObjectHandler);
        }
    }
}

