/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.LValueExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SublistExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.AssignmentOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0012J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J0\u0010,\u001a\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J(\u0010/\u001a\u0002002\u0006\u0010\u0004\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J.\u00104\u001a\u0010\u0012\u0004\u0012\u000206\u0012\u0006\u0012\u0004\u0018\u000107052\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020\rH\u0002J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\nH\u00c6\u0003J\t\u0010@\u001a\u00020\u0005H\u00c6\u0003J\t\u0010A\u001a\u00020\rH\u00c6\u0003J\t\u0010B\u001a\u00020\u000fH\u00c6\u0003Je\u0010C\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010D\u001a\u00020\r2\b\u0010E\u001a\u0004\u0018\u00010FH\u00d6\u0003J\t\u0010G\u001a\u00020HH\u00d6\u0001J\t\u0010I\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006J"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/LetCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "lvalue", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "unpackLValues", "", "unpackRest", "operator", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;", "expression", "isSyntaxSupported", "", "assignmentTextForErrors", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Ljava/util/List;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;ZLjava/lang/String;)V", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;ZLjava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getLvalue", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getUnpackLValues", "()Ljava/util/List;", "getUnpackRest", "getOperator", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/operators/AssignmentOperator;", "getExpression", "()Z", "getAssignmentTextForErrors", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "unpack", "lvalues", "rest", "assign", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult$Success;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/LValueExpression;", "rvalue", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "getNewSublistValue", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimList;", "Lcom/maddyhome/idea/vim/ex/ExException;", "sublist", "rhs", "isLValueStronglyTyped", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nLetCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LetCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/LetCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class LetCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @Nullable
    private final Expression lvalue;
    @Nullable
    private final List<Expression> unpackLValues;
    @Nullable
    private final Expression unpackRest;
    @NotNull
    private final AssignmentOperator operator;
    @NotNull
    private final Expression expression;
    private final boolean isSyntaxSupported;
    @NotNull
    private final String assignmentTextForErrors;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public LetCommand(@NotNull Range range, @Nullable Expression lvalue, @Nullable List<? extends Expression> unpackLValues, @Nullable Expression unpackRest, @NotNull AssignmentOperator operator, @NotNull Expression expression, boolean isSyntaxSupported, @NotNull String assignmentTextForErrors) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        super(range, CommandModifier.NONE, null, 4, null);
        this.range = range;
        this.lvalue = lvalue;
        this.unpackLValues = unpackLValues;
        this.unpackRest = unpackRest;
        this.operator = operator;
        this.expression = expression;
        this.isSyntaxSupported = isSyntaxSupported;
        this.assignmentTextForErrors = assignmentTextForErrors;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @Nullable
    public final Expression getLvalue() {
        return this.lvalue;
    }

    @Nullable
    public final List<Expression> getUnpackLValues() {
        return this.unpackLValues;
    }

    @Nullable
    public final Expression getUnpackRest() {
        return this.unpackRest;
    }

    @NotNull
    public final AssignmentOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    public final boolean isSyntaxSupported() {
        return this.isSyntaxSupported;
    }

    @NotNull
    public final String getAssignmentTextForErrors() {
        return this.assignmentTextForErrors;
    }

    public LetCommand(@NotNull Range range, @NotNull Expression lvalue, @NotNull AssignmentOperator operator, @NotNull Expression expression, boolean isSyntaxSupported, @NotNull String assignmentTextForErrors) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)lvalue, (String)"lvalue");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        this(range, lvalue, null, null, operator, expression, isSyntaxSupported, assignmentTextForErrors);
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        ExecutionResult executionResult;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (!this.isSyntaxSupported) {
            return ExecutionResult.Error.INSTANCE;
        }
        if (this.unpackLValues != null) {
            executionResult = this.unpack(this.unpackLValues, this.unpackRest, editor, context);
        } else if (this.lvalue instanceof LValueExpression) {
            executionResult = this.assign((LValueExpression)this.lvalue, this.expression.evaluate(editor, context, this.getVimContext()), editor, context);
        } else {
            Object[] objectArray = new Object[1];
            Object object = this.lvalue;
            if (object == null || (object = ((Expression)object).getOriginalString()) == null) {
                object = this.assignmentTextForErrors;
            }
            objectArray[0] = object;
            throw ExExceptionsKt.exExceptionMessage("E121", objectArray);
        }
        return executionResult;
    }

    private final ExecutionResult unpack(List<? extends Expression> lvalues, Expression rest, VimEditor editor, ExecutionContext context) {
        VimDataType rvalue = this.expression.evaluate(editor, context, this);
        if (!(rvalue instanceof VimList)) {
            throw ExExceptionsKt.exExceptionMessage("E714", new Object[0]);
        }
        if (rest != null && !(rest instanceof LValueExpression)) {
            Object[] objectArray = new Object[]{rest.getOriginalString()};
            throw ExExceptionsKt.exExceptionMessage("E475", objectArray);
        }
        if (rest == null && ((VimList)rvalue).getValues().size() > lvalues.size()) {
            throw ExExceptionsKt.exExceptionMessage("E687", new Object[0]);
        }
        if (((VimList)rvalue).getValues().size() < lvalues.size()) {
            throw ExExceptionsKt.exExceptionMessage("E688", new Object[0]);
        }
        for (Expression expression : lvalues) {
            if (expression instanceof LValueExpression) continue;
            Object[] objectArray = new Object[]{expression.getOriginalString()};
            throw ExExceptionsKt.exExceptionMessage("E475", objectArray);
        }
        int n = ((Collection)lvalues).size();
        for (int i = 0; i < n; ++i) {
            LValueExpression itemLValue;
            Expression expression = lvalues.get(i);
            if ((expression instanceof LValueExpression ? (LValueExpression)expression : null) == null) continue;
            itemLValue = itemLValue;
            this.assign(itemLValue, ((VimList)rvalue).getValues().get(i), editor, context);
        }
        if (rest != null) {
            VimList restValue = ((VimList)rvalue).getValues().size() > lvalues.size() ? new VimList(CollectionsKt.toMutableList((Collection)((VimList)rvalue).getValues().subList(lvalues.size(), ((VimList)rvalue).getValues().size()))) : new VimList(new ArrayList());
            this.assign((LValueExpression)rest, restValue, editor, context);
        }
        return ExecutionResult.Success.INSTANCE;
    }

    private final ExecutionResult.Success assign(LValueExpression lvalue, VimDataType rvalue, VimEditor editor, ExecutionContext context) {
        VimDataType currentValue;
        VimDataType vimDataType = currentValue = this.operator != AssignmentOperator.ASSIGNMENT ? lvalue.evaluate(editor, context, this.getVimContext()) : null;
        if (lvalue instanceof SublistExpression && this.operator != AssignmentOperator.ASSIGNMENT && currentValue instanceof VimList && rvalue instanceof VimList) {
            Pair<VimList, ExException> result = this.getNewSublistValue((VimList)currentValue, (VimList)rvalue, ((SublistExpression)lvalue).isStronglyTyped());
            ((SublistExpression)lvalue).assign((VimDataType)result.getFirst(), editor, context, this, this.assignmentTextForErrors);
            ExException exException = (ExException)result.getSecond();
            if (exException != null) {
                ExException it = exException;
                boolean bl = false;
                throw it;
            }
        } else {
            VimDataType newValue = this.operator.getNewValue(currentValue, rvalue, lvalue.isStronglyTyped());
            lvalue.assign(newValue, editor, context, this, this.assignmentTextForErrors);
        }
        return ExecutionResult.Success.INSTANCE;
    }

    private final Pair<VimList, ExException> getNewSublistValue(VimList sublist, VimList rhs, boolean isLValueStronglyTyped) {
        ExException error = null;
        int n = sublist.getValues().size();
        for (int i = 0; i < n; ++i) {
            if (i >= rhs.getValues().size()) {
                error = ExExceptionsKt.exExceptionMessage("E711", new Object[0]);
                break;
            }
            sublist.getValues().set(i, this.operator.getNewValue(sublist.getValues().get(i), rhs.getValues().get(i), isLValueStronglyTyped));
        }
        if (rhs.getValues().size() > sublist.getValues().size()) {
            error = ExExceptionsKt.exExceptionMessage("E710", new Object[0]);
        }
        return new Pair((Object)sublist, (Object)error);
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @Nullable
    public final Expression component2() {
        return this.lvalue;
    }

    @Nullable
    public final List<Expression> component3() {
        return this.unpackLValues;
    }

    @Nullable
    public final Expression component4() {
        return this.unpackRest;
    }

    @NotNull
    public final AssignmentOperator component5() {
        return this.operator;
    }

    @NotNull
    public final Expression component6() {
        return this.expression;
    }

    public final boolean component7() {
        return this.isSyntaxSupported;
    }

    @NotNull
    public final String component8() {
        return this.assignmentTextForErrors;
    }

    @NotNull
    public final LetCommand copy(@NotNull Range range, @Nullable Expression lvalue, @Nullable List<? extends Expression> unpackLValues, @Nullable Expression unpackRest, @NotNull AssignmentOperator operator, @NotNull Expression expression, boolean isSyntaxSupported, @NotNull String assignmentTextForErrors) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        return new LetCommand(range, lvalue, unpackLValues, unpackRest, operator, expression, isSyntaxSupported, assignmentTextForErrors);
    }

    public static /* synthetic */ LetCommand copy$default(LetCommand letCommand, Range range, Expression expression, List list, Expression expression2, AssignmentOperator assignmentOperator, Expression expression3, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = letCommand.range;
        }
        if ((n & 2) != 0) {
            expression = letCommand.lvalue;
        }
        if ((n & 4) != 0) {
            list = letCommand.unpackLValues;
        }
        if ((n & 8) != 0) {
            expression2 = letCommand.unpackRest;
        }
        if ((n & 0x10) != 0) {
            assignmentOperator = letCommand.operator;
        }
        if ((n & 0x20) != 0) {
            expression3 = letCommand.expression;
        }
        if ((n & 0x40) != 0) {
            bl = letCommand.isSyntaxSupported;
        }
        if ((n & 0x80) != 0) {
            string = letCommand.assignmentTextForErrors;
        }
        return letCommand.copy(range, expression, list, expression2, assignmentOperator, expression3, bl, string);
    }

    @NotNull
    public String toString() {
        return "LetCommand(range=" + this.range + ", lvalue=" + this.lvalue + ", unpackLValues=" + this.unpackLValues + ", unpackRest=" + this.unpackRest + ", operator=" + this.operator + ", expression=" + this.expression + ", isSyntaxSupported=" + this.isSyntaxSupported + ", assignmentTextForErrors=" + this.assignmentTextForErrors + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + (this.lvalue == null ? 0 : this.lvalue.hashCode());
        result = result * 31 + (this.unpackLValues == null ? 0 : ((Object)this.unpackLValues).hashCode());
        result = result * 31 + (this.unpackRest == null ? 0 : this.unpackRest.hashCode());
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.expression.hashCode();
        result = result * 31 + Boolean.hashCode(this.isSyntaxSupported);
        result = result * 31 + this.assignmentTextForErrors.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LetCommand)) {
            return false;
        }
        LetCommand letCommand = (LetCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)letCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lvalue, (Object)letCommand.lvalue)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unpackLValues, letCommand.unpackLValues)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.unpackRest, (Object)letCommand.unpackRest)) {
            return false;
        }
        if (this.operator != letCommand.operator) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expression, (Object)letCommand.expression)) {
            return false;
        }
        if (this.isSyntaxSupported != letCommand.isSyntaxSupported) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.assignmentTextForErrors, (Object)letCommand.assignmentTextForErrors);
    }
}

