/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/SubstituteCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "command", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "getCommand", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class SubstituteCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final String command;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public SubstituteCommand(@NotNull Range range, @NotNull String argument, @NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        super(range, CommandModifier.NONE, argument);
        this.range = range;
        this.argument = argument;
        this.command = command2;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean result = true;
        for (VimCaret caret : editor.nativeCarets()) {
            LineRange lineRange = this.getLineRange(editor, caret);
            if (VimInjectorKt.getInjector().getSearchGroup().processSubstituteCommand(editor, caret, context, lineRange, this.command, this.argument, this.getVimContext())) continue;
            result = false;
        }
        return result ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final String component3() {
        return this.command;
    }

    @NotNull
    public final SubstituteCommand copy(@NotNull Range range, @NotNull String argument, @NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        return new SubstituteCommand(range, argument, command2);
    }

    public static /* synthetic */ SubstituteCommand copy$default(SubstituteCommand substituteCommand, Range range, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            range = substituteCommand.range;
        }
        if ((n & 2) != 0) {
            string = substituteCommand.argument;
        }
        if ((n & 4) != 0) {
            string2 = substituteCommand.command;
        }
        return substituteCommand.copy(range, string, string2);
    }

    @NotNull
    public String toString() {
        return "SubstituteCommand(range=" + this.range + ", argument=" + this.argument + ", command=" + this.command + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        result = result * 31 + this.command.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubstituteCommand)) {
            return false;
        }
        SubstituteCommand substituteCommand = (SubstituteCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)substituteCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.argument, (Object)substituteCommand.argument)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.command, (Object)substituteCommand.command);
    }
}

