/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.FinishException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandlerBase;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J2\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J(\u0010\u001e\u001a\u0004\u0018\u00010\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001dH\u0002J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "function", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;)V", "getFunction", "()Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "handlesRange", "", "getHandlesRange", "()Z", "doFunction", "arguments", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "executeFunctionBody", "exceptionsCaught", "", "Lcom/maddyhome/idea/vim/ex/ExException;", "initializeFunctionVariables", "", "functionCallContext", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDefinedFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinedFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,163:1\n39#2:164\n*S KotlinDebug\n*F\n+ 1 DefinedFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler\n*L\n31#1:164\n*E\n"})
public final class DefinedFunctionHandler
extends FunctionHandlerBase<VimDataType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FunctionDeclaration function;
    @NotNull
    private final VimLogger logger;
    @Nullable
    private final Scope scope;

    public DefinedFunctionHandler(@NotNull FunctionDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super(function.getArgs().size(), Companion.getMaxArity(function));
        this.function = function;
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(DefinedFunctionHandler.class);
        this.scope = this.function.getScope();
        this.setName(this.function.getName());
    }

    @NotNull
    public final FunctionDeclaration getFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Override
    protected boolean getHandlesRange() {
        return this.function.getFlags().contains((Object)FunctionFlag.RANGE);
    }

    @Override
    @NotNull
    protected VimDataType doFunction(@NotNull FunctionHandlerBase.Arguments arguments, @Nullable LineRange range, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType vimDataType;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        List exceptionsCaught = new ArrayList();
        LineRange lineRange = range;
        boolean isRangeGiven = (lineRange != null ? lineRange.getSize() : 0) > 0;
        LineRange lineRange2 = range == null || !isRangeGiven ? new LineRange(editor.currentCaret().getLine(), editor.currentCaret().getLine()) : range;
        this.initializeFunctionVariables(arguments, lineRange2, editor, context, vimContext);
        VimDataType returnValue = this.executeFunctionBody(exceptionsCaught, editor, context);
        if (!((Collection)exceptionsCaught).isEmpty()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, ((ExException)CollectionsKt.last((List)exceptionsCaught)).getMessage());
        }
        if ((vimDataType = returnValue) == null) {
            vimDataType = VimInt.Companion.getZERO();
        }
        return vimDataType;
    }

    private final VimDataType executeFunctionBody(List<ExException> exceptionsCaught, VimEditor editor, ExecutionContext context) {
        VimDataType returnValue = null;
        ExecutionResult result = ExecutionResult.Success.INSTANCE;
        if (this.function.getFlags().contains((Object)FunctionFlag.ABORT)) {
            for (Executable statement : this.function.getBody()) {
                statement.setVimContext(this.function);
                if (!(result instanceof ExecutionResult.Success)) continue;
                result = statement.execute(editor, context);
            }
            ExecutionResult executionResult = result;
            if (executionResult instanceof ExecutionResult.Break) {
                exceptionsCaught.add(ExExceptionsKt.exExceptionMessage("E587", new Object[0]));
            } else if (executionResult instanceof ExecutionResult.Continue) {
                exceptionsCaught.add(ExExceptionsKt.exExceptionMessage("E586", new Object[0]));
            } else if (executionResult instanceof ExecutionResult.Error) {
                exceptionsCaught.add(new ExException("unknown error occurred"));
            } else if (executionResult instanceof ExecutionResult.Return) {
                returnValue = ((ExecutionResult.Return)result).getValue();
            } else if (!(executionResult instanceof ExecutionResult.Success)) {
                throw new NoWhenBranchMatchedException();
            }
        } else {
            for (Executable statement : this.function.getBody()) {
                statement.setVimContext(this.function);
                try {
                    ExecutionResult executionResult = result = statement.execute(editor, context);
                    if (executionResult instanceof ExecutionResult.Break) {
                        exceptionsCaught.add(ExExceptionsKt.exExceptionMessage("E587", new Object[0]));
                        continue;
                    }
                    if (executionResult instanceof ExecutionResult.Continue) {
                        exceptionsCaught.add(ExExceptionsKt.exExceptionMessage("E586", new Object[0]));
                        continue;
                    }
                    if (executionResult instanceof ExecutionResult.Error) {
                        exceptionsCaught.add(new ExException("unknown error occurred"));
                        continue;
                    }
                    if (!(executionResult instanceof ExecutionResult.Return)) {
                        if (executionResult instanceof ExecutionResult.Success) continue;
                        throw new NoWhenBranchMatchedException();
                    }
                    returnValue = ((ExecutionResult.Return)result).getValue();
                    break;
                }
                catch (ExException e) {
                    if (e instanceof FinishException) {
                        throw new FinishException();
                    }
                    exceptionsCaught.add(e);
                    this.logger.warn("Caught exception during execution of function with [abort] flag. Exception: " + e.getMessage(), e);
                }
            }
        }
        return returnValue;
    }

    private final void initializeFunctionVariables(FunctionHandlerBase.Arguments arguments, LineRange range, VimEditor editor, ExecutionContext context, VimLContext functionCallContext) {
        Iterator iterator = ((Iterable)this.function.getArgs()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String name = (String)iterator.next();
            arguments.setVariable(name, arguments.get(index), editor, context, this.function);
        }
        n = this.function.getDefaultArgs().size();
        for (int index = 0; index < n; ++index) {
            VimDataType expressionToStore = index + this.function.getArgs().size() < arguments.getSize() ? arguments.get(index + this.function.getArgs().size()) : ((Expression)this.function.getDefaultArgs().get(index).getSecond()).evaluate(editor, context, functionCallContext);
            arguments.setVariable((String)this.function.getDefaultArgs().get(index).getFirst(), expressionToStore, editor, context, this.function);
        }
        if (this.function.getHasOptionalArguments()) {
            VimList vimList;
            if (this.function.getArgs().size() + this.function.getDefaultArgs().size() < arguments.getSize()) {
                List list = new ArrayList();
                int n2 = arguments.getSize();
                for (int i = this.function.getArgs().size() + this.function.getDefaultArgs().size(); i < n2; ++i) {
                    list.add(arguments.get(i));
                }
                vimList = new VimList(list);
            } else {
                vimList = new VimList(new ArrayList());
            }
            VimList remainingArgs = vimList;
            arguments.setVariable("000", remainingArgs, editor, context, this.function);
        }
        arguments.setVariable("firstline", new VimInt(range.getStartLine1()), editor, context, this.function);
        arguments.setVariable("lastline", new VimInt(range.getEndLine1()), editor, context, this.function);
    }

    @NotNull
    public final FunctionDeclaration component1() {
        return this.function;
    }

    @NotNull
    public final DefinedFunctionHandler copy(@NotNull FunctionDeclaration function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return new DefinedFunctionHandler(function);
    }

    public static /* synthetic */ DefinedFunctionHandler copy$default(DefinedFunctionHandler definedFunctionHandler, FunctionDeclaration functionDeclaration, int n, Object object) {
        if ((n & 1) != 0) {
            functionDeclaration = definedFunctionHandler.function;
        }
        return definedFunctionHandler.copy(functionDeclaration);
    }

    @NotNull
    public String toString() {
        return "DefinedFunctionHandler(function=" + this.function + ")";
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefinedFunctionHandler)) {
            return false;
        }
        DefinedFunctionHandler definedFunctionHandler = (DefinedFunctionHandler)other;
        return Intrinsics.areEqual((Object)this.function, (Object)definedFunctionHandler.function);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/DefinedFunctionHandler$Companion;", "", "<init>", "()V", "getMaxArity", "", "function", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "(Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;)Ljava/lang/Integer;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer getMaxArity(@NotNull FunctionDeclaration function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            return function.getHasOptionalArguments() ? null : Integer.valueOf(function.getArgs().size() + function.getDefaultArgs().size());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

