/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.functions.handlers.collectionFunctions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.functions.BuiltinFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandlerBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/functions/handlers/collectionFunctions/CountFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/functions/BuiltinFunctionHandler;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "<init>", "()V", "doFunction", "arguments", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandlerBase$Arguments;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCountFunctionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CountFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/handlers/collectionFunctions/CountFunctionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1788#2,4:77\n1788#2,4:81\n*S KotlinDebug\n*F\n+ 1 CountFunctionHandler.kt\ncom/maddyhome/idea/vim/vimscript/model/functions/handlers/collectionFunctions/CountFunctionHandler\n*L\n68#1:77,4\n71#1:81,4\n*E\n"})
public final class CountFunctionHandler
extends BuiltinFunctionHandler<VimInt> {
    public CountFunctionHandler() {
        super(2, 4);
    }

    @Override
    @NotNull
    protected VimInt doFunction(@NotNull FunctionHandlerBase.Arguments arguments, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimInt vimInt;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType comp = arguments.get(0);
        VimDataType expr = arguments.get(1);
        VimInt vimInt2 = arguments.getNumberOrNull(2);
        boolean ic = vimInt2 != null ? vimInt2.getBooleanValue() : false;
        VimInt vimInt3 = arguments.getNumberOrNull(3);
        int start = vimInt3 != null ? vimInt3.getValue() : 0;
        VimDataType vimDataType = comp;
        if (vimDataType instanceof VimString) {
            String text = ((VimString)comp).getValue();
            String pattern = expr.toVimString().getValue();
            if (((CharSequence)pattern).length() == 0) {
                return new VimInt(0);
            }
            int count = 0;
            int index = 0;
            while (index <= text.length() - pattern.length()) {
                String substring;
                boolean matches;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(index, index + pattern.length()), (String)"substring(...)");
                boolean bl = matches = ic ? StringsKt.equals((String)substring, (String)pattern, (boolean)true) : Intrinsics.areEqual((Object)substring, (Object)pattern);
                if (matches) {
                    ++count;
                    index += pattern.length();
                    continue;
                }
                ++index;
            }
            vimInt = new VimInt(count);
        } else if (vimDataType instanceof VimList) {
            int n;
            List<VimDataType> items = start > 0 && start < ((VimList)comp).getValues().size() ? ((VimList)comp).getValues().subList(start, ((VimList)comp).getValues().size()) : ((VimList)comp).getValues();
            Iterable $this$count$iv = items;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    VimDataType item = (VimDataType)element$iv;
                    boolean bl = false;
                    if (!VimDataType.valueEquals$default(item, expr, ic, 0, 4, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            vimInt = VimIntKt.asVimInt(n);
        } else if (vimDataType instanceof VimDictionary) {
            int n;
            Collection<VimDataType> collection = ((VimDictionary)comp).getDictionary().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$count$iv = collection;
            boolean $i$f$count = false;
            if (((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    VimDataType item = (VimDataType)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)item);
                    if (!VimDataType.valueEquals$default(item, expr, ic, 0, 4, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            vimInt = VimIntKt.asVimInt(n);
        } else {
            vimInt = VimInt.Companion.getZERO();
        }
        return vimInt;
    }
}

