/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.yank;

import com.maddyhome.idea.vim.action.motion.updown.MotionDownLess1FirstNonSpaceAction;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimListenersNotifier;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.yank.VimYankGroup;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u000b2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/yank/YankGroupBase;", "Lcom/maddyhome/idea/vim/yank/VimYankGroup;", "<init>", "()V", "yankRange", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/common/TextRange;", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "startOffsets", "Lcom/maddyhome/idea/vim/api/VimCaret;", "", "yankMotion", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "yankLine", "count", "range", "type", "moveCursor", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nYankGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n216#2,2:185\n463#3:187\n413#3:188\n1252#4,4:189\n*S KotlinDebug\n*F\n+ 1 YankGroupBase.kt\ncom/maddyhome/idea/vim/yank/YankGroupBase\n*L\n35#1:185,2\n39#1:187\n39#1:188\n39#1:189,4\n*E\n"})
public class YankGroupBase
implements VimYankGroup {
    /*
     * WARNING - void declaration
     */
    private final boolean yankRange(VimEditor editor, ExecutionContext context, Map<ImmutableVimCaret, ? extends Pair<TextRange, ? extends SelectionType>> caretToRange, Map<VimCaret, Integer> startOffsets) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValues$iv;
        Map<ImmutableVimCaret, Integer> $this$forEach$iv;
        Map<VimCaret, Integer> map = startOffsets;
        if (map != null) {
            $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<VimCaret, Integer>> object2 = $this$forEach$iv.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry<VimCaret, Integer> element$iv;
                Map.Entry<VimCaret, Integer> entry = element$iv = object2.next();
                boolean bl = false;
                VimCaret caret = entry.getKey();
                int offset = ((Number)entry.getValue()).intValue();
                caret.moveToOffset(offset);
            }
        }
        $this$forEach$iv = caretToRange;
        VimListenersNotifier vimListenersNotifier = VimInjectorKt.getInjector().getListenersNotifier();
        boolean $i$f$mapValues = false;
        void var7_10 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable bl = var7_10.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl3 = false;
            TextRange textRange = (TextRange)((Pair)it.getValue()).getFirst();
            map3.put(k, textRange);
        }
        vimListenersNotifier.notifyYankPerformed(destination$iv$iv$iv);
        boolean result = true;
        for (Map.Entry<ImmutableVimCaret, ? extends Pair<TextRange, ? extends SelectionType>> entry : caretToRange.entrySet()) {
            ImmutableVimCaret caret = entry.getKey();
            Pair<TextRange, ? extends SelectionType> myRange = entry.getValue();
            result = caret.getRegisterStorage().storeText(editor, context, (TextRange)myRange.getFirst(), (SelectionType)((Object)myRange.getSecond()), false) && result;
        }
        return result;
    }

    @Override
    public boolean yankMotion(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Argument argument, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Argument.Motion motion = argument instanceof Argument.Motion ? (Argument.Motion)argument : null;
        if (motion == null) {
            return false;
        }
        Argument.Motion motion2 = motion;
        int nativeCaretCount = editor.nativeCarets().size();
        if (nativeCaretCount <= 0) {
            return false;
        }
        HashMap caretToRange = new HashMap(nativeCaretCount);
        HashMap<VimCaret, Integer> startOffsets = ((Argument.Motion)argument).getMotion() instanceof MotionDownLess1FirstNonSpaceAction ? null : new HashMap<VimCaret, Integer>(nativeCaretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            TextRange motionRange;
            boolean bl;
            SelectionType motionType = motion2.getMotionType();
            if (VimInjectorKt.getInjector().getMotion().getMotionRange(editor, caret, context, argument, operatorArguments) == null) continue;
            boolean bl2 = bl = motionRange.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            HashMap<VimCaret, Integer> hashMap = startOffsets;
            if (hashMap != null) {
                hashMap.put(caret, motionRange.normalize().getStartOffset());
            }
            if (((Argument.Motion)argument).getMotion() instanceof MotionActionHandler && ((MotionActionHandler)((Argument.Motion)argument).getMotion()).getMotionType() == MotionType.EXCLUSIVE) {
                BufferPosition start = editor.offsetToBufferPosition(motionRange.getStartOffset());
                BufferPosition end = editor.offsetToBufferPosition(motionRange.getEndOffset());
                if (start.getLine() != end.getLine() && !EngineEditorHelperKt.anyNonWhitespace(editor, motionRange.getStartOffset(), -1) && !EngineEditorHelperKt.anyNonWhitespace(editor, motionRange.getEndOffset(), 1)) {
                    motionType = SelectionType.LINE_WISE;
                }
            }
            ((Map)caretToRange).put(caret, TuplesKt.to((Object)new TextRange(motionRange.getStartOffset(), motionRange.getEndOffset()), (Object)((Object)motionType)));
        }
        if (caretToRange.isEmpty()) {
            return false;
        }
        return this.yankRange(editor, context, caretToRange, (Map<VimCaret, Integer>)startOffsets);
    }

    @Override
    public boolean yankLine(@NotNull VimEditor editor, @NotNull ExecutionContext context, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int caretCount = editor.nativeCarets().size();
        HashMap caretToRange = new HashMap(caretCount);
        for (VimCaret caret : editor.nativeCarets()) {
            int start = VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(editor, caret);
            int end = Math.min(VimInjectorKt.getInjector().getMotion().moveCaretToRelativeLineEnd(editor, caret, count - 1, true) + 1, (int)editor.fileSize());
            if (end == -1) continue;
            ((Map)caretToRange).put(caret, TuplesKt.to((Object)new TextRange(start, end), (Object)((Object)SelectionType.LINE_WISE)));
        }
        return this.yankRange(editor, context, caretToRange, null);
    }

    @Override
    public boolean yankRange(@NotNull VimEditor editor, @NotNull ExecutionContext context, @Nullable TextRange range, @NotNull SelectionType type, boolean moveCursor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (range == null) {
            return false;
        }
        HashMap caretToRange = new HashMap();
        if (type == SelectionType.LINE_WISE) {
            int n = range.size();
            for (int i = 0; i < n; ++i) {
                if (editor.offsetToBufferPosition(range.getStartOffsets()[i]).getColumn() != 0) {
                    range.getStartOffsets()[i] = EngineEditorHelperKt.getLineStartForOffset(editor, range.getStartOffsets()[i]);
                }
                if (editor.offsetToBufferPosition(range.getEndOffsets()[i]).getColumn() == 0) continue;
                range.getEndOffsets()[i] = RangesKt.coerceAtMost((int)(EngineEditorHelperKt.getLineEndForOffset(editor, range.getEndOffsets()[i]) + 1), (int)((int)editor.fileSize()));
            }
        }
        int[] rangeStartOffsets = range.getStartOffsets();
        int[] rangeEndOffsets = range.getEndOffsets();
        HashMap startOffsets = new HashMap(editor.nativeCarets().size());
        if (type == SelectionType.BLOCK_WISE) {
            ((Map)startOffsets).put(editor.primaryCaret(), range.normalize().getStartOffset());
            ((Map)caretToRange).put(editor.primaryCaret(), TuplesKt.to((Object)range, (Object)((Object)type)));
        } else {
            Iterator iterator = ((Iterable)editor.nativeCarets()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                VimCaret caret = (VimCaret)iterator.next();
                TextRange textRange = new TextRange(rangeStartOffsets[i], rangeEndOffsets[i]);
                ((Map)startOffsets).put(caret, textRange.normalize().getStartOffset());
                ((Map)caretToRange).put(caret, TuplesKt.to((Object)textRange, (Object)((Object)type)));
            }
        }
        return moveCursor ? this.yankRange(editor, context, caretToRange, startOffsets) : this.yankRange(editor, context, caretToRange, null);
    }
}

