/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.argtextobj;

import com.intellij.vim.api.VimApi;
import com.intellij.vim.api.scopes.editor.EditorScope;
import com.intellij.vim.api.scopes.editor.ReadScope;
import com.maddyhome.idea.vim.extension.argtextobj.BracketPairs;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 >2\u00020\u0001:\u0002=>B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u000bH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0018\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0002J\u0018\u00102\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002J\b\u00106\u001a\u0004\u0018\u00010\u0014J \u00107\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006?"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder;", "", "text", "", "api", "Lcom/intellij/vim/api/VimApi;", "brackets", "Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/vim/api/VimApi;Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs;)V", "value", "", "leftBound", "getLeftBound", "()I", "rightBound", "getRightBound", "leftBracket", "rightBracket", "error", "", "Lorg/jetbrains/annotations/Nls;", "getLineNumber", "offset", "getLineStartOffset", "lineNo", "getLineEndOffset", "getLineCount", "findBoundsAt", "", "position", "adjustForInner", "", "adjustForOuter", "extendTillNext", "isIdentPreceding", "()Z", "outOfQuotedText", "getOutOfQuotedText", "()Lkotlin/Unit;", "findRightBound", "findLeftBound", "isQuote", "i", "getCharAt", "", "logicalOffset", "skipQuotedTextForward", "start", "end", "skipQuotedTextBackward", "leftLimit", "pos", "rightLimit", "errorMessage", "skipSexp", "dir", "Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder$SexpDirection;", "findOuterBrackets", "findPrevOpenBracket", "findNextCloseBracket", "SexpDirection", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimArgTextObjExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimArgTextObjExtension.kt\ncom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,654:1\n1#2:655\n*E\n"})
final class ArgBoundsFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence text;
    @NotNull
    private final VimApi api;
    @NotNull
    private final BracketPairs brackets;
    private int leftBound;
    private int rightBound;
    private int leftBracket;
    private int rightBracket;
    @Nls
    @Nullable
    private String error;
    @NotNull
    private static final String QUOTES = "\"'";
    private static final int MAX_SEARCH_LINES = 10;
    private static final int MAX_SEARCH_OFFSET = 800;

    public ArgBoundsFinder(@NotNull CharSequence text, @NotNull VimApi api, @NotNull BracketPairs brackets) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)brackets, (String)"brackets");
        this.text = text;
        this.api = api;
        this.brackets = brackets;
        this.leftBound = Integer.MAX_VALUE;
        this.rightBound = Integer.MIN_VALUE;
    }

    public final int getLeftBound() {
        return this.leftBound;
    }

    public final int getRightBound() {
        return this.rightBound;
    }

    private final int getLineNumber(int offset) {
        return ((Number)this.api.editor(arg_0 -> ArgBoundsFinder.getLineNumber$lambda$0(offset, arg_0))).intValue();
    }

    private final int getLineStartOffset(int lineNo) {
        return ((Number)this.api.editor(arg_0 -> ArgBoundsFinder.getLineStartOffset$lambda$0(lineNo, arg_0))).intValue();
    }

    private final int getLineEndOffset(int lineNo) {
        return ((Number)this.api.editor(arg_0 -> ArgBoundsFinder.getLineEndOffset$lambda$0(lineNo, arg_0))).intValue();
    }

    private final int getLineCount() {
        return ((Number)this.api.editor(ArgBoundsFinder::getLineCount$lambda$0)).intValue();
    }

    public final boolean findBoundsAt(int position) throws IllegalStateException {
        boolean nonEmptyArg;
        if (this.text.length() == 0) {
            this.error = "empty document";
            return false;
        }
        this.leftBound = Math.min(position, this.leftBound);
        this.rightBound = Math.max(position, this.rightBound);
        this.getOutOfQuotedText();
        if (this.rightBound == this.leftBound) {
            if (this.brackets.isCloseBracket(this.getCharAt(this.rightBound))) {
                this.leftBound += -1;
                v0 = this.leftBound;
            } else {
                v0 = ++this.rightBound;
            }
        }
        int nextLeft = this.leftBound;
        int nextRight = this.rightBound;
        int leftLimit = this.leftLimit(position);
        int rightLimit = this.rightLimit(position);
        boolean bothBrackets = false;
        do {
            this.leftBracket = nextLeft;
            this.rightBracket = nextRight;
            if (!this.findOuterBrackets(leftLimit, rightLimit)) {
                this.error = "not inside argument list";
                return false;
            }
            this.leftBound = nextLeft;
            this.findLeftBound();
            nextLeft = this.leftBound - 1;
            this.rightBound = nextRight;
            this.findRightBound();
            nextRight = this.rightBound + 1;
            if (nextLeft < leftLimit || nextRight > rightLimit) {
                this.error = "not an argument";
                return false;
            }
            bothBrackets = this.getCharAt(this.leftBound) != ',' && this.getCharAt(this.rightBound) != ',';
            boolean bl = nonEmptyArg = this.rightBound - this.leftBound > 1;
        } while ((!bothBrackets || !nonEmptyArg || !this.isIdentPreceding()) && this.leftBound > leftLimit && this.rightBound < rightLimit && bothBrackets);
        return true;
    }

    public final void adjustForInner() {
        ++this.leftBound;
        while (this.leftBound < this.rightBound && Character.isWhitespace(this.getCharAt(this.leftBound))) {
            ++this.leftBound;
        }
    }

    public final void adjustForOuter() {
        if (this.getCharAt(this.leftBound) != ',') {
            ++this.leftBound;
            this.extendTillNext();
        }
    }

    public final void extendTillNext() {
        if (this.rightBound + 1 < this.rightBracket && this.getCharAt(this.rightBound) == ',') {
            ++this.rightBound;
            while (this.rightBound + 1 < this.rightBracket && Character.isWhitespace(this.getCharAt(this.rightBound))) {
                ++this.rightBound;
            }
        }
    }

    public final boolean isIdentPreceding() {
        int i;
        int idEnd = i = this.leftBound - 1;
        while (i >= 0 && Character.isJavaIdentifierPart(this.getCharAt(i))) {
            --i;
        }
        return idEnd - i > 0 && Character.isJavaIdentifierStart(this.getCharAt(i + 1));
    }

    @NotNull
    public final Unit getOutOfQuotedText() {
        int lineNo = this.getLineNumber(this.leftBound);
        int lineStartOffset = this.getLineStartOffset(lineNo);
        int lineEndOffset = this.getLineEndOffset(lineNo);
        for (int i = lineStartOffset; i <= this.leftBound; ++i) {
            if (!this.isQuote(i)) continue;
            int endOfQuotedText = this.skipQuotedTextForward(i, lineEndOffset);
            if (endOfQuotedText >= this.leftBound) {
                this.leftBound = i - 1;
                this.rightBound = endOfQuotedText + 1;
                break;
            }
            i = endOfQuotedText;
        }
        return Unit.INSTANCE;
    }

    private final void findRightBound() {
        char ch;
        while (this.rightBound < this.rightBracket && (ch = this.getCharAt(this.rightBound)) != ',') {
            if (this.brackets.isOpenBracket(ch)) {
                this.rightBound = this.skipSexp(this.rightBound, this.rightBracket, SexpDirection.Companion.forward(this.brackets));
                continue;
            }
            if (ArgBoundsFinder.Companion.isQuoteChar(ch)) {
                this.rightBound = this.skipQuotedTextForward(this.rightBound, this.rightBracket);
            }
            ++this.rightBound;
        }
    }

    private final void findLeftBound() {
        char ch;
        while (this.leftBound > this.leftBracket && (ch = this.getCharAt(this.leftBound)) != ',') {
            if (this.brackets.isCloseBracket(ch)) {
                this.leftBound = this.skipSexp(this.leftBound, this.leftBracket, SexpDirection.Companion.backward(this.brackets));
                continue;
            }
            if (ArgBoundsFinder.Companion.isQuoteChar(ch)) {
                this.leftBound = this.skipQuotedTextBackward(this.leftBound, this.leftBracket);
            }
            this.leftBound += -1;
        }
    }

    private final boolean isQuote(int i) {
        return StringsKt.indexOf$default((CharSequence)QUOTES, (char)this.getCharAt(i), (int)0, (boolean)false, (int)6, null) != -1;
    }

    private final char getCharAt(int logicalOffset) {
        if (!(logicalOffset >= 0 && logicalOffset < this.text.length())) {
            boolean bl = false;
            String string = "Offset " + logicalOffset + " out of bounds [0, " + this.text.length() + ")";
            throw new IllegalArgumentException(string.toString());
        }
        return this.text.charAt(logicalOffset);
    }

    private final int skipQuotedTextForward(int start2, int end) {
        char ch;
        int i;
        if (!(start2 < end)) {
            boolean $i$a$-require-ArgBoundsFinder$skipQuotedTextForward$22 = false;
            String $i$a$-require-ArgBoundsFinder$skipQuotedTextForward$22 = "start (" + start2 + ") must be less than end (" + end + ")";
            throw new IllegalArgumentException($i$a$-require-ArgBoundsFinder$skipQuotedTextForward$22.toString());
        }
        char quoteChar = this.getCharAt(start2);
        boolean backSlash = false;
        for (i = start2 + 1; i <= end && ((ch = this.getCharAt(i)) != quoteChar || backSlash); ++i) {
            backSlash = ch == '\\' && !backSlash;
        }
        return i;
    }

    private final int skipQuotedTextBackward(int start2, int end) {
        int i;
        if (!(start2 > end)) {
            boolean $i$a$-require-ArgBoundsFinder$skipQuotedTextBackward$22 = false;
            String $i$a$-require-ArgBoundsFinder$skipQuotedTextBackward$22 = "start (" + start2 + ") must be greater than end (" + end + ")";
            throw new IllegalArgumentException($i$a$-require-ArgBoundsFinder$skipQuotedTextBackward$22.toString());
        }
        char quoteChar = this.getCharAt(start2);
        for (i = start2 - 1; i > end; --i) {
            char ch = this.getCharAt(i);
            char prevChar = this.getCharAt(i - 1);
            if (ch == quoteChar && prevChar != '\\') break;
        }
        return i;
    }

    private final int leftLimit(int pos) {
        int offsetLimit = Math.max(pos - MAX_SEARCH_OFFSET, 0);
        int lineNo = this.getLineNumber(pos);
        int lineOffsetLimit = this.getLineStartOffset(Math.max(0, lineNo - 10));
        return Math.max(offsetLimit, lineOffsetLimit);
    }

    private final int rightLimit(int pos) {
        int offsetLimit = Math.min(pos + MAX_SEARCH_OFFSET, this.text.length());
        int lineNo = this.getLineNumber(pos);
        int lineOffsetLimit = this.getLineEndOffset(Math.min(this.getLineCount() - 1, lineNo + 10));
        return Math.min(offsetLimit, lineOffsetLimit);
    }

    @Nullable
    public final String errorMessage() {
        return this.error;
    }

    private final int skipSexp(int start2, int end, SexpDirection dir) {
        char lastChar = this.getCharAt(start2);
        boolean bl = dir.isOpenBracket(lastChar);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Deque bracketStack = new ArrayDeque();
        bracketStack.push(Character.valueOf(lastChar));
        int i = start2 + dir.delta();
        while (!bracketStack.isEmpty() && i != end) {
            char ch = this.getCharAt(i);
            if (dir.isOpenBracket(ch)) {
                bracketStack.push(Character.valueOf(ch));
            } else if (dir.isCloseBracket(ch)) {
                Character c = (Character)bracketStack.getLast();
                char c2 = this.brackets.matchingBracket(ch);
                if (c != null && c.charValue() == c2) {
                    bracketStack.pop();
                } else {
                    int n = this.brackets.getBracketPrio(ch);
                    Object e = bracketStack.getLast();
                    Intrinsics.checkNotNull(e);
                    if (n < this.brackets.getBracketPrio(((Character)e).charValue())) {
                        bracketStack.pop();
                        continue;
                    }
                }
            } else if (ArgBoundsFinder.Companion.isQuoteChar(ch)) {
                i = dir.skipQuotedText(i, end, this);
            }
            i += dir.delta();
        }
        if (bracketStack.isEmpty()) {
            return i;
        }
        return start2 + dir.delta();
    }

    private final boolean findOuterBrackets(int start2, int end) {
        boolean hasNewBracket;
        boolean foundPrev = this.findPrevOpenBracket(start2);
        boolean foundNext = foundPrev ? this.findNextCloseBracket(end) : false;
        boolean bl = hasNewBracket = foundPrev && foundNext;
        while (hasNewBracket) {
            int rightPrio;
            int leftPrio = this.brackets.getBracketPrio(this.getCharAt(this.leftBracket));
            if (leftPrio == (rightPrio = this.brackets.getBracketPrio(this.getCharAt(this.rightBracket)))) {
                return true;
            }
            if (leftPrio < rightPrio) {
                if (this.rightBracket + 1 < end) {
                    ++this.rightBracket;
                    hasNewBracket = this.findNextCloseBracket(end);
                    continue;
                }
                hasNewBracket = false;
                continue;
            }
            if (this.leftBracket > 1) {
                this.leftBracket += -1;
                hasNewBracket = this.findPrevOpenBracket(start2);
                continue;
            }
            hasNewBracket = false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findPrevOpenBracket(int start2) {
        int ch = 0;
        while (true) {
            void it;
            char c;
            char c2 = c = this.getCharAt(this.leftBracket);
            BracketPairs bracketPairs = this.brackets;
            boolean bl = false;
            ch = it;
            if (bracketPairs.isOpenBracket(c)) break;
            if (this.brackets.isCloseBracket(ch)) {
                this.leftBracket = this.skipSexp(this.leftBracket, start2, SexpDirection.Companion.backward(this.brackets));
                continue;
            }
            if (ArgBoundsFinder.Companion.isQuoteChar(ch)) {
                this.leftBracket = this.skipQuotedTextBackward(this.leftBracket, start2);
            } else if (this.leftBracket == start2) {
                return false;
            }
            this.leftBracket += -1;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findNextCloseBracket(int end) {
        block3: {
            int ch = 0;
            do {
                void it;
                char c;
                char c2 = c = this.getCharAt(this.rightBracket);
                BracketPairs bracketPairs = this.brackets;
                boolean bl = false;
                ch = it;
                if (bracketPairs.isCloseBracket(c)) break block3;
                if (this.brackets.isOpenBracket(ch)) {
                    this.rightBracket = this.skipSexp(this.rightBracket, end, SexpDirection.Companion.forward(this.brackets));
                    continue;
                }
                if (ArgBoundsFinder.Companion.isQuoteChar(ch)) {
                    this.rightBracket = this.skipQuotedTextForward(this.rightBracket, end);
                }
                ++this.rightBracket;
            } while (this.rightBracket < end);
            return false;
        }
        return true;
    }

    private static final int getLineNumber$lambda$0(int $offset, EditorScope $this$editor) {
        Intrinsics.checkNotNullParameter((Object)$this$editor, (String)"$this$editor");
        return ((Number)$this$editor.read(arg_0 -> ArgBoundsFinder.getLineNumber$lambda$0$0($offset, arg_0))).intValue();
    }

    private static final int getLineNumber$lambda$0$0(int $offset, ReadScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return $this$read.getLine($offset).getNumber();
    }

    private static final int getLineStartOffset$lambda$0(int $lineNo, EditorScope $this$editor) {
        Intrinsics.checkNotNullParameter((Object)$this$editor, (String)"$this$editor");
        return ((Number)$this$editor.read(arg_0 -> ArgBoundsFinder.getLineStartOffset$lambda$0$0($lineNo, arg_0))).intValue();
    }

    private static final int getLineStartOffset$lambda$0$0(int $lineNo, ReadScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return $this$read.getLineStartOffset($lineNo);
    }

    private static final int getLineEndOffset$lambda$0(int $lineNo, EditorScope $this$editor) {
        Intrinsics.checkNotNullParameter((Object)$this$editor, (String)"$this$editor");
        return ((Number)$this$editor.read(arg_0 -> ArgBoundsFinder.getLineEndOffset$lambda$0$0($lineNo, arg_0))).intValue();
    }

    private static final int getLineEndOffset$lambda$0$0(int $lineNo, ReadScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return $this$read.getLineEndOffset($lineNo, true);
    }

    private static final int getLineCount$lambda$0(EditorScope $this$editor) {
        Intrinsics.checkNotNullParameter((Object)$this$editor, (String)"$this$editor");
        return ((Number)$this$editor.read(ArgBoundsFinder::getLineCount$lambda$0$0)).intValue();
    }

    private static final int getLineCount$lambda$0$0(ReadScope $this$read) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"$this$read");
        return $this$read.getLineCount();
    }

    public static final /* synthetic */ int access$skipQuotedTextForward(ArgBoundsFinder $this, int start2, int end) {
        return $this.skipQuotedTextForward(start2, end);
    }

    public static final /* synthetic */ int access$skipQuotedTextBackward(ArgBoundsFinder $this, int start2, int end) {
        return $this.skipQuotedTextBackward(start2, end);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder$Companion;", "", "<init>", "()V", "QUOTES", "", "MAX_SEARCH_LINES", "", "MAX_SEARCH_OFFSET", "isQuoteChar", "", "ch", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isQuoteChar(int ch) {
            return StringsKt.indexOf$default((CharSequence)ArgBoundsFinder.QUOTES, (char)((char)ch), (int)0, (boolean)false, (int)6, null) != -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder$SexpDirection;", "", "<init>", "()V", "delta", "", "isOpenBracket", "", "ch", "", "isCloseBracket", "skipQuotedText", "pos", "end", "self", "Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder;", "Companion", "IdeaVIM"})
    public static abstract class SexpDirection {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public abstract int delta();

        public abstract boolean isOpenBracket(char var1);

        public abstract boolean isCloseBracket(char var1);

        public abstract int skipQuotedText(int var1, int var2, @NotNull ArgBoundsFinder var3);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder$SexpDirection$Companion;", "", "<init>", "()V", "forward", "Lcom/maddyhome/idea/vim/extension/argtextobj/ArgBoundsFinder$SexpDirection;", "brackets", "Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs;", "backward", "IdeaVIM"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SexpDirection forward(@NotNull BracketPairs brackets) {
                Intrinsics.checkNotNullParameter((Object)brackets, (String)"brackets");
                return new SexpDirection(brackets){
                    final /* synthetic */ BracketPairs $brackets;
                    {
                        this.$brackets = $brackets;
                    }

                    public int delta() {
                        return 1;
                    }

                    public boolean isOpenBracket(char ch) {
                        return this.$brackets.isOpenBracket(ch);
                    }

                    public boolean isCloseBracket(char ch) {
                        return this.$brackets.isCloseBracket(ch);
                    }

                    public int skipQuotedText(int pos, int end, ArgBoundsFinder self) {
                        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                        return ArgBoundsFinder.access$skipQuotedTextForward(self, pos, end);
                    }
                };
            }

            @NotNull
            public final SexpDirection backward(@NotNull BracketPairs brackets) {
                Intrinsics.checkNotNullParameter((Object)brackets, (String)"brackets");
                return new SexpDirection(brackets){
                    final /* synthetic */ BracketPairs $brackets;
                    {
                        this.$brackets = $brackets;
                    }

                    public int delta() {
                        return -1;
                    }

                    public boolean isOpenBracket(char ch) {
                        return this.$brackets.isCloseBracket(ch);
                    }

                    public boolean isCloseBracket(char ch) {
                        return this.$brackets.isOpenBracket(ch);
                    }

                    public int skipQuotedText(int pos, int end, ArgBoundsFinder self) {
                        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                        return ArgBoundsFinder.access$skipQuotedTextBackward(self, pos, end);
                    }
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

