/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.argtextobj;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0003\u000f\u0010\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs;", "", "openBrackets", "", "closeBrackets", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getBracketPrio", "", "ch", "", "matchingBracket", "isCloseBracket", "", "isOpenBracket", "ParseException", "ParseState", "Companion", "IdeaVIM"})
final class BracketPairs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String openBrackets;
    @NotNull
    private final String closeBrackets;

    public BracketPairs(@NotNull String openBrackets, @NotNull String closeBrackets) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)openBrackets, (String)"openBrackets");
        Intrinsics.checkNotNullParameter((Object)closeBrackets, (String)"closeBrackets");
        boolean bl2 = bl = openBrackets.length() == closeBrackets.length();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.openBrackets = openBrackets;
        this.closeBrackets = closeBrackets;
    }

    public final int getBracketPrio(char ch) {
        return Math.max(StringsKt.indexOf$default((CharSequence)this.openBrackets, (char)ch, (int)0, (boolean)false, (int)6, null), StringsKt.indexOf$default((CharSequence)this.closeBrackets, (char)ch, (int)0, (boolean)false, (int)6, null));
    }

    public final char matchingBracket(char ch) {
        int idx = StringsKt.indexOf$default((CharSequence)this.closeBrackets, (char)ch, (int)0, (boolean)false, (int)6, null);
        if (idx != -1) {
            return this.openBrackets.charAt(idx);
        }
        boolean bl = this.isOpenBracket(ch);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        idx = StringsKt.indexOf$default((CharSequence)this.openBrackets, (char)ch, (int)0, (boolean)false, (int)6, null);
        return this.closeBrackets.charAt(idx);
    }

    public final boolean isCloseBracket(int ch) {
        return StringsKt.indexOf$default((CharSequence)this.closeBrackets, (char)((char)ch), (int)0, (boolean)false, (int)6, null) != -1;
    }

    public final boolean isOpenBracket(int ch) {
        return StringsKt.indexOf$default((CharSequence)this.openBrackets, (char)((char)ch), (int)0, (boolean)false, (int)6, null) != -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs$Companion;", "", "<init>", "()V", "fromBracketPairList", "Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs;", "bracketPairs", "", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BracketPairs fromBracketPairList(@NotNull String bracketPairs) throws ParseException {
            Intrinsics.checkNotNullParameter((Object)bracketPairs, (String)"bracketPairs");
            StringBuilder openBrackets = new StringBuilder();
            StringBuilder closeBrackets = new StringBuilder();
            ParseState state = ParseState.OPEN;
            char[] cArray = bracketPairs.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            block6: for (char ch : cArray) {
                switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1: {
                        openBrackets.append(ch);
                        state = ParseState.COLON;
                        continue block6;
                    }
                    case 2: {
                        if (ch == ':') {
                            state = ParseState.CLOSE;
                            continue block6;
                        }
                        throw new ParseException("expecting ':', but got '" + ch + "' instead");
                    }
                    case 3: {
                        char lastOpenBracket = openBrackets.charAt(openBrackets.length() - 1);
                        if (lastOpenBracket == ch) {
                            throw new ParseException("open and close brackets must be different");
                        }
                        closeBrackets.append(ch);
                        state = ParseState.COMMA;
                        continue block6;
                    }
                    case 4: {
                        if (ch == ',') {
                            state = ParseState.OPEN;
                            continue block6;
                        }
                        throw new ParseException("expecting ',', but got '" + ch + "' instead");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (state != ParseState.COMMA) {
                throw new ParseException("list of pairs is incomplete");
            }
            String string = openBrackets.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = closeBrackets.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return new BracketPairs(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParseState.values().length];
                try {
                    nArray[ParseState.OPEN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.COLON.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.CLOSE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ParseState.COMMA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs$ParseException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "<init>", "(Ljava/lang/String;)V", "IdeaVIM"})
    public static final class ParseException
    extends Exception {
        public ParseException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/extension/argtextobj/BracketPairs$ParseState;", "", "<init>", "(Ljava/lang/String;I)V", "OPEN", "COLON", "CLOSE", "COMMA", "IdeaVIM"})
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState OPEN = new ParseState();
        public static final /* enum */ ParseState COLON = new ParseState();
        public static final /* enum */ ParseState CLOSE = new ParseState();
        public static final /* enum */ ParseState COMMA = new ParseState();
        private static final /* synthetic */ ParseState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String value) {
            return Enum.valueOf(ParseState.class, value);
        }

        @NotNull
        public static EnumEntries<ParseState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = parseStateArray = new ParseState[]{ParseState.OPEN, ParseState.COLON, ParseState.CLOSE, ParseState.COMMA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

