/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.surround;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.extension.VimExtensionFacade;
import com.maddyhome.idea.vim.extension.surround.SurroundPair;
import com.maddyhome.idea.vim.extension.surround.VimSurroundExtension;
import com.maddyhome.idea.vim.group.ChangeGroup;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\"\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REGISTER", "", "OPERATOR_FUNC", "", "tagNameAndAttributesCapturePattern", "Ljava/util/regex/Pattern;", "SURROUND_PAIRS", "", "Lcom/maddyhome/idea/vim/extension/surround/SurroundPair;", "getSurroundPair", "c", "inputTagPair", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "inputFunctionName", "withInternalSpaces", "", "getOrInputPair", "performSurround", "", "pair", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "tagsOnNewLines", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nVimSurroundExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSurroundExtension.kt\ncom/maddyhome/idea/vim/extension/surround/VimSurroundExtensionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,409:1\n13#2:410\n*S KotlinDebug\n*F\n+ 1 VimSurroundExtension.kt\ncom/maddyhome/idea/vim/extension/surround/VimSurroundExtensionKt\n*L\n309#1:410\n*E\n"})
public final class VimSurroundExtensionKt {
    @NotNull
    private static final Logger LOG;
    private static final char REGISTER = '\"';
    @NotNull
    private static final String OPERATOR_FUNC = "SurroundOperatorFunc";
    @NotNull
    private static final Pattern tagNameAndAttributesCapturePattern;
    @NotNull
    private static final Map<Character, SurroundPair> SURROUND_PAIRS;

    private static final SurroundPair getSurroundPair(char c) {
        SurroundPair surroundPair;
        if (SURROUND_PAIRS.containsKey(Character.valueOf(c))) {
            surroundPair = SURROUND_PAIRS.get(Character.valueOf(c));
        } else if (!Character.isLetter(c)) {
            String s = String.valueOf(c);
            surroundPair = new SurroundPair(s, s, false);
        } else {
            surroundPair = null;
        }
        return surroundPair;
    }

    private static final SurroundPair inputTagPair(Editor editor, DataContext context) {
        SurroundPair surroundPair;
        Matcher matcher;
        String tagInput = VimExtensionFacade.inputString(editor, context, "<", Character.valueOf('>'));
        if (IjVimEditorKt.getVim(editor).getMode() instanceof Mode.CMD_LINE) {
            IjVimEditorKt.getVim(editor).setMode(IjVimEditorKt.getVim(editor).getMode().getReturnTo());
        }
        if ((matcher = tagNameAndAttributesCapturePattern.matcher(tagInput)).find()) {
            String tagName = matcher.group(1);
            String tagAttributes = matcher.group(2);
            surroundPair = new SurroundPair("<" + tagName + tagAttributes + ">", "</" + tagName + ">", false);
        } else {
            surroundPair = null;
        }
        return surroundPair;
    }

    private static final SurroundPair inputFunctionName(Editor editor, DataContext context, boolean withInternalSpaces) {
        String functionNameInput = VimExtensionFacade.inputString(editor, context, "function: ", null);
        if (IjVimEditorKt.getVim(editor).getMode() instanceof Mode.CMD_LINE) {
            IjVimEditorKt.getVim(editor).setMode(IjVimEditorKt.getVim(editor).getMode().getReturnTo());
        }
        if (((CharSequence)functionNameInput).length() == 0) {
            return null;
        }
        return withInternalSpaces ? new SurroundPair(functionNameInput + "( ", " )", false) : new SurroundPair(functionNameInput + "(", ")", false);
    }

    private static final SurroundPair getOrInputPair(char c, Editor editor, DataContext context) {
        return switch (c) {
            case '<', 't' -> VimSurroundExtensionKt.inputTagPair(editor, context);
            case 'f' -> VimSurroundExtensionKt.inputFunctionName(editor, context, false);
            case 'F' -> VimSurroundExtensionKt.inputFunctionName(editor, context, true);
            default -> VimSurroundExtensionKt.getSurroundPair(c);
        };
    }

    private static final void performSurround(SurroundPair pair, TextRange range, VimCaret caret, boolean tagsOnNewLines) {
        ActionsKt.runWriteAction(() -> VimSurroundExtensionKt.performSurround$lambda$0(caret, pair, tagsOnNewLines, range));
    }

    static /* synthetic */ void performSurround$default(SurroundPair surroundPair, TextRange textRange, VimCaret vimCaret, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        VimSurroundExtensionKt.performSurround(surroundPair, textRange, vimCaret, bl);
    }

    private static final Unit performSurround$lambda$0(VimCaret $caret, SurroundPair $pair, boolean $tagsOnNewLines, TextRange $range) {
        VimEditor editor = $caret.getEditor();
        ChangeGroup changeGroup = VimPlugin.getChange();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)changeGroup), (String)"getChange(...)");
        ChangeGroup change = changeGroup;
        String leftSurround = $pair.getFirst() + ($tagsOnNewLines ? "\n" : "");
        boolean isEOF = $range.getEndOffset() == editor.text().length();
        boolean hasNewLine = EngineEditorHelperKt.endsWithNewLine((VimEditor)editor);
        String rightSurround = $tagsOnNewLines ? (isEOF && !hasNewLine ? "\n" + $pair.getSecond() : $pair.getSecond() + "\n") : $pair.getSecond();
        change.insertText(editor, $caret, $range.getStartOffset(), leftSurround);
        change.insertText(editor, $caret, $range.getEndOffset() + leftSurround.length(), rightSurround);
        VimMarkServiceKt.setChangeMarks((VimMarkService)VimInjectorKt.getInjector().getMarkService(), (ImmutableVimCaret)((ImmutableVimCaret)$caret), (TextRange)new TextRange($range.getStartOffset(), $range.getEndOffset() + leftSurround.length() + rightSurround.length()));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ SurroundPair access$getOrInputPair(char c, Editor editor, DataContext context) {
        return VimSurroundExtensionKt.getOrInputPair(c, editor, context);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$performSurround(SurroundPair pair, TextRange range, VimCaret caret, boolean tagsOnNewLines) {
        VimSurroundExtensionKt.performSurround(pair, range, caret, tagsOnNewLines);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VimSurroundExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pair[] pairArray = "(\\S+)([^>]*)>";
        int n = 0;
        Pattern pattern = Pattern.compile((String)pairArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        tagNameAndAttributesCapturePattern = pattern;
        pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('b'), (Object)new SurroundPair("(", ")", false)), TuplesKt.to((Object)Character.valueOf('('), (Object)new SurroundPair("( ", " )", false)), TuplesKt.to((Object)Character.valueOf(')'), (Object)new SurroundPair("(", ")", true)), TuplesKt.to((Object)Character.valueOf('B'), (Object)new SurroundPair("{", "}", false)), TuplesKt.to((Object)Character.valueOf('{'), (Object)new SurroundPair("{ ", " }", false)), TuplesKt.to((Object)Character.valueOf('}'), (Object)new SurroundPair("{", "}", true)), TuplesKt.to((Object)Character.valueOf('r'), (Object)new SurroundPair("[", "]", false)), TuplesKt.to((Object)Character.valueOf('['), (Object)new SurroundPair("[ ", " ]", false)), TuplesKt.to((Object)Character.valueOf(']'), (Object)new SurroundPair("[", "]", true)), TuplesKt.to((Object)Character.valueOf('a'), (Object)new SurroundPair("<", ">", false)), TuplesKt.to((Object)Character.valueOf('>'), (Object)new SurroundPair("<", ">", false)), TuplesKt.to((Object)Character.valueOf('s'), (Object)new SurroundPair(" ", "", false))};
        SURROUND_PAIRS = MapsKt.mapOf((Pair[])pairArray);
    }
}

