/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.history.HistoryBlock;
import com.maddyhome.idea.vim.history.HistoryEntry;
import com.maddyhome.idea.vim.history.VimHistory;
import com.maddyhome.idea.vim.history.VimHistoryBase;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="VimHistorySettings", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
public class HistoryGroup
extends VimHistoryBase
implements PersistentStateComponent<Element> {
    private static final Logger logger = Logger.getInstance((String)HistoryGroup.class.getName());

    public void saveData(@NotNull Element element) {
        if (element == null) {
            HistoryGroup.$$$reportNull$$$0(0);
        }
        logger.debug("saveData");
        Element hist = new Element("history");
        for (VimHistory.Type type : this.getHistories().keySet()) {
            this.saveData(hist, type);
        }
        element.addContent(hist);
    }

    private void saveData(@NotNull Element element, VimHistory.Type type) {
        HistoryBlock block;
        if (element == null) {
            HistoryGroup.$$$reportNull$$$0(1);
        }
        if ((block = (HistoryBlock)this.getHistories().get(type)) == null) {
            return;
        }
        Element root = new Element("history-" + this.typeToKey(type));
        for (HistoryEntry entry : block.getEntries()) {
            Element entryElement = new Element("entry");
            VimPlugin.getXML().setSafeXmlText(entryElement, entry.getEntry());
            root.addContent(entryElement);
        }
        element.addContent(root);
    }

    public void readData(@NotNull Element element) {
        if (element == null) {
            HistoryGroup.$$$reportNull$$$0(2);
        }
        logger.debug("readData");
        Element hist = element.getChild("history");
        if (hist == null) {
            return;
        }
        for (Element child : hist.getChildren()) {
            String key = child.getName().replace("history-", "");
            this.readData(hist, key);
        }
    }

    private void readData(@NotNull Element element, String key) {
        HistoryBlock block;
        if (element == null) {
            HistoryGroup.$$$reportNull$$$0(3);
        }
        if ((block = (HistoryBlock)this.getHistories().get(this.getTypeForString(key))) != null) {
            return;
        }
        block = new HistoryBlock();
        this.getHistories().put(this.getTypeForString(key), block);
        Element root = element.getChild("history-" + key);
        if (root != null) {
            List items = root.getChildren("entry");
            for (Element item : items) {
                String text = VimPlugin.getXML().getSafeXmlText(item);
                if (text == null) continue;
                block.addEntry(text);
            }
        }
    }

    private String typeToKey(VimHistory.Type type) {
        VimHistory.Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VimHistory.Type.Search.class, VimHistory.Type.Command.class, VimHistory.Type.Expression.class, VimHistory.Type.Input.class, VimHistory.Type.Custom.class}, (Object)type2, n)) {
            case 0 -> {
                VimHistory.Type.Search ignored = (VimHistory.Type.Search)type2;
                yield "search";
            }
            case 1 -> {
                VimHistory.Type.Command ignored = (VimHistory.Type.Command)type2;
                yield "cmd";
            }
            case 2 -> {
                VimHistory.Type.Expression ignored = (VimHistory.Type.Expression)type2;
                yield "expr";
            }
            case 3 -> {
                VimHistory.Type.Input ignored = (VimHistory.Type.Input)type2;
                yield "input";
            }
            case 4 -> {
                VimHistory.Type.Custom custom = (VimHistory.Type.Custom)type2;
                yield custom.getId();
            }
            default -> "unreachable";
        };
    }

    private VimHistory.Type getTypeForString(String key) {
        return switch (key) {
            case "search" -> VimHistory.Type.Search.INSTANCE;
            case "cmd" -> VimHistory.Type.Command.INSTANCE;
            case "expr" -> VimHistory.Type.Expression.INSTANCE;
            case "input" -> VimHistory.Type.Input.INSTANCE;
            default -> new VimHistory.Type.Custom(key);
        };
    }

    @Nullable
    public Element getState() {
        Element element = new Element("history");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            HistoryGroup.$$$reportNull$$$0(4);
        }
        this.readData(state);
    }

    @TestOnly
    public void clear() {
        this.getHistories().clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/maddyhome/idea/vim/group/HistoryGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

