/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.handler.KeyMapIssue;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.icons.VimIcons;
import com.maddyhome.idea.vim.key.ShortcutOwner;
import com.maddyhome.idea.vim.key.ShortcutOwnerInfo;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.statistic.ActionTracker;
import com.maddyhome.idea.vim.ui.VimEmulationConfigurable;
import com.maddyhome.idea.vim.vimscript.services.VimRcService;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT, Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 %2\u00020\u0001:\u0005!\"#$%B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003J,\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u001e\u0010\u001b\u001a\u00020\b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fJ\b\u0010 \u001a\u00020\bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "()V", "notifyAboutIdeaPut", "", "notifyAboutIdeaJoin", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "enableRepeatingMode", "", "noVimrcAsDefault", "notifyAboutShortcutConflict", "keyStroke", "Ljavax/swing/KeyStroke;", "notifySubscribedToEap", "notifyEapFinished", "showReenableNotification", "notifyActionId", "id", "", "candidates", "", "intentionName", "notifyKeymapIssues", "issues", "Ljava/util/ArrayList;", "Lcom/maddyhome/idea/vim/handler/KeyMapIssue;", "Lkotlin/collections/ArrayList;", "requiredShortcutsAssigned", "ActionIdNotifier", "OpenIdeaVimRcAction", "AppendToIdeaVimRcAction", "HelpLink", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\ncom/maddyhome/idea/vim/group/NotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,454:1\n1740#2,3:455\n1869#2,2:458\n13#3:460\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\ncom/maddyhome/idea/vim/group/NotificationService\n*L\n137#1:455,3\n216#1:458,2\n433#1:460\n*E\n"})
public final class NotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private static final NotificationGroup IDEAVIM_STICKY_GROUP;
    @NotNull
    public static final String IDEAVIM_NOTIFICATION_ID = "ideavim";
    @NotNull
    public static final String IDEAVIM_NOTIFICATION_TITLE = "IdeaVim";
    @NotNull
    public static final String ideajoinExamplesUrl = "https://jb.gg/f9zji9";
    @NotNull
    private static final Logger LOG;

    public NotificationService(@Nullable Project project) {
        this.project = project;
    }

    public NotificationService() {
        this(null);
    }

    public final void notifyAboutIdeaPut() {
        Notification notification = new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "Add <code>ideaput</code> to <code>clipboard</code> option to perform a put via the IDE<br/><b><code>set clipboard+=ideaput</code></b>", NotificationType.INFORMATION);
        notification.addAction((AnAction)new OpenIdeaVimRcAction(notification));
        notification.addAction((AnAction)new AppendToIdeaVimRcAction(notification, "set clipboard^=ideaput", "ideaput", (Function0<Unit>)((Function0)NotificationService::notifyAboutIdeaPut$lambda$0)));
        notification.notify(this.project);
    }

    public final void notifyAboutIdeaJoin(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Notification notification = new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "Put <b><code>set ideajoin</code></b> into your <code>~/.ideavimrc</code> to perform a join via the IDE", NotificationType.INFORMATION);
        notification.addAction((AnAction)new OpenIdeaVimRcAction(notification));
        notification.addAction((AnAction)new AppendToIdeaVimRcAction(notification, "set ideajoin", "ideajoin", (Function0<Unit>)((Function0)() -> NotificationService.notifyAboutIdeaJoin$lambda$0(editor))));
        notification.addAction((AnAction)new HelpLink(ideajoinExamplesUrl));
        notification.notify(this.project);
    }

    public final int enableRepeatingMode() {
        return Messages.showYesNoDialog((String)"Do you want to enable repeating keys in macOS on press and hold?\n\n(You can do it manually by running 'defaults write -g ApplePressAndHoldEnabled 0' in the console).", (String)IDEAVIM_NOTIFICATION_TITLE, (Icon)Messages.getQuestionIcon());
    }

    public final void noVimrcAsDefault() {
        Notification notification = IDEAVIM_STICKY_GROUP.createNotification(IDEAVIM_NOTIFICATION_TITLE, "The ~/.vimrc file is no longer read by default, use ~/.ideavimrc instead. You can read it from your ~/.ideavimrc using this command:<br/><br/><code>source ~/.vimrc</code>", NotificationType.INFORMATION);
        notification.notify(this.project);
    }

    public final void notifyAboutShortcutConflict(@NotNull KeyStroke keyStroke) {
        boolean bl;
        Map conflicts;
        block3: {
            Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
            conflicts = VimPlugin.getKey().getSavedShortcutConflicts();
            Iterable $this$all$iv = conflicts.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ShortcutOwnerInfo it = (ShortcutOwnerInfo)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ShortcutOwnerInfo.PerMode || it instanceof ShortcutOwnerInfo.AllModes && ((ShortcutOwnerInfo.AllModes)it).getOwner() == ShortcutOwner.UNDEFINED) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        boolean allValuesAreUndefined = bl;
        String string = KeymapUtil.getShortcutText((Shortcut)((Shortcut)new KeyboardShortcut(keyStroke, null)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortcutText(...)");
        String shortcutText = string;
        String message = allValuesAreUndefined ? "<b>" + shortcutText + "</b> is defined as a shortcut for both Vim and IntelliJ IDEA. It is now used by Vim, but you can change this." : "<b>" + shortcutText + "</b> is used as a Vim command";
        conflicts.put(keyStroke, ShortcutOwnerInfo.Companion.getAllVim());
        Notification notification = new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, message, NotificationType.INFORMATION);
        notification.addAction((AnAction)new DumbAwareAction(conflicts, keyStroke, notification){
            final /* synthetic */ Map<KeyStroke, ShortcutOwnerInfo> $conflicts;
            final /* synthetic */ KeyStroke $keyStroke;
            final /* synthetic */ Notification $notification;
            {
                this.$conflicts = $conflicts;
                this.$keyStroke = $keyStroke;
                this.$notification = $notification;
                super("Use as IDE Shortcut");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$conflicts.put(this.$keyStroke, (ShortcutOwnerInfo)ShortcutOwnerInfo.Companion.getAllIde());
                this.$notification.expire();
            }
        });
        notification.addAction((AnAction)new DumbAwareAction(notification, this){
            final /* synthetic */ Notification $notification;
            final /* synthetic */ NotificationService this$0;
            {
                this.$notification = $notification;
                this.this$0 = $receiver;
                super("Configure\u2026");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$notification.expire();
                ShowSettingsUtil.getInstance().showSettingsDialog(NotificationService.access$getProject$p(this.this$0), VimEmulationConfigurable.class);
            }
        });
        notification.notify(this.project);
    }

    public final void notifySubscribedToEap() {
        new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "You are successfully subscribed to IdeaVim EAP releases.", NotificationType.INFORMATION).notify(this.project);
    }

    public final void notifyEapFinished() {
        new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "You have finished the Early Access Program. Please reinstall IdeaVim to get the stable version.", NotificationType.INFORMATION).notify(this.project);
    }

    public final void showReenableNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Notification notification = new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "IdeaVim has been disabled. You can reenable it by clicking on the gray IdeaVim icon in the status bar.", NotificationType.INFORMATION);
        notification.setIcon(VimIcons.IDEAVIM_DISABLED);
        notification.addAction((AnAction)new DumbAwareAction(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
                super("Reenable IdeaVim");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                VimPlugin.setEnabled(true);
                this.$notification.expire();
            }
        });
        notification.notify(project);
    }

    public final void notifyActionId(@Nullable String id, @Nullable List<String> candidates, @Nullable String intentionName) {
        ActionIdNotifier.INSTANCE.notifyActionId(id, this.project, candidates, intentionName);
    }

    public static /* synthetic */ void notifyActionId$default(NotificationService notificationService, String string, List list, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        notificationService.notifyActionId(string, list, string2);
    }

    public final void notifyKeymapIssues(@NotNull ArrayList<KeyMapIssue> issues) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        Keymap keymap = keymapManager.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap keymap2 = keymap;
        StringBuilder $this$notifyKeymapIssues_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$notifyKeymapIssues_u24lambda_u240.append("Current IDE keymap (" + keymap2.getName() + ") has issues:<br/>").append('\n');
        Iterable $this$forEach$iv = issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder2;
            KeyMapIssue it = (KeyMapIssue)element$iv;
            boolean bl2 = false;
            KeyMapIssue keyMapIssue = it;
            if (keyMapIssue instanceof KeyMapIssue.AddShortcut) {
                stringBuilder2 = $this$notifyKeymapIssues_u24lambda_u240.append("- " + ((KeyMapIssue.AddShortcut)it).getKey() + " key is not assigned to the " + ((KeyMapIssue.AddShortcut)it).getAction() + " action.<br/>").append('\n');
                continue;
            }
            if (keyMapIssue instanceof KeyMapIssue.RemoveShortcut) {
                stringBuilder2 = $this$notifyKeymapIssues_u24lambda_u240.append("- " + ((KeyMapIssue.RemoveShortcut)it).getShortcut() + " key is incorrectly assigned to the " + ((KeyMapIssue.RemoveShortcut)it).getAction() + " action.<br/>").append('\n');
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        String message = stringBuilder.toString();
        Notification notification = IDEAVIM_STICKY_GROUP.createNotification(IDEAVIM_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        notification.setSubtitle("IDE keymap misconfigured");
        notification.addAction((AnAction)new DumbAwareAction(issues, notification, this, keymap2){
            final /* synthetic */ ArrayList<KeyMapIssue> $issues;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ NotificationService this$0;
            final /* synthetic */ Keymap $keymap;
            {
                this.$issues = $issues;
                this.$notification = $notification;
                this.this$0 = $receiver;
                this.$keymap = $keymap;
                super("Fix Keymap");
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable iterable = this.$issues;
                Keymap keymap = this.$keymap;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KeyMapIssue it = (KeyMapIssue)element$iv;
                    boolean bl = false;
                    KeyMapIssue keyMapIssue = it;
                    if (keyMapIssue instanceof KeyMapIssue.AddShortcut) {
                        keymap.addShortcut(((KeyMapIssue.AddShortcut)it).getActionId(), (Shortcut)new KeyboardShortcut(((KeyMapIssue.AddShortcut)it).getKeyStroke(), null));
                        continue;
                    }
                    if (keyMapIssue instanceof KeyMapIssue.RemoveShortcut) {
                        keymap.removeShortcut(((KeyMapIssue.RemoveShortcut)it).getActionId(), ((KeyMapIssue.RemoveShortcut)it).getShortcut());
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                NotificationService.access$getLOG$cp().info("Shortcuts updated " + this.$issues);
                this.$notification.expire();
                NotificationService.access$requiredShortcutsAssigned(this.this$0);
            }
        });
        notification.addAction((AnAction)new DumbAwareAction(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
                super("Open Keymap Settings");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), KeymapPanel.class);
                this.$notification.hideBalloon();
            }
        });
        notification.addAction((AnAction)new DumbAwareAction(issues, notification){
            final /* synthetic */ ArrayList<KeyMapIssue> $issues;
            final /* synthetic */ Notification $notification;
            {
                this.$issues = $issues;
                this.$notification = $notification;
                super("Ignore");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NotificationService.access$getLOG$cp().info("Ignored to update shortcuts " + this.$issues);
                this.$notification.hideBalloon();
            }
        });
        notification.notify(this.project);
    }

    private final void requiredShortcutsAssigned() {
        Notification notification = new Notification(IDEAVIM_NOTIFICATION_ID, IDEAVIM_NOTIFICATION_TITLE, "Keymap fixed", NotificationType.INFORMATION);
        notification.addAction((AnAction)new DumbAwareAction(notification){
            final /* synthetic */ Notification $notification;
            {
                this.$notification = $notification;
                super("Open Keymap Settings");
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ShowSettingsUtil.getInstance().showSettingsDialog(e.getProject(), KeymapPanel.class);
                this.$notification.hideBalloon();
            }
        });
        notification.notify(this.project);
    }

    private static final Unit notifyAboutIdeaPut$lambda$0() {
        VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getClipboard().prependValue("ideaput");
        return Unit.INSTANCE;
    }

    private static final Unit notifyAboutIdeaJoin$lambda$0(VimEditor $editor) {
        IjVimInjectorKt.ijOptions(VimInjectorKt.getInjector(), $editor).setIdeajoin(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$requiredShortcutsAssigned(NotificationService $this) {
        $this.requiredShortcutsAssigned();
    }

    static {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("ideavim-sticky");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        IDEAVIM_STICKY_GROUP = notificationGroup;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotificationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$ActionIdNotifier;", "", "<init>", "()V", "notification", "Lcom/intellij/notification/Notification;", "notifyActionId", "", "id", "", "project", "Lcom/intellij/openapi/project/Project;", "candidates", "", "intentionName", "CopyActionId", "StopTracking", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\ncom/maddyhome/idea/vim/group/NotificationService$ActionIdNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,454:1\n1869#2,2:455\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\ncom/maddyhome/idea/vim/group/NotificationService$ActionIdNotifier\n*L\n300#1:455,2\n*E\n"})
    public static final class ActionIdNotifier {
        @NotNull
        public static final ActionIdNotifier INSTANCE = new ActionIdNotifier();
        @Nullable
        private static Notification notification;

        private ActionIdNotifier() {
        }

        public final void notifyActionId(@Nullable String id, @Nullable Project project, @Nullable List<String> candidates, @Nullable String intentionName) {
            Object it;
            Object object;
            block16: {
                String string;
                List possibleIDs;
                block15: {
                    Object object2;
                    List list;
                    Notification notification = ActionIdNotifier.notification;
                    if (notification != null) {
                        notification.expire();
                    }
                    possibleIDs = (list = candidates) != null && (list = CollectionsKt.distinct((Iterable)list)) != null ? CollectionsKt.sorted((Iterable)list) : null;
                    String string2 = id;
                    if (string2 != null) {
                        object2 = "Action ID: <code>" + string2 + "</code><br><br>";
                    } else {
                        object = possibleIDs;
                        if ((object == null || object.isEmpty()) && !((object = (CharSequence)intentionName) == null || object.length() == 0)) {
                            object2 = "Intention \"" + intentionName + "\" does not have an action ID.<br><br>";
                        } else {
                            object = possibleIDs;
                            if (object == null || object.isEmpty()) {
                                object2 = "<i>Cannot detect action ID</i><br><br>";
                            } else if (possibleIDs.size() == 1) {
                                object2 = "Possible action ID: <code>" + possibleIDs.get(0) + "</code><br><br>";
                            } else {
                                Object $this$notifyActionId_u24lambda_u240 = object = new StringBuilder();
                                boolean bl = false;
                                ((StringBuilder)$this$notifyActionId_u24lambda_u240).append("<p>Multiple possible action IDs. Candidates include:<ul>");
                                Iterable $this$forEach$iv = possibleIDs;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl2 = false;
                                    ((StringBuilder)$this$notifyActionId_u24lambda_u240).append("<li><code>" + it2 + "</code></li>");
                                }
                                ((StringBuilder)$this$notifyActionId_u24lambda_u240).append("</ul></p>");
                                object2 = ((StringBuilder)object).toString();
                            }
                        }
                    }
                    String content = (String)object2 + "<small>See the Notifications tool window for previous IDs</small>";
                    it = object = new Notification(NotificationService.IDEAVIM_NOTIFICATION_ID, NotificationService.IDEAVIM_NOTIFICATION_TITLE, content, NotificationType.INFORMATION);
                    boolean bl = false;
                    it.whenExpired(ActionIdNotifier::notifyActionId$lambda$1$0);
                    it.addAction((AnAction)new StopTracking());
                    if (id != null) break block15;
                    List list2 = possibleIDs;
                    boolean bl3 = list2 != null ? list2.size() == 1 : false;
                    if (!bl3) break block16;
                }
                if ((string = id) == null) {
                    List list = possibleIDs;
                    string = list != null ? (String)list.get(0) : null;
                }
                it.addAction((AnAction)new CopyActionId(string, project));
            }
            it.notify(project);
            notification = object;
            if (id != null) {
                ActionTracker.Util.INSTANCE.logTrackedAction(id);
            }
        }

        public static /* synthetic */ void notifyActionId$default(ActionIdNotifier actionIdNotifier, String string, Project project, List list, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                list = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            actionIdNotifier.notifyActionId(string, project, list, string2);
        }

        private static final void notifyActionId$lambda$1$0() {
            notification = null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$ActionIdNotifier$CopyActionId;", "Lcom/intellij/openapi/project/DumbAwareAction;", "id", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getId", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "IdeaVIM"})
        public static final class CopyActionId
        extends DumbAwareAction {
            @Nullable
            private final String id;
            @Nullable
            private final Project project;

            public CopyActionId(@Nullable String id, @Nullable Project project) {
                super(MessageHelper.message("action.CopyActionId.text"));
                this.id = id;
                this.project = project;
            }

            @Nullable
            public final String getId() {
                return this.id;
            }

            @Nullable
            public final Project getProject() {
                return this.project;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
                String string = this.id;
                if (string == null) {
                    string = "";
                }
                copyPasteManager.setContents((Transferable)new StringSelection(string));
                if (this.id != null) {
                    ActionTracker.Util.INSTANCE.logCopiedAction(this.id);
                }
                Notification notification = notification;
                if (notification != null) {
                    notification.expire();
                }
                String content = this.id == null ? "No action id" : "Action id copied: " + this.id;
                Notification it = new Notification(NotificationService.IDEAVIM_NOTIFICATION_ID, NotificationService.IDEAVIM_NOTIFICATION_TITLE, content, NotificationType.INFORMATION);
                boolean bl = false;
                ActionIdNotifier.notification = it;
                it.whenExpired(CopyActionId::actionPerformed$lambda$0$0);
                it.addAction((AnAction)new StopTracking());
                it.notify(this.project);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(this.id != null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            private static final void actionPerformed$lambda$0$0() {
                ActionIdNotifier.notification = null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$ActionIdNotifier$StopTracking;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "IdeaVIM"})
        public static final class StopTracking
        extends DumbAwareAction {
            public StopTracking() {
                super("Stop Tracking");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).setTrackactionids(false);
                    Notification notification = notification;
                    if (notification == null) break block0;
                    notification.expire();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$AppendToIdeaVimRcAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "notification", "Lcom/intellij/notification/Notification;", "appendableText", "", "optionName", "enableOption", "Lkotlin/Function0;", "", "<init>", "(Lcom/maddyhome/idea/vim/group/NotificationService;Lcom/intellij/notification/Notification;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getNotification", "()Lcom/intellij/notification/Notification;", "getAppendableText", "()Ljava/lang/String;", "getOptionName", "getEnableOption", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "IdeaVIM"})
    private final class AppendToIdeaVimRcAction
    extends AnAction {
        @NotNull
        private final Notification notification;
        @NotNull
        private final String appendableText;
        @NotNull
        private final String optionName;
        @NotNull
        private final Function0<Unit> enableOption;

        public AppendToIdeaVimRcAction(@NotNull Notification notification, @NotNull String appendableText, @NotNull String optionName, Function0<Unit> enableOption) {
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            Intrinsics.checkNotNullParameter((Object)appendableText, (String)"appendableText");
            Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
            Intrinsics.checkNotNullParameter(enableOption, (String)"enableOption");
            super("Append to ~/.ideavimrc");
            this.notification = notification;
            this.appendableText = appendableText;
            this.optionName = optionName;
            this.enableOption = enableOption;
        }

        @NotNull
        public final Notification getNotification() {
            return this.notification;
        }

        @NotNull
        public final String getAppendableText() {
            return this.appendableText;
        }

        @NotNull
        public final String getOptionName() {
            return this.optionName;
        }

        @NotNull
        public final Function0<Unit> getEnableOption() {
            return this.enableOption;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            File ideaVimRc;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project eventProject = e.getProject();
            this.enableOption.invoke();
            if (eventProject != null && (ideaVimRc = VimRcService.INSTANCE.findOrCreateIdeaVimRc()) != null && ideaVimRc.canWrite()) {
                FilesKt.appendText$default((File)ideaVimRc, (String)this.appendableText, null, (int)2, null);
                this.notification.expire();
                Notification successNotification = new Notification(NotificationService.IDEAVIM_NOTIFICATION_ID, NotificationService.IDEAVIM_NOTIFICATION_TITLE, "<code>" + this.optionName + "</code> is enabled", NotificationType.INFORMATION);
                successNotification.addAction((AnAction)new OpenIdeaVimRcAction(successNotification));
                successNotification.notify(NotificationService.this.project);
                return;
            }
            this.notification.expire();
            Companion.createIdeaVimRcManually("Option is enabled, but the file is not modified<br/>Please modify <code>~/.ideavimrc</code> manually", NotificationService.this.project);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$Companion;", "", "<init>", "()V", "IDEAVIM_STICKY_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getIDEAVIM_STICKY_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "IDEAVIM_NOTIFICATION_ID", "", "IDEAVIM_NOTIFICATION_TITLE", "ideajoinExamplesUrl", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createIdeaVimRcManually", "", "message", "project", "Lcom/intellij/openapi/project/Project;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotificationGroup getIDEAVIM_STICKY_GROUP() {
            return IDEAVIM_STICKY_GROUP;
        }

        private final void createIdeaVimRcManually(String message, Project project) {
            Notification notification = new Notification(NotificationService.IDEAVIM_NOTIFICATION_ID, NotificationService.IDEAVIM_NOTIFICATION_TITLE, message, NotificationType.WARNING);
            Ref.ObjectRef actionName = new Ref.ObjectRef();
            Object object = actionName.element = SystemInfo.isMac ? "Reveal Home in Finder" : "Show Home in " + RevealFileAction.getFileManagerName();
            if (!new File(System.getProperty("user.home")).exists()) {
                actionName.element = "";
            }
            notification.addAction(new AnAction((Ref.ObjectRef<String>)actionName, notification){
                final /* synthetic */ Notification $notification;
                {
                    this.$notification = $notification;
                    super((String)$actionName.element);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    File homeDir = new File(System.getProperty("user.home"));
                    RevealFileAction.openDirectory((File)homeDir);
                    this.$notification.expire();
                }
            });
            notification.notify(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$HelpLink;", "Lcom/intellij/openapi/actionSystem/AnAction;", "link", "", "<init>", "(Lcom/maddyhome/idea/vim/group/NotificationService;Ljava/lang/String;)V", "getLink", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "IdeaVIM"})
    private final class HelpLink
    extends AnAction {
        @NotNull
        private final String link;

        public HelpLink(String link) {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            super("", "", AllIcons.Actions.Help);
            this.link = link;
        }

        @NotNull
        public final String getLink() {
            return this.link;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BrowserUtil.browse((String)this.link);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/group/NotificationService$OpenIdeaVimRcAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "IdeaVIM"})
    public static final class OpenIdeaVimRcAction
    extends DumbAwareAction {
        @Nullable
        private final Notification notification;

        public OpenIdeaVimRcAction(@Nullable Notification notification) {
            super(VimRcService.findIdeaVimRc() != null ? "Open ~/.ideavimrc" : "Create ~/.ideavimrc");
            this.notification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            File ideaVimRc;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project eventProject = e.getProject();
            if (eventProject != null && (ideaVimRc = VimRcService.INSTANCE.findOrCreateIdeaVimRc()) != null) {
                String string = ideaVimRc.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                OpenFileAction.Companion.openFile(string, eventProject);
                return;
            }
            Notification notification = this.notification;
            if (notification != null) {
                notification.expire();
            }
            Companion.createIdeaVimRcManually("Cannot create configuration file.<br/>Please create <code>~/.ideavimrc</code> manually", eventProject);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            String actionText = VimRcService.findIdeaVimRc() != null ? "Open ~/.ideavimrc" : "Create ~/.ideavimrc";
            e.getPresentation().setText(actionText);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

