/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.group.InternalOptionValueAccessor;
import com.maddyhome.idea.vim.group.LocalOptionToGlobalLocalIdeaSettingMapper;
import com.maddyhome.idea.vim.group.OptionGroupKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.ToggleOption;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimIntKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/group/NumberOptionMapper;", "Lcom/maddyhome/idea/vim/group/LocalOptionToGlobalLocalIdeaSettingMapper;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimInt;", "numberOption", "Lcom/maddyhome/idea/vim/options/ToggleOption;", "internalOptionValueAccessor", "Lcom/maddyhome/idea/vim/group/InternalOptionValueAccessor;", "<init>", "(Lcom/maddyhome/idea/vim/options/ToggleOption;Lcom/maddyhome/idea/vim/group/InternalOptionValueAccessor;)V", "canUserModifyExternalLocalValue", "", "getCanUserModifyExternalLocalValue", "()Z", "getGlobalExternalValue", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEffectiveExternalValue", "setLocalExternalValue", "", "value", "onGlobalIdeaValueChanged", "propertyName", "", "IdeaVIM"})
final class NumberOptionMapper
extends LocalOptionToGlobalLocalIdeaSettingMapper<VimInt> {
    private final boolean canUserModifyExternalLocalValue;

    public NumberOptionMapper(@NotNull ToggleOption numberOption, @NotNull InternalOptionValueAccessor internalOptionValueAccessor) {
        Intrinsics.checkNotNullParameter((Object)numberOption, (String)"numberOption");
        Intrinsics.checkNotNullParameter((Object)internalOptionValueAccessor, (String)"internalOptionValueAccessor");
        super((Option)numberOption, internalOptionValueAccessor);
        this.canUserModifyExternalLocalValue = true;
    }

    protected boolean getCanUserModifyExternalLocalValue() {
        return this.canUserModifyExternalLocalValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected VimInt getGlobalExternalValue(@NotNull VimEditor editor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (EditorSettingsExternalizable.getInstance().isLineNumbersShown()) {
            EditorSettings.LineNumerationType lineNumerationType = EditorSettingsExternalizable.getInstance().getLineNumeration();
            Intrinsics.checkNotNullExpressionValue((Object)lineNumerationType, (String)"getLineNumeration(...)");
            if (OptionGroupKt.access$isShowingAbsoluteLineNumbers(lineNumerationType)) {
                bl = true;
                return VimIntKt.asVimInt((boolean)bl);
            }
        }
        bl = false;
        return VimIntKt.asVimInt((boolean)bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected VimInt getEffectiveExternalValue(@NotNull VimEditor editor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (IjVimEditorKt.getIj(editor).getSettings().isLineNumbersShown()) {
            EditorSettings.LineNumerationType lineNumerationType = IjVimEditorKt.getIj(editor).getSettings().getLineNumerationType();
            Intrinsics.checkNotNullExpressionValue((Object)lineNumerationType, (String)"getLineNumerationType(...)");
            if (OptionGroupKt.access$isShowingAbsoluteLineNumbers(lineNumerationType)) {
                bl = true;
                return VimIntKt.asVimInt((boolean)bl);
            }
        }
        bl = false;
        return VimIntKt.asVimInt((boolean)bl);
    }

    protected void setLocalExternalValue(@NotNull VimEditor editor, @NotNull VimInt value) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.getBooleanValue()) {
            if (IjVimEditorKt.getIj(editor).getSettings().isLineNumbersShown()) {
                EditorSettings.LineNumerationType lineNumerationType = IjVimEditorKt.getIj(editor).getSettings().getLineNumerationType();
                Intrinsics.checkNotNullExpressionValue((Object)lineNumerationType, (String)"getLineNumerationType(...)");
                if (OptionGroupKt.access$isShowingRelativeLineNumbers(lineNumerationType)) {
                    IjVimEditorKt.getIj(editor).getSettings().setLineNumerationType(EditorSettings.LineNumerationType.HYBRID);
                }
            } else {
                IjVimEditorKt.getIj(editor).getSettings().setLineNumbersShown(true);
                IjVimEditorKt.getIj(editor).getSettings().setLineNumerationType(EditorSettings.LineNumerationType.ABSOLUTE);
            }
        } else if (IjVimEditorKt.getIj(editor).getSettings().isLineNumbersShown()) {
            EditorSettings.LineNumerationType lineNumerationType = IjVimEditorKt.getIj(editor).getSettings().getLineNumerationType();
            Intrinsics.checkNotNullExpressionValue((Object)lineNumerationType, (String)"getLineNumerationType(...)");
            if (OptionGroupKt.access$isShowingRelativeLineNumbers(lineNumerationType)) {
                IjVimEditorKt.getIj(editor).getSettings().setLineNumerationType(EditorSettings.LineNumerationType.RELATIVE);
            } else {
                IjVimEditorKt.getIj(editor).getSettings().setLineNumbersShown(false);
            }
        }
    }

    @Override
    public void onGlobalIdeaValueChanged(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        if (Intrinsics.areEqual((Object)propertyName, (Object)"areLineNumbersShown") || Intrinsics.areEqual((Object)propertyName, (Object)"lineNumeration")) {
            this.doOnGlobalIdeaValueChanged();
        }
    }
}

