/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMarkService;
import com.maddyhome.idea.vim.api.VimMarkServiceBase;
import com.maddyhome.idea.vim.group.SystemMarks;
import com.maddyhome.idea.vim.group.VimMarkServiceImpl;
import com.maddyhome.idea.vim.mark.IntellijMark;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.mark.VimMark;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="VimMarksSettings", storages={@Storage(value="$APP_CONFIG$/vim_settings_local.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0001\u0018\u0000 \u001c2\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0003\u001a\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\tH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/maddyhome/idea/vim/group/VimMarkServiceImpl;", "Lcom/maddyhome/idea/vim/api/VimMarkServiceBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "<init>", "()V", "createOrGetSystemMark", "Lcom/maddyhome/idea/vim/mark/Mark;", "ch", "", "line", "", "col", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "saveData", "", "element", "readData", "getState", "loadState", "state", "createGlobalMark", "char", "offset", "removeGlobalMark", "MarkUpdater", "VimBookmarksListener", "Companion", "IdeaVIM"})
public final class VimMarkServiceImpl
extends VimMarkServiceBase
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int SAVE_MARK_COUNT = 20;
    @NotNull
    private static final Logger logger;

    private final Mark createOrGetSystemMark(char ch, int line, int col, VimEditor editor) {
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimEditor");
        Editor ijEditor = ((IjVimEditor)editor).getEditor();
        LineBookmark lineBookmark = SystemMarks.Companion.createOrGetSystemMark(ch, line, ijEditor);
        if (lineBookmark == null) {
            return null;
        }
        LineBookmark systemMark = lineBookmark;
        return new IntellijMark(systemMark, col, ijEditor.getProject());
    }

    private final void saveData(Element element) {
        Element globalMarksElement = new Element("globalmarks");
        if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeamarks()) {
            for (Object v : this.globalMarks.values()) {
                Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
                Mark mark = (Mark)v;
                Element markElem = new Element("mark");
                markElem.setAttribute("key", String.valueOf(mark.getKey()));
                markElem.setAttribute("line", String.valueOf(mark.getLine()));
                markElem.setAttribute("column", String.valueOf(mark.getCol()));
                markElem.setAttribute("filename", StringUtil.notNullize((String)mark.getFilepath()));
                markElem.setAttribute("protocol", StringUtil.notNullize((String)mark.getProtocol(), (String)"file"));
                globalMarksElement.addContent(markElem);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("saved mark = " + mark);
            }
        }
        element.addContent(globalMarksElement);
        Element localMarksElement = new Element("localmarks");
        Collection collection = this.getFilepathToLocalMarks().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> VimMarkServiceImpl.saveData$lambda$0((Function1)saveData.files.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        List files2 = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        if (files2.size() > 20) {
            files2 = files2.subList(files2.size() - 20, files2.size());
        }
        for (String file : this.getFilepathToLocalMarks().keySet()) {
            VimMarkServiceBase.LocalMarks marks = (VimMarkServiceBase.LocalMarks)this.getFilepathToLocalMarks().get(file);
            if (!CollectionsKt.contains((Iterable)files2, (Object)marks)) continue;
            VimMarkServiceBase.LocalMarks localMarks = marks;
            Intrinsics.checkNotNull((Object)localMarks);
            if (localMarks.size() <= 0) continue;
            Element fileMarkElem = new Element("file");
            fileMarkElem.setAttribute("name", file);
            fileMarkElem.setAttribute("timestamp", Long.toString(marks.getMyTimestamp().getTime()));
            for (Object e : marks.values()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Mark mark = (Mark)e;
                if (Character.isUpperCase(mark.getKey()) || !VimInjectorKt.getInjector().getMarkService().isValidMark(mark.getKey(), VimMarkService.Operation.SAVE, true)) continue;
                Element markElem = new Element("mark");
                markElem.setAttribute("key", String.valueOf(mark.getKey()));
                markElem.setAttribute("line", String.valueOf(mark.getLine()));
                markElem.setAttribute("column", String.valueOf(mark.getCol()));
                fileMarkElem.addContent(markElem);
            }
            localMarksElement.addContent(fileMarkElem);
        }
        element.addContent(localMarksElement);
    }

    private final void readData(Element element) {
        Element fileMarksElem;
        Element marksElem = element.getChild("globalmarks");
        if (marksElem != null && !IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeamarks()) {
            List markList = marksElem.getChildren("mark");
            for (Element aMarkList : markList) {
                Character c = Character.valueOf(aMarkList.getAttributeValue("key").charAt(0));
                String string = aMarkList.getAttributeValue("line");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                Integer n = Integer.parseInt(string);
                String string2 = aMarkList.getAttributeValue("column");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
                Mark mark = (Mark)VimMark.Companion.create(c, n, Integer.valueOf(Integer.parseInt(string2)), aMarkList.getAttributeValue("filename"), aMarkList.getAttributeValue("protocol"));
                if (mark == null) continue;
                ((Map)this.globalMarks).put(Character.valueOf(mark.getKey()), mark);
                HashMap lmarks = (HashMap)this.getLocalMarks(mark.getFilepath());
                ((Map)lmarks).put(Character.valueOf(mark.getKey()), mark);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("globalMarks=" + this.globalMarks);
        }
        if ((fileMarksElem = element.getChild("localmarks")) != null) {
            List fileList = fileMarksElem.getChildren("file");
            for (Element aFileList : fileList) {
                String filename = aFileList.getAttributeValue("name");
                Date timestamp = new Date();
                try {
                    String string = aFileList.getAttributeValue("timestamp");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                    long date = Long.parseLong(string);
                    timestamp.setTime(date);
                }
                catch (NumberFormatException date) {
                    // empty catch block
                }
                Intrinsics.checkNotNull((Object)filename);
                VimMarkServiceBase.LocalMarks fmarks = this.getLocalMarks(filename);
                List markList = aFileList.getChildren("mark");
                for (Element aMarkList : markList) {
                    Character c = Character.valueOf(aMarkList.getAttributeValue("key").charAt(0));
                    String string = aMarkList.getAttributeValue("line");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                    Integer n = Integer.parseInt(string);
                    String string3 = aMarkList.getAttributeValue("column");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
                    Mark mark = (Mark)VimMark.Companion.create(c, n, Integer.valueOf(Integer.parseInt(string3)), filename, aMarkList.getAttributeValue("protocol"));
                    if (mark == null) continue;
                    ((Map)fmarks).put(Character.valueOf(mark.getKey()), mark);
                }
                fmarks.setTimestamp(timestamp);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("localMarks=" + this.getFilepathToLocalMarks());
        }
    }

    @NotNull
    public Element getState() {
        Element element = new Element("marks");
        this.saveData(element);
        return element;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.readData(state);
    }

    @Nullable
    protected Mark createGlobalMark(@NotNull VimEditor editor, char c, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeamarks()) {
            return super.createGlobalMark(editor, c, offset);
        }
        BufferPosition lp = editor.offsetToBufferPosition(offset);
        int line = lp.getLine();
        int col = lp.getColumn();
        return this.createOrGetSystemMark(c, line, col, editor);
    }

    public void removeGlobalMark(char c) {
        Mark mark = this.getGlobalMark(c);
        if (mark instanceof IntellijMark) {
            ((IntellijMark)mark).clear();
        }
        super.removeGlobalMark(c);
    }

    private static final Date saveData$lambda$0(Function1 $tmp0, Object p0) {
        return (Date)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance((String)VimMarkServiceImpl.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VimMarkServiceImpl.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/group/VimMarkServiceImpl$Companion;", "", "<init>", "()V", "SAVE_MARK_COUNT", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/group/VimMarkServiceImpl$MarkUpdater;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "()V", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "getAnyEditorForDocument", "Lcom/maddyhome/idea/vim/newapi/IjVimEditor;", "doc", "Lcom/intellij/openapi/editor/Document;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimMarkServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMarkServiceImpl.kt\ncom/maddyhome/idea/vim/group/VimMarkServiceImpl$MarkUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n1#2:297\n*E\n"})
    public static final class MarkUpdater
    implements DocumentListener {
        @NotNull
        public static final MarkUpdater INSTANCE = new MarkUpdater();

        private MarkUpdater() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MarkUpdater before, event = " + event);
            }
            if (event.getOldLength() == 0) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document doc = document;
            IjVimEditor ijVimEditor = this.getAnyEditorForDocument(doc);
            if (ijVimEditor == null) {
                return;
            }
            IjVimEditor anEditor = ijVimEditor;
            VimInjectorKt.getInjector().getMarkService().updateMarksFromDelete((VimEditor)anEditor, event.getOffset(), event.getOldLength());
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MarkUpdater after, event = " + event);
            }
            if (event.getNewLength() == 0 || event.getNewLength() == 1 && event.getNewFragment().charAt(0) != '\n') {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document doc = document;
            IjVimEditor ijVimEditor = this.getAnyEditorForDocument(doc);
            if (ijVimEditor == null) {
                return;
            }
            IjVimEditor anEditor = ijVimEditor;
            VimInjectorKt.getInjector().getMarkService().updateMarksFromInsert((VimEditor)anEditor, event.getOffset(), event.getNewLength());
        }

        private final IjVimEditor getAnyEditorForDocument(Document doc) {
            IjVimEditor ijVimEditor;
            Editor[] editorArray = EditorFactory.getInstance().getEditors(doc);
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
            Editor editor = (Editor)ArraysKt.firstOrNull((Object[])editorArray);
            if (editor != null) {
                Editor it = editor;
                boolean bl = false;
                ijVimEditor = new IjVimEditor(it);
            } else {
                ijVimEditor = null;
            }
            return ijVimEditor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/group/VimMarkServiceImpl$VimBookmarksListener;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "bookmarkAdded", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkRemoved", "createVimMark", "b", "Lcom/intellij/ide/bookmark/LineBookmark;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimMarkServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimMarkServiceImpl.kt\ncom/maddyhome/idea/vim/group/VimMarkServiceImpl$VimBookmarksListener\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,296:1\n19#2:297\n*S KotlinDebug\n*F\n+ 1 VimMarkServiceImpl.kt\ncom/maddyhome/idea/vim/group/VimMarkServiceImpl$VimBookmarksListener\n*L\n281#1:297\n*E\n"})
    public static final class VimBookmarksListener
    implements BookmarksListener {
        @NotNull
        private final Project myProject;

        public VimBookmarksListener(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myProject = myProject;
        }

        public void bookmarkAdded(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeamarks()) {
                return;
            }
            if (!(bookmark instanceof LineBookmark)) {
                return;
            }
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.myProject);
            if (bookmarksManager == null) {
                return;
            }
            BookmarksManager bookmarksManager2 = bookmarksManager;
            BookmarkType bookmarkType = bookmarksManager2.getType(bookmark);
            if (bookmarkType == null) {
                return;
            }
            BookmarkType type = bookmarkType;
            char mnemonic = type.getMnemonic();
            if (StringsKt.indexOf$default((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (char)mnemonic, (int)0, (boolean)false, (int)6, null) == -1) {
                return;
            }
            this.createVimMark((LineBookmark)bookmark);
        }

        public void bookmarkRemoved(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (!IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getIdeamarks()) {
                return;
            }
            if (!(bookmark instanceof LineBookmark)) {
                return;
            }
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.myProject);
            if (bookmarksManager == null) {
                return;
            }
            BookmarksManager bookmarksManager2 = bookmarksManager;
            BookmarkType bookmarkType = bookmarksManager2.getType(bookmark);
            if (bookmarkType == null) {
                return;
            }
            BookmarkType type = bookmarkType;
            char ch = type.getMnemonic();
            if (StringsKt.indexOf$default((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (char)ch, (int)0, (boolean)false, (int)6, null) != -1) {
                VimInjectorKt.getInjector().getMarkService().removeGlobalMark(ch);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void createVimMark(LineBookmark b) {
            col = 0;
            var4_3 = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(b.getFile());
            if (var4_3 == null) ** GOTO lbl-1000
            var6_4 = var4_3;
            $i$f$asSafely = false;
            v0 = $this$asSafely$iv;
            if (!(v0 instanceof TextEditor)) {
                v0 = null;
            }
            if ((var5_6 = (TextEditor)v0) != null) {
                v1 = var5_6.getEditor();
            } else lbl-1000:
            // 2 sources

            {
                v1 = editor = null;
            }
            if (editor != null) {
                col = editor.getCaretModel().getCurrentCaret().getLogicalPosition().column;
            }
            mark = new IntellijMark(b, col, this.myProject);
            VimInjectorKt.getInjector().getMarkService().setGlobalMark((Mark)mark);
        }
    }
}

