/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesHelperKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0003\u001a\u0014\u0010\u0011\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\tH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u000bH\u0001\"\u0018\u0010\f\u001a\u00020\u0004*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u0004*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0013"}, d2={"moveToInlayAwareOffset", "", "Lcom/intellij/openapi/editor/Caret;", "offset", "", "moveToInlayAwareLogicalPosition", "pos", "Lcom/intellij/openapi/editor/LogicalPosition;", "getVisualPositionForTextAtOffset", "Lcom/intellij/openapi/editor/VisualPosition;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlayAwareVisualColumn", "getInlayAwareVisualColumn", "(Lcom/intellij/openapi/editor/Caret;)I", "amountOfInlaysBeforeCaret", "getAmountOfInlaysBeforeCaret", "amountOfInlaysBeforeVisualPosition", "updateCaretsVisualPosition", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nInlayHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHelper.kt\ncom/maddyhome/idea/vim/helper/InlayHelperKt\n+ 2 Helper.kt\ncom/maddyhome/idea/vim/helper/HelperKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n30#2,4:121\n35#2:127\n1869#3,2:125\n*S KotlinDebug\n*F\n+ 1 InlayHelper.kt\ncom/maddyhome/idea/vim/helper/InlayHelperKt\n*L\n113#1:121,4\n113#1:127\n113#1:125,2\n*E\n"})
public final class InlayHelperKt {
    /*
     * Enabled aggressive block sorting
     */
    @RequiresEdt
    public static final void moveToInlayAwareOffset(@NotNull Caret $this$moveToInlayAwareOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$moveToInlayAwareOffset, (String)"<this>");
        if (!$this$moveToInlayAwareOffset.getEditor().getFoldingModel().isOffsetCollapsed(offset)) {
            Editor editor = $this$moveToInlayAwareOffset.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (CaretVisualAttributesHelperKt.hasBlockOrUnderscoreCaret(editor)) {
                Editor editor2 = $this$moveToInlayAwareOffset.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                VisualPosition newVisualPosition = InlayHelperKt.getVisualPositionForTextAtOffset(editor2, offset);
                if (Intrinsics.areEqual((Object)newVisualPosition, (Object)$this$moveToInlayAwareOffset.getVisualPosition())) return;
                $this$moveToInlayAwareOffset.moveToVisualPosition(newVisualPosition);
                return;
            }
        }
        $this$moveToInlayAwareOffset.moveToOffset(offset);
    }

    public static final void moveToInlayAwareLogicalPosition(@NotNull Caret $this$moveToInlayAwareLogicalPosition, @NotNull LogicalPosition pos) {
        Intrinsics.checkNotNullParameter((Object)$this$moveToInlayAwareLogicalPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        InlayHelperKt.moveToInlayAwareOffset($this$moveToInlayAwareLogicalPosition, $this$moveToInlayAwareLogicalPosition.getEditor().logicalPositionToOffset(pos));
    }

    @RequiresEdt
    private static final VisualPosition getVisualPositionForTextAtOffset(Editor editor, int offset) {
        Editor editor2;
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        if (editor instanceof EditorWindow) {
            LogicalPosition logicalPosition3 = ((EditorWindow)editor).injectedToHost(logicalPosition2);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition3, (String)"injectedToHost(...)");
            logicalPosition2 = logicalPosition3;
            editor2 = ((EditorWindow)editor).getDelegate();
        } else {
            editor2 = editor;
        }
        Editor editor3 = editor2;
        Intrinsics.checkNotNull((Object)editor3);
        Editor e = editor3;
        VisualPosition visualPosition = e.logicalToVisualPosition(logicalPosition2);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"logicalToVisualPosition(...)");
        VisualPosition pos = visualPosition;
        while (editor.getInlayModel().getInlineElementAt(pos) != null) {
            pos = new VisualPosition(pos.line, pos.column + 1);
        }
        return pos;
    }

    public static final int getInlayAwareVisualColumn(@NotNull Caret $this$inlayAwareVisualColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$inlayAwareVisualColumn, (String)"<this>");
        Editor editor = $this$inlayAwareVisualColumn.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        int textVisualColumn = InlayHelperKt.getVisualPositionForTextAtOffset((Editor)editor, (int)$this$inlayAwareVisualColumn.getOffset()).column;
        return RangesKt.coerceAtLeast((int)(textVisualColumn - InlayHelperKt.getAmountOfInlaysBeforeCaret($this$inlayAwareVisualColumn)), (int)0);
    }

    public static final int getAmountOfInlaysBeforeCaret(@NotNull Caret $this$amountOfInlaysBeforeCaret) {
        Intrinsics.checkNotNullParameter((Object)$this$amountOfInlaysBeforeCaret, (String)"<this>");
        int lineStartOffset = $this$amountOfInlaysBeforeCaret.getEditor().getDocument().getLineStartOffset($this$amountOfInlaysBeforeCaret.getLogicalPosition().line);
        return $this$amountOfInlaysBeforeCaret.getEditor().getInlayModel().getInlineElementsInRange(lineStartOffset, $this$amountOfInlaysBeforeCaret.getOffset()).size();
    }

    public static final int amountOfInlaysBeforeVisualPosition(@NotNull Editor $this$amountOfInlaysBeforeVisualPosition, @NotNull VisualPosition pos) {
        Intrinsics.checkNotNullParameter((Object)$this$amountOfInlaysBeforeVisualPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int offset = $this$amountOfInlaysBeforeVisualPosition.visualPositionToOffset(pos);
        int lineStartOffset = $this$amountOfInlaysBeforeVisualPosition.getDocument().getLineStartOffset($this$amountOfInlaysBeforeVisualPosition.visualToLogicalPosition((VisualPosition)pos).line);
        return $this$amountOfInlaysBeforeVisualPosition.getInlayModel().getInlineElementsInRange(lineStartOffset, offset).size();
    }

    @RequiresEdt
    public static final void updateCaretsVisualPosition(@NotNull Editor $this$updateCaretsVisualPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$updateCaretsVisualPosition, (String)"<this>");
        VimInjectorKt.getInjector().getApplication().runReadAction(() -> InlayHelperKt.updateCaretsVisualPosition$lambda$0($this$updateCaretsVisualPosition));
    }

    private static final Unit updateCaretsVisualPosition$lambda$0(Editor $this_updateCaretsVisualPosition) {
        Editor $this$vimForEachCaret$iv = $this_updateCaretsVisualPosition;
        boolean $i$f$vimForEachCaret = false;
        if (EditorExtensionsKt.getInBlockSelection((VimEditor)IjVimEditorKt.getVim($this$vimForEachCaret$iv))) {
            Caret caret = $this$vimForEachCaret$iv.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret it = caret;
            boolean bl = false;
            if (!$this_updateCaretsVisualPosition.getFoldingModel().isOffsetCollapsed(it.getOffset())) {
                InlayHelperKt.moveToInlayAwareOffset(it, it.getOffset());
            }
        } else {
            List list = $this$vimForEachCaret$iv.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$forEach$iv$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Caret it = (Caret)element$iv$iv;
                boolean bl = false;
                if ($this_updateCaretsVisualPosition.getFoldingModel().isOffsetCollapsed(it.getOffset())) continue;
                InlayHelperKt.moveToInlayAwareOffset(it, it.getOffset());
            }
        }
        return Unit.INSTANCE;
    }
}

