/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.ScrollHelperKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/helper/ScrollViewHelper;", "", "<init>", "()V", "scrollCaretIntoView", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "scrollCaretIntoViewVertically", "caretLine", "", "getScrollJump", "Lcom/maddyhome/idea/vim/api/VimEditor;", "height", "scrollCaretIntoViewHorizontally", "position", "Lcom/intellij/openapi/editor/VisualPosition;", "IdeaVIM"})
public final class ScrollViewHelper {
    @NotNull
    public static final ScrollViewHelper INSTANCE = new ScrollViewHelper();

    private ScrollViewHelper() {
    }

    @JvmStatic
    public static final void scrollCaretIntoView(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor instanceof TextComponentEditor) {
            return;
        }
        VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition position = visualPosition;
        INSTANCE.scrollCaretIntoViewVertically(editor, position.line);
        INSTANCE.scrollCaretIntoViewHorizontally(editor, position);
    }

    private final void scrollCaretIntoViewVertically(Editor editor, int caretLine) {
        VimEditor vimEditor = IjVimEditorKt.getVim(editor);
        int topLine = EditorHelper.getVisualLineAtTopOfScreen(editor);
        int bottomLine = EditorHelper.getVisualLineAtBottomOfScreen(editor);
        int lastLine = EngineEditorHelperKt.getVisualLineCount((VimEditor)vimEditor) - 1;
        int scrollOffset = VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)vimEditor).getScrolloff();
        int topBound = topLine + scrollOffset;
        int bottomBound = Math.max(topBound, bottomLine - scrollOffset);
        int height = EditorHelper.getNonNormalizedVisualLineAtBottomOfScreen(editor) - topLine + 1;
        int scrollJump = this.getScrollJump(vimEditor, height);
        int inlayAwareMinHeightFudge = EditorHelper.getApproximateScreenHeight(editor) / 2;
        if (height > inlayAwareMinHeightFudge && scrollOffset > height / 2) {
            EditorHelper.scrollVisualLineToMiddleOfScreen(editor, caretLine, false);
        } else if (caretLine < topBound) {
            if (topLine + scrollOffset - caretLine >= Math.max(2, height / 2 - 1)) {
                EditorHelper.scrollVisualLineToMiddleOfScreen(editor, caretLine, false);
            } else {
                int usedBelow;
                int scrollJumpTopLine = Math.max(0, caretLine < topLine ? caretLine - scrollJump + 1 : topLine - scrollJump);
                int scrollOffsetTopLine = Math.max(0, caretLine - scrollOffset);
                int newTopLine = Math.min(scrollOffsetTopLine, scrollJumpTopLine);
                int usedAbove = caretLine - newTopLine;
                int used = 1 + usedAbove + (usedBelow = Math.min(scrollOffset, EngineEditorHelperKt.getVisualLineCount((VimEditor)vimEditor) - caretLine));
                if (used > height) {
                    EditorHelper.scrollVisualLineToMiddleOfScreen(editor, caretLine, false);
                } else {
                    EditorHelper.scrollVisualLineToTopOfScreen(editor, newTopLine);
                }
            }
        } else if (caretLine > bottomBound && bottomLine < lastLine) {
            int lineCount = caretLine - (bottomLine + 1) + 1 + scrollOffset;
            if (lineCount > height) {
                EditorHelper.scrollVisualLineToMiddleOfScreen(editor, caretLine, false);
            } else {
                int scrolledAbove = caretLine - bottomLine;
                int extra = Math.max(scrollOffset, scrollJump - Math.min(scrolledAbove, MathKt.roundToInt((float)((float)(scrollJump + 1) / 2.0f))));
                int scrolled = scrolledAbove + extra;
                int usedBelow = Math.min(EngineEditorHelperKt.getVisualLineCount((VimEditor)vimEditor) - caretLine, scrolledAbove - 1);
                int used = Math.min(height + 1, scrolledAbove + usedBelow);
                int n = lineCount = used > height ? used : scrolled;
                if (lineCount >= height && lineCount > scrollOffset) {
                    EditorHelper.scrollVisualLineToMiddleOfScreen(editor, caretLine, false);
                } else {
                    EditorHelper.scrollVisualLineToBottomOfScreen(editor, caretLine + extra);
                }
            }
        }
    }

    private final int getScrollJump(VimEditor editor, int height) {
        boolean scrollJump;
        EnumSet flags = VimInjectorKt.getInjector().getVimState().getExecutingCommandFlags();
        boolean bl = scrollJump = !flags.contains(CommandFlags.FLAG_IGNORE_SCROLL_JUMP);
        if (scrollJump) {
            int scrollJumpSize = VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getScrolljump();
            return scrollJumpSize < 0 ? (int)((double)height * ((double)Math.min(100, -scrollJumpSize) / 100.0)) : Math.max(1, scrollJumpSize);
        }
        return 1;
    }

    private final void scrollCaretIntoViewHorizontally(Editor editor, VisualPosition position) {
        VimEditor vimEditor = IjVimEditorKt.getVim(editor);
        int currentVisualLeftColumn = EditorHelper.getVisualColumnAtLeftOfDisplay(editor, position.line);
        int currentVisualRightColumn = EditorHelper.getVisualColumnAtRightOfDisplay(editor, position.line);
        int caretColumn = position.column;
        int halfWidth = EditorHelper.getApproximateScreenWidth(editor) / 2;
        int scrollOffset = ScrollHelperKt.getNormalizedSideScrollOffset(editor);
        EnumSet flags = VimInjectorKt.getInjector().getVimState().getExecutingCommandFlags();
        boolean allowSidescroll = !flags.contains(CommandFlags.FLAG_IGNORE_SIDE_SCROLL_JUMP);
        int sidescroll = VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)vimEditor).getSidescroll();
        int offsetLeft = caretColumn - (currentVisualLeftColumn + scrollOffset);
        int offsetRight = caretColumn - (currentVisualRightColumn - scrollOffset);
        if (offsetLeft < 0 || offsetRight > 0) {
            int diff;
            int n = diff = offsetLeft < 0 ? -offsetLeft : offsetRight;
            if (allowSidescroll && sidescroll == 0 || diff >= halfWidth || offsetRight >= offsetLeft) {
                EditorHelper.scrollColumnToMiddleOfScreen(editor, position.line, caretColumn);
            } else {
                if (allowSidescroll && diff < sidescroll) {
                    diff = sidescroll;
                }
                if (offsetLeft < 0) {
                    EditorHelper.scrollColumnToLeftOfScreen(editor, position.line, Math.max(0, currentVisualLeftColumn - diff));
                } else {
                    EditorHelper.scrollColumnToRightOfScreen(editor, position.line, EditorHelper.normalizeVisualColumn(editor, position.line, currentVisualRightColumn + diff, false));
                }
            }
        }
    }
}

