/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"requestFocus", "", "component", "Ljavax/swing/JComponent;", "runAfterGotFocus", "runnable", "Ljava/lang/Runnable;", "selectEditorFont", "Ljava/awt/Font;", "editor", "Lcom/intellij/openapi/editor/Editor;", "forText", "", "IdeaVIM"})
@JvmName(name="UiHelper")
@SourceDebugExtension(value={"SMAP\nUiHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiHelper.kt\ncom/maddyhome/idea/vim/helper/UiHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1869#2,2:59\n*S KotlinDebug\n*F\n+ 1 UiHelper.kt\ncom/maddyhome/idea/vim/helper/UiHelper\n*L\n49#1:59,2\n*E\n"})
public final class UiHelper {
    public static final void requestFocus(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        IdeFocusManager.findInstance().requestFocus((Component)component, true);
    }

    public static final void runAfterGotFocus(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(runnable, ModalityState.defaultModalityState());
    }

    @NotNull
    public static final Font selectEditorFont(@Nullable Editor editor, @NotNull String forText) {
        float f;
        Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
        if (editor instanceof EditorImpl) {
            f = ((EditorImpl)editor).getFontSize2D();
        } else if (UISettings.Companion.getInstance().getPresentationMode()) {
            f = UISettingsUtils.Companion.getInstance().getPresentationModeFontSize();
        } else {
            Editor editor2 = editor;
            f = (editor2 != null ? editor2.getEditorKind() : null) == EditorKind.CONSOLE ? UISettingsUtils.Companion.getInstance().getScaledConsoleFontSize() : UISettingsUtils.Companion.getInstance().getScaledEditorFontSize();
        }
        float fontSize = f;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        List list = scheme.getFontPreferences().getRealFontFamilies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRealFontFamilies(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fontName = (String)element$iv;
            boolean bl = false;
            Font font = new Font(fontName, 0, scheme.getEditorFontSize());
            if (font.canDisplayUpTo(forText) != -1) continue;
            Font font2 = font.deriveFont(fontSize);
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"deriveFont(...)");
            return font2;
        }
        Font font = new Font(scheme.getEditorFontName(), 0, scheme.getEditorFontSize()).deriveFont(fontSize);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"deriveFont(...)");
        return font;
    }
}

