/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.listener;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileOpenedSyncListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.maddyhome.idea.vim.EventFacade;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimKeyListener;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.VimTypedActionHandler;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.LocalOptionInitialisationScenario;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimModalInput;
import com.maddyhome.idea.vim.api.VimOptionGroup;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.group.EditorGroup;
import com.maddyhome.idea.vim.group.FileGroup;
import com.maddyhome.idea.vim.group.IjOptions;
import com.maddyhome.idea.vim.group.IjVimRedrawService;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.group.OptionGroup;
import com.maddyhome.idea.vim.group.ScrollGroup;
import com.maddyhome.idea.vim.group.VimMarkServiceImpl;
import com.maddyhome.idea.vim.group.visual.IdeaSelectionControl;
import com.maddyhome.idea.vim.group.visual.VimVisualTimer;
import com.maddyhome.idea.vim.group.visual.VisualGroupKt;
import com.maddyhome.idea.vim.handler.CopilotKeymapCorrectorKt;
import com.maddyhome.idea.vim.handler.KeymapCheckerKt;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesHelperKt;
import com.maddyhome.idea.vim.helper.CaretVisualAttributesListener;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.GuicursorChangeListener;
import com.maddyhome.idea.vim.helper.HelperKt;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.helper.ModeHelper;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.listener.IJEditorFocusListener;
import com.maddyhome.idea.vim.listener.MouseEventsDataHolder;
import com.maddyhome.idea.vim.listener.SelectionVimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerManagerKt;
import com.maddyhome.idea.vim.listener.VimListenerSuppressor;
import com.maddyhome.idea.vim.listener.VimListenerTestObject;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimSearchGroup;
import com.maddyhome.idea.vim.newapi.InsertTimeRecorder;
import com.maddyhome.idea.vim.options.EffectiveOptionValueChangeListener;
import com.maddyhome.idea.vim.options.GlobalOptionChangeListener;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.ui.ShowCmdOptionChangeListener;
import com.maddyhome.idea.vim.ui.ShowCmdWidgetUpdater;
import com.maddyhome.idea.vim.ui.widgets.macro.MacroWidgetFactoryKt;
import com.maddyhome.idea.vim.ui.widgets.macro.MacroWidgetListener;
import com.maddyhome.idea.vim.ui.widgets.mode.ModeWidgetFactoryKt;
import com.maddyhome.idea.vim.ui.widgets.mode.listeners.ModeWidgetListener;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001:\f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "editorListenersDisposableKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "firstEditorInitialised", "", "turnOn", "", "turnOff", "GlobalListeners", "EditorListeners", "VimFocusListener", "VimDocumentListener", "VimLastSelectedEditorTracker", "VimFileEditorManagerListener", "VimEditorFactoryListener", "EditorSelectionHandler", "EditorMouseHandler", "ComponentMouseListener", "EditorCaretHandler", "SelectionSource", "IdeaVIM"})
public final class VimListenerManager {
    @NotNull
    public static final VimListenerManager INSTANCE = new VimListenerManager();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Disposable> editorListenersDisposableKey;
    private static boolean firstEditorInitialised;

    private VimListenerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnOn() {
        GlobalListeners.INSTANCE.enable();
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"VIM-3648, VIM-3649");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            EditorListeners.INSTANCE.addAll();
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (!CopilotKeymapCorrectorKt.getCorrectorRequester().tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
        if (!KeymapCheckerKt.getKeyCheckRequests().tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
        CaretVisualAttributesListener caretVisualAttributesListener = new CaretVisualAttributesListener();
        VimInjectorKt.getInjector().getListenersNotifier().getMyEditorListeners().add(caretVisualAttributesListener);
        VimInjectorKt.getInjector().getListenersNotifier().getModeChangeListeners().add(caretVisualAttributesListener);
        VimInjectorKt.getInjector().getListenersNotifier().isReplaceCharListeners().add(caretVisualAttributesListener);
        ApplicationManager.getApplication().invokeAndWait(() -> VimListenerManager.turnOn$lambda$1(caretVisualAttributesListener));
        InsertTimeRecorder insertTimeRecorder = new InsertTimeRecorder();
        VimInjectorKt.getInjector().getListenersNotifier().getModeChangeListeners().add(insertTimeRecorder);
        ModeWidgetListener modeWidgetListener = new ModeWidgetListener();
        VimInjectorKt.getInjector().getListenersNotifier().getModeChangeListeners().add(modeWidgetListener);
        VimInjectorKt.getInjector().getListenersNotifier().getMyEditorListeners().add(modeWidgetListener);
        VimInjectorKt.getInjector().getListenersNotifier().getVimPluginListeners().add(modeWidgetListener);
        MacroWidgetListener macroWidgetListener = new MacroWidgetListener();
        VimInjectorKt.getInjector().getListenersNotifier().getMacroRecordingListeners().add(macroWidgetListener);
        VimInjectorKt.getInjector().getListenersNotifier().getVimPluginListeners().add(macroWidgetListener);
        VimInjectorKt.getInjector().getListenersNotifier().getMyEditorListeners().add(new IJEditorFocusListener());
        VimInjectorKt.getInjector().getListenersNotifier().getMyEditorListeners().add(new ShowCmdWidgetUpdater());
    }

    public final void turnOff() {
        GlobalListeners.INSTANCE.disable();
        EditorListeners.INSTANCE.removeAll();
        VimInjectorKt.getInjector().getListenersNotifier().reset();
        if (!CopilotKeymapCorrectorKt.getCorrectorRequester().tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private static final void turnOn$lambda$1(CaretVisualAttributesListener $caretVisualAttributesListener) {
        $caretVisualAttributesListener.updateAllEditorsCaretsVisual();
    }

    static {
        Logger logger = Logger.getInstance(VimListenerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VimListenerManager.logger = logger;
        Key key = Key.create((String)"IdeaVim listeners disposable");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        editorListenersDisposableKey = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$ComponentMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "()V", "cutOffEnd", "", "getCutOffEnd", "()Z", "setCutOffEnd", "(Z)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "IdeaVIM"})
    private static final class ComponentMouseListener
    extends MouseAdapter {
        @NotNull
        public static final ComponentMouseListener INSTANCE = new ComponentMouseListener();
        private static boolean cutOffEnd;

        private ComponentMouseListener() {
        }

        public final boolean getCutOffEnd() {
            return cutOffEnd;
        }

        public final void setCutOffEnd(boolean bl) {
            cutOffEnd = bl;
        }

        @Override
        public void mousePressed(@Nullable MouseEvent e) {
            MouseEvent mouseEvent = e;
            Component component = mouseEvent != null ? mouseEvent.getComponent() : null;
            EditorComponentImpl editorComponentImpl = component instanceof EditorComponentImpl ? (EditorComponentImpl)component : null;
            if (editorComponentImpl == null || (editorComponentImpl = editorComponentImpl.getEditor()) == null) {
                return;
            }
            EditorComponentImpl editor = editorComponentImpl;
            if (EditorHelperRt.isIdeaVimDisabledHere((Editor)editor)) {
                return;
            }
            Mode predictedMode = (Mode)VimInjectorKt.getInjector().getApplication().runReadAction(() -> ComponentMouseListener.mousePressed$lambda$0((EditorImpl)editor));
            switch (e.getClickCount()) {
                case 1: {
                    if (!EngineHelperKt.isEndAllowed((VimEditor)IjVimEditorKt.getVim((Editor)editor), (Mode)predictedMode)) {
                        editor.getCaretModel().runForEachCaret(arg_0 -> ComponentMouseListener.mousePressed$lambda$1((EditorImpl)editor, arg_0));
                        break;
                    }
                    cutOffEnd = false;
                    break;
                }
                case 2: {
                    VisualGroupKt.moveCaretOneCharLeftFromSelectionEnd((Editor)editor, predictedMode);
                }
            }
        }

        private static final Mode mousePressed$lambda$0(EditorImpl $editor) {
            return IdeaSelectionControl.INSTANCE.predictMode((Editor)$editor, SelectionSource.MOUSE);
        }

        private static final void mousePressed$lambda$1(EditorImpl $editor, Caret caret) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            int lineEnd = EngineEditorHelperKt.getLineEndForOffset((VimEditor)((VimEditor)new IjVimEditor((Editor)$editor)), (int)caret.getOffset());
            int lineStart = EngineEditorHelperKt.getLineStartForOffset((VimEditor)((VimEditor)new IjVimEditor((Editor)$editor)), (int)caret.getOffset());
            if (caret.getOffset() == lineEnd && lineEnd != lineStart) {
                InlayHelperKt.moveToInlayAwareOffset(caret, caret.getOffset() - 1);
                bl = true;
            } else {
                bl = false;
            }
            cutOffEnd = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$EditorCaretHandler;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "()V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretAdded", "caretRemoved", "IdeaVIM"})
    private static final class EditorCaretHandler
    implements CaretListener {
        @NotNull
        public static final EditorCaretHandler INSTANCE = new EditorCaretHandler();

        private EditorCaretHandler() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Caret caret = event.getCaret();
                if (caret == null) break block0;
                UserDataManager.resetVimLastColumn(caret);
            }
        }

        public void caretAdded(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor);
        }

        public void caretRemoved(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u001e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$EditorListeners;", "", "<init>", "()V", "addAll", "", "removeAll", "add", "editor", "Lcom/intellij/openapi/editor/Editor;", "openingEditor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "scenario", "Lcom/maddyhome/idea/vim/api/LocalOptionInitialisationScenario;", "remove", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$EditorListeners\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,914:1\n13805#2,2:915\n1869#3,2:917\n1869#3,2:919\n*S KotlinDebug\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$EditorListeners\n*L\n249#1:915,2\n266#1:917,2\n275#1:919,2\n*E\n"})
    public static final class EditorListeners {
        @NotNull
        public static final EditorListeners INSTANCE = new EditorListeners();

        private EditorListeners() {
        }

        public final void addAll() {
            Set initialisedEditors = new LinkedHashSet();
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager != null) {
                ProjectManager projectManager2 = projectManager;
                boolean bl = false;
                Project[] projectArray = projectManager2.getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] $this$forEach$iv = projectArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Editor editor;
                    Project project = (Project)element$iv;
                    boolean bl2 = false;
                    if (FileEditorManager.getInstance((Project)project).getSelectedTextEditor() == null) continue;
                    boolean bl3 = false;
                    LocalOptionInitialisationScenario scenario = !firstEditorInitialised ? LocalOptionInitialisationScenario.FALLBACK : LocalOptionInitialisationScenario.EDIT;
                    INSTANCE.add(editor, VimInjectorKt.getInjector().getFallbackWindow(), scenario);
                    initialisedEditors.add(editor);
                    firstEditorInitialised = true;
                }
            }
            Iterable $this$forEach$iv = VimInjectorKt.getInjector().getEditorGroup().getEditorsRaw();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimEditor vimEditor = (VimEditor)element$iv;
                boolean bl = false;
                Editor editor = IjVimEditorKt.getIj(vimEditor);
                if (initialisedEditors.contains(editor)) continue;
                Editor editor2 = VimListenerManagerKt.access$getOpeningEditor(editor);
                if (editor2 == null || (editor2 = IjVimEditorKt.getVim(editor2)) == null) {
                    editor2 = VimInjectorKt.getInjector().getFallbackWindow();
                }
                INSTANCE.add(editor, (VimEditor)editor2, LocalOptionInitialisationScenario.NEW);
            }
        }

        public final void removeAll() {
            Iterable $this$forEach$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimEditor editor = (VimEditor)element$iv;
                boolean bl = false;
                INSTANCE.remove(IjVimEditorKt.getIj(editor));
            }
        }

        public final void add(@NotNull Editor editor, @NotNull VimEditor openingEditor, @NotNull LocalOptionInitialisationScenario scenario) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)openingEditor, (String)"openingEditor");
            Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
            if (HelperKt.vimDisabled(editor)) {
                return;
            }
            if (editor.getUserData(editorListenersDisposableKey) != null) {
                return;
            }
            Disposable disposable = Disposer.newDisposable((Disposable)VimPlugin.getInstance().onOffDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable perEditorDisposable = disposable;
            editor.putUserData(editorListenersDisposableKey, (Object)perEditorDisposable);
            Disposer.register((Disposable)perEditorDisposable, EditorListeners::add$lambda$0);
            JComponent jComponent = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            RevertOnDisposeUtilKt.addKeyListener((Component)jComponent, (Disposable)perEditorDisposable, (KeyListener)VimKeyListener.INSTANCE);
            VimEditor vimEditor = IjVimEditorKt.getVim(editor);
            VimPlugin.getOptionGroup().initialiseLocalOptions(vimEditor, openingEditor, scenario);
            EventFacade eventFacade = EventFacade.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)eventFacade, (String)"getInstance(...)");
            EventFacade eventFacade2 = eventFacade;
            eventFacade2.addEditorMouseListener(editor, EditorMouseHandler.INSTANCE, perEditorDisposable);
            eventFacade2.addEditorMouseMotionListener(editor, EditorMouseHandler.INSTANCE, perEditorDisposable);
            eventFacade2.addEditorSelectionListener(editor, EditorSelectionHandler.INSTANCE, perEditorDisposable);
            eventFacade2.addComponentMouseListener(editor.getContentComponent(), ComponentMouseListener.INSTANCE, perEditorDisposable);
            eventFacade2.addCaretListener(editor, EditorCaretHandler.INSTANCE, perEditorDisposable);
            VimPlugin.getEditor().editorCreated(editor);
            VimPlugin.getChange().editorCreated(editor, perEditorDisposable);
            ((EditorEx)editor).addFocusListener((FocusChangeListener)VimFocusListener.INSTANCE, perEditorDisposable);
            VimInjectorKt.getInjector().getListenersNotifier().notifyEditorCreated(vimEditor);
            Disposer.register((Disposable)perEditorDisposable, () -> EditorListeners.add$lambda$1(editor));
        }

        public final void remove(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Disposable editorDisposable = (Disposable)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor), (Key)editorListenersDisposableKey);
            if (editorDisposable != null) {
                Disposer.dispose((Disposable)editorDisposable);
            } else {
                StrictMode.INSTANCE.fail("Editor doesn't have disposable attached. " + editor);
            }
        }

        private static final void add$lambda$0() {
            if (VimListenerTestObject.INSTANCE.getEnabled()) {
                VimListenerTestObject.INSTANCE.setDisposedCounter(VimListenerTestObject.INSTANCE.getDisposedCounter() + 1);
            }
        }

        private static final void add$lambda$1(Editor $editor) {
            ApplicationManager.getApplication().invokeLater(() -> EditorListeners.add$lambda$1$0($editor));
        }

        private static final void add$lambda$1$0(Editor $editor) {
            VimPlugin.getEditor().editorDeinit($editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$EditorMouseHandler;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "mouseDragging", "", "cutOffFixed", "mouseDragged", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "clearFirstSelectionEvents", "onLineEnd", "caret", "Lcom/intellij/openapi/editor/Caret;", "mousePressed", "event", "mouseReleased", "mouseClicked", "IdeaVIM"})
    private static final class EditorMouseHandler
    implements EditorMouseListener,
    EditorMouseMotionListener {
        @NotNull
        public static final EditorMouseHandler INSTANCE = new EditorMouseHandler();
        private static boolean mouseDragging;
        private static boolean cutOffFixed;

        private EditorMouseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            if (EditorHelperRt.isIdeaVimDisabledHere(editor2)) {
                return;
            }
            Caret caret = editor2.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret caret2 = caret;
            this.clearFirstSelectionEvents(e);
            if (mouseDragging && caret2.hasSelection()) {
                CaretVisualAttributesHelperKt.forceBarCursor(caret2);
                if (!cutOffFixed && ComponentMouseListener.INSTANCE.getCutOffEnd()) {
                    cutOffFixed = true;
                    Closeable closeable = (Closeable)SelectionVimListenerSuppressor.INSTANCE.lock();
                    Throwable throwable = null;
                    try {
                        VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
                        boolean bl = false;
                        if (caret2.getSelectionEnd() == e.getEditor().getDocument().getLineEndOffset(caret2.getLogicalPosition().line) - 1 && caret2.getLeadSelectionOffset() == caret2.getSelectionEnd()) {
                            caret2.setSelection(caret2.getSelectionStart(), caret2.getSelectionEnd() + 1);
                        }
                        if (caret2.getSelectionEnd() == e.getEditor().getDocument().getLineEndOffset(caret2.getLogicalPosition().line) && caret2.getSelectionEnd() == caret2.getSelectionStart() + 1) {
                            caret2.setSelection(caret2.getSelectionEnd(), caret2.getSelectionEnd());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            MouseEventsDataHolder.INSTANCE.setDragEventCount(MouseEventsDataHolder.INSTANCE.getDragEventCount() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void clearFirstSelectionEvents(EditorMouseEvent e) {
            if (MouseEventsDataHolder.INSTANCE.getDragEventCount() > 0) {
                logger.debug("Mouse dragging");
                Timer timer2 = VimVisualTimer.INSTANCE.getSwingTimer();
                if (timer2 != null) {
                    timer2.stop();
                }
                if (!mouseDragging) {
                    SelectionVimListenerSuppressor.INSTANCE.lock();
                }
                mouseDragging = true;
                Caret caret = e.getEditor().getCaretModel().getPrimaryCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                Caret caret2 = caret;
                if (this.onLineEnd(caret2)) {
                    Closeable closeable = (Closeable)SelectionVimListenerSuppressor.INSTANCE.lock();
                    Throwable throwable = null;
                    try {
                        VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
                        boolean bl = false;
                        caret2.removeSelection();
                        CaretVisualAttributesHelperKt.forceBarCursor(caret2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
        }

        private final boolean onLineEnd(Caret caret) {
            Editor editor = caret.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            int lineEnd = EngineEditorHelperKt.getLineEndForOffset((VimEditor)((VimEditor)new IjVimEditor(editor2)), (int)caret.getOffset());
            int lineStart = EngineEditorHelperKt.getLineStartForOffset((VimEditor)((VimEditor)new IjVimEditor(editor2)), (int)caret.getOffset());
            return caret.getOffset() == lineEnd && lineEnd != lineStart && caret.getOffset() - 1 == caret.getSelectionStart() && caret.getOffset() == caret.getSelectionEnd();
        }

        public void mousePressed(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
                return;
            }
            MouseEventsDataHolder.INSTANCE.setDragEventCount(3);
            SelectionVimListenerSuppressor.INSTANCE.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
                return;
            }
            SelectionVimListenerSuppressor.INSTANCE.unlock();
            this.clearFirstSelectionEvents(event);
            MouseEventsDataHolder.INSTANCE.setDragEventCount(3);
            if (mouseDragging) {
                logger.debug("Release mouse after dragging");
                Editor editor2 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                Closeable closeable = (Closeable)SelectionVimListenerSuppressor.INSTANCE.lock();
                Throwable throwable = null;
                try {
                    VimListenerSuppressor.Locked it = (VimListenerSuppressor.Locked)closeable;
                    boolean bl = false;
                    Mode predictedMode = (Mode)VimInjectorKt.getInjector().getApplication().runReadAction(() -> EditorMouseHandler.mouseReleased$lambda$0$0(editor3));
                    IdeaSelectionControl.INSTANCE.controlNonVimSelectionChange(editor3, SelectionSource.MOUSE);
                    VisualGroupKt.moveCaretOneCharLeftFromSelectionEnd(editor3, predictedMode);
                    CaretVisualAttributesHelperKt.updateCaretsVisualAttributes(editor3);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                mouseDragging = false;
                cutOffFixed = false;
            }
        }

        public void mouseClicked(@NotNull EditorMouseEvent event) {
            block9: {
                block8: {
                    Editor editor;
                    block10: {
                        Boolean hasSelection2;
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Editor editor2 = event.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        if (EditorHelperRt.isIdeaVimDisabledHere(editor2)) {
                            return;
                        }
                        logger.debug("Mouse clicked");
                        if (!Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.EDITING_AREA)) break block8;
                        Editor editor3 = event.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                        editor = editor3;
                        VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
                        if (vimCommandLine != null) {
                            vimCommandLine.close(true, false);
                        }
                        VimModalInput vimModalInput = VimInjectorKt.getInjector().getModalInput().getCurrentModalInput();
                        if (vimModalInput != null) {
                            vimModalInput.deactivate(true, false);
                        }
                        VimOutputPanel vimOutputPanel = VimInjectorKt.getInjector().getOutputPanel().getCurrentOutputPanel();
                        if (vimOutputPanel != null) {
                            vimOutputPanel.close();
                        }
                        CaretModel caretModel = editor.getCaretModel();
                        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                        CaretModel caretModel2 = caretModel;
                        if (ModeExtensionsKt.getSelectionType((Mode)IjVimEditorKt.getVim(editor).getMode()) != null) {
                            caretModel2.removeSecondaryCarets();
                        }
                        if (event.getMouseEvent().getClickCount() != 1 || SwingUtilities.isRightMouseButton(event.getMouseEvent()) || (hasSelection2 = (Boolean)ApplicationManager.getApplication().runReadAction(() -> EditorMouseHandler.mouseClicked$lambda$0(editor))).booleanValue()) break block9;
                        if (!CommandStateHelper.inVisualMode(editor)) break block10;
                        EngineModeExtensionsKt.exitVisualMode((VimEditor)IjVimEditorKt.getVim(editor));
                        break block9;
                    }
                    if (!EditorExtensionsKt.getInSelectMode((VimEditor)IjVimEditorKt.getVim(editor))) break block9;
                    ModeHelper.exitSelectMode(IjVimEditorKt.getVim(editor), false);
                    KeyHandler.Companion.getInstance().reset(IjVimEditorKt.getVim(editor));
                    break block9;
                }
                if (Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.ANNOTATIONS_AREA) || Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.FOLDING_OUTLINE_AREA) || event.getMouseEvent().getButton() == 3) break block9;
                VimCommandLine vimCommandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
                if (vimCommandLine != null) {
                    vimCommandLine.close(true, false);
                }
                VimModalInput vimModalInput = VimInjectorKt.getInjector().getModalInput().getCurrentModalInput();
                if (vimModalInput != null) {
                    vimModalInput.deactivate(true, false);
                }
                VimOutputPanel vimOutputPanel = VimInjectorKt.getInjector().getOutputPanel().getCurrentOutputPanel();
                if (vimOutputPanel != null) {
                    vimOutputPanel.close();
                }
            }
        }

        private static final Mode mouseReleased$lambda$0$0(Editor $editor) {
            return IdeaSelectionControl.INSTANCE.predictMode($editor, SelectionSource.MOUSE);
        }

        private static final Boolean mouseClicked$lambda$0(Editor $editor) {
            return $editor.getSelectionModel().hasSelection(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$EditorSelectionHandler;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "<init>", "()V", "selectionChanged", "", "selectionEvent", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$EditorSelectionHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,914:1\n67#2,4:915\n67#2,4:919\n*S KotlinDebug\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$EditorSelectionHandler\n*L\n584#1:915,4\n585#1:919,4\n*E\n"})
    private static final class EditorSelectionHandler
    implements SelectionListener {
        @NotNull
        public static final EditorSelectionHandler INSTANCE = new EditorSelectionHandler();

        private EditorSelectionHandler() {
        }

        public void selectionChanged(@NotNull SelectionEvent selectionEvent) {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)selectionEvent, (String)"selectionEvent");
            VimVisualTimer.INSTANCE.drop();
            Editor editor = selectionEvent.getEditor();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            Intrinsics.checkNotNull((Object)editor);
            IjVimEditor ijVimEditor = new IjVimEditor(editor);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Selection changed");
            }
            $this$trace$iv = logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                String string = ExceptionUtil.currentStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentStackTrace(...)");
                logger.trace(string);
            }
            Caret caret = editor.getCaretModel().getCurrentCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
            Caret caret2 = caret;
            Integer caretOffset = (Integer)ApplicationManager.getApplication().runReadAction(() -> EditorSelectionHandler.selectionChanged$lambda$2(caret2));
            VimEditor vimEditor = (VimEditor)ijVimEditor;
            Intrinsics.checkNotNull((Object)caretOffset);
            int lineStart = EngineEditorHelperKt.getLineStartForOffset((VimEditor)vimEditor, (int)caretOffset);
            int lineEnd = EngineEditorHelperKt.getLineEndForOffset((VimEditor)((VimEditor)ijVimEditor), (int)caretOffset);
            int startOffset = selectionEvent.getNewRange().getStartOffset();
            int endOffset = selectionEvent.getNewRange().getEndOffset();
            if (MouseEventsDataHolder.INSTANCE.getDragEventCount() < 3 && lineStart != lineEnd && startOffset == caretOffset) {
                if (lineEnd == endOffset - 1) {
                    caret2.setSelection(EngineEditorHelperKt.coerceOffset((VimEditor)((VimEditor)ijVimEditor), (int)(endOffset + 1)), EngineEditorHelperKt.coerceOffset((VimEditor)((VimEditor)ijVimEditor), (int)startOffset));
                } else if (lineEnd == startOffset + 1 && startOffset == endOffset) {
                    caret2.setSelection(EngineEditorHelperKt.coerceOffset((VimEditor)((VimEditor)ijVimEditor), (int)lineEnd), EngineEditorHelperKt.coerceOffset((VimEditor)((VimEditor)ijVimEditor), (int)(lineEnd - 1)));
                }
            }
            if (SelectionVimListenerSuppressor.INSTANCE.isNotLocked()) {
                logger.debug("Adjust non vim selection change");
                IdeaSelectionControl.controlNonVimSelectionChange$default(IdeaSelectionControl.INSTANCE, editor, null, 2, null);
            }
            if (document2 instanceof DocumentEx && ((DocumentEx)document2).isInEventsHandling()) {
                return;
            }
        }

        private static final Integer selectionChanged$lambda$2(Caret $caret) {
            return $caret.getOffset();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$GlobalListeners;", "", "<init>", "()V", "enable", "", "disable", "IdeaVIM"})
    public static final class GlobalListeners {
        @NotNull
        public static final GlobalListeners INSTANCE = new GlobalListeners();

        private GlobalListeners() {
        }

        public final void enable() {
            TypedAction typedAction = TypedAction.getInstance();
            if (!(typedAction.getRawHandler() instanceof VimTypedActionHandler)) {
                EventFacade eventFacade = EventFacade.getInstance();
                TypedActionHandler typedActionHandler = typedAction.getRawHandler();
                Intrinsics.checkNotNullExpressionValue((Object)typedActionHandler, (String)"getRawHandler(...)");
                eventFacade.setupTypedActionHandler(new VimTypedActionHandler(typedActionHandler));
            } else {
                StrictMode.INSTANCE.fail("typeAction expected to be non-vim.");
            }
            VimOptionGroup vimOptionGroup = VimPlugin.getOptionGroup();
            Intrinsics.checkNotNullExpressionValue((Object)vimOptionGroup, (String)"getOptionGroup(...)");
            VimOptionGroup optionGroup = vimOptionGroup;
            Option option = (Option)Options.INSTANCE.getNumber();
            EditorGroup.NumberChangeListener numberChangeListener = EditorGroup.NumberChangeListener.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)numberChangeListener, (String)"INSTANCE");
            optionGroup.addEffectiveOptionValueChangeListener(option, (EffectiveOptionValueChangeListener)numberChangeListener);
            Option option2 = (Option)IjOptions.INSTANCE.getRelativenumber();
            EditorGroup.NumberChangeListener numberChangeListener2 = EditorGroup.NumberChangeListener.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)numberChangeListener2, (String)"INSTANCE");
            optionGroup.addEffectiveOptionValueChangeListener(option2, (EffectiveOptionValueChangeListener)numberChangeListener2);
            optionGroup.addEffectiveOptionValueChangeListener((Option)Options.INSTANCE.getScrolloff(), (EffectiveOptionValueChangeListener)ScrollGroup.ScrollOptionsChangeListener.INSTANCE);
            optionGroup.addEffectiveOptionValueChangeListener((Option)Options.INSTANCE.getGuicursor(), (EffectiveOptionValueChangeListener)GuicursorChangeListener.INSTANCE);
            optionGroup.addGlobalOptionChangeListener((Option)Options.INSTANCE.getShowcmd(), (GlobalOptionChangeListener)ShowCmdOptionChangeListener.INSTANCE);
            optionGroup.addGlobalOptionChangeListener((Option)Options.INSTANCE.getShowmode(), (GlobalOptionChangeListener)ModeWidgetFactoryKt.getModeWidgetOptionListener());
            optionGroup.addGlobalOptionChangeListener((Option)Options.INSTANCE.getShowmode(), (GlobalOptionChangeListener)MacroWidgetFactoryKt.getMacroWidgetOptionListener());
            ModeWidgetFactoryKt.getModeWidgetOptionListener().onGlobalOptionChanged();
            MacroWidgetFactoryKt.getMacroWidgetOptionListener().onGlobalOptionChanged();
            EventFacade.getInstance().addEditorFactoryListener(VimEditorFactoryListener.INSTANCE, VimPlugin.getInstance().onOffDisposable);
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Disposable disposable = VimPlugin.getInstance().onOffDisposable;
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"onOffDisposable");
            MessageBusConnection busConnection = messageBus.connect(disposable);
            busConnection.subscribe(FileOpenedSyncListener.TOPIC, (Object)VimEditorFactoryListener.INSTANCE);
        }

        public final void disable() {
            EventFacade.getInstance().restoreTypedActionHandler();
            VimOptionGroup vimOptionGroup = VimPlugin.getOptionGroup();
            Intrinsics.checkNotNullExpressionValue((Object)vimOptionGroup, (String)"getOptionGroup(...)");
            VimOptionGroup optionGroup = vimOptionGroup;
            Option option = (Option)Options.INSTANCE.getNumber();
            EditorGroup.NumberChangeListener numberChangeListener = EditorGroup.NumberChangeListener.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)numberChangeListener, (String)"INSTANCE");
            optionGroup.removeEffectiveOptionValueChangeListener(option, (EffectiveOptionValueChangeListener)numberChangeListener);
            Option option2 = (Option)IjOptions.INSTANCE.getRelativenumber();
            EditorGroup.NumberChangeListener numberChangeListener2 = EditorGroup.NumberChangeListener.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)numberChangeListener2, (String)"INSTANCE");
            optionGroup.removeEffectiveOptionValueChangeListener(option2, (EffectiveOptionValueChangeListener)numberChangeListener2);
            optionGroup.removeEffectiveOptionValueChangeListener((Option)Options.INSTANCE.getScrolloff(), (EffectiveOptionValueChangeListener)ScrollGroup.ScrollOptionsChangeListener.INSTANCE);
            optionGroup.removeGlobalOptionChangeListener((Option)Options.INSTANCE.getShowcmd(), (GlobalOptionChangeListener)ShowCmdOptionChangeListener.INSTANCE);
            optionGroup.removeGlobalOptionChangeListener((Option)Options.INSTANCE.getShowmode(), (GlobalOptionChangeListener)ModeWidgetFactoryKt.getModeWidgetOptionListener());
            optionGroup.removeGlobalOptionChangeListener((Option)Options.INSTANCE.getShowmode(), (GlobalOptionChangeListener)MacroWidgetFactoryKt.getMacroWidgetOptionListener());
            optionGroup.removeEffectiveOptionValueChangeListener((Option)Options.INSTANCE.getGuicursor(), (EffectiveOptionValueChangeListener)GuicursorChangeListener.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$SelectionSource;", "", "<init>", "(Ljava/lang/String;I)V", "MOUSE", "OTHER", "IdeaVIM"})
    public static final class SelectionSource
    extends Enum<SelectionSource> {
        public static final /* enum */ SelectionSource MOUSE = new SelectionSource();
        public static final /* enum */ SelectionSource OTHER = new SelectionSource();
        private static final /* synthetic */ SelectionSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SelectionSource[] values() {
            return (SelectionSource[])$VALUES.clone();
        }

        public static SelectionSource valueOf(String value) {
            return Enum.valueOf(SelectionSource.class, value);
        }

        @NotNull
        public static EnumEntries<SelectionSource> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = selectionSourceArray = new SelectionSource[]{SelectionSource.MOUSE, SelectionSource.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "()V", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "IdeaVIM"})
    public static final class VimDocumentListener
    implements DocumentListener {
        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VimMarkServiceImpl.MarkUpdater.INSTANCE.beforeDocumentChange(event);
            IjVimSearchGroup.DocumentSearchListener.Companion.getINSTANCE().beforeDocumentChange(event);
            IjVimRedrawService.RedrawListener.INSTANCE.beforeDocumentChange(event);
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VimMarkServiceImpl.MarkUpdater.INSTANCE.documentChanged(event);
            IjVimSearchGroup.DocumentSearchListener.Companion.getINSTANCE().documentChanged(event);
            IjVimRedrawService.RedrawListener.INSTANCE.documentChanged(event);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "Lcom/intellij/openapi/fileEditor/FileOpenedSyncListener;", "<init>", "()V", "openingEditorKey", "Lcom/intellij/openapi/util/Key;", "Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimEditorFactoryListener$OpeningEditor;", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "fileOpenedSync", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "getOwningEditorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "editor", "Lcom/intellij/openapi/editor/Editor;", "OpeningEditor", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$VimEditorFactoryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,914:1\n1869#2:915\n1740#2,3:927\n1870#2:930\n1761#2,2:931\n808#2,11:933\n1761#2,3:944\n1763#2:947\n4225#3,11:916\n*S KotlinDebug\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$VimEditorFactoryListener\n*L\n527#1:915\n541#1:927,3\n527#1:930\n562#1:931,2\n563#1:933,11\n563#1:944,3\n562#1:947\n541#1:916,11\n*E\n"})
    private static final class VimEditorFactoryListener
    implements EditorFactoryListener,
    FileOpenedSyncListener {
        @NotNull
        public static final VimEditorFactoryListener INSTANCE = new VimEditorFactoryListener();
        @NotNull
        private static final Key<OpeningEditor> openingEditorKey = new Key("IdeaVim::OpeningEditor");

        private VimEditorFactoryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            block15: {
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (HelperKt.vimDisabled(event.getEditor())) {
                            return;
                        }
                        v0 = event.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getEditor(...)");
                        openingEditor = VimListenerManagerKt.access$getOpeningEditor(v0);
                        if (event.getEditor().getVirtualFile() == null || event.getEditor().getEditorKind() != EditorKind.MAIN_EDITOR) break block13;
                        if (openingEditor != null) break block14;
                    }
                    scenario = openingEditor == null && VimListenerManager.access$getFirstEditorInitialised$p() == false ? LocalOptionInitialisationScenario.FALLBACK : (openingEditor == null ? LocalOptionInitialisationScenario.EDIT : LocalOptionInitialisationScenario.NEW);
                    var4_5 = (AutoCloseable)SlowOperations.knownIssue((String)"VIM-3648");
                    var5_7 = null;
                    try {
                        it = (AccessToken)var4_5;
                        $i$a$-use-VimListenerManager$VimEditorFactoryListener$editorCreated$1 = false;
                        v1 = event.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getEditor(...)");
                        v2 = openingEditor;
                        if (v2 == null || (v2 = IjVimEditorKt.getVim(v2)) == null) {
                            v2 = VimInjectorKt.getInjector().getFallbackWindow();
                        }
                        EditorListeners.INSTANCE.add(v1, (VimEditor)v2, scenario);
                        it = Unit.INSTANCE;
                    }
                    catch (Throwable $i$a$-use-VimListenerManager$VimEditorFactoryListener$editorCreated$1) {
                        var5_7 = $i$a$-use-VimListenerManager$VimEditorFactoryListener$editorCreated$1;
                        throw $i$a$-use-VimListenerManager$VimEditorFactoryListener$editorCreated$1;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var4_5, (Throwable)var5_7);
                    }
                    VimListenerManager.access$setFirstEditorInitialised$p(true);
                    break block15;
                }
                v3 = openingEditor.getProject();
                if (v3 == null) {
                    return;
                }
                project = v3;
                v4 = openingEditor.getVirtualFile();
                if (v4 == null) {
                    return;
                }
                virtualFile = v4;
                manager = FileEditorManager.getInstance((Project)project);
                v5 = manager.getComposite(virtualFile);
                v6 = isPreview = v5 != null ? v5.isPreview() : false;
                if (!UISettings.Companion.getInstance().getReuseNotModifiedTabs()) ** GOTO lbl-1000
                var9_15 = manager.getComposite(virtualFile);
                v7 = var9_15 instanceof EditorComposite != false ? (EditorComposite)var9_15 : null;
                if (v7 != null) {
                    composite = v7;
                    $i$a$-let-VimListenerManager$VimEditorFactoryListener$editorCreated$canBeReused$1 = false;
                    v8 = !composite.isPinned() && !composite.isModified();
                } else {
                    v8 = false;
                }
                if (v8) {
                    v9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = false;
                }
                canBeReused = v9;
                owningEditorWindow = this.getOwningEditorWindow(openingEditor);
                event.getEditor().putUserData(VimEditorFactoryListener.openingEditorKey, (Object)new OpeningEditor(openingEditor, owningEditorWindow, isPreview, canBeReused));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (HelperKt.vimDisabled(event.getEditor())) {
                return;
            }
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            VimEditor vimEditor = IjVimEditorKt.getVim(editor);
            Editor editor2 = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            EditorListeners.INSTANCE.remove(editor2);
            VimInjectorKt.getInjector().getListenersNotifier().notifyEditorReleased(vimEditor);
            VimInjectorKt.getInjector().getMarkService().editorReleased(vimEditor);
            AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"VIM-3658");
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                Editor editor3 = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
                OptionGroup.Companion.editorReleased(editor3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
            Iterable $this$forEach$iv = editorsWithProviders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LocalOptionInitialisationScenario scenario;
                boolean bl;
                boolean isInSameSplit;
                OpeningEditor openingEditor;
                TextEditor editor;
                block8: {
                    FileEditorWithProvider it = (FileEditorWithProvider)element$iv;
                    boolean bl2 = false;
                    FileEditor fileEditor = it.getFileEditor();
                    TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                    if (textEditor == null || (textEditor = textEditor.getEditor()) == null) continue;
                    editor = textEditor;
                    boolean bl3 = false;
                    if (HelperKt.vimDisabled((Editor)editor) || UserDataManager.getVimInitialised((Editor)editor)) continue;
                    openingEditor = (OpeningEditor)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)editor), openingEditorKey);
                    EditorWindow owningEditorWindow = INSTANCE.getOwningEditorWindow((Editor)editor);
                    OpeningEditor openingEditor2 = openingEditor;
                    isInSameSplit = Intrinsics.areEqual((Object)owningEditorWindow, (Object)(openingEditor2 != null ? openingEditor2.getOwningEditorWindow() : null));
                    if (editor.getProject() != null) {
                        void $this$all$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Project p;
                        boolean bl4 = false;
                        FileEditor[] fileEditorArray = FileEditorManagerEx.Companion.getInstanceEx(p).getAllEditors();
                        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
                        Object $this$filterIsInstance$iv = fileEditorArray;
                        boolean $i$f$filterIsInstance = false;
                        Object[] objectArray = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof TextEditor)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                TextEditor textEditor2 = (TextEditor)element$iv2;
                                boolean bl5 = false;
                                OpeningEditor openingEditor3 = openingEditor;
                                if (!Intrinsics.areEqual((Object)textEditor2.getEditor(), (Object)(openingEditor3 != null ? openingEditor3.getEditor() : null))) continue;
                                bl = false;
                                break block8;
                            }
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                }
                boolean openingEditorIsClosed = bl;
                LocalOptionInitialisationScenario localOptionInitialisationScenario = openingEditor == null ? (!firstEditorInitialised ? LocalOptionInitialisationScenario.FALLBACK : LocalOptionInitialisationScenario.EDIT) : (scenario = Intrinsics.areEqual((Object)editor.getDocument(), (Object)openingEditor.getEditor().getDocument()) ? LocalOptionInitialisationScenario.SPLIT : ((openingEditor.getCanBeReused() || openingEditor.isPreview()) && isInSameSplit && openingEditorIsClosed ? LocalOptionInitialisationScenario.EDIT : LocalOptionInitialisationScenario.NEW));
                OpeningEditor openingEditor4 = openingEditor;
                if (openingEditor4 == null || (openingEditor4 = openingEditor4.getEditor()) == null || (openingEditor4 = IjVimEditorKt.getVim((Editor)openingEditor4)) == null) {
                    openingEditor4 = VimInjectorKt.getInjector().getFallbackWindow();
                }
                EditorListeners.INSTANCE.add((Editor)editor, (VimEditor)openingEditor4, scenario);
                firstEditorInitialised = true;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final EditorWindow getOwningEditorWindow(Editor editor) {
            EditorWindow editorWindow;
            block12: {
                Project project = editor.getProject();
                if (project != null) {
                    Project p = project;
                    boolean bl = false;
                    EditorWindow[] editorWindowArray = FileEditorManagerEx.Companion.getInstanceEx(p).getWindows();
                    int n = editorWindowArray.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl2;
                        EditorWindow editorWindow2;
                        block11: {
                            EditorWindow editorWindow3 = editorWindow2 = editorWindowArray[i];
                            boolean bl3 = false;
                            Iterable $this$any$iv = editorWindow3.getAllComposites();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    boolean bl4;
                                    block10: {
                                        void $this$any$iv2;
                                        void $this$filterIsInstanceTo$iv$iv;
                                        EditorComposite composite = (EditorComposite)element$iv;
                                        boolean bl5 = false;
                                        Iterable $this$filterIsInstance$iv = composite.getAllEditors();
                                        boolean $i$f$filterIsInstance = false;
                                        Iterable iterable = $this$filterIsInstance$iv;
                                        Collection destination$iv$iv = new ArrayList();
                                        boolean $i$f$filterIsInstanceTo = false;
                                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                            if (!(element$iv$iv instanceof TextEditor)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                                        boolean $i$f$any2 = false;
                                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                            bl4 = false;
                                        } else {
                                            for (Object element$iv2 : $this$any$iv2) {
                                                TextEditor it = (TextEditor)element$iv2;
                                                boolean bl6 = false;
                                                if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)editor)) continue;
                                                bl4 = true;
                                                break block10;
                                            }
                                            bl4 = false;
                                        }
                                    }
                                    if (!bl4) continue;
                                    bl2 = true;
                                    break block11;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        editorWindow = editorWindow2;
                        break block12;
                    }
                    editorWindow = null;
                } else {
                    editorWindow = null;
                }
            }
            return editorWindow;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimEditorFactoryListener$OpeningEditor;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "owningEditorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "isPreview", "", "canBeReused", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;ZZ)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getOwningEditorWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "()Z", "getCanBeReused", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "IdeaVIM"})
        private static final class OpeningEditor {
            @NotNull
            private final Editor editor;
            @Nullable
            private final EditorWindow owningEditorWindow;
            private final boolean isPreview;
            private final boolean canBeReused;

            public OpeningEditor(@NotNull Editor editor, @Nullable EditorWindow owningEditorWindow, boolean isPreview, boolean canBeReused) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.editor = editor;
                this.owningEditorWindow = owningEditorWindow;
                this.isPreview = isPreview;
                this.canBeReused = canBeReused;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            @Nullable
            public final EditorWindow getOwningEditorWindow() {
                return this.owningEditorWindow;
            }

            public final boolean isPreview() {
                return this.isPreview;
            }

            public final boolean getCanBeReused() {
                return this.canBeReused;
            }

            @NotNull
            public final Editor component1() {
                return this.editor;
            }

            @Nullable
            public final EditorWindow component2() {
                return this.owningEditorWindow;
            }

            public final boolean component3() {
                return this.isPreview;
            }

            public final boolean component4() {
                return this.canBeReused;
            }

            @NotNull
            public final OpeningEditor copy(@NotNull Editor editor, @Nullable EditorWindow owningEditorWindow, boolean isPreview, boolean canBeReused) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return new OpeningEditor(editor, owningEditorWindow, isPreview, canBeReused);
            }

            public static /* synthetic */ OpeningEditor copy$default(OpeningEditor openingEditor, Editor editor, EditorWindow editorWindow, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    editor = openingEditor.editor;
                }
                if ((n & 2) != 0) {
                    editorWindow = openingEditor.owningEditorWindow;
                }
                if ((n & 4) != 0) {
                    bl = openingEditor.isPreview;
                }
                if ((n & 8) != 0) {
                    bl2 = openingEditor.canBeReused;
                }
                return openingEditor.copy(editor, editorWindow, bl, bl2);
            }

            @NotNull
            public String toString() {
                return "OpeningEditor(editor=" + this.editor + ", owningEditorWindow=" + this.owningEditorWindow + ", isPreview=" + this.isPreview + ", canBeReused=" + this.canBeReused + ")";
            }

            public int hashCode() {
                int result = this.editor.hashCode();
                result = result * 31 + (this.owningEditorWindow == null ? 0 : this.owningEditorWindow.hashCode());
                result = result * 31 + Boolean.hashCode(this.isPreview);
                result = result * 31 + Boolean.hashCode(this.canBeReused);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OpeningEditor)) {
                    return false;
                }
                OpeningEditor openingEditor = (OpeningEditor)other;
                if (!Intrinsics.areEqual((Object)this.editor, (Object)openingEditor.editor)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.owningEditorWindow, (Object)openingEditor.owningEditorWindow)) {
                    return false;
                }
                if (this.isPreview != openingEditor.isPreview) {
                    return false;
                }
                return this.canBeReused == openingEditor.canBeReused;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "IdeaVIM"})
    public static final class VimFileEditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VimPlugin.isNotEnabled() || !ClientId.Companion.isCurrentlyUnderLocalId()) {
                return;
            }
            MotionGroup.Companion.fileEditorManagerSelectionChangedCallback(event);
            FileGroup.Companion.fileEditorManagerSelectionChangedCallback(event);
            VimPlugin.getSearch().fileEditorManagerSelectionChangedCallback(event);
            IjVimRedrawService.Companion.fileEditorManagerSelectionChangedCallback(event);
            VimLastSelectedEditorTracker.INSTANCE.setLastSelectedEditor$IdeaVIM(event.getNewEditor());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimFocusListener;", "Lcom/intellij/openapi/editor/ex/FocusChangeListener;", "<init>", "()V", "focusGained", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "focusLost", "IdeaVIM"})
    private static final class VimFocusListener
    implements FocusChangeListener {
        @NotNull
        public static final VimFocusListener INSTANCE = new VimFocusListener();

        private VimFocusListener() {
        }

        public void focusGained(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (HelperKt.vimDisabled(editor)) {
                return;
            }
            VimInjectorKt.getInjector().getListenersNotifier().notifyEditorFocusGained(IjVimEditorKt.getVim(editor));
        }

        public void focusLost(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (HelperKt.vimDisabled(editor)) {
                return;
            }
            VimInjectorKt.getInjector().getListenersNotifier().notifyEditorFocusLost(IjVimEditorKt.getVim(editor));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0006J\u0017\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0011R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/listener/VimListenerManager$VimLastSelectedEditorTracker;", "", "<init>", "()V", "selectedEditors", "Ljava/util/WeakHashMap;", "Lcom/intellij/openapi/project/Project;", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Editor;", "getLastSelectedEditor", "project", "setLastSelectedEditor", "", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "setLastSelectedEditor$IdeaVIM", "resetLastSelectedEditor", "resetLastSelectedEditor$IdeaVIM", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimListenerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimListenerManager.kt\ncom/maddyhome/idea/vim/listener/VimListenerManager$VimLastSelectedEditorTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,914:1\n1#2:915\n*E\n"})
    public static final class VimLastSelectedEditorTracker {
        @NotNull
        public static final VimLastSelectedEditorTracker INSTANCE = new VimLastSelectedEditorTracker();
        @NotNull
        private static final WeakHashMap<Project, WeakReference<Editor>> selectedEditors = new WeakHashMap();

        private VimLastSelectedEditorTracker() {
        }

        @Nullable
        public final Editor getLastSelectedEditor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WeakReference<Editor> weakReference = selectedEditors.get(project);
            return weakReference != null ? (Editor)weakReference.get() : null;
        }

        public final void setLastSelectedEditor$IdeaVIM(@Nullable FileEditor fileEditor) {
            block1: {
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if (textEditor == null || (textEditor = textEditor.getEditor()) == null) break block1;
                TextEditor editor = textEditor;
                boolean bl = false;
                Project project = editor.getProject();
                if (project != null) {
                    Project project2 = project;
                    boolean bl2 = false;
                    ((Map)selectedEditors).put(project2, new WeakReference<TextEditor>(editor));
                }
            }
        }

        @TestOnly
        public final void resetLastSelectedEditor$IdeaVIM(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            selectedEditors.remove(project);
        }
    }
}

