/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.maddyhome.idea.vim.api.VimApplicationBase;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.ide.ClionNovaDetectorKt;
import com.maddyhome.idea.vim.ide.RiderDetectorKt;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J!\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimApplication;", "Lcom/maddyhome/idea/vim/api/VimApplicationBase;", "<init>", "()V", "isMainThread", "", "invokeLater", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "action", "Lkotlin/Function0;", "invokeAndWait", "isUnitTest", "isInternal", "postKey", "stroke", "Ljavax/swing/KeyStroke;", "runWriteAction", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "runReadAction", "currentStackTrace", "", "runAfterGotFocus", "runnable", "Ljava/lang/Runnable;", "isOctopusEnabled", "createKeyEvent", "Ljava/awt/event/KeyEvent;", "component", "Ljava/awt/Component;", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIjVimApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjVimApplication.kt\ncom/maddyhome/idea/vim/newapi/IjVimApplication\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,106:1\n39#2:107\n*S KotlinDebug\n*F\n+ 1 IjVimApplication.kt\ncom/maddyhome/idea/vim/newapi/IjVimApplication\n*L\n103#1:107\n*E\n"})
public final class IjVimApplication
extends VimApplicationBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    public boolean isMainThread() {
        return ApplicationManager.getApplication().isDispatchThread();
    }

    public void invokeLater(@NotNull VimEditor editor, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ApplicationManager.getApplication().invokeLater(() -> IjVimApplication.invokeLater$lambda$0(action), ModalityState.stateForComponent((Component)((IjVimEditor)editor).getEditor().getComponent()));
    }

    public void invokeLater(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ApplicationManager.getApplication().invokeLater(() -> IjVimApplication.invokeLater$lambda$1(action));
    }

    public void invokeAndWait(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ApplicationManager.getApplication().invokeAndWait(() -> IjVimApplication.invokeAndWait$lambda$0(action));
    }

    public boolean isUnitTest() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public boolean isInternal() {
        return ApplicationManager.getApplication().isInternal();
    }

    public void postKey(@NotNull KeyStroke stroke, @NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Container container = SwingUtilities.getAncestorOfClass(Window.class, IjVimEditorKt.getIj(editor).getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getAncestorOfClass(...)");
        Component component = container;
        KeyEvent event = this.createKeyEvent(stroke, component);
        ApplicationManager.getApplication().invokeLater(() -> IjVimApplication.postKey$lambda$0(event));
    }

    public <T> T runWriteAction(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)ApplicationManager.getApplication().runWriteAction(() -> IjVimApplication.runWriteAction$lambda$0(action));
    }

    public <T> T runReadAction(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)ApplicationManager.getApplication().runReadAction(() -> IjVimApplication.runReadAction$lambda$0(action));
    }

    @NotNull
    public String currentStackTrace() {
        String string = ExceptionUtil.currentStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentStackTrace(...)");
        return string;
    }

    public void runAfterGotFocus(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        UiHelper.runAfterGotFocus(runnable);
    }

    public boolean isOctopusEnabled() {
        String property;
        if (RiderDetectorKt.isRider() || PlatformUtils.isJetBrainsClient() || ClionNovaDetectorKt.isClionNova()) {
            return false;
        }
        String string = System.getProperty("octopus.handler");
        if (string == null) {
            string = "true";
        }
        if (StringsKt.isBlank((CharSequence)(property = string))) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    private final KeyEvent createKeyEvent(KeyStroke stroke, Component component) {
        return new KeyEvent(component, stroke.getKeyChar() == '\uffff' ? 401 : 400, System.currentTimeMillis(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar());
    }

    private static final void invokeLater$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void invokeLater$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void invokeAndWait$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final void postKey$lambda$0(KeyEvent $event) {
        if (logger.isDebug()) {
            logger.debug("posting " + $event);
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent($event);
    }

    private static final Object runWriteAction$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final Object runReadAction$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(IjVimApplication.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimApplication$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

