/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IJSwingUtilities;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOutputPanel;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.helper.UserDataManager;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.ui.ExPanelBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 :2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u000389:B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010'H\u0016J\u000e\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u0017J\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020\u001eH\u0002J\u0006\u0010-\u001a\u00020\u001eJ\u0006\u0010.\u001a\u00020\u001eJ\u0006\u0010/\u001a\u00020\u001eJ\u0006\u00100\u001a\u00020\u001eJ\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020\u001eH\u0002J\u0014\u00105\u001a\u00020\u001e2\n\b\u0002\u00106\u001a\u0004\u0018\u000107H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u00103\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001a\u00a8\u0006;"}, d2={"Lcom/maddyhome/idea/vim/ui/ExOutputPanel;", "Lcom/intellij/ui/components/JBPanel;", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "myLabel", "Ljavax/swing/JLabel;", "getMyLabel", "()Ljavax/swing/JLabel;", "myText", "Ljavax/swing/JTextArea;", "myScrollPane", "Ljavax/swing/JScrollPane;", "myAdapter", "Ljava/awt/event/ComponentAdapter;", "myLineHeight", "", "myOldGlass", "Ljavax/swing/JComponent;", "myOldLayout", "Ljava/awt/LayoutManager;", "myWasOpaque", "", "myActive", "getMyActive", "()Z", "setMyActive", "(Z)V", "updateUI", "", "data", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getForeground", "Ljava/awt/Color;", "getBackground", "deactivate", "refocusOwningEditor", "activate", "setFontForElements", "scrollLine", "scrollPage", "scrollHalfPage", "onBadKey", "scrollOffset", "more", "isAtEnd", "positionPanel", "close", "key", "Ljavax/swing/KeyStroke;", "MoreKeyListener", "LafListener", "Companion", "IdeaVIM"})
public final class ExOutputPanel
extends JBPanel<ExOutputPanel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JTextArea myText;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final ComponentAdapter myAdapter;
    private int myLineHeight;
    @Nullable
    private JComponent myOldGlass;
    @Nullable
    private LayoutManager myOldLayout;
    private boolean myWasOpaque;
    private boolean myActive;
    @NotNull
    private static final VimLogger LOG = VimInjectorKt.getInjector().getLogger(ExOutputPanel.class);

    private ExOutputPanel(Editor myEditor) {
        this.myEditor = myEditor;
        this.myLabel = new JLabel("more");
        this.myText = new JTextArea();
        this.myScrollPane = (JScrollPane)new JBScrollPane((Component)this.myText, 20, 31);
        BorderLayout layout = new BorderLayout(0, 0);
        this.setLayout(layout);
        this.add(this.myScrollPane, "Center");
        this.add(this.myLabel, "South");
        this.myText.setEditable(false);
        this.myText.setLineWrap(true);
        this.myAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.positionPanel();
            }
        };
        MoreKeyListener moreKeyListener = new MoreKeyListener();
        this.addKeyListener(moreKeyListener);
        this.myText.addKeyListener(moreKeyListener);
        ClientProperty.putRecursive((JComponent)((JComponent)((Object)this)), (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
        this.updateUI();
    }

    @NotNull
    public final JLabel getMyLabel() {
        return this.myLabel;
    }

    public final boolean getMyActive() {
        return this.myActive;
    }

    public final void setMyActive(boolean bl) {
        this.myActive = bl;
    }

    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)((Object)new ExPanelBorder()));
        if (this.myText != null && this.myLabel != null && this.myScrollPane != null) {
            this.setFontForElements();
            this.myText.setBorder(null);
            this.myScrollPane.setBorder(null);
            this.myLabel.setForeground(this.myText.getForeground());
            this.positionPanel();
        }
    }

    @Nullable
    public final String getText() {
        return this.myText.getText();
    }

    public final void setText(@Nullable String data) {
        String string = data;
        Intrinsics.checkNotNull((Object)string);
        String data2 = string;
        if (!(((CharSequence)data2).length() == 0) && data2.charAt(data2.length() - 1) == '\n') {
            data2 = StringsKt.dropLast((String)data2, (int)1);
        }
        this.myText.setText(data2);
        this.myText.setFont(UiHelper.selectEditorFont(this.myEditor, data2));
        this.myText.setCaretPosition(0);
        if (!(((CharSequence)data2).length() == 0)) {
            this.activate();
        }
    }

    @Nullable
    public Color getForeground() {
        if (this.myText == null) {
            return super.getForeground();
        }
        return this.myText.getForeground();
    }

    @Nullable
    public Color getBackground() {
        if (this.myText == null) {
            return super.getBackground();
        }
        return this.myText.getBackground();
    }

    public final void deactivate(boolean refocusOwningEditor) {
        if (!this.myActive) {
            return;
        }
        this.myActive = false;
        this.myText.setText("");
        if (refocusOwningEditor) {
            JComponent jComponent = this.myEditor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            UiHelper.requestFocus(jComponent);
        }
        if (this.myOldGlass != null) {
            JComponent jComponent = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent);
            jComponent.removeComponentListener(this.myAdapter);
            JComponent jComponent2 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent2);
            jComponent2.setVisible(false);
            JComponent jComponent3 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent3);
            jComponent3.remove((Component)((Object)this));
            JComponent jComponent4 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent4);
            jComponent4.setOpaque(this.myWasOpaque);
            JComponent jComponent5 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent5);
            jComponent5.setLayout(this.myOldLayout);
        }
    }

    public final void activate() {
        JRootPane root = SwingUtilities.getRootPane(this.myEditor.getContentComponent());
        this.myOldGlass = (JComponent)root.getGlassPane();
        if (this.myOldGlass != null) {
            JComponent jComponent = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent);
            this.myOldLayout = jComponent.getLayout();
            JComponent jComponent2 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent2);
            this.myWasOpaque = jComponent2.isOpaque();
            JComponent jComponent3 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent3);
            jComponent3.setLayout(null);
            JComponent jComponent4 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent4);
            jComponent4.setOpaque(false);
            JComponent jComponent5 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent5);
            jComponent5.add((Component)((Object)this));
            JComponent jComponent6 = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent6);
            jComponent6.addComponentListener(this.myAdapter);
        }
        this.setFontForElements();
        this.positionPanel();
        if (this.myOldGlass != null) {
            JComponent jComponent = this.myOldGlass;
            Intrinsics.checkNotNull((Object)jComponent);
            jComponent.setVisible(true);
        }
        this.myActive = true;
        UiHelper.requestFocus(this.myText);
    }

    private final void setFontForElements() {
        String string = this.myText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.myText.setFont(UiHelper.selectEditorFont(this.myEditor, string));
        String string2 = this.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, string2));
    }

    public final void scrollLine() {
        this.scrollOffset(this.myLineHeight);
    }

    public final void scrollPage() {
        this.scrollOffset(this.myScrollPane.getVerticalScrollBar().getVisibleAmount());
    }

    public final void scrollHalfPage() {
        double sa = (double)this.myScrollPane.getVerticalScrollBar().getVisibleAmount() / 2.0;
        double offset = Math.ceil(sa / (double)this.myLineHeight) * (double)this.myLineHeight;
        this.scrollOffset((int)offset);
    }

    public final void onBadKey() {
        this.myLabel.setText(VimInjectorKt.getInjector().getMessages().message("message.ex.output.more.prompt.full", new Object[0]));
        String string = this.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, string));
    }

    private final void scrollOffset(int more) {
        int val = this.myScrollPane.getVerticalScrollBar().getValue();
        this.myScrollPane.getVerticalScrollBar().setValue(val + more);
        this.myScrollPane.getHorizontalScrollBar().setValue(0);
        if (val + more >= this.myScrollPane.getVerticalScrollBar().getMaximum() - this.myScrollPane.getVerticalScrollBar().getVisibleAmount()) {
            this.myLabel.setText(VimInjectorKt.getInjector().getMessages().message("message.ex.output.end.prompt", new Object[0]));
        } else {
            this.myLabel.setText(VimInjectorKt.getInjector().getMessages().message("message.ex.output.more.prompt", new Object[0]));
        }
        String string = this.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.myLabel.setFont(UiHelper.selectEditorFont(this.myEditor, string));
    }

    public final boolean isAtEnd() {
        int val = this.myScrollPane.getVerticalScrollBar().getValue();
        return val >= this.myScrollPane.getVerticalScrollBar().getMaximum() - this.myScrollPane.getVerticalScrollBar().getVisibleAmount();
    }

    private final void positionPanel() {
        JComponent jComponent = this.myEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, contentComponent);
        JRootPane rootPane = SwingUtilities.getRootPane(contentComponent);
        if (scroll == null || rootPane == null) {
            return;
        }
        this.setSize(scroll.getSize());
        this.myLineHeight = this.myText.getFontMetrics(this.myText.getFont()).getHeight();
        String string = this.myText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int count = ExOutputPanel.Companion.countLines(string);
        int visLines = this.getSize().height / this.myLineHeight - 1;
        int lines = Math.min(count, visLines);
        this.setSize(this.getSize().width, lines * this.myLineHeight + this.myLabel.getPreferredSize().height + this.getBorder().getBorderInsets((Component)((Component)((Object)this))).top * 2);
        int height = this.getSize().height;
        Rectangle bounds = scroll.getBounds();
        bounds.translate(0, scroll.getHeight() - height);
        bounds.height = height;
        Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), rootPane.getGlassPane());
        bounds.setLocation(pos);
        this.setBounds(bounds);
        this.myScrollPane.getVerticalScrollBar().setValue(0);
        if (!VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getMore()) {
            this.scrollOffset(100000);
        } else {
            this.scrollOffset(0);
        }
    }

    @JvmOverloads
    public final void close(@Nullable KeyStroke key) {
        ApplicationManager.getApplication().invokeLater(() -> ExOutputPanel.close$lambda$0(this, key));
    }

    public static /* synthetic */ void close$default(ExOutputPanel exOutputPanel, KeyStroke keyStroke, int n, Object object) {
        if ((n & 1) != 0) {
            keyStroke = null;
        }
        exOutputPanel.close(keyStroke);
    }

    @JvmOverloads
    public final void close() {
        ExOutputPanel.close$default(this, null, 1, null);
    }

    private static final void close$lambda$0(ExOutputPanel this$0, KeyStroke $key) {
        this$0.deactivate(true);
        Project project = this$0.myEditor.getProject();
        if (project != null && $key != null && $key.getKeyChar() != '\n') {
            List keys = new ArrayList(1);
            keys.add($key);
            if (LOG.isTrace()) {
                LOG.trace("Adding new keys to keyStack as part of playback. State before adding keys: " + KeyHandler.Companion.getInstance().getKeyStack().dump());
            }
            KeyHandler.Companion.getInstance().getKeyStack().addKeys(keys);
            ExecutionContext context = VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext((VimEditor)new IjVimEditor(this$0.myEditor));
            VimPlugin.getMacro().playbackKeys((VimEditor)new IjVimEditor(this$0.myEditor), context, 1);
        }
    }

    public /* synthetic */ ExOutputPanel(Editor myEditor, DefaultConstructorMarker $constructor_marker) {
        this(myEditor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/ui/ExOutputPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getNullablePanel", "Lcom/maddyhome/idea/vim/ui/ExOutputPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isPanelActive", "", "getInstance", "countLines", "", "text", "", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nExOutputPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExOutputPanel.kt\ncom/maddyhome/idea/vim/ui/ExOutputPanel$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n1#2:367\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ExOutputPanel getNullablePanel(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return UserDataManager.getVimMorePanel(editor);
        }

        public final boolean isPanelActive(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.getNullablePanel(editor) != null;
        }

        @NotNull
        public final ExOutputPanel getInstance(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ExOutputPanel panel2 = this.getNullablePanel(editor);
            if (panel2 == null) {
                panel2 = new ExOutputPanel(editor, null);
                UserDataManager.setVimMorePanel(editor, panel2);
            }
            return panel2;
        }

        private final int countLines(String text) {
            if (((CharSequence)text).length() == 0) {
                return 0;
            }
            int count = 0;
            int pos = 0;
            pos = -1;
            while (true) {
                int n;
                int it = n = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)(pos + 1), (boolean)false, (int)4, null);
                boolean bl = false;
                pos = it;
                if (n == -1) break;
                ++count;
            }
            if (text.charAt(text.length() - 1) != '\n') {
                ++count;
            }
            return count;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/ui/ExOutputPanel$LafListener;", "Lcom/intellij/ide/ui/LafManagerListener;", "<init>", "()V", "lookAndFeelChanged", "", "source", "Lcom/intellij/ide/ui/LafManager;", "IdeaVIM"})
    public static final class LafListener
    implements LafManagerListener {
        public void lookAndFeelChanged(@NotNull LafManager source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            for (VimEditor vimEditor : VimInjectorKt.getInjector().getEditorGroup().getEditors()) {
                Intrinsics.checkNotNull((Object)vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.newapi.IjVimEditor");
                Editor editor = ((IjVimEditor)vimEditor).getEditor();
                if (!Companion.isPanelActive(editor)) continue;
                IJSwingUtilities.updateComponentTreeUI((Component)((Component)((Object)Companion.getInstance(editor))));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/ui/ExOutputPanel$MoreKeyListener;", "Ljava/awt/event/KeyAdapter;", "<init>", "()V", "keyTyped", "", "e", "Ljava/awt/event/KeyEvent;", "IdeaVIM"})
    private static final class MoreKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VimOutputPanel vimOutputPanel = VimInjectorKt.getInjector().getOutputPanel().getCurrentOutputPanel();
            if (vimOutputPanel == null) {
                return;
            }
            VimOutputPanel currentPanel = vimOutputPanel;
            int keyCode = e.getKeyCode();
            char keyChar = e.getKeyChar();
            int modifiers = e.getModifiersEx();
            KeyStroke keyStroke = keyChar == '\uffff' ? KeyStroke.getKeyStroke(keyCode, modifiers) : KeyStroke.getKeyStroke(Character.valueOf(keyChar), modifiers);
            Intrinsics.checkNotNull((Object)keyStroke);
            currentPanel.handleKey(keyStroke);
        }
    }
}

