/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.icons.VimIcons;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.troubleshooting.Troubleshooter;
import com.maddyhome.idea.vim.ui.VimRcFileState;
import com.maddyhome.idea.vim.vimscript.services.VimRcService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/ui/ReloadVimRc;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "IdeaVIM"})
public final class ReloadVimRc
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            ReloadVimRc $this$update_u24lambda_u240 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor2 = editor;
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            ReloadVimRc $this$update_u24lambda_u241 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (VimRcFileState.INSTANCE.getFilePath() != null && !Intrinsics.areEqual((Object)FileUtil.toSystemDependentName((String)virtualFile2.getPath()), (Object)VimRcFileState.INSTANCE.getFilePath())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (VimRcFileState.INSTANCE.getFilePath() == null) {
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"ideavimrc", (boolean)false, (int)2, null)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        boolean sameDoc = VimRcFileState.INSTANCE.equalTo(document);
        e.getPresentation().setIcon(sameDoc ? VimIcons.IDEAVIM : AllIcons.Actions.BuildLoadChanges);
        e.getPresentation().setText(sameDoc ? MessageHelper.message("action.ReloadVimRc.no.changes.text") : MessageHelper.message("action.ReloadVimRc.text"));
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        VimInjectorKt.getInjector().getKeyGroup().removeKeyMapping((MappingOwner)MappingOwner.IdeaVim.InitScript.INSTANCE);
        Troubleshooter.Companion.getInstance().removeByType("old-action-notation-in-mappings");
        VimRcService.executeIdeaVimRc((VimEditor)IjVimEditorKt.getVim(editor2));
    }
}

