/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.openapi.util.SystemInfo;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.helper.EngineStringHelper;
import com.maddyhome.idea.vim.ui.ex.ExEntryPanel;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\"\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExDocument;", "Ljavax/swing/text/DefaultStyledDocument;", "<init>", "()V", "value", "", "isOverwrite", "()Z", "setSpecialKeyForeground", "", "fg", "Ljava/awt/Color;", "toggleInsertReplace", "insertString", "offs", "", "str", "", "a", "Ljavax/swing/text/AttributeSet;", "addInputMethodAttributes", "attributeSet", "ExDocumentFilter", "Companion", "IdeaVIM"})
public final class ExDocument
extends DefaultStyledDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isOverwrite;
    @NotNull
    public static final String SPECIAL_KEY_STYLE_NAME = "SpecialKey";
    @NotNull
    public static final String NON_PRINTABLE_ELEMENT_NAME = "non-printable";

    public ExDocument() {
        this.setDocumentFilter(new ExDocumentFilter());
        Style specialStyle = this.addStyle(SPECIAL_KEY_STYLE_NAME, null);
        Style nonPrintableStyle = this.addStyle(NON_PRINTABLE_ELEMENT_NAME, specialStyle);
        nonPrintableStyle.addAttribute("$ename", NON_PRINTABLE_ELEMENT_NAME);
    }

    public final boolean isOverwrite() {
        return this.isOverwrite;
    }

    public final void setSpecialKeyForeground(@NotNull Color fg) {
        Intrinsics.checkNotNullParameter((Object)fg, (String)"fg");
        Style style = this.getStyle(SPECIAL_KEY_STYLE_NAME);
        if (style != null) {
            StyleConstants.setForeground(style, fg);
        }
    }

    public final void toggleInsertReplace() {
        VimCommandLine commandLine = VimInjectorKt.getInjector().getCommandLine().getActiveCommandLine();
        if (commandLine != null) {
            ((ExEntryPanel)commandLine).setReplaceMode(!((ExEntryPanel)commandLine).isReplaceMode());
        }
        this.isOverwrite = !this.isOverwrite;
    }

    @Override
    public void insertString(int offs, @NotNull String str, @Nullable AttributeSet a) throws BadLocationException {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.addInputMethodAttributes(a);
        super.insertString(offs, str, a);
    }

    private final void addInputMethodAttributes(AttributeSet attributeSet) {
        Object composedTextAttribute;
        if (!SystemInfo.isMac) {
            return;
        }
        AttributeSet attributeSet2 = attributeSet;
        Object object = composedTextAttribute = attributeSet2 != null ? attributeSet2.getAttribute(StyleConstants.ComposedTextAttribute) : null;
        if (composedTextAttribute instanceof AttributedString) {
            AttributedCharacterIterator iterator = ((AttributedString)composedTextAttribute).getIterator();
            while (iterator.current() != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> currentCharAttributes = iterator.getAttributes();
                if (!currentCharAttributes.containsKey(TextAttribute.INPUT_METHOD_HIGHLIGHT) && !currentCharAttributes.containsKey(TextAttribute.INPUT_METHOD_UNDERLINE)) {
                    ((AttributedString)composedTextAttribute).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, iterator.getIndex(), iterator.getIndex() + 1);
                }
                iterator.next();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExDocument$Companion;", "", "<init>", "()V", "SPECIAL_KEY_STYLE_NAME", "", "NON_PRINTABLE_ELEMENT_NAME", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExDocument$ExDocumentFilter;", "Ljavax/swing/text/DocumentFilter;", "<init>", "()V", "insertString", "", "fb", "Ljavax/swing/text/DocumentFilter$FilterBypass;", "offset", "", "string", "", "attr", "Ljavax/swing/text/AttributeSet;", "replace", "length", "text", "attrs", "filterNewLines", "document", "Ljavax/swing/text/Document;", "Companion", "IdeaVIM"})
    private static final class ExDocumentFilter
    extends DocumentFilter {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        public void insertString(@NotNull DocumentFilter.FilterBypass fb, int offset, @NotNull String string, @Nullable AttributeSet attr) throws BadLocationException {
            int rest;
            Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int offset2 = offset;
            String string2 = string;
            int originalOffset = offset2;
            Document document = fb.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            string2 = this.filterNewLines(document, string2);
            int start2 = 0;
            int pos = 0;
            while (pos < string2.length()) {
                String s;
                boolean isPrintable = ExDocumentFilter.Companion.isPrintableCharacter(string2.charAt(pos));
                while (pos < string2.length() && ExDocumentFilter.Companion.isPrintableCharacter(string2.charAt(pos)) == isPrintable) {
                    ++pos;
                }
                AttributeSet a = isPrintable ? attr : ExDocumentFilter.Companion.getNonPrintableAttributes(fb.getDocument(), attr);
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(start2, pos), (String)"substring(...)");
                fb.insertString(offset2, s, a);
                offset2 += s.length();
                start2 = pos;
            }
            Document exDocument = fb.getDocument();
            if (exDocument instanceof ExDocument && ((ExDocument)exDocument).isOverwrite() && (rest = originalOffset + string2.length()) < ((ExDocument)exDocument).getLength()) {
                int len = Math.min(string2.length(), ((ExDocument)exDocument).getLength() - rest);
                fb.remove(rest, len);
            }
        }

        @Override
        public void replace(@NotNull DocumentFilter.FilterBypass fb, int offset, int length, @NotNull String text, @Nullable AttributeSet attrs) throws BadLocationException {
            Intrinsics.checkNotNullParameter((Object)fb, (String)"fb");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int offset2 = offset;
            int length2 = length;
            String text2 = text;
            if (((CharSequence)text2).length() == 0) {
                fb.replace(offset2, length2, text2, attrs);
                return;
            }
            Document document = fb.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            text2 = this.filterNewLines(document, text2);
            Document exDocument = fb.getDocument();
            if (exDocument instanceof ExDocument && ((ExDocument)exDocument).isOverwrite()) {
                length2 = offset2 + text2.length() > ((ExDocument)exDocument).getLength() ? ((ExDocument)exDocument).getLength() - offset2 : Math.max(length2, text2.length());
            }
            int start2 = 0;
            int pos = 0;
            while (pos < text2.length()) {
                String s;
                boolean isPrintable = ExDocumentFilter.Companion.isPrintableCharacter(text2.charAt(pos));
                while (pos < text2.length() && ExDocumentFilter.Companion.isPrintableCharacter(text2.charAt(pos)) == isPrintable) {
                    ++pos;
                }
                AttributeSet a = isPrintable ? attrs : ExDocumentFilter.Companion.getNonPrintableAttributes(fb.getDocument(), attrs);
                Intrinsics.checkNotNullExpressionValue((Object)text2.substring(start2, pos), (String)"substring(...)");
                if (start2 == 0) {
                    fb.replace(offset2, length2, s, a);
                } else {
                    fb.insertString(offset2, s, a);
                }
                offset2 += s.length();
                start2 = pos;
            }
        }

        @NotNull
        public final String filterNewLines(@NotNull Document document, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Object filterNewlines = document.getProperty("filterNewlines");
            if (filterNewlines instanceof Boolean && ((Boolean)filterNewlines).booleanValue()) {
                CharSequence charSequence = string;
                Regex regex = new Regex("\n");
                String string2 = " ";
                return regex.replace(charSequence, string2);
            }
            return string;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExDocument$ExDocumentFilter$Companion;", "", "<init>", "()V", "isPrintableCharacter", "", "c", "", "getNonPrintableAttributes", "Ljavax/swing/text/AttributeSet;", "document", "Ljavax/swing/text/Document;", "attrs", "IdeaVIM"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isPrintableCharacter(char c) {
                return EngineStringHelper.INSTANCE.isPrintableCharacter(c);
            }

            private final AttributeSet getNonPrintableAttributes(Document document, AttributeSet attrs) {
                if (document instanceof ExDocument) {
                    Style style = ((ExDocument)document).getStyle(ExDocument.NON_PRINTABLE_ELEMENT_NAME);
                    Intrinsics.checkNotNullExpressionValue((Object)style, (String)"getStyle(...)");
                    return style;
                }
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                if (attrs != null) {
                    attributeSet.addAttributes(attrs);
                }
                attributeSet.addAttribute("$ename", ExDocument.NON_PRINTABLE_ELEMENT_NAME);
                return attributeSet;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

