/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui.ex;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IJSwingUtilities;
import com.maddyhome.idea.vim.EventFacade;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.VimShortcutKeyAction;
import com.maddyhome.idea.vim.api.VimCommandLine;
import com.maddyhome.idea.vim.api.VimCommandLineCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimKeyGroup;
import com.maddyhome.idea.vim.api.VimKeyGroupBase;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.group.KeyGroup;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.SearchHighlightsHelper;
import com.maddyhome.idea.vim.helper.UiHelper;
import com.maddyhome.idea.vim.key.interceptors.VimInputInterceptor;
import com.maddyhome.idea.vim.newapi.IjVimCaret;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.ui.ExPanelBorder;
import com.maddyhome.idea.vim.ui.ex.ExTextField;
import com.maddyhome.idea.vim.ui.ex.ExTextFieldUI;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.GlobalCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.SubstituteCommand;
import com.maddyhome.idea.vim.vimscript.parser.VimscriptParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Caret;
import javax.swing.text.GlyphView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ~2\u00020\u00012\u00020\u0002:\u0002}~B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010:\u001a\u00020\r2\b\u00106\u001a\u0004\u0018\u00010!J(\u0010;\u001a\u00020\r2\u0006\u00106\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\fJ\u000e\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u0006J\u0018\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006H\u0016J\b\u0010A\u001a\u00020\rH\u0002J\u0010\u0010B\u001a\u00020\r2\u0006\u00106\u001a\u00020!H\u0002J\b\u0010F\u001a\u00020\fH\u0016J\b\u0010G\u001a\u00020\rH\u0016J\b\u0010J\u001a\u00020\fH\u0016J\u001c\u0010J\u001a\u00020\r2\u0006\u0010K\u001a\u00020L2\n\u0010M\u001a\u00060Nj\u0002`OH\u0002J\u0010\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\u0013H\u0016J\b\u0010R\u001a\u00020\rH\u0016J\u0010\u0010S\u001a\u00020\r2\u0006\u0010T\u001a\u00020UH\u0016J\b\u0010V\u001a\u00020\rH\u0016J\n\u0010W\u001a\u0004\u0018\u00010XH\u0016J\n\u0010Y\u001a\u0004\u0018\u00010XH\u0016J\b\u0010Z\u001a\u00020\rH\u0002J\b\u0010[\u001a\u00020\rH\u0002J\u0018\u0010t\u001a\u00020\r2\u0006\u0010u\u001a\u00020\f2\u0006\u0010v\u001a\u00020\u0006H\u0016J\u0018\u0010w\u001a\u00020\r2\u0006\u0010x\u001a\u00020)2\u0006\u0010y\u001a\u00020)H\u0016J\u0018\u0010z\u001a\u00020\r2\u0006\u0010x\u001a\u00020)2\u0006\u0010u\u001a\u00020\fH\u0016J\b\u0010{\u001a\u00020\rH\u0016J\b\u0010|\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010!\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0013\u00103\u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u00100R\u0014\u0010\\\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u0007R\u001e\u0010^\u001a\u00020\u00062\u0006\u0010]\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0007R\u0010\u0010_\u001a\u0004\u0018\u00010`X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010a\u001a\u00020bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010c\u001a\u00020d\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010fR\u0010\u0010g\u001a\u0004\u0018\u00010`X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010h\u001a\u0004\u0018\u00010iX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010j\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010k\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010l\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010m\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010n\u001a\u00020oX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010p\u001a\u00020q8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\br\u0010s\u00a8\u0006\u007f"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;", "Ljavax/swing/JPanel;", "Lcom/maddyhome/idea/vim/api/VimCommandLine;", "<init>", "()V", "isReplaceMode", "", "()Z", "setReplaceMode", "(Z)V", "inputProcessing", "Lkotlin/Function1;", "", "", "getInputProcessing", "()Lkotlin/jvm/functions/Function1;", "setInputProcessing", "(Lkotlin/jvm/functions/Function1;)V", "finishOn", "", "getFinishOn", "()Ljava/lang/Character;", "setFinishOn", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "inputInterceptor", "Lcom/maddyhome/idea/vim/key/interceptors/VimInputInterceptor;", "getInputInterceptor", "()Lcom/maddyhome/idea/vim/key/interceptors/VimInputInterceptor;", "setInputInterceptor", "(Lcom/maddyhome/idea/vim/key/interceptors/VimInputInterceptor;)V", "weakEditor", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getContext", "()Lcom/intellij/openapi/actionSystem/DataContext;", "setContext", "(Lcom/intellij/openapi/actionSystem/DataContext;)V", "histIndex", "", "getHistIndex", "()I", "setHistIndex", "(I)V", "lastEntry", "getLastEntry", "()Ljava/lang/String;", "setLastEntry", "(Ljava/lang/String;)V", "ijEditor", "getIjEditor", "()Lcom/intellij/openapi/editor/Editor;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "setEditor", "activate", "label", "initText", "deactivate", "refocusOwningEditor", "resetCaret", "reset", "resetCaretOffset", "fontListener", "Ljavax/swing/event/DocumentListener;", "incSearchDocumentListener", "getLabel", "toggleReplaceMode", "text", "getText", "getRenderedText", "view", "Ljavax/swing/text/View;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "setPromptCharacter", "promptCharacter", "clearPromptCharacter", "handleKey", "key", "Ljavax/swing/KeyStroke;", "updateUI", "getForeground", "Ljava/awt/Color;", "getBackground", "setFontForElements", "positionPanel", "isIncSearchEnabled", "value", "isActive", "parent", "Ljavax/swing/JComponent;", "myLabel", "Ljavax/swing/JLabel;", "entry", "Lcom/maddyhome/idea/vim/ui/ex/ExTextField;", "getEntry", "()Lcom/maddyhome/idea/vim/ui/ex/ExTextField;", "oldGlass", "oldLayout", "Ljava/awt/LayoutManager;", "wasOpaque", "verticalOffset", "horizontalOffset", "caretOffset", "resizePanelListener", "Ljava/awt/event/ComponentListener;", "caret", "Lcom/maddyhome/idea/vim/api/VimCommandLineCaret;", "getCaret", "()Lcom/maddyhome/idea/vim/api/VimCommandLineCaret;", "setText", "string", "updateLastEntry", "deleteText", "offset", "length", "insertText", "clearCurrentAction", "focus", "LafListener", "Companion", "IdeaVIM"})
public final class ExEntryPanel
extends JPanel
implements VimCommandLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isReplaceMode;
    @Nullable
    private Function1<? super String, Unit> inputProcessing;
    @Nullable
    private Character finishOn;
    @Nullable
    private VimInputInterceptor inputInterceptor;
    @Nullable
    private WeakReference<Editor> weakEditor;
    @Nullable
    private DataContext context;
    private int histIndex;
    @Nullable
    private String lastEntry;
    @NotNull
    private final DocumentListener fontListener = (DocumentListener)new DocumentAdapter(this){
        final /* synthetic */ ExEntryPanel this$0;
        {
            this.this$0 = $receiver;
        }

        protected void textChanged(DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String text = this.this$0.getEntry().getText();
            Editor editor = this.this$0.getIjEditor();
            Intrinsics.checkNotNull((Object)text);
            Font newFont = UiHelper.selectEditorFont(editor, text);
            if (newFont != this.this$0.getEntry().getFont()) {
                this.this$0.getEntry().setFont(newFont);
            }
        }
    };
    @NotNull
    private final DocumentListener incSearchDocumentListener = (DocumentListener)new DocumentAdapter(this){
        final /* synthetic */ ExEntryPanel this$0;
        {
            this.this$0 = $receiver;
        }

        protected void textChanged(DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            try {
                Editor editor = this.this$0.getIjEditor();
                if (editor == null) {
                    return;
                }
                Editor editor2 = editor;
                String string = ExEntryPanel.access$getMyLabel$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String labelText = string;
                boolean searchCommand = false;
                LineRange searchRange = null;
                char separator = labelText.charAt(0);
                String searchText = this.this$0.getText();
                if (Intrinsics.areEqual((Object)labelText, (Object)":")) {
                    if (((CharSequence)searchText).length() == 0) {
                        return;
                    }
                    Command command = this.getIncsearchCommand(searchText);
                    if (command == null) {
                        return;
                    }
                    Command command2 = command;
                    searchCommand = true;
                    searchText = "";
                    String argument = command2.getCommandArgument();
                    if (argument.length() > 1) {
                        separator = argument.charAt(0);
                        String string2 = argument.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        searchText = string2;
                    }
                    if (!(((CharSequence)searchText).length() == 0)) {
                        searchRange = command2.getLineRangeSafe((VimEditor)new IjVimEditor(editor2));
                    }
                    if (((CharSequence)searchText).length() == 0 || searchRange == null) {
                        VimPlugin.getSearch().resetIncsearchHighlights();
                        ExEntryPanel.access$resetCaretOffset(this.this$0, editor2);
                        return;
                    }
                }
                int count1 = Math.max(1, KeyHandler.Companion.getInstance().getKeyHandlerState().getEditorCommandBuilder().calculateCount0Snapshot());
                if (Intrinsics.areEqual((Object)labelText, (Object)"/") || Intrinsics.areEqual((Object)labelText, (Object)"?") || searchCommand) {
                    boolean forwards = !Intrinsics.areEqual((Object)labelText, (Object)"?");
                    int patternEnd = VimInjectorKt.getInjector().getSearchGroup().findEndOfPattern(searchText, separator, 0);
                    String pattern = StringsKt.take((String)searchText, (int)patternEnd);
                    VimPlugin.getEditor().closeEditorSearchSession(editor2);
                    int matchOffset = SearchHighlightsHelper.updateIncsearchHighlights(editor2, pattern, count1, forwards, ExEntryPanel.access$getCaretOffset$p(this.this$0), searchRange);
                    if (matchOffset != -1) {
                        if (searchCommand) {
                            EngineModeExtensionsKt.exitVisualMode((VimEditor)((VimEditor)new IjVimEditor(editor2)));
                        }
                        com.intellij.openapi.editor.Caret caret = editor2.getCaretModel().getPrimaryCaret();
                        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
                        new IjVimCaret(caret).moveToOffset(matchOffset);
                    } else {
                        ExEntryPanel.access$resetCaretOffset(this.this$0, editor2);
                    }
                }
            }
            catch (Throwable ex) {
                ExEntryPanel.access$getLogger$cp().error("Error while trying to show incsearch highlights", ex);
            }
        }

        @Contract(value="null -> null")
        private final Command getIncsearchCommand(String commandText) {
            if (commandText == null) {
                return null;
            }
            try {
                Command exCommand = VimscriptParser.INSTANCE.parseCommand(commandText);
                if (exCommand instanceof SubstituteCommand || exCommand instanceof GlobalCommand) {
                    return exCommand;
                }
            }
            catch (Exception e) {
                ExEntryPanel.access$getLogger$cp().error("Cannot parse command for incsearch", (Throwable)e);
            }
            return null;
        }
    };
    private boolean isActive;
    @Nullable
    private JComponent parent;
    @NotNull
    private final JLabel myLabel = new JLabel(" ");
    @NotNull
    private final ExTextField entry = new ExTextField(this);
    @Nullable
    private JComponent oldGlass;
    @Nullable
    private LayoutManager oldLayout;
    private boolean wasOpaque;
    private int verticalOffset;
    private int horizontalOffset;
    private int caretOffset;
    @NotNull
    private final ComponentListener resizePanelListener = new ComponentAdapter(this){
        final /* synthetic */ ExEntryPanel this$0;
        {
            this.this$0 = $receiver;
        }

        public void componentResized(ComponentEvent e) {
            ExEntryPanel.access$positionPanel(this.this$0);
        }
    };
    @Nullable
    private static ExEntryPanel instance;
    @NotNull
    private static final Logger logger;

    private ExEntryPanel() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        gbc.gridx = 0;
        layout.setConstraints(this.myLabel, gbc);
        this.add(this.myLabel);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        layout.setConstraints(this.entry, gbc);
        this.add(this.entry);
        EventFacade eventFacade = EventFacade.getInstance();
        AnAction anAction = VimShortcutKeyAction.Companion.getInstance();
        VimKeyGroup vimKeyGroup = VimInjectorKt.getInjector().getKeyGroup();
        Intrinsics.checkNotNull((Object)vimKeyGroup, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.VimKeyGroupBase");
        eventFacade.registerCustomShortcutSet(anAction, KeyGroup.toShortcutSet(((VimKeyGroupBase)vimKeyGroup).getRequiredShortcutKeys()), this.entry);
        this.updateUI();
    }

    public boolean isReplaceMode() {
        return this.isReplaceMode;
    }

    public void setReplaceMode(boolean bl) {
        this.isReplaceMode = bl;
    }

    @Nullable
    public Function1<String, Unit> getInputProcessing() {
        return this.inputProcessing;
    }

    public void setInputProcessing(@Nullable Function1<? super String, Unit> function1) {
        this.inputProcessing = function1;
    }

    @Nullable
    public Character getFinishOn() {
        return this.finishOn;
    }

    public void setFinishOn(@Nullable Character c) {
        this.finishOn = c;
    }

    @Nullable
    public final VimInputInterceptor getInputInterceptor() {
        return this.inputInterceptor;
    }

    public final void setInputInterceptor(@Nullable VimInputInterceptor vimInputInterceptor) {
        this.inputInterceptor = vimInputInterceptor;
    }

    @Nullable
    public final DataContext getContext() {
        return this.context;
    }

    public final void setContext(@Nullable DataContext dataContext) {
        this.context = dataContext;
    }

    public int getHistIndex() {
        return this.histIndex;
    }

    public void setHistIndex(int n) {
        this.histIndex = n;
    }

    @Nullable
    public String getLastEntry() {
        return this.lastEntry;
    }

    public void setLastEntry(@Nullable String string) {
        this.lastEntry = string;
    }

    @Nullable
    public final Editor getIjEditor() {
        Editor editor;
        if (this.weakEditor != null) {
            WeakReference<Editor> weakReference = this.weakEditor;
            Intrinsics.checkNotNull(weakReference);
            editor = (Editor)weakReference.get();
        } else {
            editor = null;
        }
        return editor;
    }

    @NotNull
    public VimEditor getEditor() {
        Editor editor = this.getIjEditor();
        if (editor == null) {
            throw new RuntimeException("Editor was disposed for active command line");
        }
        Editor editor2 = editor;
        return (VimEditor)new IjVimEditor(editor2);
    }

    public final void setEditor(@Nullable Editor editor) {
        this.weakEditor = editor == null ? null : new WeakReference<Editor>(editor);
    }

    public final void activate(@NotNull Editor editor, @Nullable DataContext context, @NotNull String label, @NotNull String initText) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)initText, (String)"initText");
        logger.info("Activate ex entry panel");
        this.myLabel.setText(label);
        this.myLabel.setFont(UiHelper.selectEditorFont(editor, label));
        this.entry.reset();
        this.entry.setText(initText);
        this.entry.setFont(UiHelper.selectEditorFont(editor, initText));
        this.parent = editor.getContentComponent();
        Color color = editor.getColorsScheme().getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        Color foregroundColour = color;
        this.entry.setForeground(foregroundColour);
        Color whitespaceColour = editor.getColorsScheme().getColor(EditorColors.WHITESPACES_COLOR);
        Color color2 = whitespaceColour;
        if (color2 == null) {
            color2 = foregroundColour;
        }
        this.entry.setSpecialKeyForeground(color2);
        this.myLabel.setForeground(this.entry.getForeground());
        this.context = context;
        this.setEditor(editor);
        this.setHistIndex(VimPlugin.getHistory().getEntries(this.getHistoryType(), 0, 0).size());
        this.entry.getDocument().addDocumentListener(this.fontListener);
        if (this.isIncSearchEnabled()) {
            this.entry.getDocument().addDocumentListener(this.incSearchDocumentListener);
            this.caretOffset = editor.getCaretModel().getOffset();
            this.verticalOffset = editor.getScrollingModel().getVerticalScrollOffset();
            this.horizontalOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JComponent glassPane;
            JRootPane jRootPane = SwingUtilities.getRootPane(this.parent);
            if (jRootPane == null) {
                return;
            }
            JRootPane root = jRootPane;
            Component component = root.getGlassPane();
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            this.oldGlass = glassPane = (JComponent)component;
            this.oldLayout = glassPane.getLayout();
            this.wasOpaque = glassPane.isOpaque();
            glassPane.setLayout(null);
            glassPane.setOpaque(false);
            glassPane.add(this);
            glassPane.addComponentListener(this.resizePanelListener);
            this.positionPanel();
            glassPane.setVisible(true);
            this.entry.requestFocusInWindow();
        }
        this.isActive = true;
    }

    public final void deactivate(boolean refocusOwningEditor) {
        this.deactivate(refocusOwningEditor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean refocusOwningEditor, boolean resetCaret) {
        logger.info("Deactivate ex entry panel");
        if (!this.isActive) {
            return;
        }
        this.clearPromptCharacter();
        try {
            this.entry.getDocument().removeDocumentListener(this.fontListener);
            if (this.isIncSearchEnabled()) {
                this.entry.getDocument().removeDocumentListener(this.incSearchDocumentListener);
                Editor editor = this.getIjEditor();
                if (editor != null && !editor.isDisposed() && resetCaret) {
                    this.resetCaretOffset(editor);
                }
                VimPlugin.getSearch().resetIncsearchHighlights();
            }
            this.entry.deactivate();
        }
        finally {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (refocusOwningEditor && this.parent != null) {
                    JComponent jComponent = this.parent;
                    Intrinsics.checkNotNull((Object)jComponent);
                    UiHelper.requestFocus(jComponent);
                }
                JComponent jComponent = this.oldGlass;
                Intrinsics.checkNotNull((Object)jComponent);
                jComponent.removeComponentListener(this.resizePanelListener);
                JComponent jComponent2 = this.oldGlass;
                Intrinsics.checkNotNull((Object)jComponent2);
                jComponent2.setVisible(false);
                JComponent jComponent3 = this.oldGlass;
                Intrinsics.checkNotNull((Object)jComponent3);
                jComponent3.remove(this);
                JComponent jComponent4 = this.oldGlass;
                Intrinsics.checkNotNull((Object)jComponent4);
                jComponent4.setOpaque(this.wasOpaque);
                JComponent jComponent5 = this.oldGlass;
                Intrinsics.checkNotNull((Object)jComponent5);
                jComponent5.setLayout(this.oldLayout);
            }
            this.parent = null;
        }
        this.setReplaceMode(false);
        this.setEditor(null);
        this.context = null;
        this.isActive = false;
        this.setFinishOn(null);
        this.inputInterceptor = null;
        this.setInputProcessing(null);
    }

    private final void reset() {
        this.deactivate(false);
    }

    private final void resetCaretOffset(Editor editor) {
        com.intellij.openapi.editor.Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        com.intellij.openapi.editor.Caret primaryCaret = caret;
        if (primaryCaret.getOffset() != this.caretOffset) {
            new IjVimCaret(primaryCaret).moveToOffset(this.caretOffset);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        ScrollingModel scrollingModel2 = scrollingModel;
        if (scrollingModel2.getHorizontalScrollOffset() != this.horizontalOffset || scrollingModel2.getVerticalScrollOffset() != this.verticalOffset) {
            scrollingModel2.scroll(this.horizontalOffset, this.verticalOffset);
        }
    }

    @NotNull
    public String getLabel() {
        String string = this.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public void toggleReplaceMode() {
        this.entry.toggleInsertReplace();
    }

    @NotNull
    public String getText() {
        String string = this.entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public String getRenderedText() {
        StringBuilder stringBuilder = new StringBuilder();
        View view = this.entry.getUI().getRootView(this.entry);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getRootView(...)");
        this.getRenderedText(view, stringBuilder);
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void getRenderedText(View view, StringBuilder stringBuilder) {
        if (view.getElement().isLeaf()) {
            if (view instanceof GlyphView) {
                Segment text = ((GlyphView)view).getText(((GlyphView)view).getStartOffset(), ((GlyphView)view).getEndOffset());
                stringBuilder.append(text);
                if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
            } else {
                stringBuilder.append("<Unknown leaf view. Expected GlyphView, got: ");
                stringBuilder.append(view.getClass().getName());
                stringBuilder.append(">");
            }
        } else {
            int viewCount = view.getViewCount();
            for (int i = 0; i < viewCount; ++i) {
                View child = view.getView(i);
                Intrinsics.checkNotNull((Object)child);
                this.getRenderedText(child, stringBuilder);
            }
        }
    }

    public void setPromptCharacter(char promptCharacter) {
        TextUI entryUi = this.entry.getUI();
        if (entryUi instanceof ExTextFieldUI) {
            ((ExTextFieldUI)entryUi).setPromptCharacter(promptCharacter);
        }
    }

    public void clearPromptCharacter() {
        TextUI exTextFieldUI = this.entry.getUI();
        if (exTextFieldUI instanceof ExTextFieldUI) {
            ((ExTextFieldUI)exTextFieldUI).clearPromptCharacter();
        }
    }

    public void handleKey(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.entry.handleKey(key);
        Function1<String, Unit> myInputProcessor = this.getInputProcessing();
        if (this.getFinishOn() != null) {
            Character c = this.getFinishOn();
            if (c != null && key.getKeyChar() == c.charValue() && myInputProcessor != null) {
                String myText = this.getText();
                this.close(true, true);
                myInputProcessor.invoke((Object)myText);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder((Border)((Object)new ExPanelBorder()));
        if (this.entry != null && this.myLabel != null) {
            this.setFontForElements();
            this.myLabel.setForeground(this.entry.getForeground());
            this.positionPanel();
        }
    }

    @Override
    @Nullable
    public Color getForeground() {
        if (this.entry == null) {
            return super.getForeground();
        }
        return this.entry.getForeground();
    }

    @Override
    @Nullable
    public Color getBackground() {
        if (this.entry == null) {
            return super.getBackground();
        }
        return this.entry.getBackground();
    }

    private final void setFontForElements() {
        Editor editor = this.getIjEditor();
        String string = this.myLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.myLabel.setFont(UiHelper.selectEditorFont(editor, string));
        Editor editor2 = this.getIjEditor();
        String string2 = this.entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.entry.setFont(UiHelper.selectEditorFont(editor2, string2));
    }

    private final void positionPanel() {
        if (this.parent == null) {
            return;
        }
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.parent);
        int height = (int)this.getPreferredSize().getHeight();
        if (scroll != null) {
            Rectangle bounds = scroll.getBounds();
            bounds.translate(0, scroll.getHeight() - height);
            bounds.height = height;
            Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), this.oldGlass);
            bounds.setLocation(pos);
            this.setBounds(bounds);
            this.repaint();
        }
    }

    private final boolean isIncSearchEnabled() {
        return VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getIncsearch();
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @NotNull
    public final ExTextField getEntry() {
        return this.entry;
    }

    @NotNull
    public VimCommandLineCaret getCaret() {
        Caret caret = this.entry.getCaret();
        Intrinsics.checkNotNull((Object)caret, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.VimCommandLineCaret");
        return (VimCommandLineCaret)caret;
    }

    public void setText(@NotNull String string, boolean updateLastEntry) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int offset = this.getCaret().getOffset();
        this.entry.updateText(string);
        if (updateLastEntry) {
            this.entry.saveLastEntry();
        }
        this.getCaret().setOffset(Math.min(offset, this.getText().length()));
    }

    public void deleteText(int offset, int length) {
        this.entry.deleteText(offset, length);
    }

    public void insertText(int offset, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.isReplaceMode()) {
            this.entry.deleteText(offset, string.length());
        }
        this.entry.insertText(offset, string);
    }

    public void clearCurrentAction() {
        this.entry.clearCurrentAction();
    }

    public void focus() {
        IdeFocusManager.findInstance().requestFocus((Component)this.entry, true);
    }

    public /* synthetic */ ExEntryPanel(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ JLabel access$getMyLabel$p(ExEntryPanel $this) {
        return $this.myLabel;
    }

    public static final /* synthetic */ void access$resetCaretOffset(ExEntryPanel $this, Editor editor) {
        $this.resetCaretOffset(editor);
    }

    public static final /* synthetic */ int access$getCaretOffset$p(ExEntryPanel $this) {
        return $this.caretOffset;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$positionPanel(ExEntryPanel $this) {
        $this.positionPanel();
    }

    static {
        Logger logger = Logger.getInstance((String)ExEntryPanel.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ExEntryPanel.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel$Companion;", "", "<init>", "()V", "instance", "Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;", "getInstance", "()Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;", "setInstance", "(Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel;)V", "getOrCreatePanelInstance", "fullReset", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ExEntryPanel getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable ExEntryPanel exEntryPanel) {
            instance = exEntryPanel;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ExEntryPanel getOrCreatePanelInstance() {
            ExEntryPanel exEntryPanel = this.getInstance();
            if (exEntryPanel == null) {
                void var3_3;
                Companion it = this;
                boolean bl = false;
                ExEntryPanel exEntryPanel2 = new ExEntryPanel(null);
                Companion.setInstance(exEntryPanel2);
                exEntryPanel = var3_3;
            }
            return exEntryPanel;
        }

        public final void fullReset() {
            ExEntryPanel myInstance = this.getInstance();
            if (myInstance != null) {
                myInstance.reset();
                this.setInstance(null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/ui/ex/ExEntryPanel$LafListener;", "Lcom/intellij/ide/ui/LafManagerListener;", "<init>", "()V", "lookAndFeelChanged", "", "source", "Lcom/intellij/ide/ui/LafManager;", "IdeaVIM"})
    public static final class LafListener
    implements LafManagerListener {
        public void lookAndFeelChanged(@NotNull LafManager source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (Companion.getInstance() != null) {
                IJSwingUtilities.updateComponentTreeUI((Component)Companion.getInstance());
            }
        }
    }
}

